#ifndef __BOARD_CPU86__
#define __BOARD_CPU86__

#include <config.h>

#define REG8(x)			(*(volatile unsigned char *)(x))

/* CPU86 register definitions */
#define CPU86_VME_EAC		REG8(CFG_BCRS_BASE + 0x00)
#define CPU86_VME_SAC		REG8(CFG_BCRS_BASE + 0x01)
#define CPU86_VME_MAC		REG8(CFG_BCRS_BASE + 0x02)
#define CPU86_BCR		REG8(CFG_BCRS_BASE + 0x03)
#define CPU86_BSR		REG8(CFG_BCRS_BASE + 0x04)
#define CPU86_WDOG_RPORT	REG8(CFG_BCRS_BASE + 0x05)
#define CPU86_MBOX_IRQ		REG8(CFG_BCRS_BASE + 0x04)
#define CPU86_REV		REG8(CFG_BCRS_BASE + 0x07)
#define CPU86_VME_IRQMASK	REG8(CFG_BCRS_BASE + 0x80)
#define CPU86_VME_IRQSTATUS	REG8(CFG_BCRS_BASE + 0x81)
#define CPU86_LOCAL_IRQMASK	REG8(CFG_BCRS_BASE + 0x82)
#define CPU86_LOCAL_IRQSTATUS	REG8(CFG_BCRS_BASE + 0x83)
#define CPU86_PMCL_IRQSTATUS	REG8(CFG_BCRS_BASE + 0x84)

/* Board Control Register bits */
#define CPU86_BCR_FWPT		0x01
#define CPU86_BCR_FWRE		0x02

#endif /* __BOARD_CPU86__ */
