#include <stdio.h>
#include <stdlib.h>

#include <dos.h>			/* clock() */
#include <time.h>			/* clock() */
#include <process.h>			/* exec() */

#include <locale.h>			/* setlocale */
#include "catgets.h"			/* catopen/catgets */

/* Functions */

void help (nl_catd cat);

/* Program starts here */

int
main (int argc, char **argv)
{
  char *fmt;
  int i;
  nl_catd cat;
  clock_t begin, end;

  /* Open the message catalog */

  cat = catopen ("runtime", 0);

  /* Note that Borland setlocale only supports the C locale, so this
     doesn't really do anything.  Otherwise, "" means use LANG env var */

  setlocale (LC_NUMERIC, "");

  /* Check command line */

  if (argc == 1)
    {
      help(cat);
      catclose (cat);
      exit (1);
    }

  if (argv[1][0] == '/')
    {
      help(cat);
      catclose (cat);
      exit (1);
    }

  /* Shift argv, and terminate with NULL */

  for (i = 1; i < argc;  i++)
    {
      argv[i-1] = argv[i];
    }

  argc--;
  argv[argc] = NULL;

  /* Start the timer, run it, then stop the timer */

  begin = clock();
  spawnvp (P_WAIT, argv[0], argv);
  end = clock();

  /* Print results and quit */

  fmt = catgets (cat, 1, 0, "Run time was %f seconds");
  printf (fmt, (end - begin) / CLK_TCK);
  printf ("\n");

  /* Done */

  catclose (cat);
  exit (0);
}

void
help (nl_catd cat)
{
  char *s;

  /* print the help message, and return */

  s = catgets (cat, 0, 0, "Determine the run time for a program");
  fprintf (stderr, "RUNTIME - %s\n", s);

  s = catgets (cat, 0, 1, "Usage");
  fprintf (stderr, "%s:\n", s);

  s = catgets (cat, 2, 0, "program");
  fprintf (stderr, "  RUNTIME { %s } [ ... ]\n", s);
}
