/*

  Unicode Conversion Table Generator
  Written by Jiang Hong.

*/

#include <stdio.h>
#include <stdlib.h>

typedef unsigned char BYTE;

void main( void )
{
	FILE	*fin, *fout;
	BYTE    b;
	int	i;

	printf( "Unicode Conversion Table Generator by Jiang Hong.\n" );

	fin = fopen( "UNICODE.TXT", "rb" );
	fout = fopen( "UNICODE.H", "wb+" );
	fputs( "unsigned char gb_unicode[] = {\n", fout );
	for( i = 0; i < 17860; i++ ) {
		fread( &b, 1, 1, fin );
		fprintf( fout, "0x%02x", b );
		if( i != 17860-1 )
			fputs( ",", fout );
		if( i % 8 == 7 )
			fputs( "\n", fout );
	}
	fputs( "\n};\n", fout );
	fclose( fin );
	fclose( fout );
	printf( "UNICODE.H generated.\n" );

	fin = fopen( "GB2312.TXT", "rb" );
	fout = fopen( "GB2312.H", "wb+" );
	fputs( "unsigned char unicode_gb[] = {\n", fout );
	for( i = 0; i < 17860; i++ ) {
		fread( &b, 1, 1, fin );
		fprintf( fout, "0x%02x", b );
		if( i != 17860-1 )
			fputs( ",", fout );
		if( i % 8 == 7 )
			fputs( "\n", fout );
	}
	fputs( "\n};\n", fout );
	fclose( fin );
	fclose( fout );
	printf( "GB2312.H generated.\n" );
}