; Stupid collection of int hooks to figure out when flushing of dirty
; buffers should be done for a write cache... 20.01.2002 by EA.

; WARNING: INT 19 not well hooked in this version, as INT 19 == reboot
; and we only want to display a "now we would flush" on the screen...
; Hopefully the user can imagine that ctrl-alt-del has some chances
; for flushing (because it uses int 19) BUT that is not recommended.

; Better assume that flushing will only occur at file close, disk
; sync, (eject disk)(*), and program terminate/tsr !
; (*) int 13.eject disk is currently the API for LBAcache.flush :-).
; However, I do for now recommend to sync ALL disks on ANY flush
; event - do not attempt to figure out which hardware is <-> which
; DOS drive etc., I would say.

; an actual write cache would behave much like a read cache, BUT
; writes will NEVER be passed on to the disk directly: writes will
; be passed on to disk WHEN the cache is synced (flushing all dirty
; buffers) OR a dirty buffer is synced because its XMS/... memory
; is about to be used for buffering another sector !!!

; Most important diffs to a pure read cache:
; int 13.write -> always write to XMS, no copy to disk
;                 (writes are also cloned in XMS in read caches,
;                 because otherwise the XMS would lose sync...)
; int 13.read  -> no change, but even if we would not provide
;                 a read cache, we would have to keep XMS in sync!
; XMS.alloc    -> write to DISK if reusing a dirty buffer (*)
; flush        -> write all dirty buffers to disk (*)
;                 We could SHOW the stats to the user right then...
;   (*) really sophisticated implementations would collect several
;   sectors into multisector writes, but this can be very tricky...

; PROBLEM: Disk errors with writes will occur delayed and can never
; reach the "state of mind" of the caller (at least not when they
; SHOULD have occurred, and it is not THAT useful to complain to
; probably some OTHER caller on the next request to our int 13
; after the error - better tell always "ok" at the API and warn
; (TTY) if WE get a disk error (which better never happened at all!).
; Conclusion: We should NEVER write-cache anything but fixed disks!
; Especially floppy disks should not be write-cached by a sane user.

; BONUS: Obviously we need to remember which of the cached sectors
; are "dirty" (changed but not written back to disk yet), and we
; should probably count how many sectors of read/write were requested
; at OUR int 13 versus how many WE requested at the BIOS int 13,
; and/or we can count how often -each- cached sector got read and
; written to, adding its statistics to a -histogram- at the moment
; when we stop caching -that- sector... Maybe also distinguish syncs
; because of full cache from ones because of a global "sync trigger".

; GEOMETRY must be preserved: Mixing LBA and CHS is not recommended,
; and for multisector requests, we get BIG troubles with a geometry
; wrong in any way (except the number of cyls)! For single sector
; requests, only a too small "sectors per track" or "heads" count
; will cause troubles in CHS->canonical_LBA->CHS... subtle bug cause!
; Of course, FLOPPIES may not use LBA, but still, geometry is needed
; for multisector requests AND the canonical sector numbering. BONUS
; problem is that floppies may vary in geometry :-/ ...

; MULTISECTOR access W: Bundling disk WRITES due to several "flush of
; dirty buffer" events in short time seems to be VERY complicated,
; and for requests to us, all writes will go to XMS first and thus
; need no caching. For a READ only cache, disk WRITES will be passed
; on to the disk BIOS directly (with the successfully written sectors
; being cloned to XMS afterwards).

; MULTISECTOR access R: Bundling disk READS due to several cache
; misses in a multisector read request to us seems to be more useful
; and more easily done, as we can do like this:
; for all sectors to be read DO
;   if miss, then (add one) to a "miss count" (delay disk access...)
;   if hit,  then do delayed disk acc's now (check the "miss count")
;            and copy that hit ("hitten") sector from XMS as well !
; DONE. After the for all, exec remaining delayed disk accesses !


; %idefine BKP int3	; 1byte
; %idefine BKP int 3	; 2byte
%idefine BKP nop	; 1byte

        org  100h	; COM file

	jmp inst

old19	dd 12345678h	; old int 19h vector (REBOOT..)
old20	dd 12345678h	; old int 20h vector (DOS: END)
old21	dd 12345678h	; old int 21h vector (DOS: API)
old27	dd 12345678h	; old int 27h vector (DOS: TSR)

used    dw 1		; bits: 1: init done 2/4/8/16: disable...
reason	dw 0		; why the flush was triggered



TTY:	push ax
	push bx
	push bp	; some BIOSes destroy it
	; we could check 40h:49h (current video mode) and
	; revert to beeping if TTY seems inappropriate,
	; and we could use 40h:62h (current page number)
	; for BH and we could adjust BL in graphics modes...
	mov ah,0eh	; TTY output (CR, LF, BS and BEL handled)
	mov bx,001eh	; assume page 0, set color (textmode: ignored)
	int 10h		; BIOS - let us hope we do never nest here,
	pop bp		; because even a VGA BIOS could get confused!?
	pop bx
	pop ax
	ret



FLUSH:	BKP
	push ax
	push si

	mov si,themsg	; *offset*
flsh1:	mov al,[cs:si]
	or al,al
	jz flsh2
	call TTY	; ... string output: next char ...
	inc si
	jmp short flsh1

flsh2:	mov si,[cs:reason]
	shr si,12		; high nibble
	mov al,[cs:hexa+si]	; translated
	call TTY
	mov si,[cs:reason]
	shr si,8
	and si,15		; 2nd
	mov al,[cs:hexa+si]	; translated
	call TTY
	mov si,[cs:reason]
	shr si,4
	and si,15		; 3rd
	mov al,[cs:hexa+si]	; translated
	call TTY
	mov si,[cs:reason]
	and si,15		; 4th
	mov al,[cs:hexa+si]	; translated
	call TTY

	mov si,themsg2	; *offset* - this beeps...
flsh3:	mov al,[cs:si]
	or al,al
	jz flsh4
	call TTY	; ... string output: next char ...
	inc si
	jmp short flsh3	; we could also delay after that "beep CR LF"
			; or wait for a key - if we know that we may!
flsh4:	pop si
	pop ax
	ret



I19:	BKP
	test word [cs:used],2
	jnz skip19
	mov word [cs:reason],19h
	call FLUSH
skip19:	jmp far [cs:old19]	; jump to real int 19

I20:	BKP
	test word [cs:used],4
	jnz skip20
	mov word [cs:reason],20h
	call FLUSH
skip20:	jmp far [cs:old20]	; jump to real int 20

I27:	BKP
	test word [cs:used],16
	jnz skip27
	mov word [cs:reason],27h
	call FLUSH
skip27:	jmp far [cs:old27]	; jump to real int 27



I21:	BKP
	test word [cs:used],8
	jnz skip21
	mov byte [cs:reason+1],21h
	mov byte [cs:reason],ah
	cmp ah,0	; exit
	jz preflush
	cmp ah,31h	; terminate and stay resident
	jz preflush
	cmp ah,4bh	; exec ...
	jz preflush
	cmp ah,4ch	; exit
	jz preflush
	cmp ah,4dh	; get exec return status
	jz preflush

	cmp ax,710dh	; sync drive (LFN/Win95)
	jz postflush
	cmp ah,0dh
	jz postflush	; flush dirty buffers / sync drive
			; (uses DOS drive numbering)
	cmp ah,10h	; close file (FCB)
	jz postflush
	cmp ah,3eh	; close file (Handle)
	jz postflush
	cmp ah,68h	; commit file (share/network?)
	jz postflush
	cmp ah,6ah	; commit file (alternate) (share/network?)
	jz postflush
	cmp ah,5dh	; share.exe: includes subfunctions
	jz postflush	; like 01: commit and others: close

	jmp useold

postflush:
	pushf
	call far [cs:old21]	; call real int 21
	pushf
	call FLUSH
	popf
	RETF +2		; return to caller with flags unchanged!

preflush:		; flush, then jump to real int 21
	call FLUSH
skip21:
useold:	jmp far [cs:old21]	; do nothing if other function



themsg	db 'FLUSH:',0

themsg2	db ' ',0
;	db 7,13,10,0

hexa	db '0123456789ABCDEF'
align 4
himsg	db 'This shows potential disk sync triggers - please'
	db 13, 10
	db 'mail a nice/useful selection to <eric@coli.uni-sb.de>'
	db 13, 10, 13, 10
ente    db 'Write cache flush dirty buffer timing indicator'
	db ' by EA 2002', 13, 10, 0

inst:   BKP		; because we hook ints we could cli...
			; ...but dword access is "atomic" anyway :)

	mov byte [cs:used],0	; what to disable...
				; ...0 is enable all

	push ebx
	mov bx,cs
	shl ebx,16		; prepare for vectors
       	push word 0
	pop es

	push dword [es:64h]	; int 19
	pop dword [cs:old19]
	push dword [es:80h]	; int 20
	pop dword [cs:old20]
	push dword [es:84h]	; int 21
	pop dword [cs:old21]
	push dword [es:9ch]	; int 27
	pop dword [cs:old27]

	mov bx,I19		; *offset*
	mov [es:64h],ebx	; our int 19
	mov bx,I20		; *offset*
	mov [es:80h],ebx	; our int 20
	mov bx,I21		; *offset*
	mov [es:84h],ebx	; our int 21
	mov bx,I27		; *offset*
	mov [es:9ch],ebx	; our int 27 (int 27 done by command,
				; in newer DOS - so we are no sys!)

	pop ebx

	mov si,himsg	; *offset*
himsg1:	mov al,[cs:si]
	or al,al
	jz himsg2
	call TTY	; ... string output: next char ...
	inc si
	jmp short himsg1
	
himsg2:	push es
	mov ax,[cs:2ch]		; ENV seg (PSP: intlist 61 tab 01378)
	mov es,ax		; what to free
	mov ah,49h
	int 21h			; free memory
	pop es
	mov ax,3100h		; TSR
	mov dx,ente+15		; *offset*
	shr dx,4		; paras to keep TSR
	int 21h			; hopefully this is somehow small...
