/*
// Program:  Format
// Version:  0.90
// Written By:  Brian E. Reifsnyder
// Copyright:  2002 under the terms of the GNU GPL, Version 2
// Module Name:  bpb.h
// Module Description:  BPB info header file.
*/


#define  FD160    0
#define  FD180    1
#define  FD320    2
#define  FD360    3
#define  FD720    4
#define  FD1200   5
#define  FD1440   6
#define  FD2880   7
#define  HD       8
#define  FD400    9
#define  FD800   10
#define  FD1680  11
#define  FD3360  12
#define  FD1494  13
#define  FD1743  14
#define  FD3486  15
#define  FD1700  16
#define  UNKNOWN 99

typedef struct BIOS_Parameter_Block
{                                            /* diskoffset */
  unsigned cylinders                 :  8;
  unsigned bytes_per_sector          : 16;   /* 0b         */
  unsigned sectors_per_cluster       :  8;   /* 0d         */
  unsigned reserved_sectors          : 16;   /* 0e         */
  unsigned number_of_fats            :  8;   /* 10         */
  unsigned root_directory_entries    : 16;   /* 11         */
  unsigned total_sectors             : 16;   /* 13         */
  unsigned media_descriptor          :  8;   /* 15         */
  unsigned sectors_per_fat           : 16;   /* 16         */
  unsigned sectors_per_cylinder      : 16;   /* 18         */
  unsigned number_of_heads           : 16;   /* 1a         */
  unsigned hidden_sectors_low        : 16;   /* 1c         */
  unsigned hidden_sectors_high       : 16;   /* 1e         */
  unsigned large_sector_count_low    : 16;   /* 20         */
  unsigned large_sector_count_high   : 16;   /* 22         */
  int interleave_factor;
  int sector_skew;
  unsigned long total_logical_sectors;
} BPB;

/* make sure, struct size is OK; i.e. alignement is 0 */
struct verify_BIOS_Parameter_Block {
    char x[1 - 2*(sizeof(BPB) != 1 + 25 + 2*sizeof(int) + sizeof(long))];
    };

BPB drive_specs[17]=
{
  {40,512,1,1,2, 64, 320,0xfe,1, 8,1,0,0,0,0, 1, 0},  /* FD160  5.25 SS   */
  {40,512,1,1,2, 64, 360,0xfc,2, 9,1,0,0,0,0, 1, 0},  /* FD180  5.25 SS   */
  {40,512,2,1,2,112, 640,0xff,1, 8,2,0,0,0,0, 1, 0},  /* FD320  5.25 DS   */
  {40,512,2,1,2,112, 720,0xfd,2, 9,2,0,0,0,0, 1, 0},  /* FD360  5.25 DS   */
  {80,512,2,1,2,112,1440,0xf9,3, 9,2,0,0,0,0, 1, 0},  /* FD720  3.5  LD   */
  {80,512,1,1,2,224,2400,0xf9,7,15,2,0,0,0,0, 1, 0},  /* FD1200 5.25 HD   */
  {80,512,1,1,2,224,2880,0xf0,9,18,2,0,0,0,0, 1, 0},  /* FD1440 3.5  HD   */
  {80,512,2,1,2,240,5760,0xf0,9,36,2,0,0,0,0, 1, 0},  /* FD2880 3.5  ED   */
  { 0,512,0,1,2,512,   0,0xf8,0, 0,0,0,0,0,0, 0, 0},  /* HD     HARD DISK */

 /* Non-Standard Format BPB Values */

  /* More Sectors Only */
  {40,512,2,1,2,112, 800,0xfd,2,10,2,0,0,0,0, 3, 3},  /* FD400  5.25 DS   */
  {80,512,2,1,2,112,1600,0xf9,3,10,2,0,0,0,0, 3, 3},  /* FD800  3.5  LD   */
  {80,512,1,1,2,224,3360,0xf0,9,21,2,0,0,0,0, 3, 3},  /* FD1680 3.5  HD   */
  {80,512,2,1,2,240,6720,0xf0,9,42,2,0,0,0,0, 3, 3},  /* FD3360 3.5  ED   */

  /* More Cylinders and Sectors */
  {83,512,1,1,2,224,2988,0xf9,7,18,2,0,0,0,0, 3, 3},  /* FD1494 5.25 HD   */
  {83,512,1,1,2,224,3486,0xf0,9,21,2,0,0,0,0, 3, 3},  /* FD1743 3.5  HD   */
  {83,512,2,1,2,240,6972,0xf0,9,42,2,0,0,0,0, 3, 3},  /* FD3486 3.5  ED   */

  /* DMF Format */
  {80,512,1,1,2, 16,3360,0xf0,9,21,2,0,0,0,0, 2, 3}   /* FD1700 3.5  HD   */
};


typedef struct FAT32_BIOS_Parameter_Block
{                                            /* diskoffset */

  char     oem_id[8]                     ;   /* 03         */
  unsigned bytes_per_sector          : 16;   /* 0b         */
  unsigned sectors_per_cluster       :  8;   /* 0d         */
  unsigned reserved_sectors          : 16;   /* 0e         */
  unsigned number_of_fats            :  8;   /* 10         */
  unsigned root_directory_entries    : 16;   /* 11         */
  unsigned total_sectors             : 16;   /* 13         */
  unsigned media_descriptor          :  8;   /* 15         */
  unsigned sectors_per_fat           : 16;   /* 16         */
  unsigned sectors_per_cylinder      : 16;   /* 18         */
  unsigned number_of_heads           : 16;   /* 1a         */
  unsigned hidden_sectors_low        : 16;   /* 1c         */
  unsigned hidden_sectors_high       : 16;   /* 1e         */
  unsigned large_sector_count_low    : 16;   /* 20         */
  unsigned large_sector_count_high   : 16;   /* 22         */
  unsigned fat_size_low              : 16;   /*       36   */
  unsigned fat_size_high             : 16;   /*       38   */
  unsigned ext_flags                 : 16;   /*       40   */
  unsigned file_system_version       : 16;   /*       42   */
  unsigned root_dir_start_low        : 16;   /*       44   */
  unsigned root_dir_start_high       : 16;   /*       46   */
  unsigned fs_info_structure         : 16;   /*       48   */
  unsigned backup_boot_sector        : 16;   /*       50   */
  char     reserved_1[12]                ;   /*       52   */
  unsigned drive_number              :  8;   /*       64   */
  unsigned reserved_2                :  8;   /*       65   */
  unsigned signature_byte            :  8;   /*       66   */
  char     serial_number_1[1]            ;   /*       67   */
  char     serial_number_2[1]            ;   /*       68   */
  char     serial_number_3[1]            ;   /*       69   */
  char     serial_number_4[1]            ;   /*       70   */
  char     volume_label[11]              ;   /*       71   */
  char     file_system_type[8]           ;   /*       82   */
} BPB_FAT32;

BPB_FAT32 bpb_fat32;

