        TITLE   CYRIX.ASM

DGROUP  GROUP   _DATA
        ASSUME  CS:_TEXT, DS:DGROUP

_DATA   SEGMENT WORD PUBLIC 'DATA'
;        extrn   fpu_type:byte          ; Holds the FPU type (8087, 80287, etc.)
;        extrn   cputype:byte           ; Holds the current CPU type
;        extrn   fp_status:word         ; Hold the FPU status word
_DATA   ENDS

_TEXT   SEGMENT WORD PUBLIC 'CODE'

        public iscyrix
;        public get_fpu_type
;        fp_status dw ?

iscyrix proc far
  xor ax, ax               ; clear ax
  sahf                     ; clear flags, bit 1 is always 1 in flags
  mov ax, 5
  mov bx, 2
  div bl                   ; do an operation that does not change flags
  lahf                     ; get flags
  cmp ah, 2                ; check for change in flags
  jne not_cyrix            ; flags changed not Cyrix
  mov ax, 1                ; TRUE Cyrix CPU
  jmp done
not_cyrix:
  mov  ax, 0               ; FALSE NON-Cyrix CPU
done:
iscyrix endp

_TEXT   ENDS
  end
