// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/actions/sdk/v2/account_linking.proto

package sdk

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of Account Linking to perform.
type AccountLinking_LinkingType int32

const (
	// Unspecified.
	AccountLinking_LINKING_TYPE_UNSPECIFIED AccountLinking_LinkingType = 0
	// Google Sign In linking type.
	// If using this linking type, no OAuth-related fields need to be set below.
	AccountLinking_GOOGLE_SIGN_IN AccountLinking_LinkingType = 1
	// OAuth and Google Sign In linking type.
	AccountLinking_OAUTH_AND_GOOGLE_SIGN_IN AccountLinking_LinkingType = 2
	// OAuth linking type.
	AccountLinking_OAUTH AccountLinking_LinkingType = 3
)

// Enum value maps for AccountLinking_LinkingType.
var (
	AccountLinking_LinkingType_name = map[int32]string{
		0: "LINKING_TYPE_UNSPECIFIED",
		1: "GOOGLE_SIGN_IN",
		2: "OAUTH_AND_GOOGLE_SIGN_IN",
		3: "OAUTH",
	}
	AccountLinking_LinkingType_value = map[string]int32{
		"LINKING_TYPE_UNSPECIFIED": 0,
		"GOOGLE_SIGN_IN":           1,
		"OAUTH_AND_GOOGLE_SIGN_IN": 2,
		"OAUTH":                    3,
	}
)

func (x AccountLinking_LinkingType) Enum() *AccountLinking_LinkingType {
	p := new(AccountLinking_LinkingType)
	*p = x
	return p
}

func (x AccountLinking_LinkingType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccountLinking_LinkingType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_actions_sdk_v2_account_linking_proto_enumTypes[0].Descriptor()
}

func (AccountLinking_LinkingType) Type() protoreflect.EnumType {
	return &file_google_actions_sdk_v2_account_linking_proto_enumTypes[0]
}

func (x AccountLinking_LinkingType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccountLinking_LinkingType.Descriptor instead.
func (AccountLinking_LinkingType) EnumDescriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_account_linking_proto_rawDescGZIP(), []int{0, 0}
}

// The OAuth2 grant type Google uses to guide the user to sign in to your
// App's web service.
type AccountLinking_AuthGrantType int32

const (
	// Unspecified.
	AccountLinking_AUTH_GRANT_TYPE_UNSPECIFIED AccountLinking_AuthGrantType = 0
	// Authorization code grant. Requires you to provide both
	// authentication URL and access token URL.
	AccountLinking_AUTH_CODE AccountLinking_AuthGrantType = 1
	// Implicit code grant. Only requires you to provide authentication
	// URL.
	AccountLinking_IMPLICIT AccountLinking_AuthGrantType = 2
)

// Enum value maps for AccountLinking_AuthGrantType.
var (
	AccountLinking_AuthGrantType_name = map[int32]string{
		0: "AUTH_GRANT_TYPE_UNSPECIFIED",
		1: "AUTH_CODE",
		2: "IMPLICIT",
	}
	AccountLinking_AuthGrantType_value = map[string]int32{
		"AUTH_GRANT_TYPE_UNSPECIFIED": 0,
		"AUTH_CODE":                   1,
		"IMPLICIT":                    2,
	}
)

func (x AccountLinking_AuthGrantType) Enum() *AccountLinking_AuthGrantType {
	p := new(AccountLinking_AuthGrantType)
	*p = x
	return p
}

func (x AccountLinking_AuthGrantType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccountLinking_AuthGrantType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_actions_sdk_v2_account_linking_proto_enumTypes[1].Descriptor()
}

func (AccountLinking_AuthGrantType) Type() protoreflect.EnumType {
	return &file_google_actions_sdk_v2_account_linking_proto_enumTypes[1]
}

func (x AccountLinking_AuthGrantType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccountLinking_AuthGrantType.Descriptor instead.
func (AccountLinking_AuthGrantType) EnumDescriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_account_linking_proto_rawDescGZIP(), []int{0, 1}
}

// AccountLinking allows Google to guide the user to sign-in to the App's web
// services.
//
// For Google Sign In and OAuth + Google Sign In linking types, Google generates
// a client ID identifying your App to Google ("Client ID issued by Google to
// your Actions" on Console UI). This field is read-only and can be checked by
// navigating to the Console UI's Account Linking page.
// See: https://developers.google.com/assistant/identity/google-sign-in
//
// Note: For all account linking setting types (except for Google Sign In), you
// must provide a username and password for a test account in
// Settings.testing_instructions for the review team to review the app (they
// will not be visible to users).
type AccountLinking struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. If `true`, users are allowed to sign up for new accounts via voice.
	// If `false`, account creation is only allowed on your website. Select this
	// option if you want to display your terms of service or obtain user consents
	// during sign-up.
	// linking_type cannot be GOOGLE_SIGN_IN when this is `false`.
	// linking_type cannot be OAUTH when this is `true`.
	EnableAccountCreation bool `protobuf:"varint,1,opt,name=enable_account_creation,json=enableAccountCreation,proto3" json:"enable_account_creation,omitempty"`
	// Required. The linking type to use.
	// See https://developers.google.com/assistant/identity for further details on
	// the linking types.
	LinkingType AccountLinking_LinkingType `protobuf:"varint,2,opt,name=linking_type,json=linkingType,proto3,enum=google.actions.sdk.v2.AccountLinking_LinkingType" json:"linking_type,omitempty"`
	// Optional. Indicates the type of authentication for OAUTH linking_type.
	AuthGrantType AccountLinking_AuthGrantType `protobuf:"varint,3,opt,name=auth_grant_type,json=authGrantType,proto3,enum=google.actions.sdk.v2.AccountLinking_AuthGrantType" json:"auth_grant_type,omitempty"`
	// Optional. Client ID issued by your App to Google.
	// This is the OAuth2 Client ID identifying Google to your service.
	// Only set when using OAuth.
	AppClientId string `protobuf:"bytes,4,opt,name=app_client_id,json=appClientId,proto3" json:"app_client_id,omitempty"`
	// Optional. Endpoint for your sign-in web page that supports OAuth2 code or
	// implicit flows.
	// URL must use HTTPS.
	// Only set when using OAuth.
	AuthorizationUrl string `protobuf:"bytes,5,opt,name=authorization_url,json=authorizationUrl,proto3" json:"authorization_url,omitempty"`
	// Optional. OAuth2 endpoint for token exchange.
	// URL must use HTTPS.
	// This is not set when only using OAuth with IMPLICIT grant as the
	// linking type.
	// Only set when using OAuth.
	TokenUrl string `protobuf:"bytes,6,opt,name=token_url,json=tokenUrl,proto3" json:"token_url,omitempty"`
	// Optional. List of permissions the user must consent to in order to use
	// your service.
	// Only set when using OAuth.
	// Make sure to provide a Terms of Service in the directory information in
	// LocalizedSettings.terms_of_service_url section if specifying this field.
	Scopes []string `protobuf:"bytes,7,rep,name=scopes,proto3" json:"scopes,omitempty"`
	// Optional. This is the web page on your service which describes the
	// permissions the user is granting to Google.
	// Only set if using OAuth and Google Sign In.
	// Make sure to provide a Terms of Service in the directory information in
	// LocalizedSettings.terms_of_service_url section if specifying this field.
	LearnMoreUrl string `protobuf:"bytes,8,opt,name=learn_more_url,json=learnMoreUrl,proto3" json:"learn_more_url,omitempty"`
	// Optional. If true, allow Google to transmit client ID and secret via HTTP
	// basic auth header. Otherwise, Google uses the client ID and secret inside
	// the post body.
	// Only set when using OAuth.
	// Make sure to provide a Terms of Service in the directory information in
	// LocalizedSettings.terms_of_service_url section if specifying this field.
	UseBasicAuthHeader bool `protobuf:"varint,9,opt,name=use_basic_auth_header,json=useBasicAuthHeader,proto3" json:"use_basic_auth_header,omitempty"`
}

func (x *AccountLinking) Reset() {
	*x = AccountLinking{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_account_linking_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccountLinking) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccountLinking) ProtoMessage() {}

func (x *AccountLinking) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_account_linking_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccountLinking.ProtoReflect.Descriptor instead.
func (*AccountLinking) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_account_linking_proto_rawDescGZIP(), []int{0}
}

func (x *AccountLinking) GetEnableAccountCreation() bool {
	if x != nil {
		return x.EnableAccountCreation
	}
	return false
}

func (x *AccountLinking) GetLinkingType() AccountLinking_LinkingType {
	if x != nil {
		return x.LinkingType
	}
	return AccountLinking_LINKING_TYPE_UNSPECIFIED
}

func (x *AccountLinking) GetAuthGrantType() AccountLinking_AuthGrantType {
	if x != nil {
		return x.AuthGrantType
	}
	return AccountLinking_AUTH_GRANT_TYPE_UNSPECIFIED
}

func (x *AccountLinking) GetAppClientId() string {
	if x != nil {
		return x.AppClientId
	}
	return ""
}

func (x *AccountLinking) GetAuthorizationUrl() string {
	if x != nil {
		return x.AuthorizationUrl
	}
	return ""
}

func (x *AccountLinking) GetTokenUrl() string {
	if x != nil {
		return x.TokenUrl
	}
	return ""
}

func (x *AccountLinking) GetScopes() []string {
	if x != nil {
		return x.Scopes
	}
	return nil
}

func (x *AccountLinking) GetLearnMoreUrl() string {
	if x != nil {
		return x.LearnMoreUrl
	}
	return ""
}

func (x *AccountLinking) GetUseBasicAuthHeader() bool {
	if x != nil {
		return x.UseBasicAuthHeader
	}
	return false
}

var File_google_actions_sdk_v2_account_linking_proto protoreflect.FileDescriptor

var file_google_actions_sdk_v2_account_linking_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64,
	0x6b, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc0, 0x05, 0x0a, 0x0e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x12, 0x3b, 0x0a, 0x17, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x0c, 0x6c, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b,
	0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x69,
	0x6e, 0x67, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6c, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x60, 0x0a, 0x0f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76,
	0x32, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67,
	0x2e, 0x41, 0x75, 0x74, 0x68, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0d, 0x61, 0x75, 0x74, 0x68, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x27, 0x0a, 0x0d, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x61, 0x70, 0x70, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x11, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x6c,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x72, 0x6c, 0x12, 0x20, 0x0a,
	0x09, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x55, 0x72, 0x6c, 0x12,
	0x1b, 0x0a, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x0e,
	0x6c, 0x65, 0x61, 0x72, 0x6e, 0x5f, 0x6d, 0x6f, 0x72, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x65, 0x61, 0x72, 0x6e,
	0x4d, 0x6f, 0x72, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x36, 0x0a, 0x15, 0x75, 0x73, 0x65, 0x5f, 0x62,
	0x61, 0x73, 0x69, 0x63, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x75, 0x73, 0x65,
	0x42, 0x61, 0x73, 0x69, 0x63, 0x41, 0x75, 0x74, 0x68, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22,
	0x68, 0x0a, 0x0b, 0x4c, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c,
	0x0a, 0x18, 0x4c, 0x49, 0x4e, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e,
	0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x49, 0x4e, 0x10, 0x01,
	0x12, 0x1c, 0x0a, 0x18, 0x4f, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x47, 0x4f,
	0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x49, 0x4e, 0x10, 0x02, 0x12, 0x09,
	0x0a, 0x05, 0x4f, 0x41, 0x55, 0x54, 0x48, 0x10, 0x03, 0x22, 0x4d, 0x0a, 0x0d, 0x41, 0x75, 0x74,
	0x68, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x41, 0x55,
	0x54, 0x48, 0x5f, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x41,
	0x55, 0x54, 0x48, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4d,
	0x50, 0x4c, 0x49, 0x43, 0x49, 0x54, 0x10, 0x02, 0x42, 0x6c, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73,
	0x64, 0x6b, 0x2e, 0x76, 0x32, 0x42, 0x13, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x69,
	0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f,
	0x76, 0x32, 0x3b, 0x73, 0x64, 0x6b, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_actions_sdk_v2_account_linking_proto_rawDescOnce sync.Once
	file_google_actions_sdk_v2_account_linking_proto_rawDescData = file_google_actions_sdk_v2_account_linking_proto_rawDesc
)

func file_google_actions_sdk_v2_account_linking_proto_rawDescGZIP() []byte {
	file_google_actions_sdk_v2_account_linking_proto_rawDescOnce.Do(func() {
		file_google_actions_sdk_v2_account_linking_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_actions_sdk_v2_account_linking_proto_rawDescData)
	})
	return file_google_actions_sdk_v2_account_linking_proto_rawDescData
}

var file_google_actions_sdk_v2_account_linking_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_actions_sdk_v2_account_linking_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_actions_sdk_v2_account_linking_proto_goTypes = []interface{}{
	(AccountLinking_LinkingType)(0),   // 0: google.actions.sdk.v2.AccountLinking.LinkingType
	(AccountLinking_AuthGrantType)(0), // 1: google.actions.sdk.v2.AccountLinking.AuthGrantType
	(*AccountLinking)(nil),            // 2: google.actions.sdk.v2.AccountLinking
}
var file_google_actions_sdk_v2_account_linking_proto_depIdxs = []int32{
	0, // 0: google.actions.sdk.v2.AccountLinking.linking_type:type_name -> google.actions.sdk.v2.AccountLinking.LinkingType
	1, // 1: google.actions.sdk.v2.AccountLinking.auth_grant_type:type_name -> google.actions.sdk.v2.AccountLinking.AuthGrantType
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_actions_sdk_v2_account_linking_proto_init() }
func file_google_actions_sdk_v2_account_linking_proto_init() {
	if File_google_actions_sdk_v2_account_linking_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_actions_sdk_v2_account_linking_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccountLinking); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_actions_sdk_v2_account_linking_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_actions_sdk_v2_account_linking_proto_goTypes,
		DependencyIndexes: file_google_actions_sdk_v2_account_linking_proto_depIdxs,
		EnumInfos:         file_google_actions_sdk_v2_account_linking_proto_enumTypes,
		MessageInfos:      file_google_actions_sdk_v2_account_linking_proto_msgTypes,
	}.Build()
	File_google_actions_sdk_v2_account_linking_proto = out.File
	file_google_actions_sdk_v2_account_linking_proto_rawDesc = nil
	file_google_actions_sdk_v2_account_linking_proto_goTypes = nil
	file_google_actions_sdk_v2_account_linking_proto_depIdxs = nil
}
