// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package firebaseappdistribution provides access to the Firebase App Distribution API.
//
// For product documentation, see: https://firebase.google.com/products/app-distribution
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/firebaseappdistribution/v1alpha"
//	...
//	ctx := context.Background()
//	firebaseappdistributionService, err := firebaseappdistribution.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	firebaseappdistributionService, err := firebaseappdistribution.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	firebaseappdistributionService, err := firebaseappdistribution.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package firebaseappdistribution // import "google.golang.org/api/firebaseappdistribution/v1alpha"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "firebaseappdistribution:v1alpha"
const apiName = "firebaseappdistribution"
const apiVersion = "v1alpha"
const basePath = "https://firebaseappdistribution.googleapis.com/"
const basePathTemplate = "https://firebaseappdistribution.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://firebaseappdistribution.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Apps = NewAppsService(s)
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Apps *AppsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAppsService(s *Service) *AppsService {
	rs := &AppsService{s: s}
	rs.ReleaseByHash = NewAppsReleaseByHashService(s)
	rs.Releases = NewAppsReleasesService(s)
	rs.Testers = NewAppsTestersService(s)
	rs.UploadStatus = NewAppsUploadStatusService(s)
	return rs
}

type AppsService struct {
	s *Service

	ReleaseByHash *AppsReleaseByHashService

	Releases *AppsReleasesService

	Testers *AppsTestersService

	UploadStatus *AppsUploadStatusService
}

func NewAppsReleaseByHashService(s *Service) *AppsReleaseByHashService {
	rs := &AppsReleaseByHashService{s: s}
	return rs
}

type AppsReleaseByHashService struct {
	s *Service
}

func NewAppsReleasesService(s *Service) *AppsReleasesService {
	rs := &AppsReleasesService{s: s}
	rs.Notes = NewAppsReleasesNotesService(s)
	return rs
}

type AppsReleasesService struct {
	s *Service

	Notes *AppsReleasesNotesService
}

func NewAppsReleasesNotesService(s *Service) *AppsReleasesNotesService {
	rs := &AppsReleasesNotesService{s: s}
	return rs
}

type AppsReleasesNotesService struct {
	s *Service
}

func NewAppsTestersService(s *Service) *AppsTestersService {
	rs := &AppsTestersService{s: s}
	return rs
}

type AppsTestersService struct {
	s *Service
}

func NewAppsUploadStatusService(s *Service) *AppsUploadStatusService {
	rs := &AppsUploadStatusService{s: s}
	return rs
}

type AppsUploadStatusService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Apps = NewProjectsAppsService(s)
	rs.Testers = NewProjectsTestersService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Apps *ProjectsAppsService

	Testers *ProjectsTestersService
}

func NewProjectsAppsService(s *Service) *ProjectsAppsService {
	rs := &ProjectsAppsService{s: s}
	rs.Releases = NewProjectsAppsReleasesService(s)
	return rs
}

type ProjectsAppsService struct {
	s *Service

	Releases *ProjectsAppsReleasesService
}

func NewProjectsAppsReleasesService(s *Service) *ProjectsAppsReleasesService {
	rs := &ProjectsAppsReleasesService{s: s}
	rs.Tests = NewProjectsAppsReleasesTestsService(s)
	return rs
}

type ProjectsAppsReleasesService struct {
	s *Service

	Tests *ProjectsAppsReleasesTestsService
}

func NewProjectsAppsReleasesTestsService(s *Service) *ProjectsAppsReleasesTestsService {
	rs := &ProjectsAppsReleasesTestsService{s: s}
	return rs
}

type ProjectsAppsReleasesTestsService struct {
	s *Service
}

func NewProjectsTestersService(s *Service) *ProjectsTestersService {
	rs := &ProjectsTestersService{s: s}
	return rs
}

type ProjectsTestersService struct {
	s *Service
}

// GoogleFirebaseAppdistroV1Release: A release of a Firebase app.
type GoogleFirebaseAppdistroV1Release struct {
	// BinaryDownloadUri: Output only. A signed link (which expires in one hour) to
	// directly download the app binary (IPA/APK/AAB) file.
	BinaryDownloadUri string `json:"binaryDownloadUri,omitempty"`
	// BuildVersion: Output only. Build version of the release. For an Android
	// release, the build version is the `versionCode`. For an iOS release, the
	// build version is the `CFBundleVersion`.
	BuildVersion string `json:"buildVersion,omitempty"`
	// CreateTime: Output only. The time the release was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayVersion: Output only. Display version of the release. For an Android
	// release, the display version is the `versionName`. For an iOS release, the
	// display version is the `CFBundleShortVersionString`.
	DisplayVersion string `json:"displayVersion,omitempty"`
	// FirebaseConsoleUri: Output only. A link to the Firebase console displaying a
	// single release.
	FirebaseConsoleUri string `json:"firebaseConsoleUri,omitempty"`
	// Name: The name of the release resource. Format:
	// `projects/{project_number}/apps/{app_id}/releases/{release_id}`
	Name string `json:"name,omitempty"`
	// ReleaseNotes: Notes of the release.
	ReleaseNotes *GoogleFirebaseAppdistroV1ReleaseNotes `json:"releaseNotes,omitempty"`
	// TestingUri: Output only. A link to the release in the tester web clip or
	// Android app that lets testers (which were granted access to the app) view
	// release notes and install the app onto their devices.
	TestingUri string `json:"testingUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BinaryDownloadUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BinaryDownloadUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1Release) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1Release
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1ReleaseNotes: Notes that belong to a release.
type GoogleFirebaseAppdistroV1ReleaseNotes struct {
	// Text: The text of the release notes.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1ReleaseNotes) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1ReleaseNotes
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1UploadReleaseMetadata: Operation metadata for
// `UploadRelease`.
type GoogleFirebaseAppdistroV1UploadReleaseMetadata struct {
}

// GoogleFirebaseAppdistroV1UploadReleaseResponse: Response message for
// `UploadRelease`.
type GoogleFirebaseAppdistroV1UploadReleaseResponse struct {
	// Release: Release associated with the uploaded binary.
	Release *GoogleFirebaseAppdistroV1Release `json:"release,omitempty"`
	// Result: Result of upload release.
	//
	// Possible values:
	//   "UPLOAD_RELEASE_RESULT_UNSPECIFIED" - Upload binary result unspecified
	//   "RELEASE_CREATED" - Upload binary resulted in a new release
	//   "RELEASE_UPDATED" - Upload binary updated an existing release
	//   "RELEASE_UNMODIFIED" - Upload binary resulted in a no-op. A release with
	// the exact same binary already exists.
	Result string `json:"result,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Release") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Release") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1UploadReleaseResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1UploadReleaseResponse
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1alphaAabCertificate: App bundle test certificate
type GoogleFirebaseAppdistroV1alphaAabCertificate struct {
	// CertificateHashMd5: MD5 hash of the certificate used to resign the AAB
	CertificateHashMd5 string `json:"certificateHashMd5,omitempty"`
	// CertificateHashSha1: SHA1 hash of the certificate used to resign the AAB
	CertificateHashSha1 string `json:"certificateHashSha1,omitempty"`
	// CertificateHashSha256: SHA256 hash of the certificate used to resign the AAB
	CertificateHashSha256 string `json:"certificateHashSha256,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertificateHashMd5") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertificateHashMd5") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaAabCertificate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaAabCertificate
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

type GoogleFirebaseAppdistroV1alphaApp struct {
	// AabCertificate: App bundle test certificate generated for the app.
	AabCertificate *GoogleFirebaseAppdistroV1alphaAabCertificate `json:"aabCertificate,omitempty"`
	// AabState: App bundle state. Only valid for android apps. The app_view field
	// in the request must be set to FULL in order for this to be populated.
	//
	// Possible values:
	//   "AAB_STATE_UNSPECIFIED" - Aab state unspecified
	//   "ACTIVE" - App can receive app bundle uploads
	//   "PLAY_ACCOUNT_NOT_LINKED" - Firebase project is not linked to a Play
	// developer account
	//   "NO_APP_WITH_GIVEN_BUNDLE_ID_IN_PLAY_ACCOUNT" - There is no app in linked
	// Play developer account with the same bundle id
	//   "APP_NOT_PUBLISHED" - The app in Play developer account is not in a
	// published state
	//   "AAB_STATE_UNAVAILABLE" - Play App status is unavailable
	//   "PLAY_IAS_TERMS_NOT_ACCEPTED" - Play IAS terms not accepted
	AabState string `json:"aabState,omitempty"`
	// AppId: Firebase gmp app id
	AppId string `json:"appId,omitempty"`
	// BundleId: Bundle identifier
	BundleId string `json:"bundleId,omitempty"`
	// ContactEmail: Developer contact email for testers to reach out to about
	// privacy or support issues.
	ContactEmail string `json:"contactEmail,omitempty"`
	// Platform: iOS or Android
	Platform string `json:"platform,omitempty"`
	// ProjectNumber: Project number of the Firebase project, for example
	// 300830567303.
	ProjectNumber string `json:"projectNumber,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AabCertificate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AabCertificate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaApp) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaApp
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1alphaAppCrash: An app crash that occurred during an
// automated test.
type GoogleFirebaseAppdistroV1alphaAppCrash struct {
	// Message: Output only. The message associated with the crash.
	Message string `json:"message,omitempty"`
	// StackTrace: Output only. The raw stack trace.
	StackTrace string `json:"stackTrace,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaAppCrash) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaAppCrash
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

type GoogleFirebaseAppdistroV1alphaCreateReleaseNotesRequest struct {
	// ReleaseNotes: The actual release notes body from the user
	ReleaseNotes *GoogleFirebaseAppdistroV1alphaReleaseNotes `json:"releaseNotes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReleaseNotes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReleaseNotes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaCreateReleaseNotesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaCreateReleaseNotesRequest
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

type GoogleFirebaseAppdistroV1alphaCreateReleaseNotesResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleFirebaseAppdistroV1alphaDeviceExecution: The results of running an
// automated test on a particular device.
type GoogleFirebaseAppdistroV1alphaDeviceExecution struct {
	// AppCrash: Output only. An app crash, if any occurred during the test.
	AppCrash *GoogleFirebaseAppdistroV1alphaAppCrash `json:"appCrash,omitempty"`
	// CrawlGraphUri: Output only. A URI to an image of the Robo crawl graph.
	CrawlGraphUri string `json:"crawlGraphUri,omitempty"`
	// Device: Required. The device that the test was run on.
	Device *GoogleFirebaseAppdistroV1alphaTestDevice `json:"device,omitempty"`
	// FailedReason: Output only. The reason why the test failed.
	//
	// Possible values:
	//   "FAILED_REASON_UNSPECIFIED" - Reason unspecified.
	//   "CRASHED" - The app crashed during the test.
	//   "NOT_INSTALLED" - If an app is not installed and thus no test can be run
	// with the app. This might be caused by trying to run a test on an unsupported
	// platform.
	//   "UNABLE_TO_CRAWL" - If the app could not be crawled (possibly because the
	// app did not start).
	//   "DEVICE_OUT_OF_MEMORY" - If the device ran out of memory during the test.
	FailedReason string `json:"failedReason,omitempty"`
	// InconclusiveReason: Output only. The reason why the test was inconclusive.
	//
	// Possible values:
	//   "INCONCLUSIVE_REASON_UNSPECIFIED" - Reason unspecified.
	//   "QUOTA_EXCEEDED" - Not enough quota remained to run the test.
	//   "INFRASTRUCTURE_FAILURE" - The outcome of the test could not be determined
	// because of a failure in the test running infrastructure.
	//   "SERVICE_NOT_ACTIVATED" - A required cloud service api is not activated
	// (Google Cloud Testing API or Cloud Tool Results API).
	//   "NO_SIGNATURE" - The app was not signed.
	//   "NO_LAUNCHER_ACTIVITY" - A main launcher activity could not be found.
	//   "FORBIDDEN_PERMISSIONS" - The app declares one or more permissions that
	// are not allowed.
	//   "DEVICE_ADMIN_RECEIVER" - Device administrator applications are not
	// allowed.
	//   "NO_CODE_APK" - APK contains no code. See also
	// https://developer.android.com/guide/topics/manifest/application-element.html#code
	//   "INVALID_APK_PREVIEW_SDK" - APK is built for a preview SDK which is
	// unsupported.
	InconclusiveReason string `json:"inconclusiveReason,omitempty"`
	// ResultsStoragePath: Output only. The path to a directory in Cloud Storage
	// that will eventually contain the results for this execution. For example,
	// gs://bucket/Nexus5-18-en-portrait.
	ResultsStoragePath string `json:"resultsStoragePath,omitempty"`
	// RoboStats: Output only. The statistics collected during the Robo test.
	RoboStats *GoogleFirebaseAppdistroV1alphaRoboStats `json:"roboStats,omitempty"`
	// ScreenshotUris: Output only. A list of screenshot image URIs taken from the
	// Robo crawl. The file names are numbered by the order in which they were
	// taken.
	ScreenshotUris []string `json:"screenshotUris,omitempty"`
	// State: Output only. The state of the test.
	//
	// Possible values:
	//   "TEST_STATE_UNSPECIFIED" - Test state unspecified.
	//   "IN_PROGRESS" - The test is in progress.
	//   "PASSED" - The test has passed.
	//   "FAILED" - The test has failed.
	//   "INCONCLUSIVE" - The test was inconclusive.
	State string `json:"state,omitempty"`
	// VideoUri: Output only. A URI to a video of the test run.
	VideoUri string `json:"videoUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppCrash") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppCrash") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaDeviceExecution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaDeviceExecution
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

type GoogleFirebaseAppdistroV1alphaEnableAccessOnReleaseRequest struct {
	// BuildVersion: Optional. Ignored. Used to be build version of the app release
	// if an instance identifier was provided for the release_id.
	BuildVersion string `json:"buildVersion,omitempty"`
	// DisplayVersion: Optional. Ignored. Used to be display version of the app
	// release if an instance identifier was provided for the release_id.
	DisplayVersion string `json:"displayVersion,omitempty"`
	// Emails: Optional. An email address which should get access to this release,
	// for example rebeccahe@google.com
	Emails []string `json:"emails,omitempty"`
	// GroupIds: Optional. A repeated list of group aliases to enable access to a
	// release for Note: This field is misnamed, but can't be changed because we
	// need to maintain compatibility with old build tools
	GroupIds []string `json:"groupIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BuildVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuildVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaEnableAccessOnReleaseRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaEnableAccessOnReleaseRequest
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

type GoogleFirebaseAppdistroV1alphaEnableAccessOnReleaseResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleFirebaseAppdistroV1alphaGetReleaseByUploadHashResponse: Response
// object to get the release given a upload hash
type GoogleFirebaseAppdistroV1alphaGetReleaseByUploadHashResponse struct {
	// Release: Release object
	Release *GoogleFirebaseAppdistroV1alphaRelease `json:"release,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Release") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Release") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaGetReleaseByUploadHashResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaGetReleaseByUploadHashResponse
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1alphaGetTesterUdidsResponse: Response containing
// the UDIDs of tester iOS devices in a project
type GoogleFirebaseAppdistroV1alphaGetTesterUdidsResponse struct {
	// TesterUdids: The UDIDs of tester iOS devices in a project
	TesterUdids []*GoogleFirebaseAppdistroV1alphaTesterUdid `json:"testerUdids,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "TesterUdids") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TesterUdids") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaGetTesterUdidsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaGetTesterUdidsResponse
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

type GoogleFirebaseAppdistroV1alphaGetUploadStatusResponse struct {
	// ErrorCode: The error code associated with (only set on "FAILURE")
	//
	// Possible values:
	//   "ERROR_UNSPECIFIED"
	//   "INVALID_ZIP"
	//   "MISSING_PLIST"
	//   "MISSING_PROFILE"
	//   "VERSION_TOO_LONG"
	//   "MISSING_UUIDS"
	//   "MISSING_RESOURCES"
	//   "MISSING_MANIFEST"
	//   "IOS_METADATA_ERROR"
	//   "ANDROID_METADATA_ERROR"
	//   "UNSUPPORTED_PLATFORM_TYPE"
	//   "BUNDLE_ID_MISMATCH"
	//   "APK_NOT_ZIP_ALIGNED"
	//   "INVALID_CERTIFICATE"
	//   "APK_TOO_LARGE"
	//   "AAB_NOT_PUBLISHED"
	//   "INVALID_PLIST_DEVICE_FAMILIES"
	//   "AAB_TOS_NOT_ACCEPTED"
	//   "APP_NAME_TOO_LONG"
	//   "AAB_DEVELOPER_ACCOUNT_NOT_LINKED"
	//   "AAB_NO_APP_WITH_GIVEN_PACKAGE_NAME_IN_ACCOUNT"
	//   "AAB_UPLOAD_ERROR"
	ErrorCode string `json:"errorCode,omitempty"`
	// Message: Any additional context for the given upload status (e.g. error
	// message) Meant to be displayed to the client
	Message string `json:"message,omitempty"`
	// Release: The release that was created from the upload (only set on
	// "SUCCESS")
	Release *GoogleFirebaseAppdistroV1alphaRelease `json:"release,omitempty"`
	// Status: The status of the upload
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED"
	//   "IN_PROGRESS"
	//   "ALREADY_UPLOADED"
	//   "SUCCESS"
	//   "ERROR"
	Status string `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ErrorCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaGetUploadStatusResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaGetUploadStatusResponse
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

type GoogleFirebaseAppdistroV1alphaJwt struct {
	Token string `json:"token,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Token") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Token") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaJwt) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaJwt
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1alphaListReleaseTestsResponse: The response message
// for `ListReleaseTests`.
type GoogleFirebaseAppdistroV1alphaListReleaseTestsResponse struct {
	// NextPageToken: A short-lived token, which can be sent as `pageToken` to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ReleaseTests: The tests listed.
	ReleaseTests []*GoogleFirebaseAppdistroV1alphaReleaseTest `json:"releaseTests,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaListReleaseTestsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaListReleaseTestsResponse
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1alphaLoginCredential: Login credential for
// automated tests
type GoogleFirebaseAppdistroV1alphaLoginCredential struct {
	// FieldHints: Optional. Hints to the crawler for identifying input fields
	FieldHints *GoogleFirebaseAppdistroV1alphaLoginCredentialFieldHints `json:"fieldHints,omitempty"`
	// Google: Optional. Are these credentials for Google?
	Google bool `json:"google,omitempty"`
	// Password: Optional. Password for automated tests
	Password string `json:"password,omitempty"`
	// Username: Optional. Username for automated tests
	Username string `json:"username,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldHints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldHints") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaLoginCredential) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaLoginCredential
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1alphaLoginCredentialFieldHints: Hints to the
// crawler for identifying input fields
type GoogleFirebaseAppdistroV1alphaLoginCredentialFieldHints struct {
	// PasswordResourceName: Required. The Android resource name of the password UI
	// element. For example, in Java: R.string.foo in xml: @string/foo Only the
	// "foo" part is needed. Reference doc:
	// https://developer.android.com/guide/topics/resources/accessing-resources.html
	PasswordResourceName string `json:"passwordResourceName,omitempty"`
	// UsernameResourceName: Required. The Android resource name of the username UI
	// element. For example, in Java: R.string.foo in xml: @string/foo Only the
	// "foo" part is needed. Reference doc:
	// https://developer.android.com/guide/topics/resources/accessing-resources.html
	UsernameResourceName string `json:"usernameResourceName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PasswordResourceName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PasswordResourceName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaLoginCredentialFieldHints) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaLoginCredentialFieldHints
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

type GoogleFirebaseAppdistroV1alphaProvisionAppResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleFirebaseAppdistroV1alphaRelease: Proto defining a release object
type GoogleFirebaseAppdistroV1alphaRelease struct {
	// BuildVersion: Release build version
	BuildVersion string `json:"buildVersion,omitempty"`
	// DisplayVersion: Release version
	DisplayVersion string `json:"displayVersion,omitempty"`
	// DistributedAt: Timestamp when the release was created
	DistributedAt string `json:"distributedAt,omitempty"`
	// Id: Release Id
	Id string `json:"id,omitempty"`
	// InstanceId: Instance id of the release
	InstanceId string `json:"instanceId,omitempty"`
	// LastActivityAt: Last activity timestamp
	LastActivityAt string `json:"lastActivityAt,omitempty"`
	// OpenInvitationCount: Number of testers who have open invitations for the
	// release
	OpenInvitationCount int64 `json:"openInvitationCount,omitempty"`
	// ReceivedAt: unused.
	ReceivedAt string `json:"receivedAt,omitempty"`
	// ReleaseNotesSummary: Release notes summary
	ReleaseNotesSummary string `json:"releaseNotesSummary,omitempty"`
	// TesterCount: Count of testers added to the release
	TesterCount int64 `json:"testerCount,omitempty"`
	// TesterWithInstallCount: Number of testers who have installed the release
	TesterWithInstallCount int64 `json:"testerWithInstallCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BuildVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuildVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaRelease) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaRelease
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

type GoogleFirebaseAppdistroV1alphaReleaseNotes struct {
	ReleaseNotes string `json:"releaseNotes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReleaseNotes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReleaseNotes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaReleaseNotes) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaReleaseNotes
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1alphaReleaseTest: The results of running an
// automated test on a release.
type GoogleFirebaseAppdistroV1alphaReleaseTest struct {
	// CreateTime: Output only. Timestamp when the test was run.
	CreateTime string `json:"createTime,omitempty"`
	// DeviceExecutions: Required. The results of the test on each device.
	DeviceExecutions []*GoogleFirebaseAppdistroV1alphaDeviceExecution `json:"deviceExecutions,omitempty"`
	// LoginCredential: Optional. Input only. Login credentials for the test. Input
	// only.
	LoginCredential *GoogleFirebaseAppdistroV1alphaLoginCredential `json:"loginCredential,omitempty"`
	// Name: The name of the release test resource. Format:
	// `projects/{project_number}/apps/{app_id}/releases/{release_id}/tests/{test_id
	// }`
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaReleaseTest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaReleaseTest
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1alphaRoboCrawler: Configuration for Robo crawler
type GoogleFirebaseAppdistroV1alphaRoboCrawler struct {
	// LoginCredential: Optional. Login credential for automated tests
	LoginCredential *GoogleFirebaseAppdistroV1alphaLoginCredential `json:"loginCredential,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LoginCredential") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LoginCredential") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaRoboCrawler) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaRoboCrawler
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1alphaRoboStats: Statistics collected during a Robo
// test.
type GoogleFirebaseAppdistroV1alphaRoboStats struct {
	// ActionsPerformed: Output only. Number of actions that crawler performed.
	ActionsPerformed int64 `json:"actionsPerformed,omitempty"`
	// CrawlDuration: Output only. Duration of crawl.
	CrawlDuration string `json:"crawlDuration,omitempty"`
	// DistinctVisitedScreens: Output only. Number of distinct screens visited.
	DistinctVisitedScreens int64 `json:"distinctVisitedScreens,omitempty"`
	// MainActivityCrawlTimedOut: Output only. Whether the main activity crawl
	// timed out.
	MainActivityCrawlTimedOut bool `json:"mainActivityCrawlTimedOut,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionsPerformed") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionsPerformed") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaRoboStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaRoboStats
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1alphaTestConfig: Configuration for automated tests
type GoogleFirebaseAppdistroV1alphaTestConfig struct {
	// Name: Identifier. The name of the test configuration resource. Format:
	// `projects/{project_number}/apps/{app_id}/testConfig`
	Name string `json:"name,omitempty"`
	// RoboCrawler: Optional. Configuration for Robo crawler
	RoboCrawler *GoogleFirebaseAppdistroV1alphaRoboCrawler `json:"roboCrawler,omitempty"`
	// TestDevices: Optional. Tests will be run on this list of devices
	TestDevices []*GoogleFirebaseAppdistroV1alphaTestDevice `json:"testDevices,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaTestConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaTestConfig
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1alphaTestDevice: A device on which automated tests
// can be run.
type GoogleFirebaseAppdistroV1alphaTestDevice struct {
	// Locale: Optional. The locale of the device (e.g. "en_US" for US English)
	// during the test.
	Locale string `json:"locale,omitempty"`
	// Model: Required. The device model.
	Model string `json:"model,omitempty"`
	// Orientation: Optional. The orientation of the device during the test.
	Orientation string `json:"orientation,omitempty"`
	// Version: Required. The version of the device (API level on Android).
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Locale") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locale") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaTestDevice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaTestDevice
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1alphaTesterUdid: The UDIDs of a tester's iOS device
type GoogleFirebaseAppdistroV1alphaTesterUdid struct {
	// Name: The name of the tester's device
	Name string `json:"name,omitempty"`
	// Platform: The platform of the tester's device
	Platform string `json:"platform,omitempty"`
	// Udid: The UDID of the tester's device
	Udid string `json:"udid,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s *GoogleFirebaseAppdistroV1alphaTesterUdid) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1alphaTesterUdid
	return gensupport.MarshalJSON(NoMethod(*s), s.ForceSendFields, s.NullFields)
}

type AppsGetCall struct {
	s              *Service
	mobilesdkAppId string
	urlParams_     gensupport.URLParams
	ifNoneMatch_   string
	ctx_           context.Context
	header_        http.Header
}

// Get: Get the app, if it exists
//
//   - mobilesdkAppId: Unique id for a Firebase app of the format:
//     {version}:{project_number}:{platform}:{hash(bundle_id)} Example:
//     1:581234567376:android:aa0a3c7b135e90289.
func (r *AppsService) Get(mobilesdkAppId string) *AppsGetCall {
	c := &AppsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.mobilesdkAppId = mobilesdkAppId
	return c
}

// AppView sets the optional parameter "appView": App view. When unset or set
// to BASIC, returns an App with everything set except for aab_state. When set
// to FULL, returns an App with aab_state set.
//
// Possible values:
//
//	"APP_VIEW_UNSPECIFIED" - The default / unset value. The API will default
//
// to the BASIC view.
//
//	"BASIC" - Include everything except aab_state.
//	"FULL" - Include everything.
func (c *AppsGetCall) AppView(appView string) *AppsGetCall {
	c.urlParams_.Set("appView", appView)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AppsGetCall) Fields(s ...googleapi.Field) *AppsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AppsGetCall) IfNoneMatch(entityTag string) *AppsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AppsGetCall) Context(ctx context.Context) *AppsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AppsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AppsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/apps/{mobilesdkAppId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"mobilesdkAppId": c.mobilesdkAppId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.apps.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1alphaApp.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AppsGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1alphaApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1alphaApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type AppsGetJwtCall struct {
	s              *Service
	mobilesdkAppId string
	urlParams_     gensupport.URLParams
	ifNoneMatch_   string
	ctx_           context.Context
	header_        http.Header
}

// GetJwt: Get a JWT token
//
//   - mobilesdkAppId: Unique id for a Firebase app of the format:
//     {version}:{project_number}:{platform}:{hash(bundle_id)} Example:
//     1:581234567376:android:aa0a3c7b135e90289.
func (r *AppsService) GetJwt(mobilesdkAppId string) *AppsGetJwtCall {
	c := &AppsGetJwtCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.mobilesdkAppId = mobilesdkAppId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AppsGetJwtCall) Fields(s ...googleapi.Field) *AppsGetJwtCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AppsGetJwtCall) IfNoneMatch(entityTag string) *AppsGetJwtCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AppsGetJwtCall) Context(ctx context.Context) *AppsGetJwtCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AppsGetJwtCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AppsGetJwtCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/apps/{mobilesdkAppId}/jwt")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"mobilesdkAppId": c.mobilesdkAppId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.apps.getJwt" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1alphaJwt.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AppsGetJwtCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1alphaJwt, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1alphaJwt{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type AppsProvisionAppCall struct {
	s              *Service
	mobilesdkAppId string
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// ProvisionApp: Provision app distribution for an existing Firebase app,
// enabling it to subsequently be used by appdistro.
//
//   - mobilesdkAppId: Unique id for a Firebase app of the format:
//     {version}:{project_number}:{platform}:{hash(bundle_id)} Example:
//     1:581234567376:android:aa0a3c7b135e90289.
func (r *AppsService) ProvisionApp(mobilesdkAppId string) *AppsProvisionAppCall {
	c := &AppsProvisionAppCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.mobilesdkAppId = mobilesdkAppId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AppsProvisionAppCall) Fields(s ...googleapi.Field) *AppsProvisionAppCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AppsProvisionAppCall) Context(ctx context.Context) *AppsProvisionAppCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AppsProvisionAppCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AppsProvisionAppCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/apps/{mobilesdkAppId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"mobilesdkAppId": c.mobilesdkAppId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.apps.provisionApp" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1alphaProvisionAppResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AppsProvisionAppCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1alphaProvisionAppResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1alphaProvisionAppResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type AppsReleaseByHashGetCall struct {
	s              *Service
	mobilesdkAppId string
	uploadHash     string
	urlParams_     gensupport.URLParams
	ifNoneMatch_   string
	ctx_           context.Context
	header_        http.Header
}

// Get: GET Release by binary upload hash
//
//   - mobilesdkAppId: Unique id for a Firebase app of the format:
//     {version}:{project_number}:{platform}:{hash(bundle_id)} Example:
//     1:581234567376:android:aa0a3c7b135e90289.
//   - uploadHash: The hash for the upload.
func (r *AppsReleaseByHashService) Get(mobilesdkAppId string, uploadHash string) *AppsReleaseByHashGetCall {
	c := &AppsReleaseByHashGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.mobilesdkAppId = mobilesdkAppId
	c.uploadHash = uploadHash
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AppsReleaseByHashGetCall) Fields(s ...googleapi.Field) *AppsReleaseByHashGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AppsReleaseByHashGetCall) IfNoneMatch(entityTag string) *AppsReleaseByHashGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AppsReleaseByHashGetCall) Context(ctx context.Context) *AppsReleaseByHashGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AppsReleaseByHashGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AppsReleaseByHashGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/apps/{mobilesdkAppId}/release_by_hash/{uploadHash}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"mobilesdkAppId": c.mobilesdkAppId,
		"uploadHash":     c.uploadHash,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.apps.release_by_hash.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1alphaGetReleaseByUploadHashResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AppsReleaseByHashGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1alphaGetReleaseByUploadHashResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1alphaGetReleaseByUploadHashResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type AppsReleasesEnableAccessCall struct {
	s                                                          *Service
	mobilesdkAppId                                             string
	releaseId                                                  string
	googlefirebaseappdistrov1alphaenableaccessonreleaserequest *GoogleFirebaseAppdistroV1alphaEnableAccessOnReleaseRequest
	urlParams_                                                 gensupport.URLParams
	ctx_                                                       context.Context
	header_                                                    http.Header
}

// EnableAccess: Enable access on a release for testers.
//
//   - mobilesdkAppId: Unique id for a Firebase app of the format:
//     {version}:{project_number}:{platform}:{hash(bundle_id)} Example:
//     1:581234567376:android:aa0a3c7b135e90289.
//   - releaseId: Release identifier.
func (r *AppsReleasesService) EnableAccess(mobilesdkAppId string, releaseId string, googlefirebaseappdistrov1alphaenableaccessonreleaserequest *GoogleFirebaseAppdistroV1alphaEnableAccessOnReleaseRequest) *AppsReleasesEnableAccessCall {
	c := &AppsReleasesEnableAccessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.mobilesdkAppId = mobilesdkAppId
	c.releaseId = releaseId
	c.googlefirebaseappdistrov1alphaenableaccessonreleaserequest = googlefirebaseappdistrov1alphaenableaccessonreleaserequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AppsReleasesEnableAccessCall) Fields(s ...googleapi.Field) *AppsReleasesEnableAccessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AppsReleasesEnableAccessCall) Context(ctx context.Context) *AppsReleasesEnableAccessCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AppsReleasesEnableAccessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AppsReleasesEnableAccessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappdistrov1alphaenableaccessonreleaserequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/apps/{mobilesdkAppId}/releases/{releaseId}/enable_access")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"mobilesdkAppId": c.mobilesdkAppId,
		"releaseId":      c.releaseId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.apps.releases.enable_access" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1alphaEnableAccessOnReleaseResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AppsReleasesEnableAccessCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1alphaEnableAccessOnReleaseResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1alphaEnableAccessOnReleaseResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type AppsReleasesNotesCreateCall struct {
	s                                                       *Service
	mobilesdkAppId                                          string
	releaseId                                               string
	googlefirebaseappdistrov1alphacreatereleasenotesrequest *GoogleFirebaseAppdistroV1alphaCreateReleaseNotesRequest
	urlParams_                                              gensupport.URLParams
	ctx_                                                    context.Context
	header_                                                 http.Header
}

// Create: Create release notes on a release.
//
//   - mobilesdkAppId: Unique id for a Firebase app of the format:
//     {version}:{project_number}:{platform}:{hash(bundle_id)} Example:
//     1:581234567376:android:aa0a3c7b135e90289.
//   - releaseId: Release identifier.
func (r *AppsReleasesNotesService) Create(mobilesdkAppId string, releaseId string, googlefirebaseappdistrov1alphacreatereleasenotesrequest *GoogleFirebaseAppdistroV1alphaCreateReleaseNotesRequest) *AppsReleasesNotesCreateCall {
	c := &AppsReleasesNotesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.mobilesdkAppId = mobilesdkAppId
	c.releaseId = releaseId
	c.googlefirebaseappdistrov1alphacreatereleasenotesrequest = googlefirebaseappdistrov1alphacreatereleasenotesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AppsReleasesNotesCreateCall) Fields(s ...googleapi.Field) *AppsReleasesNotesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AppsReleasesNotesCreateCall) Context(ctx context.Context) *AppsReleasesNotesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AppsReleasesNotesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AppsReleasesNotesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappdistrov1alphacreatereleasenotesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/apps/{mobilesdkAppId}/releases/{releaseId}/notes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"mobilesdkAppId": c.mobilesdkAppId,
		"releaseId":      c.releaseId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.apps.releases.notes.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1alphaCreateReleaseNotesResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AppsReleasesNotesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1alphaCreateReleaseNotesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1alphaCreateReleaseNotesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type AppsTestersGetTesterUdidsCall struct {
	s              *Service
	mobilesdkAppId string
	urlParams_     gensupport.URLParams
	ifNoneMatch_   string
	ctx_           context.Context
	header_        http.Header
}

// GetTesterUdids: Get UDIDs of tester iOS devices in a project
//
//   - mobilesdkAppId: Unique id for a Firebase app of the format:
//     {version}:{project_number}:{platform}:{hash(bundle_id)} Example:
//     1:581234567376:android:aa0a3c7b135e90289.
func (r *AppsTestersService) GetTesterUdids(mobilesdkAppId string) *AppsTestersGetTesterUdidsCall {
	c := &AppsTestersGetTesterUdidsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.mobilesdkAppId = mobilesdkAppId
	return c
}

// Project sets the optional parameter "project": The name of the project,
// which is the parent of testers Format: `projects/{project_number}`
func (c *AppsTestersGetTesterUdidsCall) Project(project string) *AppsTestersGetTesterUdidsCall {
	c.urlParams_.Set("project", project)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AppsTestersGetTesterUdidsCall) Fields(s ...googleapi.Field) *AppsTestersGetTesterUdidsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AppsTestersGetTesterUdidsCall) IfNoneMatch(entityTag string) *AppsTestersGetTesterUdidsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AppsTestersGetTesterUdidsCall) Context(ctx context.Context) *AppsTestersGetTesterUdidsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AppsTestersGetTesterUdidsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AppsTestersGetTesterUdidsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/apps/{mobilesdkAppId}/testers:getTesterUdids")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"mobilesdkAppId": c.mobilesdkAppId,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.apps.testers.getTesterUdids" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1alphaGetTesterUdidsResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AppsTestersGetTesterUdidsCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1alphaGetTesterUdidsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1alphaGetTesterUdidsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type AppsUploadStatusGetCall struct {
	s              *Service
	mobilesdkAppId string
	uploadToken    string
	urlParams_     gensupport.URLParams
	ifNoneMatch_   string
	ctx_           context.Context
	header_        http.Header
}

// Get: GET Binary upload status by token
//
//   - mobilesdkAppId: Unique id for a Firebase app of the format:
//     {version}:{project_number}:{platform}:{hash(bundle_id)} Example:
//     1:581234567376:android:aa0a3c7b135e90289.
//   - uploadToken: The token for the upload.
func (r *AppsUploadStatusService) Get(mobilesdkAppId string, uploadToken string) *AppsUploadStatusGetCall {
	c := &AppsUploadStatusGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.mobilesdkAppId = mobilesdkAppId
	c.uploadToken = uploadToken
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AppsUploadStatusGetCall) Fields(s ...googleapi.Field) *AppsUploadStatusGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *AppsUploadStatusGetCall) IfNoneMatch(entityTag string) *AppsUploadStatusGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AppsUploadStatusGetCall) Context(ctx context.Context) *AppsUploadStatusGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AppsUploadStatusGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AppsUploadStatusGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/apps/{mobilesdkAppId}/upload_status/{uploadToken}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"mobilesdkAppId": c.mobilesdkAppId,
		"uploadToken":    c.uploadToken,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.apps.upload_status.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1alphaGetUploadStatusResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AppsUploadStatusGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1alphaGetUploadStatusResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1alphaGetUploadStatusResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsAppsGetTestConfigCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetTestConfig: Gets configuration for automated tests.
//
//   - name: The name of the `TestConfig` resource to retrieve. Format:
//     `projects/{project_number}/apps/{app_id}/testConfig`.
func (r *ProjectsAppsService) GetTestConfig(name string) *ProjectsAppsGetTestConfigCall {
	c := &ProjectsAppsGetTestConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsGetTestConfigCall) Fields(s ...googleapi.Field) *ProjectsAppsGetTestConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsGetTestConfigCall) IfNoneMatch(entityTag string) *ProjectsAppsGetTestConfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsGetTestConfigCall) Context(ctx context.Context) *ProjectsAppsGetTestConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsGetTestConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsGetTestConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.getTestConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1alphaTestConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsGetTestConfigCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1alphaTestConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1alphaTestConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsAppsUpdateTestConfigCall struct {
	s                                        *Service
	name                                     string
	googlefirebaseappdistrov1alphatestconfig *GoogleFirebaseAppdistroV1alphaTestConfig
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// UpdateTestConfig: Updates a release.
//
//   - name: Identifier. The name of the test configuration resource. Format:
//     `projects/{project_number}/apps/{app_id}/testConfig`.
func (r *ProjectsAppsService) UpdateTestConfig(name string, googlefirebaseappdistrov1alphatestconfig *GoogleFirebaseAppdistroV1alphaTestConfig) *ProjectsAppsUpdateTestConfigCall {
	c := &ProjectsAppsUpdateTestConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappdistrov1alphatestconfig = googlefirebaseappdistrov1alphatestconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update.
func (c *ProjectsAppsUpdateTestConfigCall) UpdateMask(updateMask string) *ProjectsAppsUpdateTestConfigCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsUpdateTestConfigCall) Fields(s ...googleapi.Field) *ProjectsAppsUpdateTestConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsUpdateTestConfigCall) Context(ctx context.Context) *ProjectsAppsUpdateTestConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsUpdateTestConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsUpdateTestConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappdistrov1alphatestconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.updateTestConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1alphaTestConfig.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsUpdateTestConfigCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1alphaTestConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1alphaTestConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsAppsReleasesTestsCreateCall struct {
	s                                         *Service
	parent                                    string
	googlefirebaseappdistrov1alphareleasetest *GoogleFirebaseAppdistroV1alphaReleaseTest
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Create: Run automated test(s) on release.
//
//   - parent: The name of the release resource, which is the parent of the test
//     Format: `projects/{project_number}/apps/{app_id}/releases/{release_id}`.
func (r *ProjectsAppsReleasesTestsService) Create(parent string, googlefirebaseappdistrov1alphareleasetest *GoogleFirebaseAppdistroV1alphaReleaseTest) *ProjectsAppsReleasesTestsCreateCall {
	c := &ProjectsAppsReleasesTestsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlefirebaseappdistrov1alphareleasetest = googlefirebaseappdistrov1alphareleasetest
	return c
}

// ReleaseTestId sets the optional parameter "releaseTestId": The ID to use for
// the test, which will become the final component of the tests's resource
// name. This value should be 4-63 characters, and valid characters are /a-z-/.
// If it is not provided one will be automatically generated.
func (c *ProjectsAppsReleasesTestsCreateCall) ReleaseTestId(releaseTestId string) *ProjectsAppsReleasesTestsCreateCall {
	c.urlParams_.Set("releaseTestId", releaseTestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsReleasesTestsCreateCall) Fields(s ...googleapi.Field) *ProjectsAppsReleasesTestsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsReleasesTestsCreateCall) Context(ctx context.Context) *ProjectsAppsReleasesTestsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsReleasesTestsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsReleasesTestsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlefirebaseappdistrov1alphareleasetest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/tests")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.releases.tests.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1alphaReleaseTest.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsReleasesTestsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1alphaReleaseTest, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1alphaReleaseTest{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsAppsReleasesTestsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get results for automated test run on release.
//
//   - name: The name of the release test resource. Format:
//     `projects/{project_number}/apps/{app_id}/releases/{release_id}/tests/{test_
//     id}`.
func (r *ProjectsAppsReleasesTestsService) Get(name string) *ProjectsAppsReleasesTestsGetCall {
	c := &ProjectsAppsReleasesTestsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsReleasesTestsGetCall) Fields(s ...googleapi.Field) *ProjectsAppsReleasesTestsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsReleasesTestsGetCall) IfNoneMatch(entityTag string) *ProjectsAppsReleasesTestsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsReleasesTestsGetCall) Context(ctx context.Context) *ProjectsAppsReleasesTestsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsReleasesTestsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsReleasesTestsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.releases.tests.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1alphaReleaseTest.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsReleasesTestsGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1alphaReleaseTest, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1alphaReleaseTest{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type ProjectsAppsReleasesTestsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List results for automated tests run on release.
//
//   - parent: The name of the release resource, which is the parent of the tests
//     Format: `projects/{project_number}/apps/{app_id}/releases/{release_id}`.
func (r *ProjectsAppsReleasesTestsService) List(parent string) *ProjectsAppsReleasesTestsListCall {
	c := &ProjectsAppsReleasesTestsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of tests
// to return. The service may return fewer than this value.
func (c *ProjectsAppsReleasesTestsListCall) PageSize(pageSize int64) *ProjectsAppsReleasesTestsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListReleaseTests` call. Provide this to retrieve the
// subsequent page.
func (c *ProjectsAppsReleasesTestsListCall) PageToken(pageToken string) *ProjectsAppsReleasesTestsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsReleasesTestsListCall) Fields(s ...googleapi.Field) *ProjectsAppsReleasesTestsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsReleasesTestsListCall) IfNoneMatch(entityTag string) *ProjectsAppsReleasesTestsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsReleasesTestsListCall) Context(ctx context.Context) *ProjectsAppsReleasesTestsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsReleasesTestsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsReleasesTestsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/tests")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.releases.tests.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1alphaListReleaseTestsResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in error.(*googleapi.Error).Header.
//
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsReleasesTestsListCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1alphaListReleaseTestsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1alphaListReleaseTestsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAppsReleasesTestsListCall) Pages(ctx context.Context, f func(*GoogleFirebaseAppdistroV1alphaListReleaseTestsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsTestersGetUdidsCall struct {
	s            *Service
	project      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetUdids: Get UDIDs of tester iOS devices in a project
//
//   - project: The name of the project, which is the parent of testers Format:
//     `projects/{project_number}`.
func (r *ProjectsTestersService) GetUdids(project string) *ProjectsTestersGetUdidsCall {
	c := &ProjectsTestersGetUdidsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	return c
}

// MobilesdkAppId sets the optional parameter "mobilesdkAppId": Unique id for a
// Firebase app of the format:
// {version}:{project_number}:{platform}:{hash(bundle_id)} Example:
// 1:581234567376:android:aa0a3c7b135e90289
func (c *ProjectsTestersGetUdidsCall) MobilesdkAppId(mobilesdkAppId string) *ProjectsTestersGetUdidsCall {
	c.urlParams_.Set("mobilesdkAppId", mobilesdkAppId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsTestersGetUdidsCall) Fields(s ...googleapi.Field) *ProjectsTestersGetUdidsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsTestersGetUdidsCall) IfNoneMatch(entityTag string) *ProjectsTestersGetUdidsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsTestersGetUdidsCall) Context(ctx context.Context) *ProjectsTestersGetUdidsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsTestersGetUdidsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsTestersGetUdidsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+project}/testers:udids")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.testers.getUdids" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1alphaGetTesterUdidsResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsTestersGetUdidsCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1alphaGetTesterUdidsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1alphaGetTesterUdidsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}
