// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// OpenSearch Service API
//
// The OpenSearch service API provides access to OCI Search Service with OpenSearch.
//

package opensearch

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// UpgradeOpenSearchClusterDetails Minor or major version upgrade of a cluster.
type UpgradeOpenSearchClusterDetails struct {

	// The display name of the original cluster.
	// This is required to validate that the cluster ID has the same display name.
	OriginalClusterDisplayName *string `mandatory:"true" json:"originalClusterDisplayName"`

	// The software version the cluster is desired.
	DesiredSoftwareVersion *string `mandatory:"true" json:"desiredSoftwareVersion"`

	// The upgrade type of cluster (major or minor).
	UpgradeType UpgradeTypeEnum `mandatory:"true" json:"upgradeType"`

	// The cluster would be cloned for true and updated for false with the provided version.
	IsClone *bool `mandatory:"false" json:"isClone"`

	// Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
	// Example: `{"bar-key": "value"}`
	FreeformTags map[string]string `mandatory:"false" json:"freeformTags"`

	// Defined tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"foo-namespace": {"bar-key": "value"}}`
	DefinedTags map[string]map[string]interface{} `mandatory:"false" json:"definedTags"`

	// Usage of system tag keys. These predefined keys are scoped to namespaces.
	// Example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
	SystemTags map[string]map[string]interface{} `mandatory:"false" json:"systemTags"`

	// Security attributes for this resource. Each key is predefined and scoped to a namespace.
	// For more information, see Resource Tags (https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
	// Example: `{"Oracle-ZPR": {"MaxEgressCount": {"value": "42", "mode": "enforce"}}}`
	SecurityAttributes map[string]map[string]interface{} `mandatory:"false" json:"securityAttributes"`
}

func (m UpgradeOpenSearchClusterDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m UpgradeOpenSearchClusterDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingUpgradeTypeEnum(string(m.UpgradeType)); !ok && m.UpgradeType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for UpgradeType: %s. Supported values are: %s.", m.UpgradeType, strings.Join(GetUpgradeTypeEnumStringValues(), ",")))
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
