// DO NOT EDIT: This file is autogenerated via the builtin command.

package promql

import (
	flux "github.com/influxdata/flux"
	ast "github.com/influxdata/flux/ast"
)

func init() {
	flux.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Errors: nil,
		Loc:    nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 25,
					Line:   120,
				},
				File:   "promql.flux",
				Source: "package promql\n\nimport \"math\" \nimport \"universe\"\nimport \"experimental\"\n\n// changes() implements functionality equivalent to PromQL's changes() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#changes\nbuiltin changes\n\n// promqlDayOfMonth() implements functionality equivalent to PromQL's day_of_month() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#day_of_month\nbuiltin promqlDayOfMonth\n\n// promqlDayOfWeek() implements functionality equivalent to PromQL's day_of_week() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#day_of_week\nbuiltin promqlDayOfWeek\n\n// promqlDaysInMonth() implements functionality equivalent to PromQL's days_in_month() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#days_in_month\nbuiltin promqlDaysInMonth\n\n// emptyTable() returns an empty table, which is used as a helper function to implement\n// PromQL's time() and vector() functions:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#time\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#vector\nbuiltin emptyTable\n\n// extrapolatedRate() is a helper function that calculates extrapolated rates over\n// counters and is used to implement PromQL's rate(), delta(), and increase() functions.\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#rate\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#increase\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#delta\nbuiltin extrapolatedRate\n\n// holtWinters() implements functionality equivalent to PromQL's holt_winters()\n// function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#holt_winters\nbuiltin holtWinters\n\n// promqlHour() implements functionality equivalent to PromQL's hour() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#hour\nbuiltin promqlHour\n\n// instantRate() is a helper function that calculates instant rates over\n// counters and is used to implement PromQL's irate() and idelta() functions.\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#irate\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#idelta\nbuiltin instantRate\n\n// labelReplace implements functionality equivalent to PromQL's label_replace() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#label_replace\nbuiltin labelReplace\n\n// linearRegression implements linear regression functionality required to implement\n// PromQL's deriv() and predict_linear() functions:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#deriv\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#predict_linear\nbuiltin linearRegression\n\n// promqlMinute() implements functionality equivalent to PromQL's minute() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#minute\nbuiltin promqlMinute\n\n// promqlMonth() implements functionality equivalent to PromQL's month() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#month\nbuiltin promqlMonth\n\n// promHistogramQuantile() implements functionality equivalent to PromQL's\n// histogram_quantile() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#histogram_quantile\nbuiltin promHistogramQuantile\n\n// resets() implements functionality equivalent to PromQL's resets() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#resets\nbuiltin resets\n\n// timestamp() implements functionality equivalent to PromQL's timestamp() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#timestamp\nbuiltin timestamp\n\n// promqlYear() implements functionality equivalent to PromQL's year() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#year\nbuiltin promqlYear\n\n// quantile() accounts checks for quantile values that are out of range, above 1.0 or \n// below 0.0, by either returning positive infinity or negative infinity in the `_value` \n// column respectively. q must be a float \n\nquantile = (q, tables=<-, method=\"exact_mean\") => \n    // value is in normal range. We can use the normal quantile function\n    if q <= 1.0 and q >= 0.0 then \n    (tables\n        |> universe.quantile(q: q, method: method))\n    else if q < 0.0 then\n    (tables\n        |> reduce(identity: {_value: math.mInf(sign: -1)}, fn: (r, accumulator) => accumulator))\n    else \n    (tables\n        |> reduce(identity: {_value: math.mInf(sign: 1)}, fn: (r, accumulator) => accumulator))\n\njoin = experimental.join",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   11,
					},
					File:   "promql.flux",
					Source: "builtin changes",
					Start: ast.Position{
						Column: 1,
						Line:   11,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   11,
						},
						File:   "promql.flux",
						Source: "changes",
						Start: ast.Position{
							Column: 9,
							Line:   11,
						},
					},
				},
				Name: "changes",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   16,
					},
					File:   "promql.flux",
					Source: "builtin promqlDayOfMonth",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   16,
						},
						File:   "promql.flux",
						Source: "promqlDayOfMonth",
						Start: ast.Position{
							Column: 9,
							Line:   16,
						},
					},
				},
				Name: "promqlDayOfMonth",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   21,
					},
					File:   "promql.flux",
					Source: "builtin promqlDayOfWeek",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   21,
						},
						File:   "promql.flux",
						Source: "promqlDayOfWeek",
						Start: ast.Position{
							Column: 9,
							Line:   21,
						},
					},
				},
				Name: "promqlDayOfWeek",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 26,
						Line:   26,
					},
					File:   "promql.flux",
					Source: "builtin promqlDaysInMonth",
					Start: ast.Position{
						Column: 1,
						Line:   26,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   26,
						},
						File:   "promql.flux",
						Source: "promqlDaysInMonth",
						Start: ast.Position{
							Column: 9,
							Line:   26,
						},
					},
				},
				Name: "promqlDaysInMonth",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   33,
					},
					File:   "promql.flux",
					Source: "builtin emptyTable",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   33,
						},
						File:   "promql.flux",
						Source: "emptyTable",
						Start: ast.Position{
							Column: 9,
							Line:   33,
						},
					},
				},
				Name: "emptyTable",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   41,
					},
					File:   "promql.flux",
					Source: "builtin extrapolatedRate",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   41,
						},
						File:   "promql.flux",
						Source: "extrapolatedRate",
						Start: ast.Position{
							Column: 9,
							Line:   41,
						},
					},
				},
				Name: "extrapolatedRate",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   47,
					},
					File:   "promql.flux",
					Source: "builtin holtWinters",
					Start: ast.Position{
						Column: 1,
						Line:   47,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   47,
						},
						File:   "promql.flux",
						Source: "holtWinters",
						Start: ast.Position{
							Column: 9,
							Line:   47,
						},
					},
				},
				Name: "holtWinters",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   52,
					},
					File:   "promql.flux",
					Source: "builtin promqlHour",
					Start: ast.Position{
						Column: 1,
						Line:   52,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   52,
						},
						File:   "promql.flux",
						Source: "promqlHour",
						Start: ast.Position{
							Column: 9,
							Line:   52,
						},
					},
				},
				Name: "promqlHour",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   59,
					},
					File:   "promql.flux",
					Source: "builtin instantRate",
					Start: ast.Position{
						Column: 1,
						Line:   59,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   59,
						},
						File:   "promql.flux",
						Source: "instantRate",
						Start: ast.Position{
							Column: 9,
							Line:   59,
						},
					},
				},
				Name: "instantRate",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   64,
					},
					File:   "promql.flux",
					Source: "builtin labelReplace",
					Start: ast.Position{
						Column: 1,
						Line:   64,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   64,
						},
						File:   "promql.flux",
						Source: "labelReplace",
						Start: ast.Position{
							Column: 9,
							Line:   64,
						},
					},
				},
				Name: "labelReplace",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   71,
					},
					File:   "promql.flux",
					Source: "builtin linearRegression",
					Start: ast.Position{
						Column: 1,
						Line:   71,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   71,
						},
						File:   "promql.flux",
						Source: "linearRegression",
						Start: ast.Position{
							Column: 9,
							Line:   71,
						},
					},
				},
				Name: "linearRegression",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   76,
					},
					File:   "promql.flux",
					Source: "builtin promqlMinute",
					Start: ast.Position{
						Column: 1,
						Line:   76,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   76,
						},
						File:   "promql.flux",
						Source: "promqlMinute",
						Start: ast.Position{
							Column: 9,
							Line:   76,
						},
					},
				},
				Name: "promqlMinute",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   81,
					},
					File:   "promql.flux",
					Source: "builtin promqlMonth",
					Start: ast.Position{
						Column: 1,
						Line:   81,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   81,
						},
						File:   "promql.flux",
						Source: "promqlMonth",
						Start: ast.Position{
							Column: 9,
							Line:   81,
						},
					},
				},
				Name: "promqlMonth",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 30,
						Line:   87,
					},
					File:   "promql.flux",
					Source: "builtin promHistogramQuantile",
					Start: ast.Position{
						Column: 1,
						Line:   87,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   87,
						},
						File:   "promql.flux",
						Source: "promHistogramQuantile",
						Start: ast.Position{
							Column: 9,
							Line:   87,
						},
					},
				},
				Name: "promHistogramQuantile",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   92,
					},
					File:   "promql.flux",
					Source: "builtin resets",
					Start: ast.Position{
						Column: 1,
						Line:   92,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   92,
						},
						File:   "promql.flux",
						Source: "resets",
						Start: ast.Position{
							Column: 9,
							Line:   92,
						},
					},
				},
				Name: "resets",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   97,
					},
					File:   "promql.flux",
					Source: "builtin timestamp",
					Start: ast.Position{
						Column: 1,
						Line:   97,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   97,
						},
						File:   "promql.flux",
						Source: "timestamp",
						Start: ast.Position{
							Column: 9,
							Line:   97,
						},
					},
				},
				Name: "timestamp",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   102,
					},
					File:   "promql.flux",
					Source: "builtin promqlYear",
					Start: ast.Position{
						Column: 1,
						Line:   102,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   102,
						},
						File:   "promql.flux",
						Source: "promqlYear",
						Start: ast.Position{
							Column: 9,
							Line:   102,
						},
					},
				},
				Name: "promqlYear",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 96,
						Line:   118,
					},
					File:   "promql.flux",
					Source: "quantile = (q, tables=<-, method=\"exact_mean\") => \n    // value is in normal range. We can use the normal quantile function\n    if q <= 1.0 and q >= 0.0 then \n    (tables\n        |> universe.quantile(q: q, method: method))\n    else if q < 0.0 then\n    (tables\n        |> reduce(identity: {_value: math.mInf(sign: -1)}, fn: (r, accumulator) => accumulator))\n    else \n    (tables\n        |> reduce(identity: {_value: math.mInf(sign: 1)}, fn: (r, accumulator) => accumulator))",
					Start: ast.Position{
						Column: 1,
						Line:   108,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   108,
						},
						File:   "promql.flux",
						Source: "quantile",
						Start: ast.Position{
							Column: 1,
							Line:   108,
						},
					},
				},
				Name: "quantile",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 96,
							Line:   118,
						},
						File:   "promql.flux",
						Source: "(q, tables=<-, method=\"exact_mean\") => \n    // value is in normal range. We can use the normal quantile function\n    if q <= 1.0 and q >= 0.0 then \n    (tables\n        |> universe.quantile(q: q, method: method))\n    else if q < 0.0 then\n    (tables\n        |> reduce(identity: {_value: math.mInf(sign: -1)}, fn: (r, accumulator) => accumulator))\n    else \n    (tables\n        |> reduce(identity: {_value: math.mInf(sign: 1)}, fn: (r, accumulator) => accumulator))",
						Start: ast.Position{
							Column: 12,
							Line:   108,
						},
					},
				},
				Body: &ast.ConditionalExpression{
					Alternate: &ast.ConditionalExpression{
						Alternate: &ast.ParenExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 96,
										Line:   118,
									},
									File:   "promql.flux",
									Source: "(tables\n        |> reduce(identity: {_value: math.mInf(sign: 1)}, fn: (r, accumulator) => accumulator))",
									Start: ast.Position{
										Column: 5,
										Line:   117,
									},
								},
							},
							Expression: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   117,
											},
											File:   "promql.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 6,
												Line:   117,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 95,
											Line:   118,
										},
										File:   "promql.flux",
										Source: "tables\n        |> reduce(identity: {_value: math.mInf(sign: 1)}, fn: (r, accumulator) => accumulator)",
										Start: ast.Position{
											Column: 6,
											Line:   117,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 94,
													Line:   118,
												},
												File:   "promql.flux",
												Source: "identity: {_value: math.mInf(sign: 1)}, fn: (r, accumulator) => accumulator",
												Start: ast.Position{
													Column: 19,
													Line:   118,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   118,
													},
													File:   "promql.flux",
													Source: "identity: {_value: math.mInf(sign: 1)}",
													Start: ast.Position{
														Column: 19,
														Line:   118,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   118,
														},
														File:   "promql.flux",
														Source: "identity",
														Start: ast.Position{
															Column: 19,
															Line:   118,
														},
													},
												},
												Name: "identity",
											},
											Value: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 57,
															Line:   118,
														},
														File:   "promql.flux",
														Source: "{_value: math.mInf(sign: 1)}",
														Start: ast.Position{
															Column: 29,
															Line:   118,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   118,
															},
															File:   "promql.flux",
															Source: "_value: math.mInf(sign: 1)",
															Start: ast.Position{
																Column: 30,
																Line:   118,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   118,
																},
																File:   "promql.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   118,
																},
															},
														},
														Name: "_value",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   118,
																	},
																	File:   "promql.flux",
																	Source: "sign: 1",
																	Start: ast.Position{
																		Column: 48,
																		Line:   118,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 55,
																			Line:   118,
																		},
																		File:   "promql.flux",
																		Source: "sign: 1",
																		Start: ast.Position{
																			Column: 48,
																			Line:   118,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 52,
																				Line:   118,
																			},
																			File:   "promql.flux",
																			Source: "sign",
																			Start: ast.Position{
																				Column: 48,
																				Line:   118,
																			},
																		},
																	},
																	Name: "sign",
																},
																Value: &ast.IntegerLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 55,
																				Line:   118,
																			},
																			File:   "promql.flux",
																			Source: "1",
																			Start: ast.Position{
																				Column: 54,
																				Line:   118,
																			},
																		},
																	},
																	Value: int64(1),
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   118,
																},
																File:   "promql.flux",
																Source: "math.mInf(sign: 1)",
																Start: ast.Position{
																	Column: 38,
																	Line:   118,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   118,
																	},
																	File:   "promql.flux",
																	Source: "math.mInf",
																	Start: ast.Position{
																		Column: 38,
																		Line:   118,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   118,
																		},
																		File:   "promql.flux",
																		Source: "math",
																		Start: ast.Position{
																			Column: 38,
																			Line:   118,
																		},
																	},
																},
																Name: "math",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 47,
																			Line:   118,
																		},
																		File:   "promql.flux",
																		Source: "mInf",
																		Start: ast.Position{
																			Column: 43,
																			Line:   118,
																		},
																	},
																},
																Name: "mInf",
															},
														},
													},
												}},
												With: nil,
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 94,
														Line:   118,
													},
													File:   "promql.flux",
													Source: "fn: (r, accumulator) => accumulator",
													Start: ast.Position{
														Column: 59,
														Line:   118,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   118,
														},
														File:   "promql.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 59,
															Line:   118,
														},
													},
												},
												Name: "fn",
											},
											Value: &ast.FunctionExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 94,
															Line:   118,
														},
														File:   "promql.flux",
														Source: "(r, accumulator) => accumulator",
														Start: ast.Position{
															Column: 63,
															Line:   118,
														},
													},
												},
												Body: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 94,
																Line:   118,
															},
															File:   "promql.flux",
															Source: "accumulator",
															Start: ast.Position{
																Column: 83,
																Line:   118,
															},
														},
													},
													Name: "accumulator",
												},
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 65,
																Line:   118,
															},
															File:   "promql.flux",
															Source: "r",
															Start: ast.Position{
																Column: 64,
																Line:   118,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 65,
																	Line:   118,
																},
																File:   "promql.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 64,
																	Line:   118,
																},
															},
														},
														Name: "r",
													},
													Value: nil,
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 78,
																Line:   118,
															},
															File:   "promql.flux",
															Source: "accumulator",
															Start: ast.Position{
																Column: 67,
																Line:   118,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 78,
																	Line:   118,
																},
																File:   "promql.flux",
																Source: "accumulator",
																Start: ast.Position{
																	Column: 67,
																	Line:   118,
																},
															},
														},
														Name: "accumulator",
													},
													Value: nil,
												}},
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 95,
												Line:   118,
											},
											File:   "promql.flux",
											Source: "reduce(identity: {_value: math.mInf(sign: 1)}, fn: (r, accumulator) => accumulator)",
											Start: ast.Position{
												Column: 12,
												Line:   118,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   118,
												},
												File:   "promql.flux",
												Source: "reduce",
												Start: ast.Position{
													Column: 12,
													Line:   118,
												},
											},
										},
										Name: "reduce",
									},
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 96,
									Line:   118,
								},
								File:   "promql.flux",
								Source: "if q < 0.0 then\n    (tables\n        |> reduce(identity: {_value: math.mInf(sign: -1)}, fn: (r, accumulator) => accumulator))\n    else \n    (tables\n        |> reduce(identity: {_value: math.mInf(sign: 1)}, fn: (r, accumulator) => accumulator))",
								Start: ast.Position{
									Column: 10,
									Line:   113,
								},
							},
						},
						Consequent: &ast.ParenExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 97,
										Line:   115,
									},
									File:   "promql.flux",
									Source: "(tables\n        |> reduce(identity: {_value: math.mInf(sign: -1)}, fn: (r, accumulator) => accumulator))",
									Start: ast.Position{
										Column: 5,
										Line:   114,
									},
								},
							},
							Expression: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   114,
											},
											File:   "promql.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 6,
												Line:   114,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 96,
											Line:   115,
										},
										File:   "promql.flux",
										Source: "tables\n        |> reduce(identity: {_value: math.mInf(sign: -1)}, fn: (r, accumulator) => accumulator)",
										Start: ast.Position{
											Column: 6,
											Line:   114,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 95,
													Line:   115,
												},
												File:   "promql.flux",
												Source: "identity: {_value: math.mInf(sign: -1)}, fn: (r, accumulator) => accumulator",
												Start: ast.Position{
													Column: 19,
													Line:   115,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   115,
													},
													File:   "promql.flux",
													Source: "identity: {_value: math.mInf(sign: -1)}",
													Start: ast.Position{
														Column: 19,
														Line:   115,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   115,
														},
														File:   "promql.flux",
														Source: "identity",
														Start: ast.Position{
															Column: 19,
															Line:   115,
														},
													},
												},
												Name: "identity",
											},
											Value: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   115,
														},
														File:   "promql.flux",
														Source: "{_value: math.mInf(sign: -1)}",
														Start: ast.Position{
															Column: 29,
															Line:   115,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 57,
																Line:   115,
															},
															File:   "promql.flux",
															Source: "_value: math.mInf(sign: -1)",
															Start: ast.Position{
																Column: 30,
																Line:   115,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   115,
																},
																File:   "promql.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   115,
																},
															},
														},
														Name: "_value",
													},
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   115,
																	},
																	File:   "promql.flux",
																	Source: "sign: -1",
																	Start: ast.Position{
																		Column: 48,
																		Line:   115,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 56,
																			Line:   115,
																		},
																		File:   "promql.flux",
																		Source: "sign: -1",
																		Start: ast.Position{
																			Column: 48,
																			Line:   115,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 52,
																				Line:   115,
																			},
																			File:   "promql.flux",
																			Source: "sign",
																			Start: ast.Position{
																				Column: 48,
																				Line:   115,
																			},
																		},
																	},
																	Name: "sign",
																},
																Value: &ast.UnaryExpression{
																	Argument: &ast.IntegerLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 56,
																					Line:   115,
																				},
																				File:   "promql.flux",
																				Source: "1",
																				Start: ast.Position{
																					Column: 55,
																					Line:   115,
																				},
																			},
																		},
																		Value: int64(1),
																	},
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 56,
																				Line:   115,
																			},
																			File:   "promql.flux",
																			Source: "-1",
																			Start: ast.Position{
																				Column: 54,
																				Line:   115,
																			},
																		},
																	},
																	Operator: 6,
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 57,
																	Line:   115,
																},
																File:   "promql.flux",
																Source: "math.mInf(sign: -1)",
																Start: ast.Position{
																	Column: 38,
																	Line:   115,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   115,
																	},
																	File:   "promql.flux",
																	Source: "math.mInf",
																	Start: ast.Position{
																		Column: 38,
																		Line:   115,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   115,
																		},
																		File:   "promql.flux",
																		Source: "math",
																		Start: ast.Position{
																			Column: 38,
																			Line:   115,
																		},
																	},
																},
																Name: "math",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 47,
																			Line:   115,
																		},
																		File:   "promql.flux",
																		Source: "mInf",
																		Start: ast.Position{
																			Column: 43,
																			Line:   115,
																		},
																	},
																},
																Name: "mInf",
															},
														},
													},
												}},
												With: nil,
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 95,
														Line:   115,
													},
													File:   "promql.flux",
													Source: "fn: (r, accumulator) => accumulator",
													Start: ast.Position{
														Column: 60,
														Line:   115,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   115,
														},
														File:   "promql.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 60,
															Line:   115,
														},
													},
												},
												Name: "fn",
											},
											Value: &ast.FunctionExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 95,
															Line:   115,
														},
														File:   "promql.flux",
														Source: "(r, accumulator) => accumulator",
														Start: ast.Position{
															Column: 64,
															Line:   115,
														},
													},
												},
												Body: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 95,
																Line:   115,
															},
															File:   "promql.flux",
															Source: "accumulator",
															Start: ast.Position{
																Column: 84,
																Line:   115,
															},
														},
													},
													Name: "accumulator",
												},
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 66,
																Line:   115,
															},
															File:   "promql.flux",
															Source: "r",
															Start: ast.Position{
																Column: 65,
																Line:   115,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 66,
																	Line:   115,
																},
																File:   "promql.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 65,
																	Line:   115,
																},
															},
														},
														Name: "r",
													},
													Value: nil,
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 79,
																Line:   115,
															},
															File:   "promql.flux",
															Source: "accumulator",
															Start: ast.Position{
																Column: 68,
																Line:   115,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 79,
																	Line:   115,
																},
																File:   "promql.flux",
																Source: "accumulator",
																Start: ast.Position{
																	Column: 68,
																	Line:   115,
																},
															},
														},
														Name: "accumulator",
													},
													Value: nil,
												}},
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 96,
												Line:   115,
											},
											File:   "promql.flux",
											Source: "reduce(identity: {_value: math.mInf(sign: -1)}, fn: (r, accumulator) => accumulator)",
											Start: ast.Position{
												Column: 12,
												Line:   115,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   115,
												},
												File:   "promql.flux",
												Source: "reduce",
												Start: ast.Position{
													Column: 12,
													Line:   115,
												},
											},
										},
										Name: "reduce",
									},
								},
							},
						},
						Test: &ast.BinaryExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   113,
									},
									File:   "promql.flux",
									Source: "q < 0.0",
									Start: ast.Position{
										Column: 13,
										Line:   113,
									},
								},
							},
							Left: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   113,
										},
										File:   "promql.flux",
										Source: "q",
										Start: ast.Position{
											Column: 13,
											Line:   113,
										},
									},
								},
								Name: "q",
							},
							Operator: 8,
							Right: &ast.FloatLiteral{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   113,
										},
										File:   "promql.flux",
										Source: "0.0",
										Start: ast.Position{
											Column: 17,
											Line:   113,
										},
									},
								},
								Value: 0.0,
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 96,
								Line:   118,
							},
							File:   "promql.flux",
							Source: "if q <= 1.0 and q >= 0.0 then \n    (tables\n        |> universe.quantile(q: q, method: method))\n    else if q < 0.0 then\n    (tables\n        |> reduce(identity: {_value: math.mInf(sign: -1)}, fn: (r, accumulator) => accumulator))\n    else \n    (tables\n        |> reduce(identity: {_value: math.mInf(sign: 1)}, fn: (r, accumulator) => accumulator))",
							Start: ast.Position{
								Column: 5,
								Line:   110,
							},
						},
					},
					Consequent: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 52,
									Line:   112,
								},
								File:   "promql.flux",
								Source: "(tables\n        |> universe.quantile(q: q, method: method))",
								Start: ast.Position{
									Column: 5,
									Line:   111,
								},
							},
						},
						Expression: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   111,
										},
										File:   "promql.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 6,
											Line:   111,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   112,
									},
									File:   "promql.flux",
									Source: "tables\n        |> universe.quantile(q: q, method: method)",
									Start: ast.Position{
										Column: 6,
										Line:   111,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   112,
											},
											File:   "promql.flux",
											Source: "q: q, method: method",
											Start: ast.Position{
												Column: 30,
												Line:   112,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   112,
												},
												File:   "promql.flux",
												Source: "q: q",
												Start: ast.Position{
													Column: 30,
													Line:   112,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   112,
													},
													File:   "promql.flux",
													Source: "q",
													Start: ast.Position{
														Column: 30,
														Line:   112,
													},
												},
											},
											Name: "q",
										},
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   112,
													},
													File:   "promql.flux",
													Source: "q",
													Start: ast.Position{
														Column: 33,
														Line:   112,
													},
												},
											},
											Name: "q",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   112,
												},
												File:   "promql.flux",
												Source: "method: method",
												Start: ast.Position{
													Column: 36,
													Line:   112,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   112,
													},
													File:   "promql.flux",
													Source: "method",
													Start: ast.Position{
														Column: 36,
														Line:   112,
													},
												},
											},
											Name: "method",
										},
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   112,
													},
													File:   "promql.flux",
													Source: "method",
													Start: ast.Position{
														Column: 44,
														Line:   112,
													},
												},
											},
											Name: "method",
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   112,
										},
										File:   "promql.flux",
										Source: "universe.quantile(q: q, method: method)",
										Start: ast.Position{
											Column: 12,
											Line:   112,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   112,
											},
											File:   "promql.flux",
											Source: "universe.quantile",
											Start: ast.Position{
												Column: 12,
												Line:   112,
											},
										},
									},
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   112,
												},
												File:   "promql.flux",
												Source: "universe",
												Start: ast.Position{
													Column: 12,
													Line:   112,
												},
											},
										},
										Name: "universe",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   112,
												},
												File:   "promql.flux",
												Source: "quantile",
												Start: ast.Position{
													Column: 21,
													Line:   112,
												},
											},
										},
										Name: "quantile",
									},
								},
							},
						},
					},
					Test: &ast.LogicalExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   110,
								},
								File:   "promql.flux",
								Source: "q <= 1.0 and q >= 0.0",
								Start: ast.Position{
									Column: 8,
									Line:   110,
								},
							},
						},
						Left: &ast.BinaryExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   110,
									},
									File:   "promql.flux",
									Source: "q <= 1.0",
									Start: ast.Position{
										Column: 8,
										Line:   110,
									},
								},
							},
							Left: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   110,
										},
										File:   "promql.flux",
										Source: "q",
										Start: ast.Position{
											Column: 8,
											Line:   110,
										},
									},
								},
								Name: "q",
							},
							Operator: 7,
							Right: &ast.FloatLiteral{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   110,
										},
										File:   "promql.flux",
										Source: "1.0",
										Start: ast.Position{
											Column: 13,
											Line:   110,
										},
									},
								},
								Value: 1.0,
							},
						},
						Operator: 1,
						Right: &ast.BinaryExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   110,
									},
									File:   "promql.flux",
									Source: "q >= 0.0",
									Start: ast.Position{
										Column: 21,
										Line:   110,
									},
								},
							},
							Left: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   110,
										},
										File:   "promql.flux",
										Source: "q",
										Start: ast.Position{
											Column: 21,
											Line:   110,
										},
									},
								},
								Name: "q",
							},
							Operator: 9,
							Right: &ast.FloatLiteral{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   110,
										},
										File:   "promql.flux",
										Source: "0.0",
										Start: ast.Position{
											Column: 26,
											Line:   110,
										},
									},
								},
								Value: 0.0,
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   108,
							},
							File:   "promql.flux",
							Source: "q",
							Start: ast.Position{
								Column: 13,
								Line:   108,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   108,
								},
								File:   "promql.flux",
								Source: "q",
								Start: ast.Position{
									Column: 13,
									Line:   108,
								},
							},
						},
						Name: "q",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   108,
							},
							File:   "promql.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 16,
								Line:   108,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   108,
								},
								File:   "promql.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 16,
									Line:   108,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   108,
							},
							File:   "promql.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 23,
								Line:   108,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 46,
								Line:   108,
							},
							File:   "promql.flux",
							Source: "method=\"exact_mean\"",
							Start: ast.Position{
								Column: 27,
								Line:   108,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   108,
								},
								File:   "promql.flux",
								Source: "method",
								Start: ast.Position{
									Column: 27,
									Line:   108,
								},
							},
						},
						Name: "method",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   108,
								},
								File:   "promql.flux",
								Source: "\"exact_mean\"",
								Start: ast.Position{
									Column: 34,
									Line:   108,
								},
							},
						},
						Value: "exact_mean",
					},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   120,
					},
					File:   "promql.flux",
					Source: "join = experimental.join",
					Start: ast.Position{
						Column: 1,
						Line:   120,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   120,
						},
						File:   "promql.flux",
						Source: "join",
						Start: ast.Position{
							Column: 1,
							Line:   120,
						},
					},
				},
				Name: "join",
			},
			Init: &ast.MemberExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   120,
						},
						File:   "promql.flux",
						Source: "experimental.join",
						Start: ast.Position{
							Column: 8,
							Line:   120,
						},
					},
				},
				Object: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   120,
							},
							File:   "promql.flux",
							Source: "experimental",
							Start: ast.Position{
								Column: 8,
								Line:   120,
							},
						},
					},
					Name: "experimental",
				},
				Property: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   120,
							},
							File:   "promql.flux",
							Source: "join",
							Start: ast.Position{
								Column: 21,
								Line:   120,
							},
						},
					},
					Name: "join",
				},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "promql.flux",
					Source: "import \"math\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "promql.flux",
						Source: "\"math\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "math",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   5,
					},
					File:   "promql.flux",
					Source: "import \"universe\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   5,
						},
						File:   "promql.flux",
						Source: "\"universe\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "universe",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   6,
					},
					File:   "promql.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   6,
						},
						File:   "promql.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "experimental",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "promql.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   2,
					},
					File:   "promql.flux",
					Source: "package promql",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   2,
						},
						File:   "promql.flux",
						Source: "promql",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "promql",
			},
		},
	}},
	Package: "promql",
	Path:    "internal/promql",
}
