// Code generated by go-swagger; DO NOT EDIT.

package signed_in_user

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// New creates a new signed in user API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for signed in user API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	ChangeUserPassword(body *models.ChangeUserPasswordCommand, opts ...ClientOption) (*ChangeUserPasswordOK, error)
	ChangeUserPasswordWithParams(params *ChangeUserPasswordParams, opts ...ClientOption) (*ChangeUserPasswordOK, error)

	ClearHelpFlags(opts ...ClientOption) (*ClearHelpFlagsOK, error)
	ClearHelpFlagsWithParams(params *ClearHelpFlagsParams, opts ...ClientOption) (*ClearHelpFlagsOK, error)

	GetSignedInUser(opts ...ClientOption) (*GetSignedInUserOK, error)
	GetSignedInUserWithParams(params *GetSignedInUserParams, opts ...ClientOption) (*GetSignedInUserOK, error)

	GetSignedInUserOrgList(opts ...ClientOption) (*GetSignedInUserOrgListOK, error)
	GetSignedInUserOrgListWithParams(params *GetSignedInUserOrgListParams, opts ...ClientOption) (*GetSignedInUserOrgListOK, error)

	GetSignedInUserTeamList(opts ...ClientOption) (*GetSignedInUserTeamListOK, error)
	GetSignedInUserTeamListWithParams(params *GetSignedInUserTeamListParams, opts ...ClientOption) (*GetSignedInUserTeamListOK, error)

	GetUserAuthTokens(opts ...ClientOption) (*GetUserAuthTokensOK, error)
	GetUserAuthTokensWithParams(params *GetUserAuthTokensParams, opts ...ClientOption) (*GetUserAuthTokensOK, error)

	GetUserQuotas(opts ...ClientOption) (*GetUserQuotasOK, error)
	GetUserQuotasWithParams(params *GetUserQuotasParams, opts ...ClientOption) (*GetUserQuotasOK, error)

	RevokeUserAuthToken(body *models.RevokeAuthTokenCmd, opts ...ClientOption) (*RevokeUserAuthTokenOK, error)
	RevokeUserAuthTokenWithParams(params *RevokeUserAuthTokenParams, opts ...ClientOption) (*RevokeUserAuthTokenOK, error)

	SetHelpFlag(flagID string, opts ...ClientOption) (*SetHelpFlagOK, error)
	SetHelpFlagWithParams(params *SetHelpFlagParams, opts ...ClientOption) (*SetHelpFlagOK, error)

	StarDashboard(dashboardID string, opts ...ClientOption) (*StarDashboardOK, error)
	StarDashboardWithParams(params *StarDashboardParams, opts ...ClientOption) (*StarDashboardOK, error)

	StarDashboardByUID(dashboardUID string, opts ...ClientOption) (*StarDashboardByUIDOK, error)
	StarDashboardByUIDWithParams(params *StarDashboardByUIDParams, opts ...ClientOption) (*StarDashboardByUIDOK, error)

	UnstarDashboard(dashboardID string, opts ...ClientOption) (*UnstarDashboardOK, error)
	UnstarDashboardWithParams(params *UnstarDashboardParams, opts ...ClientOption) (*UnstarDashboardOK, error)

	UnstarDashboardByUID(dashboardUID string, opts ...ClientOption) (*UnstarDashboardByUIDOK, error)
	UnstarDashboardByUIDWithParams(params *UnstarDashboardByUIDParams, opts ...ClientOption) (*UnstarDashboardByUIDOK, error)

	UpdateSignedInUser(body *models.UpdateUserCommand, opts ...ClientOption) (*UpdateSignedInUserOK, error)
	UpdateSignedInUserWithParams(params *UpdateSignedInUserParams, opts ...ClientOption) (*UpdateSignedInUserOK, error)

	UserSetUsingOrg(orgID int64, opts ...ClientOption) (*UserSetUsingOrgOK, error)
	UserSetUsingOrgWithParams(params *UserSetUsingOrgParams, opts ...ClientOption) (*UserSetUsingOrgOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
ChangeUserPassword changes password

Changes the password for the user.
*/
func (a *Client) ChangeUserPassword(body *models.ChangeUserPasswordCommand, opts ...ClientOption) (*ChangeUserPasswordOK, error) {
	params := NewChangeUserPasswordParams().WithBody(body)
	return a.ChangeUserPasswordWithParams(params, opts...)
}

func (a *Client) ChangeUserPasswordWithParams(params *ChangeUserPasswordParams, opts ...ClientOption) (*ChangeUserPasswordOK, error) {
	if params == nil {
		params = NewChangeUserPasswordParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "changeUserPassword",
		Method:             "PUT",
		PathPattern:        "/user/password",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ChangeUserPasswordReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ChangeUserPasswordOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for changeUserPassword: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ClearHelpFlags clears user help flag
*/
func (a *Client) ClearHelpFlags(opts ...ClientOption) (*ClearHelpFlagsOK, error) {
	params := NewClearHelpFlagsParams()
	return a.ClearHelpFlagsWithParams(params, opts...)
}

func (a *Client) ClearHelpFlagsWithParams(params *ClearHelpFlagsParams, opts ...ClientOption) (*ClearHelpFlagsOK, error) {
	if params == nil {
		params = NewClearHelpFlagsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "clearHelpFlags",
		Method:             "GET",
		PathPattern:        "/user/helpflags/clear",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ClearHelpFlagsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClearHelpFlagsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for clearHelpFlags: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetSignedInUser Get (current authenticated user)
*/
func (a *Client) GetSignedInUser(opts ...ClientOption) (*GetSignedInUserOK, error) {
	params := NewGetSignedInUserParams()
	return a.GetSignedInUserWithParams(params, opts...)
}

func (a *Client) GetSignedInUserWithParams(params *GetSignedInUserParams, opts ...ClientOption) (*GetSignedInUserOK, error) {
	if params == nil {
		params = NewGetSignedInUserParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getSignedInUser",
		Method:             "GET",
		PathPattern:        "/user",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetSignedInUserReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetSignedInUserOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getSignedInUser: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetSignedInUserOrgList organizations of the actual user

Return a list of all organizations of the current user.
*/
func (a *Client) GetSignedInUserOrgList(opts ...ClientOption) (*GetSignedInUserOrgListOK, error) {
	params := NewGetSignedInUserOrgListParams()
	return a.GetSignedInUserOrgListWithParams(params, opts...)
}

func (a *Client) GetSignedInUserOrgListWithParams(params *GetSignedInUserOrgListParams, opts ...ClientOption) (*GetSignedInUserOrgListOK, error) {
	if params == nil {
		params = NewGetSignedInUserOrgListParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getSignedInUserOrgList",
		Method:             "GET",
		PathPattern:        "/user/orgs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetSignedInUserOrgListReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetSignedInUserOrgListOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getSignedInUserOrgList: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetSignedInUserTeamList teams that the actual user is member of

Return a list of all teams that the current user is member of.
*/
func (a *Client) GetSignedInUserTeamList(opts ...ClientOption) (*GetSignedInUserTeamListOK, error) {
	params := NewGetSignedInUserTeamListParams()
	return a.GetSignedInUserTeamListWithParams(params, opts...)
}

func (a *Client) GetSignedInUserTeamListWithParams(params *GetSignedInUserTeamListParams, opts ...ClientOption) (*GetSignedInUserTeamListOK, error) {
	if params == nil {
		params = NewGetSignedInUserTeamListParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getSignedInUserTeamList",
		Method:             "GET",
		PathPattern:        "/user/teams",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetSignedInUserTeamListReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetSignedInUserTeamListOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getSignedInUserTeamList: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetUserAuthTokens auths tokens of the actual user

Return a list of all auth tokens (devices) that the actual user currently have logged in from.
*/
func (a *Client) GetUserAuthTokens(opts ...ClientOption) (*GetUserAuthTokensOK, error) {
	params := NewGetUserAuthTokensParams()
	return a.GetUserAuthTokensWithParams(params, opts...)
}

func (a *Client) GetUserAuthTokensWithParams(params *GetUserAuthTokensParams, opts ...ClientOption) (*GetUserAuthTokensOK, error) {
	if params == nil {
		params = NewGetUserAuthTokensParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getUserAuthTokens",
		Method:             "GET",
		PathPattern:        "/user/auth-tokens",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetUserAuthTokensReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetUserAuthTokensOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getUserAuthTokens: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetUserQuotas fetches user quota
*/
func (a *Client) GetUserQuotas(opts ...ClientOption) (*GetUserQuotasOK, error) {
	params := NewGetUserQuotasParams()
	return a.GetUserQuotasWithParams(params, opts...)
}

func (a *Client) GetUserQuotasWithParams(params *GetUserQuotasParams, opts ...ClientOption) (*GetUserQuotasOK, error) {
	if params == nil {
		params = NewGetUserQuotasParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getUserQuotas",
		Method:             "GET",
		PathPattern:        "/user/quotas",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetUserQuotasReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetUserQuotasOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getUserQuotas: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RevokeUserAuthToken revokes an auth token of the actual user

Revokes the given auth token (device) for the actual user. User of issued auth token (device) will no longer be logged in and will be required to authenticate again upon next activity.
*/
func (a *Client) RevokeUserAuthToken(body *models.RevokeAuthTokenCmd, opts ...ClientOption) (*RevokeUserAuthTokenOK, error) {
	params := NewRevokeUserAuthTokenParams().WithBody(body)
	return a.RevokeUserAuthTokenWithParams(params, opts...)
}

func (a *Client) RevokeUserAuthTokenWithParams(params *RevokeUserAuthTokenParams, opts ...ClientOption) (*RevokeUserAuthTokenOK, error) {
	if params == nil {
		params = NewRevokeUserAuthTokenParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "revokeUserAuthToken",
		Method:             "POST",
		PathPattern:        "/user/revoke-auth-token",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RevokeUserAuthTokenReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RevokeUserAuthTokenOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for revokeUserAuthToken: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
SetHelpFlag sets user help flag
*/
func (a *Client) SetHelpFlag(flagID string, opts ...ClientOption) (*SetHelpFlagOK, error) {
	params := NewSetHelpFlagParams().WithFlagID(flagID)
	return a.SetHelpFlagWithParams(params, opts...)
}

func (a *Client) SetHelpFlagWithParams(params *SetHelpFlagParams, opts ...ClientOption) (*SetHelpFlagOK, error) {
	if params == nil {
		params = NewSetHelpFlagParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "setHelpFlag",
		Method:             "PUT",
		PathPattern:        "/user/helpflags/{flag_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &SetHelpFlagReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SetHelpFlagOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for setHelpFlag: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
StarDashboard stars a dashboard

Stars the given Dashboard for the actual user.
*/
func (a *Client) StarDashboard(dashboardID string, opts ...ClientOption) (*StarDashboardOK, error) {
	params := NewStarDashboardParams().WithDashboardID(dashboardID)
	return a.StarDashboardWithParams(params, opts...)
}

func (a *Client) StarDashboardWithParams(params *StarDashboardParams, opts ...ClientOption) (*StarDashboardOK, error) {
	if params == nil {
		params = NewStarDashboardParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "starDashboard",
		Method:             "POST",
		PathPattern:        "/user/stars/dashboard/{dashboard_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &StarDashboardReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StarDashboardOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for starDashboard: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
StarDashboardByUID stars a dashboard

Stars the given Dashboard for the actual user.
*/
func (a *Client) StarDashboardByUID(dashboardUID string, opts ...ClientOption) (*StarDashboardByUIDOK, error) {
	params := NewStarDashboardByUIDParams().WithDashboardUID(dashboardUID)
	return a.StarDashboardByUIDWithParams(params, opts...)
}

func (a *Client) StarDashboardByUIDWithParams(params *StarDashboardByUIDParams, opts ...ClientOption) (*StarDashboardByUIDOK, error) {
	if params == nil {
		params = NewStarDashboardByUIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "starDashboardByUID",
		Method:             "POST",
		PathPattern:        "/user/stars/dashboard/uid/{dashboard_uid}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &StarDashboardByUIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StarDashboardByUIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for starDashboardByUID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UnstarDashboard unstars a dashboard

Deletes the starring of the given Dashboard for the actual user.
*/
func (a *Client) UnstarDashboard(dashboardID string, opts ...ClientOption) (*UnstarDashboardOK, error) {
	params := NewUnstarDashboardParams().WithDashboardID(dashboardID)
	return a.UnstarDashboardWithParams(params, opts...)
}

func (a *Client) UnstarDashboardWithParams(params *UnstarDashboardParams, opts ...ClientOption) (*UnstarDashboardOK, error) {
	if params == nil {
		params = NewUnstarDashboardParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unstarDashboard",
		Method:             "DELETE",
		PathPattern:        "/user/stars/dashboard/{dashboard_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UnstarDashboardReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnstarDashboardOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for unstarDashboard: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UnstarDashboardByUID unstars a dashboard

Deletes the starring of the given Dashboard for the actual user.
*/
func (a *Client) UnstarDashboardByUID(dashboardUID string, opts ...ClientOption) (*UnstarDashboardByUIDOK, error) {
	params := NewUnstarDashboardByUIDParams().WithDashboardUID(dashboardUID)
	return a.UnstarDashboardByUIDWithParams(params, opts...)
}

func (a *Client) UnstarDashboardByUIDWithParams(params *UnstarDashboardByUIDParams, opts ...ClientOption) (*UnstarDashboardByUIDOK, error) {
	if params == nil {
		params = NewUnstarDashboardByUIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "unstarDashboardByUID",
		Method:             "DELETE",
		PathPattern:        "/user/stars/dashboard/uid/{dashboard_uid}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UnstarDashboardByUIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnstarDashboardByUIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for unstarDashboardByUID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateSignedInUser updates signed in user
*/
func (a *Client) UpdateSignedInUser(body *models.UpdateUserCommand, opts ...ClientOption) (*UpdateSignedInUserOK, error) {
	params := NewUpdateSignedInUserParams().WithBody(body)
	return a.UpdateSignedInUserWithParams(params, opts...)
}

func (a *Client) UpdateSignedInUserWithParams(params *UpdateSignedInUserParams, opts ...ClientOption) (*UpdateSignedInUserOK, error) {
	if params == nil {
		params = NewUpdateSignedInUserParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateSignedInUser",
		Method:             "PUT",
		PathPattern:        "/user",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateSignedInUserReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateSignedInUserOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateSignedInUser: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UserSetUsingOrg switches user context for signed in user

Switch user context to the given organization.
*/
func (a *Client) UserSetUsingOrg(orgID int64, opts ...ClientOption) (*UserSetUsingOrgOK, error) {
	params := NewUserSetUsingOrgParams().WithOrgID(orgID)
	return a.UserSetUsingOrgWithParams(params, opts...)
}

func (a *Client) UserSetUsingOrgWithParams(params *UserSetUsingOrgParams, opts ...ClientOption) (*UserSetUsingOrgOK, error) {
	if params == nil {
		params = NewUserSetUsingOrgParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "userSetUsingOrg",
		Method:             "POST",
		PathPattern:        "/user/using/{org_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UserSetUsingOrgReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UserSetUsingOrgOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for userSetUsingOrg: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
