// Code generated by go-swagger; DO NOT EDIT.

package library_elements

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetLibraryElementsReader is a Reader for the GetLibraryElements structure.
type GetLibraryElementsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetLibraryElementsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetLibraryElementsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetLibraryElementsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetLibraryElementsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /library-elements] getLibraryElements", response, response.Code())
	}
}

// NewGetLibraryElementsOK creates a GetLibraryElementsOK with default headers values
func NewGetLibraryElementsOK() *GetLibraryElementsOK {
	return &GetLibraryElementsOK{}
}

/*
GetLibraryElementsOK describes a response with status code 200, with default header values.

(empty)
*/
type GetLibraryElementsOK struct {
	Payload *models.LibraryElementSearchResponse
}

// IsSuccess returns true when this get library elements Ok response has a 2xx status code
func (o *GetLibraryElementsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get library elements Ok response has a 3xx status code
func (o *GetLibraryElementsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get library elements Ok response has a 4xx status code
func (o *GetLibraryElementsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get library elements Ok response has a 5xx status code
func (o *GetLibraryElementsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get library elements Ok response a status code equal to that given
func (o *GetLibraryElementsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get library elements Ok response
func (o *GetLibraryElementsOK) Code() int {
	return 200
}

func (o *GetLibraryElementsOK) Error() string {
	return fmt.Sprintf("[GET /library-elements][%d] getLibraryElementsOk  %+v", 200, o.Payload)
}

func (o *GetLibraryElementsOK) String() string {
	return fmt.Sprintf("[GET /library-elements][%d] getLibraryElementsOk  %+v", 200, o.Payload)
}

func (o *GetLibraryElementsOK) GetPayload() *models.LibraryElementSearchResponse {
	return o.Payload
}

func (o *GetLibraryElementsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LibraryElementSearchResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLibraryElementsUnauthorized creates a GetLibraryElementsUnauthorized with default headers values
func NewGetLibraryElementsUnauthorized() *GetLibraryElementsUnauthorized {
	return &GetLibraryElementsUnauthorized{}
}

/*
GetLibraryElementsUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetLibraryElementsUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get library elements unauthorized response has a 2xx status code
func (o *GetLibraryElementsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get library elements unauthorized response has a 3xx status code
func (o *GetLibraryElementsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get library elements unauthorized response has a 4xx status code
func (o *GetLibraryElementsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get library elements unauthorized response has a 5xx status code
func (o *GetLibraryElementsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get library elements unauthorized response a status code equal to that given
func (o *GetLibraryElementsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get library elements unauthorized response
func (o *GetLibraryElementsUnauthorized) Code() int {
	return 401
}

func (o *GetLibraryElementsUnauthorized) Error() string {
	return fmt.Sprintf("[GET /library-elements][%d] getLibraryElementsUnauthorized  %+v", 401, o.Payload)
}

func (o *GetLibraryElementsUnauthorized) String() string {
	return fmt.Sprintf("[GET /library-elements][%d] getLibraryElementsUnauthorized  %+v", 401, o.Payload)
}

func (o *GetLibraryElementsUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetLibraryElementsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLibraryElementsInternalServerError creates a GetLibraryElementsInternalServerError with default headers values
func NewGetLibraryElementsInternalServerError() *GetLibraryElementsInternalServerError {
	return &GetLibraryElementsInternalServerError{}
}

/*
GetLibraryElementsInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetLibraryElementsInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get library elements internal server error response has a 2xx status code
func (o *GetLibraryElementsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get library elements internal server error response has a 3xx status code
func (o *GetLibraryElementsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get library elements internal server error response has a 4xx status code
func (o *GetLibraryElementsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get library elements internal server error response has a 5xx status code
func (o *GetLibraryElementsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get library elements internal server error response a status code equal to that given
func (o *GetLibraryElementsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get library elements internal server error response
func (o *GetLibraryElementsInternalServerError) Code() int {
	return 500
}

func (o *GetLibraryElementsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /library-elements][%d] getLibraryElementsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetLibraryElementsInternalServerError) String() string {
	return fmt.Sprintf("[GET /library-elements][%d] getLibraryElementsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetLibraryElementsInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetLibraryElementsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
