package opts

import (
	"testing"

	"gotest.tools/v3/assert"
	is "gotest.tools/v3/assert/cmp"
)

func TestQuotedStringSetWithQuotes(t *testing.T) {
	value := ""
	qs := NewQuotedString(&value)
	assert.NilError(t, qs.Set(`"something"`))
	assert.Check(t, is.Equal("something", qs.String()))
	assert.Check(t, is.Equal("something", value))
}

func TestQuotedStringSetWithMismatchedQuotes(t *testing.T) {
	value := ""
	qs := NewQuotedString(&value)
	assert.NilError(t, qs.Set(`"something'`))
	assert.Check(t, is.Equal(`"something'`, qs.String()))
}

func TestQuotedStringSetWithNoQuotes(t *testing.T) {
	value := ""
	qs := NewQuotedString(&value)
	assert.NilError(t, qs.Set("something"))
	assert.Check(t, is.Equal("something", qs.String()))
}

func TestQuotedStringShort(t *testing.T) {
	value := ""
	qs := NewQuotedString(&value)
	assert.NilError(t, qs.Set(`"`))
	assert.Check(t, is.Equal(`"`, qs.String()))

	assert.NilError(t, qs.Set(`'`))
	assert.Check(t, is.Equal(`'`, qs.String()))
}
