# Certificate


## Fields

| Field                                                                                                                                                                                                          | Type                                                                                                                                                                                                           | Required                                                                                                                                                                                                       | Description                                                                                                                                                                                                    |
| -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `AddedAt`                                                                                                                                                                                                      | **string*                                                                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                             | When the certificate was added to the Censys dataset.                                                                                                                                                          |
| `Ct`                                                                                                                                                                                                           | [*components.Ct](../../models/components/ct.md)                                                                                                                                                                | :heavy_minus_sign:                                                                                                                                                                                             | N/A                                                                                                                                                                                                            |
| `EverSeenInScan`                                                                                                                                                                                               | **bool*                                                                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                             | Whether the certificate has ever been presented by a service during a scan.                                                                                                                                    |
| `FingerprintMd5`                                                                                                                                                                                               | **string*                                                                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                             | The MD-5 digest of the entire raw certificate. An identifier used by some systems.                                                                                                                             |
| `FingerprintSha1`                                                                                                                                                                                              | **string*                                                                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                             | The SHA-1 digest of the entire raw certificate. An identifier used by some systems.                                                                                                                            |
| `FingerprintSha256`                                                                                                                                                                                            | **string*                                                                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                             | The SHA-256 digest of the entire raw certificate. Its unique identifier, which Censys uses to index certificates records.                                                                                      |
| `ModifiedAt`                                                                                                                                                                                                   | **string*                                                                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                             | When the certificate record was last modified.                                                                                                                                                                 |
| `Names`                                                                                                                                                                                                        | []*string*                                                                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                                                                             | All the names contained in the certificate from various fields.                                                                                                                                                |
| `ParentSpkiFingerprintSha256`                                                                                                                                                                                  | **string*                                                                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                             | DEPRECATED: Use parent_spki_subject_fingerprint_sha256                                                                                                                                                         |
| `ParentSpkiSubjectFingerprintSha256`                                                                                                                                                                           | **string*                                                                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                             | The SHA-256 digest of the parent certificate's DER-encoded SubjectPublicKeyInfo concatenated with its Subject.                                                                                                 |
| `ParseStatus`                                                                                                                                                                                                  | [*components.ParseStatus](../../models/components/parsestatus.md)                                                                                                                                              | :heavy_minus_sign:                                                                                                                                                                                             | N/A                                                                                                                                                                                                            |
| `Parsed`                                                                                                                                                                                                       | [*components.CertificateParsed](../../models/components/certificateparsed.md)                                                                                                                                  | :heavy_minus_sign:                                                                                                                                                                                             | N/A                                                                                                                                                                                                            |
| `Precert`                                                                                                                                                                                                      | **bool*                                                                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                             | Whether the X.509 "poison" extension (OID: 1.3.6.1.4.1.11129.2.4.3) is marked critical, which prohibits the pre-certificate from being trusted.                                                                |
| `Revocation`                                                                                                                                                                                                   | [*components.CertificateRevocation](../../models/components/certificaterevocation.md)                                                                                                                          | :heavy_minus_sign:                                                                                                                                                                                             | N/A                                                                                                                                                                                                            |
| `Revoked`                                                                                                                                                                                                      | **bool*                                                                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                                             | Whether the certificate has been revoked before its expiry date by the issuer.                                                                                                                                 |
| `SpkiFingerprintSha256`                                                                                                                                                                                        | **string*                                                                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                             | DEPRECATED: Use spki_subject_fingerprint_sha256                                                                                                                                                                |
| `SpkiSubjectFingerprintSha256`                                                                                                                                                                                 | **string*                                                                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                             | The SHA-256 digest of the certificate's DER-encoded SubjectPublicKeyInfo concatenated with its Subject.                                                                                                        |
| `TbsFingerprintSha256`                                                                                                                                                                                         | **string*                                                                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                             | The SHA-256 digest of the unsigned certificate's contents.                                                                                                                                                     |
| `TbsNoCtFingerprintSha256`                                                                                                                                                                                     | **string*                                                                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                             | The SHA-256 digest of the unsigned certificate with the CT Poison extension removed, if present. This represents the shared contents of a certificate and its corresponding pre-certificate.                   |
| `ValidatedAt`                                                                                                                                                                                                  | **string*                                                                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                             | When the certificate record's trust was last checked.                                                                                                                                                          |
| `Validation`                                                                                                                                                                                                   | [*components.Validation](../../models/components/validation.md)                                                                                                                                                | :heavy_minus_sign:                                                                                                                                                                                             | N/A                                                                                                                                                                                                            |
| `ValidationLevel`                                                                                                                                                                                              | [*components.ValidationLevel](../../models/components/validationlevel.md)                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                             | The extent to which the certificate's issuer validated the identity of the entity requesting the certificate. Options include Domain validated (DV), Organization Validated (OV), or Extended Validation (EV). |
| `Zlint`                                                                                                                                                                                                        | [*components.ZLint](../../models/components/zlint.md)                                                                                                                                                          | :heavy_minus_sign:                                                                                                                                                                                             | N/A                                                                                                                                                                                                            |