# Cayley Documentation

Welcome to the Cayley Manual! Cayley is an open-source graph database designed for ease of use and storing complex data. The manual introduces key concepts in Cayley, presents the query languages, and provides operational and administrative considerations and procedures as well as comprehensive reference section.

## Introduction

* [Getting Started](getting-started.md)
* [Installation](installation.md)
* [Advanced Use](usage/advanced-use.md)
* [UI Overview](usage/ui-overview.md)
* [Project Locations](getting-involved/locations.md)

## Reference

* [Glossary](getting-involved/glossary.md)
* [Gizmo API](query-languages/gizmoapi.md)
* [GraphQL](query-languages/graphql.md)
* [MQL](query-languages/mql.md)
* [HTTP](usage/http.md)
* [GephiGraphStream](query-languages/gephigraphstream.md)

## Administrators

* [Configuration](configuration.md)
* [Migration](usage/migration.md)
* [Usage as Container](deployment/container.md)
* [Usage in Kubernetes](./k8s/k8s.md)

## Developers

* [Libraries \(3rd party\)](usage/3rd-party-apis.md)
* [Contributing](getting-involved/contributing.md)
* [Quick Start As Go Library](usage/quickstart-as-lib.md)

