# rez [![GoDoc](https://godoc.org/github.com/bamiaux/rez/web?status.png)](https://godoc.org/github.com/bamiaux/rez) [![Build Status](https://travis-ci.org/bamiaux/rez.png)](https://travis-ci.org/bamiaux/rez)
Package rez provides image resizing in pure Go and SIMD.

Download:
```shell
go get github.com/bamiaux/rez
```


Full documentation at http://godoc.org/github.com/bamiaux/rez

* * *
Package rez provides image resizing in pure Go and SIMD.

Featuring:

```
- YCbCr, RGBA, NRGBA & Gray resizes
- YCbCr Chroma subsample ratio conversions
- Optional interlaced-aware resizes
- Parallel resizes
- SIMD optimisations on AMD64
```

The easiest way to use it is:

```
err := Convert(output, input, NewBicubicFilter())
```

However, if you plan to convert video, where resize parameters are the same for
multiple images, the best way is:

```
cfg, err := PrepareConversion(output, input)
converter, err := NewConverter(cfg, NewBicubicFilter())
for i := 0; i < N; i++ {
    err := converter.Convert(output[i], input[i])
}
```

Note that by default, images are resized in parallel with GOMAXPROCS slices.
Best performance is obtained when GOMAXPROCS is at least equal to your CPU
count.



* * *
Automatically generated by [autoreadme](https://github.com/jimmyfrasche/autoreadme) on 2014.11.25
