package reid

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCameraStatistics invokes the reid.DescribeCameraStatistics API synchronously
// api document: https://help.aliyun.com/api/reid/describecamerastatistics.html
func (client *Client) DescribeCameraStatistics(request *DescribeCameraStatisticsRequest) (response *DescribeCameraStatisticsResponse, err error) {
	response = CreateDescribeCameraStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCameraStatisticsWithChan invokes the reid.DescribeCameraStatistics API asynchronously
// api document: https://help.aliyun.com/api/reid/describecamerastatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCameraStatisticsWithChan(request *DescribeCameraStatisticsRequest) (<-chan *DescribeCameraStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeCameraStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCameraStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCameraStatisticsWithCallback invokes the reid.DescribeCameraStatistics API asynchronously
// api document: https://help.aliyun.com/api/reid/describecamerastatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCameraStatisticsWithCallback(request *DescribeCameraStatisticsRequest, callback func(response *DescribeCameraStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCameraStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeCameraStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCameraStatisticsRequest is the request struct for api DescribeCameraStatistics
type DescribeCameraStatisticsRequest struct {
	*requests.RpcRequest
	StartTimestamp requests.Integer `position:"Body" name:"StartTimestamp"`
	StoreId        requests.Integer `position:"Body" name:"StoreId"`
	EndTimestamp   requests.Integer `position:"Body" name:"EndTimestamp"`
}

// DescribeCameraStatisticsResponse is the response struct for api DescribeCameraStatistics
type DescribeCameraStatisticsResponse struct {
	*responses.BaseResponse
	ErrorCode          string             `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage       string             `json:"ErrorMessage" xml:"ErrorMessage"`
	Message            string             `json:"Message" xml:"Message"`
	Code               string             `json:"Code" xml:"Code"`
	DynamicCode        string             `json:"DynamicCode" xml:"DynamicCode"`
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	Success            bool               `json:"Success" xml:"Success"`
	DynamicMessage     string             `json:"DynamicMessage" xml:"DynamicMessage"`
	PvStatisticResults PvStatisticResults `json:"PvStatisticResults" xml:"PvStatisticResults"`
}

// CreateDescribeCameraStatisticsRequest creates a request to invoke DescribeCameraStatistics API
func CreateDescribeCameraStatisticsRequest() (request *DescribeCameraStatisticsRequest) {
	request = &DescribeCameraStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("reid", "2019-09-28", "DescribeCameraStatistics", "1.1.8.2", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCameraStatisticsResponse creates a response to parse from DescribeCameraStatistics response
func CreateDescribeCameraStatisticsResponse() (response *DescribeCameraStatisticsResponse) {
	response = &DescribeCameraStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
