package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteWaterMarkTemplate invokes the mts.DeleteWaterMarkTemplate API synchronously
func (client *Client) DeleteWaterMarkTemplate(request *DeleteWaterMarkTemplateRequest) (response *DeleteWaterMarkTemplateResponse, err error) {
	response = CreateDeleteWaterMarkTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteWaterMarkTemplateWithChan invokes the mts.DeleteWaterMarkTemplate API asynchronously
func (client *Client) DeleteWaterMarkTemplateWithChan(request *DeleteWaterMarkTemplateRequest) (<-chan *DeleteWaterMarkTemplateResponse, <-chan error) {
	responseChan := make(chan *DeleteWaterMarkTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteWaterMarkTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteWaterMarkTemplateWithCallback invokes the mts.DeleteWaterMarkTemplate API asynchronously
func (client *Client) DeleteWaterMarkTemplateWithCallback(request *DeleteWaterMarkTemplateRequest, callback func(response *DeleteWaterMarkTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteWaterMarkTemplateResponse
		var err error
		defer close(result)
		response, err = client.DeleteWaterMarkTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteWaterMarkTemplateRequest is the request struct for api DeleteWaterMarkTemplate
type DeleteWaterMarkTemplateRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	WaterMarkTemplateId  string           `position:"Query" name:"WaterMarkTemplateId"`
}

// DeleteWaterMarkTemplateResponse is the response struct for api DeleteWaterMarkTemplate
type DeleteWaterMarkTemplateResponse struct {
	*responses.BaseResponse
	RequestId           string `json:"RequestId" xml:"RequestId"`
	WaterMarkTemplateId string `json:"WaterMarkTemplateId" xml:"WaterMarkTemplateId"`
}

// CreateDeleteWaterMarkTemplateRequest creates a request to invoke DeleteWaterMarkTemplate API
func CreateDeleteWaterMarkTemplateRequest() (request *DeleteWaterMarkTemplateRequest) {
	request = &DeleteWaterMarkTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "DeleteWaterMarkTemplate", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteWaterMarkTemplateResponse creates a response to parse from DeleteWaterMarkTemplate response
func CreateDeleteWaterMarkTemplateResponse() (response *DeleteWaterMarkTemplateResponse) {
	response = &DeleteWaterMarkTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
