package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCommodity invokes the market.DescribeCommodity API synchronously
// api document: https://help.aliyun.com/api/market/describecommodity.html
func (client *Client) DescribeCommodity(request *DescribeCommodityRequest) (response *DescribeCommodityResponse, err error) {
	response = CreateDescribeCommodityResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCommodityWithChan invokes the market.DescribeCommodity API asynchronously
// api document: https://help.aliyun.com/api/market/describecommodity.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCommodityWithChan(request *DescribeCommodityRequest) (<-chan *DescribeCommodityResponse, <-chan error) {
	responseChan := make(chan *DescribeCommodityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCommodity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCommodityWithCallback invokes the market.DescribeCommodity API asynchronously
// api document: https://help.aliyun.com/api/market/describecommodity.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCommodityWithCallback(request *DescribeCommodityRequest, callback func(response *DescribeCommodityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCommodityResponse
		var err error
		defer close(result)
		response, err = client.DescribeCommodity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCommodityRequest is the request struct for api DescribeCommodity
type DescribeCommodityRequest struct {
	*requests.RpcRequest
	CommodityId string `position:"Query" name:"CommodityId"`
}

// DescribeCommodityResponse is the response struct for api DescribeCommodity
type DescribeCommodityResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Success   bool      `json:"Success" xml:"Success"`
	Commodity Commodity `json:"Commodity" xml:"Commodity"`
}

// CreateDescribeCommodityRequest creates a request to invoke DescribeCommodity API
func CreateDescribeCommodityRequest() (request *DescribeCommodityRequest) {
	request = &DescribeCommodityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "DescribeCommodity", "yunmarket", "openAPI")
	return
}

// CreateDescribeCommodityResponse creates a response to parse from DescribeCommodity response
func CreateDescribeCommodityResponse() (response *DescribeCommodityResponse) {
	response = &DescribeCommodityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
