package idrsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApps invokes the idrsservice.ListApps API synchronously
func (client *Client) ListApps(request *ListAppsRequest) (response *ListAppsResponse, err error) {
	response = CreateListAppsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAppsWithChan invokes the idrsservice.ListApps API asynchronously
func (client *Client) ListAppsWithChan(request *ListAppsRequest) (<-chan *ListAppsResponse, <-chan error) {
	responseChan := make(chan *ListAppsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAppsWithCallback invokes the idrsservice.ListApps API asynchronously
func (client *Client) ListAppsWithCallback(request *ListAppsRequest, callback func(response *ListAppsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAppsResponse
		var err error
		defer close(result)
		response, err = client.ListApps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAppsRequest is the request struct for api ListApps
type ListAppsRequest struct {
	*requests.RpcRequest
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	PageIndex requests.Integer `position:"Query" name:"PageIndex"`
}

// ListAppsResponse is the response struct for api ListApps
type ListAppsResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListAppsRequest creates a request to invoke ListApps API
func CreateListAppsRequest() (request *ListAppsRequest) {
	request = &ListAppsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idrsservice", "2020-06-30", "ListApps", "idrsservice", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAppsResponse creates a response to parse from ListApps response
func CreateListAppsResponse() (response *ListAppsResponse) {
	response = &ListAppsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
