package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloseBackup invokes the hbase.CloseBackup API synchronously
func (client *Client) CloseBackup(request *CloseBackupRequest) (response *CloseBackupResponse, err error) {
	response = CreateCloseBackupResponse()
	err = client.DoAction(request, response)
	return
}

// CloseBackupWithChan invokes the hbase.CloseBackup API asynchronously
func (client *Client) CloseBackupWithChan(request *CloseBackupRequest) (<-chan *CloseBackupResponse, <-chan error) {
	responseChan := make(chan *CloseBackupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloseBackup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloseBackupWithCallback invokes the hbase.CloseBackup API asynchronously
func (client *Client) CloseBackupWithCallback(request *CloseBackupRequest, callback func(response *CloseBackupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloseBackupResponse
		var err error
		defer close(result)
		response, err = client.CloseBackup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloseBackupRequest is the request struct for api CloseBackup
type CloseBackupRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// CloseBackupResponse is the response struct for api CloseBackup
type CloseBackupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCloseBackupRequest creates a request to invoke CloseBackup API
func CreateCloseBackupRequest() (request *CloseBackupRequest) {
	request = &CloseBackupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "CloseBackup", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCloseBackupResponse creates a response to parse from CloseBackup response
func CreateCloseBackupResponse() (response *CloseBackupResponse) {
	response = &CloseBackupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
