package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemovePublicIpsFromEpnInstance invokes the ens.RemovePublicIpsFromEpnInstance API synchronously
func (client *Client) RemovePublicIpsFromEpnInstance(request *RemovePublicIpsFromEpnInstanceRequest) (response *RemovePublicIpsFromEpnInstanceResponse, err error) {
	response = CreateRemovePublicIpsFromEpnInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// RemovePublicIpsFromEpnInstanceWithChan invokes the ens.RemovePublicIpsFromEpnInstance API asynchronously
func (client *Client) RemovePublicIpsFromEpnInstanceWithChan(request *RemovePublicIpsFromEpnInstanceRequest) (<-chan *RemovePublicIpsFromEpnInstanceResponse, <-chan error) {
	responseChan := make(chan *RemovePublicIpsFromEpnInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemovePublicIpsFromEpnInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemovePublicIpsFromEpnInstanceWithCallback invokes the ens.RemovePublicIpsFromEpnInstance API asynchronously
func (client *Client) RemovePublicIpsFromEpnInstanceWithCallback(request *RemovePublicIpsFromEpnInstanceRequest, callback func(response *RemovePublicIpsFromEpnInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemovePublicIpsFromEpnInstanceResponse
		var err error
		defer close(result)
		response, err = client.RemovePublicIpsFromEpnInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemovePublicIpsFromEpnInstanceRequest is the request struct for api RemovePublicIpsFromEpnInstance
type RemovePublicIpsFromEpnInstanceRequest struct {
	*requests.RpcRequest
	EPNInstanceId string `position:"Query" name:"EPNInstanceId"`
	InstanceInfos string `position:"Query" name:"InstanceInfos"`
}

// RemovePublicIpsFromEpnInstanceResponse is the response struct for api RemovePublicIpsFromEpnInstance
type RemovePublicIpsFromEpnInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRemovePublicIpsFromEpnInstanceRequest creates a request to invoke RemovePublicIpsFromEpnInstance API
func CreateRemovePublicIpsFromEpnInstanceRequest() (request *RemovePublicIpsFromEpnInstanceRequest) {
	request = &RemovePublicIpsFromEpnInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "RemovePublicIpsFromEpnInstance", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemovePublicIpsFromEpnInstanceResponse creates a response to parse from RemovePublicIpsFromEpnInstance response
func CreateRemovePublicIpsFromEpnInstanceResponse() (response *RemovePublicIpsFromEpnInstanceResponse) {
	response = &RemovePublicIpsFromEpnInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
