package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DcdnHttpRequestTestTool invokes the dcdn.DcdnHttpRequestTestTool API synchronously
func (client *Client) DcdnHttpRequestTestTool(request *DcdnHttpRequestTestToolRequest) (response *DcdnHttpRequestTestToolResponse, err error) {
	response = CreateDcdnHttpRequestTestToolResponse()
	err = client.DoAction(request, response)
	return
}

// DcdnHttpRequestTestToolWithChan invokes the dcdn.DcdnHttpRequestTestTool API asynchronously
func (client *Client) DcdnHttpRequestTestToolWithChan(request *DcdnHttpRequestTestToolRequest) (<-chan *DcdnHttpRequestTestToolResponse, <-chan error) {
	responseChan := make(chan *DcdnHttpRequestTestToolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DcdnHttpRequestTestTool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DcdnHttpRequestTestToolWithCallback invokes the dcdn.DcdnHttpRequestTestTool API asynchronously
func (client *Client) DcdnHttpRequestTestToolWithCallback(request *DcdnHttpRequestTestToolRequest, callback func(response *DcdnHttpRequestTestToolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DcdnHttpRequestTestToolResponse
		var err error
		defer close(result)
		response, err = client.DcdnHttpRequestTestTool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DcdnHttpRequestTestToolRequest is the request struct for api DcdnHttpRequestTestTool
type DcdnHttpRequestTestToolRequest struct {
	*requests.RpcRequest
	ProxyIp string           `position:"Body" name:"ProxyIp"`
	Scheme  string           `position:"Body" name:"Scheme"`
	Body    string           `position:"Body" name:"Body"`
	Host    string           `position:"Body" name:"Host"`
	Method  string           `position:"Body" name:"Method"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
	Uri     string           `position:"Body" name:"Uri"`
	Args    string           `position:"Body" name:"Args"`
	Header  string           `position:"Body" name:"Header"`
}

// DcdnHttpRequestTestToolResponse is the response struct for api DcdnHttpRequestTestTool
type DcdnHttpRequestTestToolResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Header     string `json:"Header" xml:"Header"`
	Body       string `json:"Body" xml:"Body"`
	StatusCode int    `json:"StatusCode" xml:"StatusCode"`
}

// CreateDcdnHttpRequestTestToolRequest creates a request to invoke DcdnHttpRequestTestTool API
func CreateDcdnHttpRequestTestToolRequest() (request *DcdnHttpRequestTestToolRequest) {
	request = &DcdnHttpRequestTestToolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DcdnHttpRequestTestTool", "", "")
	request.Method = requests.POST
	return
}

// CreateDcdnHttpRequestTestToolResponse creates a response to parse from DcdnHttpRequestTestTool response
func CreateDcdnHttpRequestTestToolResponse() (response *DcdnHttpRequestTestToolResponse) {
	response = &DcdnHttpRequestTestToolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
