package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutMeasureReadyFlag invokes the companyreg.PutMeasureReadyFlag API synchronously
func (client *Client) PutMeasureReadyFlag(request *PutMeasureReadyFlagRequest) (response *PutMeasureReadyFlagResponse, err error) {
	response = CreatePutMeasureReadyFlagResponse()
	err = client.DoAction(request, response)
	return
}

// PutMeasureReadyFlagWithChan invokes the companyreg.PutMeasureReadyFlag API asynchronously
func (client *Client) PutMeasureReadyFlagWithChan(request *PutMeasureReadyFlagRequest) (<-chan *PutMeasureReadyFlagResponse, <-chan error) {
	responseChan := make(chan *PutMeasureReadyFlagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutMeasureReadyFlag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutMeasureReadyFlagWithCallback invokes the companyreg.PutMeasureReadyFlag API asynchronously
func (client *Client) PutMeasureReadyFlagWithCallback(request *PutMeasureReadyFlagRequest, callback func(response *PutMeasureReadyFlagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutMeasureReadyFlagResponse
		var err error
		defer close(result)
		response, err = client.PutMeasureReadyFlag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutMeasureReadyFlagRequest is the request struct for api PutMeasureReadyFlag
type PutMeasureReadyFlagRequest struct {
	*requests.RpcRequest
	ReadyFlag string `position:"Query" name:"ReadyFlag"`
	EndTime   string `position:"Query" name:"EndTime"`
	StartTime string `position:"Query" name:"StartTime"`
	BizType   string `position:"Query" name:"BizType"`
	DataType  string `position:"Query" name:"DataType"`
}

// PutMeasureReadyFlagResponse is the response struct for api PutMeasureReadyFlag
type PutMeasureReadyFlagResponse struct {
	*responses.BaseResponse
	Data      bool   `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePutMeasureReadyFlagRequest creates a request to invoke PutMeasureReadyFlag API
func CreatePutMeasureReadyFlagRequest() (request *PutMeasureReadyFlagRequest) {
	request = &PutMeasureReadyFlagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-03-06", "PutMeasureReadyFlag", "", "")
	request.Method = requests.POST
	return
}

// CreatePutMeasureReadyFlagResponse creates a response to parse from PutMeasureReadyFlag response
func CreatePutMeasureReadyFlagResponse() (response *PutMeasureReadyFlagResponse) {
	response = &PutMeasureReadyFlagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
