package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLorneLog invokes the clickhouse.DescribeLorneLog API synchronously
func (client *Client) DescribeLorneLog(request *DescribeLorneLogRequest) (response *DescribeLorneLogResponse, err error) {
	response = CreateDescribeLorneLogResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLorneLogWithChan invokes the clickhouse.DescribeLorneLog API asynchronously
func (client *Client) DescribeLorneLogWithChan(request *DescribeLorneLogRequest) (<-chan *DescribeLorneLogResponse, <-chan error) {
	responseChan := make(chan *DescribeLorneLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLorneLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLorneLogWithCallback invokes the clickhouse.DescribeLorneLog API asynchronously
func (client *Client) DescribeLorneLogWithCallback(request *DescribeLorneLogRequest, callback func(response *DescribeLorneLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLorneLogResponse
		var err error
		defer close(result)
		response, err = client.DescribeLorneLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLorneLogRequest is the request struct for api DescribeLorneLog
type DescribeLorneLogRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	StartTime            string           `position:"Query" name:"StartTime"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	TaskId               string           `position:"Query" name:"TaskId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	EndTime              string           `position:"Query" name:"EndTime"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLorneLogResponse is the response struct for api DescribeLorneLog
type DescribeLorneLogResponse struct {
	*responses.BaseResponse
	TotalCount int        `json:"TotalCount" xml:"TotalCount"`
	PageSize   int        `json:"PageSize" xml:"PageSize"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	PageNumber int        `json:"PageNumber" xml:"PageNumber"`
	Data       []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeLorneLogRequest creates a request to invoke DescribeLorneLog API
func CreateDescribeLorneLogRequest() (request *DescribeLorneLogRequest) {
	request = &DescribeLorneLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "DescribeLorneLog", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeLorneLogResponse creates a response to parse from DescribeLorneLog response
func CreateDescribeLorneLogResponse() (response *DescribeLorneLogResponse) {
	response = &DescribeLorneLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
