package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFabricConsortiumMember invokes the baas.CreateFabricConsortiumMember API synchronously
// api document: https://help.aliyun.com/api/baas/createfabricconsortiummember.html
func (client *Client) CreateFabricConsortiumMember(request *CreateFabricConsortiumMemberRequest) (response *CreateFabricConsortiumMemberResponse, err error) {
	response = CreateCreateFabricConsortiumMemberResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFabricConsortiumMemberWithChan invokes the baas.CreateFabricConsortiumMember API asynchronously
// api document: https://help.aliyun.com/api/baas/createfabricconsortiummember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateFabricConsortiumMemberWithChan(request *CreateFabricConsortiumMemberRequest) (<-chan *CreateFabricConsortiumMemberResponse, <-chan error) {
	responseChan := make(chan *CreateFabricConsortiumMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFabricConsortiumMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFabricConsortiumMemberWithCallback invokes the baas.CreateFabricConsortiumMember API asynchronously
// api document: https://help.aliyun.com/api/baas/createfabricconsortiummember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateFabricConsortiumMemberWithCallback(request *CreateFabricConsortiumMemberRequest, callback func(response *CreateFabricConsortiumMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFabricConsortiumMemberResponse
		var err error
		defer close(result)
		response, err = client.CreateFabricConsortiumMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFabricConsortiumMemberRequest is the request struct for api CreateFabricConsortiumMember
type CreateFabricConsortiumMemberRequest struct {
	*requests.RpcRequest
	Code         string                                      `position:"Query" name:"Code"`
	Organization *[]CreateFabricConsortiumMemberOrganization `position:"Query" name:"Organization"  type:"Repeated"`
	ConsortiumId string                                      `position:"Query" name:"ConsortiumId"`
}

// CreateFabricConsortiumMemberOrganization is a repeated param struct in CreateFabricConsortiumMemberRequest
type CreateFabricConsortiumMemberOrganization struct {
	OrganizationId string `name:"OrganizationId"`
}

// CreateFabricConsortiumMemberResponse is the response struct for api CreateFabricConsortiumMember
type CreateFabricConsortiumMemberResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateCreateFabricConsortiumMemberRequest creates a request to invoke CreateFabricConsortiumMember API
func CreateCreateFabricConsortiumMemberRequest() (request *CreateFabricConsortiumMemberRequest) {
	request = &CreateFabricConsortiumMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "CreateFabricConsortiumMember", "baas", "openAPI")
	return
}

// CreateCreateFabricConsortiumMemberResponse creates a response to parse from CreateFabricConsortiumMember response
func CreateCreateFabricConsortiumMemberResponse() (response *CreateFabricConsortiumMemberResponse) {
	response = &CreateFabricConsortiumMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
