package iotspacesapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/iotspaces/mgmt/2017-10-01-preview/iotspaces"
)

// ClientAPI contains the set of methods on the Client type.
type ClientAPI interface {
	CheckNameAvailability(ctx context.Context, operationInputs iotspaces.OperationInputs) (result iotspaces.NameAvailabilityInfo, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, resourceName string, iotSpaceDescription iotspaces.Description) (result iotspaces.CreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, resourceName string) (result iotspaces.DeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, resourceName string) (result iotspaces.Description, err error)
	List(ctx context.Context) (result iotspaces.DescriptionListResultPage, err error)
	ListComplete(ctx context.Context) (result iotspaces.DescriptionListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result iotspaces.DescriptionListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result iotspaces.DescriptionListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, resourceName string, iotSpacePatchDescription iotspaces.PatchDescription) (result iotspaces.UpdateFuture, err error)
}

var _ ClientAPI = (*iotspaces.Client)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result iotspaces.OperationListResultPage, err error)
	ListComplete(ctx context.Context) (result iotspaces.OperationListResultIterator, err error)
}

var _ OperationsClientAPI = (*iotspaces.OperationsClient)(nil)
