package webservices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/machinelearning/mgmt/2016-05-01-preview/webservices"

// AssetItem information about an asset associated with the web service.
type AssetItem struct {
	// Name - Asset's friendly name.
	Name *string `json:"name,omitempty"`
	// ID - Asset's Id.
	ID *string `json:"id,omitempty"`
	// Type - Asset's type. Possible values include: 'AssetTypeModule', 'AssetTypeResource'
	Type AssetType `json:"type,omitempty"`
	// LocationInfo - Access information for the asset.
	LocationInfo *AssetLocation `json:"locationInfo,omitempty"`
	// InputPorts - Information about the asset's input ports.
	InputPorts map[string]*InputPort `json:"inputPorts"`
	// OutputPorts - Information about the asset's output ports.
	OutputPorts map[string]*OutputPort `json:"outputPorts"`
	// Metadata - If the asset is a custom module, this holds the module's metadata.
	Metadata map[string]*string `json:"metadata"`
	// Parameters - If the asset is a custom module, this holds the module's parameters.
	Parameters *[]ModuleAssetParameter `json:"parameters,omitempty"`
}

// MarshalJSON is the custom marshaler for AssetItem.
func (ai AssetItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ai.Name != nil {
		objectMap["name"] = ai.Name
	}
	if ai.ID != nil {
		objectMap["id"] = ai.ID
	}
	if ai.Type != "" {
		objectMap["type"] = ai.Type
	}
	if ai.LocationInfo != nil {
		objectMap["locationInfo"] = ai.LocationInfo
	}
	if ai.InputPorts != nil {
		objectMap["inputPorts"] = ai.InputPorts
	}
	if ai.OutputPorts != nil {
		objectMap["outputPorts"] = ai.OutputPorts
	}
	if ai.Metadata != nil {
		objectMap["metadata"] = ai.Metadata
	}
	if ai.Parameters != nil {
		objectMap["parameters"] = ai.Parameters
	}
	return json.Marshal(objectMap)
}

// AssetLocation describes the access location for a web service asset.
type AssetLocation struct {
	// URI - The URI where the asset is accessible from, (e.g. aml://abc for system assets or https://xyz for user assets
	URI *string `json:"uri,omitempty"`
	// Credentials - Access credentials for the asset, if applicable (e.g. asset specified by storage account connection string + blob URI)
	Credentials *string `json:"credentials,omitempty"`
}

// ColumnSpecification swagger 2.0 schema for a column within the data table representing a web service
// input or output. See Swagger specification: http://swagger.io/specification/
type ColumnSpecification struct {
	// Type - Data type of the column. Possible values include: 'Boolean', 'Integer', 'Number', 'String'
	Type ColumnType `json:"type,omitempty"`
	// Format - Additional format information for the data type. Possible values include: 'Byte', 'Char', 'Complex64', 'Complex128', 'DateTime', 'DateTimeOffset', 'Double', 'Duration', 'Float', 'Int8', 'Int16', 'Int32', 'Int64', 'Uint8', 'Uint16', 'Uint32', 'Uint64'
	Format ColumnFormat `json:"format,omitempty"`
	// Enum - If the data type is categorical, this provides the list of accepted categories.
	Enum *[]interface{} `json:"enum,omitempty"`
	// XMsIsnullable - Flag indicating if the type supports null values or not.
	XMsIsnullable *bool `json:"x-ms-isnullable,omitempty"`
	// XMsIsordered - Flag indicating whether the categories are treated as an ordered set or not, if this is a categorical column.
	XMsIsordered *bool `json:"x-ms-isordered,omitempty"`
}

// CommitmentPlan information about the machine learning commitment plan associated with the web service.
type CommitmentPlan struct {
	// ID - Specifies the Azure Resource Manager ID of the commitment plan associated with the web service.
	ID *string `json:"id,omitempty"`
}

// CreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (WebService, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CreateOrUpdateFuture.Result.
func (future *CreateOrUpdateFuture) result(client Client) (ws WebService, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "webservices.CreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ws.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("webservices.CreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ws.Response.Response, err = future.GetResult(sender); err == nil && ws.Response.Response.StatusCode != http.StatusNoContent {
		ws, err = client.CreateOrUpdateResponder(ws.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "webservices.CreateOrUpdateFuture", "Result", ws.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DiagnosticsConfiguration diagnostics settings for an Azure ML web service.
type DiagnosticsConfiguration struct {
	// Level - Specifies the verbosity of the diagnostic output. Valid values are: None - disables tracing; Error - collects only error (stderr) traces; All - collects all traces (stdout and stderr). Possible values include: 'None', 'Error', 'All'
	Level DiagnosticsLevel `json:"level,omitempty"`
	// Expiry - Specifies the date and time when the logging will cease. If null, diagnostic collection is not time limited.
	Expiry *date.Time `json:"expiry,omitempty"`
}

// ExampleRequest sample input data for the service's input(s).
type ExampleRequest struct {
	// Inputs - Sample input data for the web service's input(s) given as an input name to sample input values matrix map.
	Inputs map[string][][]interface{} `json:"inputs"`
	// GlobalParameters - Sample input data for the web service's global parameters
	GlobalParameters map[string]interface{} `json:"globalParameters"`
}

// MarshalJSON is the custom marshaler for ExampleRequest.
func (er ExampleRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if er.Inputs != nil {
		objectMap["inputs"] = er.Inputs
	}
	if er.GlobalParameters != nil {
		objectMap["globalParameters"] = er.GlobalParameters
	}
	return json.Marshal(objectMap)
}

// GraphEdge defines an edge within the web service's graph.
type GraphEdge struct {
	// SourceNodeID - The source graph node's identifier.
	SourceNodeID *string `json:"sourceNodeId,omitempty"`
	// SourcePortID - The identifier of the source node's port that the edge connects from.
	SourcePortID *string `json:"sourcePortId,omitempty"`
	// TargetNodeID - The destination graph node's identifier.
	TargetNodeID *string `json:"targetNodeId,omitempty"`
	// TargetPortID - The identifier of the destination node's port that the edge connects into.
	TargetPortID *string `json:"targetPortId,omitempty"`
}

// GraphNode specifies a node in the web service graph. The node can either be an input, output or asset
// node, so only one of the corresponding id properties is populated at any given time.
type GraphNode struct {
	// AssetID - The id of the asset represented by this node.
	AssetID *string `json:"assetId,omitempty"`
	// InputID - The id of the input element represented by this node.
	InputID *string `json:"inputId,omitempty"`
	// OutputID - The id of the output element represented by this node.
	OutputID *string `json:"outputId,omitempty"`
	// Parameters - If applicable, parameters of the node. Global graph parameters map into these, with values set at runtime.
	Parameters map[string]*string `json:"parameters"`
}

// MarshalJSON is the custom marshaler for GraphNode.
func (gn GraphNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gn.AssetID != nil {
		objectMap["assetId"] = gn.AssetID
	}
	if gn.InputID != nil {
		objectMap["inputId"] = gn.InputID
	}
	if gn.OutputID != nil {
		objectMap["outputId"] = gn.OutputID
	}
	if gn.Parameters != nil {
		objectMap["parameters"] = gn.Parameters
	}
	return json.Marshal(objectMap)
}

// GraphPackage defines the graph of modules making up the machine learning solution.
type GraphPackage struct {
	// Nodes - The set of nodes making up the graph, provided as a nodeId to GraphNode map
	Nodes map[string]*GraphNode `json:"nodes"`
	// Edges - The list of edges making up the graph.
	Edges *[]GraphEdge `json:"edges,omitempty"`
	// GraphParameters - The collection of global parameters for the graph, given as a global parameter name to GraphParameter map. Each parameter here has a 1:1 match with the global parameters values map declared at the WebServiceProperties level.
	GraphParameters map[string]*GraphParameter `json:"graphParameters"`
}

// MarshalJSON is the custom marshaler for GraphPackage.
func (gp GraphPackage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gp.Nodes != nil {
		objectMap["nodes"] = gp.Nodes
	}
	if gp.Edges != nil {
		objectMap["edges"] = gp.Edges
	}
	if gp.GraphParameters != nil {
		objectMap["graphParameters"] = gp.GraphParameters
	}
	return json.Marshal(objectMap)
}

// GraphParameter defines a global parameter in the graph.
type GraphParameter struct {
	// Description - Description of this graph parameter.
	Description *string `json:"description,omitempty"`
	// Type - Graph parameter's type. Possible values include: 'ParameterTypeString', 'ParameterTypeInt', 'ParameterTypeFloat', 'ParameterTypeEnumerated', 'ParameterTypeScript', 'ParameterTypeMode', 'ParameterTypeCredential', 'ParameterTypeBoolean', 'ParameterTypeDouble', 'ParameterTypeColumnPicker', 'ParameterTypeParameterRange', 'ParameterTypeDataGatewayName'
	Type ParameterType `json:"type,omitempty"`
	// Links - Association links for this parameter to nodes in the graph.
	Links *[]GraphParameterLink `json:"links,omitempty"`
}

// GraphParameterLink association link for a graph global parameter to a node in the graph.
type GraphParameterLink struct {
	// NodeID - The graph node's identifier
	NodeID *string `json:"nodeId,omitempty"`
	// ParameterKey - The identifier of the node parameter that the global parameter maps to.
	ParameterKey *string `json:"parameterKey,omitempty"`
}

// InputPort asset input port
type InputPort struct {
	// Type - Port data type. Possible values include: 'Dataset'
	Type InputPortType `json:"type,omitempty"`
}

// Keys access keys for the web service calls.
type Keys struct {
	autorest.Response `json:"-"`
	// Primary - The primary access key.
	Primary *string `json:"primary,omitempty"`
	// Secondary - The secondary access key.
	Secondary *string `json:"secondary,omitempty"`
}

// MachineLearningWorkspace information about the machine learning workspace containing the experiment that
// is source for the web service.
type MachineLearningWorkspace struct {
	// ID - Specifies the workspace ID of the machine learning workspace associated with the web service
	ID *string `json:"id,omitempty"`
}

// ModeValueInfo nested parameter definition.
type ModeValueInfo struct {
	// InterfaceString - The interface string name for the nested parameter.
	InterfaceString *string `json:"interfaceString,omitempty"`
	// Parameters - The definition of the parameter.
	Parameters *[]ModuleAssetParameter `json:"parameters,omitempty"`
}

// ModuleAssetParameter parameter definition for a module asset.
type ModuleAssetParameter struct {
	// Name - Parameter name.
	Name *string `json:"name,omitempty"`
	// ParameterType - Parameter type.
	ParameterType *string `json:"parameterType,omitempty"`
	// ModeValuesInfo - Definitions for nested interface parameters if this is a complex module parameter.
	ModeValuesInfo map[string]*ModeValueInfo `json:"modeValuesInfo"`
}

// MarshalJSON is the custom marshaler for ModuleAssetParameter.
func (mapVar ModuleAssetParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mapVar.Name != nil {
		objectMap["name"] = mapVar.Name
	}
	if mapVar.ParameterType != nil {
		objectMap["parameterType"] = mapVar.ParameterType
	}
	if mapVar.ModeValuesInfo != nil {
		objectMap["modeValuesInfo"] = mapVar.ModeValuesInfo
	}
	return json.Marshal(objectMap)
}

// OutputPort asset output port
type OutputPort struct {
	// Type - Port data type. Possible values include: 'OutputPortTypeDataset'
	Type OutputPortType `json:"type,omitempty"`
}

// PaginatedWebServicesList paginated list of web services.
type PaginatedWebServicesList struct {
	autorest.Response `json:"-"`
	// Value - An array of web service objects.
	Value *[]WebService `json:"value,omitempty"`
	// NextLink - A continuation link (absolute URI) to the next page of results in the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// PaginatedWebServicesListIterator provides access to a complete listing of WebService values.
type PaginatedWebServicesListIterator struct {
	i    int
	page PaginatedWebServicesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PaginatedWebServicesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PaginatedWebServicesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PaginatedWebServicesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PaginatedWebServicesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PaginatedWebServicesListIterator) Response() PaginatedWebServicesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PaginatedWebServicesListIterator) Value() WebService {
	if !iter.page.NotDone() {
		return WebService{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PaginatedWebServicesListIterator type.
func NewPaginatedWebServicesListIterator(page PaginatedWebServicesListPage) PaginatedWebServicesListIterator {
	return PaginatedWebServicesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pwsl PaginatedWebServicesList) IsEmpty() bool {
	return pwsl.Value == nil || len(*pwsl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pwsl PaginatedWebServicesList) hasNextLink() bool {
	return pwsl.NextLink != nil && len(*pwsl.NextLink) != 0
}

// paginatedWebServicesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pwsl PaginatedWebServicesList) paginatedWebServicesListPreparer(ctx context.Context) (*http.Request, error) {
	if !pwsl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pwsl.NextLink)))
}

// PaginatedWebServicesListPage contains a page of WebService values.
type PaginatedWebServicesListPage struct {
	fn   func(context.Context, PaginatedWebServicesList) (PaginatedWebServicesList, error)
	pwsl PaginatedWebServicesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PaginatedWebServicesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PaginatedWebServicesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pwsl)
		if err != nil {
			return err
		}
		page.pwsl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PaginatedWebServicesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PaginatedWebServicesListPage) NotDone() bool {
	return !page.pwsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PaginatedWebServicesListPage) Response() PaginatedWebServicesList {
	return page.pwsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PaginatedWebServicesListPage) Values() []WebService {
	if page.pwsl.IsEmpty() {
		return nil
	}
	return *page.pwsl.Value
}

// Creates a new instance of the PaginatedWebServicesListPage type.
func NewPaginatedWebServicesListPage(cur PaginatedWebServicesList, getNextPage func(context.Context, PaginatedWebServicesList) (PaginatedWebServicesList, error)) PaginatedWebServicesListPage {
	return PaginatedWebServicesListPage{
		fn:   getNextPage,
		pwsl: cur,
	}
}

// PatchFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type PatchFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (WebService, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PatchFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PatchFuture.Result.
func (future *PatchFuture) result(client Client) (ws WebService, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "webservices.PatchFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ws.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("webservices.PatchFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ws.Response.Response, err = future.GetResult(sender); err == nil && ws.Response.Response.StatusCode != http.StatusNoContent {
		ws, err = client.PatchResponder(ws.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "webservices.PatchFuture", "Result", ws.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BasicProperties the set of properties specific to the Azure ML web service resource.
type BasicProperties interface {
	AsPropertiesForGraph() (*PropertiesForGraph, bool)
	AsProperties() (*Properties, bool)
}

// Properties the set of properties specific to the Azure ML web service resource.
type Properties struct {
	// Title - The title of the web service.
	Title *string `json:"title,omitempty"`
	// Description - The description of the web service.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; Read Only: The date and time when the web service was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; Read Only: The date and time when the web service was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ProvisioningState - READ-ONLY; Read Only: The provision state of the web service. Valid values are Unknown, Provisioning, Succeeded, and Failed. Possible values include: 'Unknown', 'Provisioning', 'Succeeded', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Keys - Contains the web service provisioning keys. If you do not specify provisioning keys, the Azure Machine Learning system generates them for you. Note: The keys are not returned from calls to GET operations.
	Keys *Keys `json:"keys,omitempty"`
	// ReadOnly - When set to true, indicates that the web service is read-only and can no longer be updated or patched, only removed. Default, is false. Note: Once set to true, you cannot change its value.
	ReadOnly *bool `json:"readOnly,omitempty"`
	// SwaggerLocation - READ-ONLY; Read Only: Contains the URI of the swagger spec associated with this web service.
	SwaggerLocation *string `json:"swaggerLocation,omitempty"`
	// ExposeSampleData - When set to true, sample data is included in the web service's swagger definition. The default value is true.
	ExposeSampleData *bool `json:"exposeSampleData,omitempty"`
	// RealtimeConfiguration - Contains the configuration settings for the web service endpoint.
	RealtimeConfiguration *RealtimeConfiguration `json:"realtimeConfiguration,omitempty"`
	// Diagnostics - Settings controlling the diagnostics traces collection for the web service.
	Diagnostics *DiagnosticsConfiguration `json:"diagnostics,omitempty"`
	// StorageAccount - Specifies the storage account that Azure Machine Learning uses to store information about the web service. Only the name of the storage account is returned from calls to GET operations. When updating the storage account information, you must ensure that all necessary assets are available in the new storage account or calls to your web service will fail.
	StorageAccount *StorageAccount `json:"storageAccount,omitempty"`
	// MachineLearningWorkspace - Specifies the Machine Learning workspace containing the experiment that is source for the web service.
	MachineLearningWorkspace *MachineLearningWorkspace `json:"machineLearningWorkspace,omitempty"`
	// CommitmentPlan - Contains the commitment plan associated with this web service. Set at creation time. Once set, this value cannot be changed. Note: The commitment plan is not returned from calls to GET operations.
	CommitmentPlan *CommitmentPlan `json:"commitmentPlan,omitempty"`
	// Input - Contains the Swagger 2.0 schema describing one or more of the web service's inputs. For more information, see the Swagger specification.
	Input *ServiceInputOutputSpecification `json:"input,omitempty"`
	// Output - Contains the Swagger 2.0 schema describing one or more of the web service's outputs. For more information, see the Swagger specification.
	Output *ServiceInputOutputSpecification `json:"output,omitempty"`
	// ExampleRequest - Defines sample input data for one or more of the service's inputs.
	ExampleRequest *ExampleRequest `json:"exampleRequest,omitempty"`
	// Assets - Contains user defined properties describing web service assets. Properties are expressed as Key/Value pairs.
	Assets map[string]*AssetItem `json:"assets"`
	// Parameters - The set of global parameters values defined for the web service, given as a global parameter name to default value map. If no default value is specified, the parameter is considered to be required.
	Parameters map[string]*string `json:"parameters"`
	// PackageType - Possible values include: 'PackageTypeWebServiceProperties', 'PackageTypeGraph'
	PackageType PackageType `json:"packageType,omitempty"`
}

func unmarshalBasicProperties(body []byte) (BasicProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["packageType"] {
	case string(PackageTypeGraph):
		var pfg PropertiesForGraph
		err := json.Unmarshal(body, &pfg)
		return pfg, err
	default:
		var p Properties
		err := json.Unmarshal(body, &p)
		return p, err
	}
}
func unmarshalBasicPropertiesArray(body []byte) ([]BasicProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	pArray := make([]BasicProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		p, err := unmarshalBasicProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		pArray[index] = p
	}
	return pArray, nil
}

// MarshalJSON is the custom marshaler for Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	p.PackageType = PackageTypeWebServiceProperties
	objectMap := make(map[string]interface{})
	if p.Title != nil {
		objectMap["title"] = p.Title
	}
	if p.Description != nil {
		objectMap["description"] = p.Description
	}
	if p.Keys != nil {
		objectMap["keys"] = p.Keys
	}
	if p.ReadOnly != nil {
		objectMap["readOnly"] = p.ReadOnly
	}
	if p.ExposeSampleData != nil {
		objectMap["exposeSampleData"] = p.ExposeSampleData
	}
	if p.RealtimeConfiguration != nil {
		objectMap["realtimeConfiguration"] = p.RealtimeConfiguration
	}
	if p.Diagnostics != nil {
		objectMap["diagnostics"] = p.Diagnostics
	}
	if p.StorageAccount != nil {
		objectMap["storageAccount"] = p.StorageAccount
	}
	if p.MachineLearningWorkspace != nil {
		objectMap["machineLearningWorkspace"] = p.MachineLearningWorkspace
	}
	if p.CommitmentPlan != nil {
		objectMap["commitmentPlan"] = p.CommitmentPlan
	}
	if p.Input != nil {
		objectMap["input"] = p.Input
	}
	if p.Output != nil {
		objectMap["output"] = p.Output
	}
	if p.ExampleRequest != nil {
		objectMap["exampleRequest"] = p.ExampleRequest
	}
	if p.Assets != nil {
		objectMap["assets"] = p.Assets
	}
	if p.Parameters != nil {
		objectMap["parameters"] = p.Parameters
	}
	if p.PackageType != "" {
		objectMap["packageType"] = p.PackageType
	}
	return json.Marshal(objectMap)
}

// AsPropertiesForGraph is the BasicProperties implementation for Properties.
func (p Properties) AsPropertiesForGraph() (*PropertiesForGraph, bool) {
	return nil, false
}

// AsProperties is the BasicProperties implementation for Properties.
func (p Properties) AsProperties() (*Properties, bool) {
	return &p, true
}

// AsBasicProperties is the BasicProperties implementation for Properties.
func (p Properties) AsBasicProperties() (BasicProperties, bool) {
	return &p, true
}

// PropertiesForGraph properties specific to a Graph based web service.
type PropertiesForGraph struct {
	// Package - The definition of the graph package making up this web service.
	Package *GraphPackage `json:"package,omitempty"`
	// Title - The title of the web service.
	Title *string `json:"title,omitempty"`
	// Description - The description of the web service.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; Read Only: The date and time when the web service was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; Read Only: The date and time when the web service was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ProvisioningState - READ-ONLY; Read Only: The provision state of the web service. Valid values are Unknown, Provisioning, Succeeded, and Failed. Possible values include: 'Unknown', 'Provisioning', 'Succeeded', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Keys - Contains the web service provisioning keys. If you do not specify provisioning keys, the Azure Machine Learning system generates them for you. Note: The keys are not returned from calls to GET operations.
	Keys *Keys `json:"keys,omitempty"`
	// ReadOnly - When set to true, indicates that the web service is read-only and can no longer be updated or patched, only removed. Default, is false. Note: Once set to true, you cannot change its value.
	ReadOnly *bool `json:"readOnly,omitempty"`
	// SwaggerLocation - READ-ONLY; Read Only: Contains the URI of the swagger spec associated with this web service.
	SwaggerLocation *string `json:"swaggerLocation,omitempty"`
	// ExposeSampleData - When set to true, sample data is included in the web service's swagger definition. The default value is true.
	ExposeSampleData *bool `json:"exposeSampleData,omitempty"`
	// RealtimeConfiguration - Contains the configuration settings for the web service endpoint.
	RealtimeConfiguration *RealtimeConfiguration `json:"realtimeConfiguration,omitempty"`
	// Diagnostics - Settings controlling the diagnostics traces collection for the web service.
	Diagnostics *DiagnosticsConfiguration `json:"diagnostics,omitempty"`
	// StorageAccount - Specifies the storage account that Azure Machine Learning uses to store information about the web service. Only the name of the storage account is returned from calls to GET operations. When updating the storage account information, you must ensure that all necessary assets are available in the new storage account or calls to your web service will fail.
	StorageAccount *StorageAccount `json:"storageAccount,omitempty"`
	// MachineLearningWorkspace - Specifies the Machine Learning workspace containing the experiment that is source for the web service.
	MachineLearningWorkspace *MachineLearningWorkspace `json:"machineLearningWorkspace,omitempty"`
	// CommitmentPlan - Contains the commitment plan associated with this web service. Set at creation time. Once set, this value cannot be changed. Note: The commitment plan is not returned from calls to GET operations.
	CommitmentPlan *CommitmentPlan `json:"commitmentPlan,omitempty"`
	// Input - Contains the Swagger 2.0 schema describing one or more of the web service's inputs. For more information, see the Swagger specification.
	Input *ServiceInputOutputSpecification `json:"input,omitempty"`
	// Output - Contains the Swagger 2.0 schema describing one or more of the web service's outputs. For more information, see the Swagger specification.
	Output *ServiceInputOutputSpecification `json:"output,omitempty"`
	// ExampleRequest - Defines sample input data for one or more of the service's inputs.
	ExampleRequest *ExampleRequest `json:"exampleRequest,omitempty"`
	// Assets - Contains user defined properties describing web service assets. Properties are expressed as Key/Value pairs.
	Assets map[string]*AssetItem `json:"assets"`
	// Parameters - The set of global parameters values defined for the web service, given as a global parameter name to default value map. If no default value is specified, the parameter is considered to be required.
	Parameters map[string]*string `json:"parameters"`
	// PackageType - Possible values include: 'PackageTypeWebServiceProperties', 'PackageTypeGraph'
	PackageType PackageType `json:"packageType,omitempty"`
}

// MarshalJSON is the custom marshaler for PropertiesForGraph.
func (pfg PropertiesForGraph) MarshalJSON() ([]byte, error) {
	pfg.PackageType = PackageTypeGraph
	objectMap := make(map[string]interface{})
	if pfg.Package != nil {
		objectMap["package"] = pfg.Package
	}
	if pfg.Title != nil {
		objectMap["title"] = pfg.Title
	}
	if pfg.Description != nil {
		objectMap["description"] = pfg.Description
	}
	if pfg.Keys != nil {
		objectMap["keys"] = pfg.Keys
	}
	if pfg.ReadOnly != nil {
		objectMap["readOnly"] = pfg.ReadOnly
	}
	if pfg.ExposeSampleData != nil {
		objectMap["exposeSampleData"] = pfg.ExposeSampleData
	}
	if pfg.RealtimeConfiguration != nil {
		objectMap["realtimeConfiguration"] = pfg.RealtimeConfiguration
	}
	if pfg.Diagnostics != nil {
		objectMap["diagnostics"] = pfg.Diagnostics
	}
	if pfg.StorageAccount != nil {
		objectMap["storageAccount"] = pfg.StorageAccount
	}
	if pfg.MachineLearningWorkspace != nil {
		objectMap["machineLearningWorkspace"] = pfg.MachineLearningWorkspace
	}
	if pfg.CommitmentPlan != nil {
		objectMap["commitmentPlan"] = pfg.CommitmentPlan
	}
	if pfg.Input != nil {
		objectMap["input"] = pfg.Input
	}
	if pfg.Output != nil {
		objectMap["output"] = pfg.Output
	}
	if pfg.ExampleRequest != nil {
		objectMap["exampleRequest"] = pfg.ExampleRequest
	}
	if pfg.Assets != nil {
		objectMap["assets"] = pfg.Assets
	}
	if pfg.Parameters != nil {
		objectMap["parameters"] = pfg.Parameters
	}
	if pfg.PackageType != "" {
		objectMap["packageType"] = pfg.PackageType
	}
	return json.Marshal(objectMap)
}

// AsPropertiesForGraph is the BasicProperties implementation for PropertiesForGraph.
func (pfg PropertiesForGraph) AsPropertiesForGraph() (*PropertiesForGraph, bool) {
	return &pfg, true
}

// AsProperties is the BasicProperties implementation for PropertiesForGraph.
func (pfg PropertiesForGraph) AsProperties() (*Properties, bool) {
	return nil, false
}

// AsBasicProperties is the BasicProperties implementation for PropertiesForGraph.
func (pfg PropertiesForGraph) AsBasicProperties() (BasicProperties, bool) {
	return &pfg, true
}

// RealtimeConfiguration holds the available configuration options for an Azure ML web service endpoint.
type RealtimeConfiguration struct {
	// MaxConcurrentCalls - Specifies the maximum concurrent calls that can be made to the web service. Minimum value: 4, Maximum value: 200.
	MaxConcurrentCalls *int32 `json:"maxConcurrentCalls,omitempty"`
}

// RemoveFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RemoveFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RemoveFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RemoveFuture.Result.
func (future *RemoveFuture) result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "webservices.RemoveFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("webservices.RemoveFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Resource ...
type Resource struct {
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ServiceInputOutputSpecification the swagger 2.0 schema describing the service's inputs or outputs. See
// Swagger specification: http://swagger.io/specification/
type ServiceInputOutputSpecification struct {
	// Title - The title of your Swagger schema.
	Title *string `json:"title,omitempty"`
	// Description - The description of the Swagger schema.
	Description *string `json:"description,omitempty"`
	// Type - The type of the entity described in swagger. Always 'object'.
	Type *string `json:"type,omitempty"`
	// Properties - Specifies a collection that contains the column schema for each input or output of the web service. For more information, see the Swagger specification.
	Properties map[string]*TableSpecification `json:"properties"`
}

// MarshalJSON is the custom marshaler for ServiceInputOutputSpecification.
func (sios ServiceInputOutputSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sios.Title != nil {
		objectMap["title"] = sios.Title
	}
	if sios.Description != nil {
		objectMap["description"] = sios.Description
	}
	if sios.Type != nil {
		objectMap["type"] = sios.Type
	}
	if sios.Properties != nil {
		objectMap["properties"] = sios.Properties
	}
	return json.Marshal(objectMap)
}

// StorageAccount access information for a storage account.
type StorageAccount struct {
	// Name - Specifies the name of the storage account.
	Name *string `json:"name,omitempty"`
	// Key - Specifies the key used to access the storage account.
	Key *string `json:"key,omitempty"`
}

// TableSpecification the swagger 2.0 schema describing a single service input or output. See Swagger
// specification: http://swagger.io/specification/
type TableSpecification struct {
	// Title - Swagger schema title.
	Title *string `json:"title,omitempty"`
	// Description - Swagger schema description.
	Description *string `json:"description,omitempty"`
	// Type - The type of the entity described in swagger.
	Type *string `json:"type,omitempty"`
	// Format - The format, if 'type' is not 'object'
	Format *string `json:"format,omitempty"`
	// Properties - The set of columns within the data table.
	Properties map[string]*ColumnSpecification `json:"properties"`
}

// MarshalJSON is the custom marshaler for TableSpecification.
func (ts TableSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ts.Title != nil {
		objectMap["title"] = ts.Title
	}
	if ts.Description != nil {
		objectMap["description"] = ts.Description
	}
	if ts.Type != nil {
		objectMap["type"] = ts.Type
	}
	if ts.Format != nil {
		objectMap["format"] = ts.Format
	}
	if ts.Properties != nil {
		objectMap["properties"] = ts.Properties
	}
	return json.Marshal(objectMap)
}

// WebService instance of an Azure ML web service resource.
type WebService struct {
	autorest.Response `json:"-"`
	// Properties - Contains the property payload that describes the web service.
	Properties BasicProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for WebService.
func (ws WebService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = ws.Properties
	if ws.Name != nil {
		objectMap["name"] = ws.Name
	}
	if ws.Location != nil {
		objectMap["location"] = ws.Location
	}
	if ws.Tags != nil {
		objectMap["tags"] = ws.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WebService struct.
func (ws *WebService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicProperties(*v)
				if err != nil {
					return err
				}
				ws.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ws.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ws.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ws.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ws.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ws.Tags = tags
			}
		}
	}

	return nil
}
