package guestconfigurationapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/guestconfiguration/mgmt/2020-06-25/guestconfiguration"
	"github.com/Azure/go-autorest/autorest"
)

// AssignmentsClientAPI contains the set of methods on the AssignmentsClient type.
type AssignmentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, guestConfigurationAssignmentName string, parameters guestconfiguration.Assignment, resourceGroupName string, VMName string) (result guestconfiguration.Assignment, err error)
	Delete(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, VMName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, VMName string) (result guestconfiguration.Assignment, err error)
	List(ctx context.Context, resourceGroupName string, VMName string) (result guestconfiguration.AssignmentList, err error)
}

var _ AssignmentsClientAPI = (*guestconfiguration.AssignmentsClient)(nil)

// AssignmentReportsClientAPI contains the set of methods on the AssignmentReportsClient type.
type AssignmentReportsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, reportID string, VMName string) (result guestconfiguration.AssignmentReportType, err error)
	List(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, VMName string) (result guestconfiguration.AssignmentReportList, err error)
}

var _ AssignmentReportsClientAPI = (*guestconfiguration.AssignmentReportsClient)(nil)

// HCRPAssignmentsClientAPI contains the set of methods on the HCRPAssignmentsClient type.
type HCRPAssignmentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, guestConfigurationAssignmentName string, parameters guestconfiguration.Assignment, resourceGroupName string, machineName string) (result guestconfiguration.Assignment, err error)
	Delete(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, machineName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, machineName string) (result guestconfiguration.Assignment, err error)
	List(ctx context.Context, resourceGroupName string, machineName string) (result guestconfiguration.AssignmentList, err error)
}

var _ HCRPAssignmentsClientAPI = (*guestconfiguration.HCRPAssignmentsClient)(nil)

// HCRPAssignmentReportsClientAPI contains the set of methods on the HCRPAssignmentReportsClient type.
type HCRPAssignmentReportsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, reportID string, machineName string) (result guestconfiguration.AssignmentReportType, err error)
	List(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, machineName string) (result guestconfiguration.AssignmentReportList, err error)
}

var _ HCRPAssignmentReportsClientAPI = (*guestconfiguration.HCRPAssignmentReportsClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result guestconfiguration.OperationList, err error)
}

var _ OperationsClientAPI = (*guestconfiguration.OperationsClient)(nil)
