#!/bin/sh

# Test the rq.error() builtin.

set -e
set -u
set -x

EXPECT="hello, test.sh"

set +e
ACTUAL="$("$RQ" 'rq.error("hello, test.sh")')"
EC=$?
set -e

if [ "$ACTUAL" != "$EXPECT" ] ; then
	echo "expected '$EXPECT' but got '$ACTUAL'" 1>&2
	exit 1
fi

if [ $EC -ne 1 ] ; then
	echo "expected exit code to be 1, not $EC" 1>&2
	exit 1
fi
