// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/documentai/v1beta3/document_processor_service.proto

package documentaipb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The final state of human review on a processed document.
type HumanReviewStatus_State int32

const (
	// Human review state is unspecified. Most likely due to an internal error.
	HumanReviewStatus_STATE_UNSPECIFIED HumanReviewStatus_State = 0
	// Human review is skipped for the document. This can happen because human
	// review is not enabled on the processor or the processing request has
	// been set to skip this document.
	HumanReviewStatus_SKIPPED HumanReviewStatus_State = 1
	// Human review validation is triggered and passed, so no review is needed.
	HumanReviewStatus_VALIDATION_PASSED HumanReviewStatus_State = 2
	// Human review validation is triggered and the document is under review.
	HumanReviewStatus_IN_PROGRESS HumanReviewStatus_State = 3
	// Some error happened during triggering human review, see the
	// [state_message] for details.
	HumanReviewStatus_ERROR HumanReviewStatus_State = 4
)

// Enum value maps for HumanReviewStatus_State.
var (
	HumanReviewStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SKIPPED",
		2: "VALIDATION_PASSED",
		3: "IN_PROGRESS",
		4: "ERROR",
	}
	HumanReviewStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SKIPPED":           1,
		"VALIDATION_PASSED": 2,
		"IN_PROGRESS":       3,
		"ERROR":             4,
	}
)

func (x HumanReviewStatus_State) Enum() *HumanReviewStatus_State {
	p := new(HumanReviewStatus_State)
	*p = x
	return p
}

func (x HumanReviewStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HumanReviewStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_enumTypes[0].Descriptor()
}

func (HumanReviewStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1beta3_document_processor_service_proto_enumTypes[0]
}

func (x HumanReviewStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HumanReviewStatus_State.Descriptor instead.
func (HumanReviewStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{1, 0}
}

// Possible states of the batch processing operation.
type BatchProcessMetadata_State int32

const (
	// The default value. This value is used if the state is omitted.
	BatchProcessMetadata_STATE_UNSPECIFIED BatchProcessMetadata_State = 0
	// Request operation is waiting for scheduling.
	BatchProcessMetadata_WAITING BatchProcessMetadata_State = 1
	// Request is being processed.
	BatchProcessMetadata_RUNNING BatchProcessMetadata_State = 2
	// The batch processing completed successfully.
	BatchProcessMetadata_SUCCEEDED BatchProcessMetadata_State = 3
	// The batch processing was being cancelled.
	BatchProcessMetadata_CANCELLING BatchProcessMetadata_State = 4
	// The batch processing was cancelled.
	BatchProcessMetadata_CANCELLED BatchProcessMetadata_State = 5
	// The batch processing has failed.
	BatchProcessMetadata_FAILED BatchProcessMetadata_State = 6
)

// Enum value maps for BatchProcessMetadata_State.
var (
	BatchProcessMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "WAITING",
		2: "RUNNING",
		3: "SUCCEEDED",
		4: "CANCELLING",
		5: "CANCELLED",
		6: "FAILED",
	}
	BatchProcessMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"WAITING":           1,
		"RUNNING":           2,
		"SUCCEEDED":         3,
		"CANCELLING":        4,
		"CANCELLED":         5,
		"FAILED":            6,
	}
)

func (x BatchProcessMetadata_State) Enum() *BatchProcessMetadata_State {
	p := new(BatchProcessMetadata_State)
	*p = x
	return p
}

func (x BatchProcessMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BatchProcessMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_enumTypes[1].Descriptor()
}

func (BatchProcessMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1beta3_document_processor_service_proto_enumTypes[1]
}

func (x BatchProcessMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BatchProcessMetadata_State.Descriptor instead.
func (BatchProcessMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{5, 0}
}

// The priority level of the human review task.
type ReviewDocumentRequest_Priority int32

const (
	// The default priority level.
	ReviewDocumentRequest_DEFAULT ReviewDocumentRequest_Priority = 0
	// The urgent priority level. The labeling manager should allocate labeler
	// resource to the urgent task queue to respect this priority level.
	ReviewDocumentRequest_URGENT ReviewDocumentRequest_Priority = 1
)

// Enum value maps for ReviewDocumentRequest_Priority.
var (
	ReviewDocumentRequest_Priority_name = map[int32]string{
		0: "DEFAULT",
		1: "URGENT",
	}
	ReviewDocumentRequest_Priority_value = map[string]int32{
		"DEFAULT": 0,
		"URGENT":  1,
	}
)

func (x ReviewDocumentRequest_Priority) Enum() *ReviewDocumentRequest_Priority {
	p := new(ReviewDocumentRequest_Priority)
	*p = x
	return p
}

func (x ReviewDocumentRequest_Priority) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReviewDocumentRequest_Priority) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_enumTypes[2].Descriptor()
}

func (ReviewDocumentRequest_Priority) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1beta3_document_processor_service_proto_enumTypes[2]
}

func (x ReviewDocumentRequest_Priority) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReviewDocumentRequest_Priority.Descriptor instead.
func (ReviewDocumentRequest_Priority) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{36, 0}
}

// Possible states of the review operation.
type ReviewDocumentResponse_State int32

const (
	// The default value. This value is used if the state is omitted.
	ReviewDocumentResponse_STATE_UNSPECIFIED ReviewDocumentResponse_State = 0
	// The review operation is rejected by the reviewer.
	ReviewDocumentResponse_REJECTED ReviewDocumentResponse_State = 1
	// The review operation is succeeded.
	ReviewDocumentResponse_SUCCEEDED ReviewDocumentResponse_State = 2
)

// Enum value maps for ReviewDocumentResponse_State.
var (
	ReviewDocumentResponse_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "REJECTED",
		2: "SUCCEEDED",
	}
	ReviewDocumentResponse_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"REJECTED":          1,
		"SUCCEEDED":         2,
	}
)

func (x ReviewDocumentResponse_State) Enum() *ReviewDocumentResponse_State {
	p := new(ReviewDocumentResponse_State)
	*p = x
	return p
}

func (x ReviewDocumentResponse_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReviewDocumentResponse_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_enumTypes[3].Descriptor()
}

func (ReviewDocumentResponse_State) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1beta3_document_processor_service_proto_enumTypes[3]
}

func (x ReviewDocumentResponse_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReviewDocumentResponse_State.Descriptor instead.
func (ReviewDocumentResponse_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{37, 0}
}

// State of the longrunning operation.
type ReviewDocumentOperationMetadata_State int32

const (
	// Unspecified state.
	ReviewDocumentOperationMetadata_STATE_UNSPECIFIED ReviewDocumentOperationMetadata_State = 0
	// Operation is still running.
	ReviewDocumentOperationMetadata_RUNNING ReviewDocumentOperationMetadata_State = 1
	// Operation is being cancelled.
	ReviewDocumentOperationMetadata_CANCELLING ReviewDocumentOperationMetadata_State = 2
	// Operation succeeded.
	ReviewDocumentOperationMetadata_SUCCEEDED ReviewDocumentOperationMetadata_State = 3
	// Operation failed.
	ReviewDocumentOperationMetadata_FAILED ReviewDocumentOperationMetadata_State = 4
	// Operation is cancelled.
	ReviewDocumentOperationMetadata_CANCELLED ReviewDocumentOperationMetadata_State = 5
)

// Enum value maps for ReviewDocumentOperationMetadata_State.
var (
	ReviewDocumentOperationMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "CANCELLING",
		3: "SUCCEEDED",
		4: "FAILED",
		5: "CANCELLED",
	}
	ReviewDocumentOperationMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"CANCELLING":        2,
		"SUCCEEDED":         3,
		"FAILED":            4,
		"CANCELLED":         5,
	}
)

func (x ReviewDocumentOperationMetadata_State) Enum() *ReviewDocumentOperationMetadata_State {
	p := new(ReviewDocumentOperationMetadata_State)
	*p = x
	return p
}

func (x ReviewDocumentOperationMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReviewDocumentOperationMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_enumTypes[4].Descriptor()
}

func (ReviewDocumentOperationMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1beta3_document_processor_service_proto_enumTypes[4]
}

func (x ReviewDocumentOperationMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReviewDocumentOperationMetadata_State.Descriptor instead.
func (ReviewDocumentOperationMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{38, 0}
}

// Request message for the process document method.
type ProcessRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The document payload.
	//
	// Types that are assignable to Source:
	//
	//	*ProcessRequest_InlineDocument
	//	*ProcessRequest_RawDocument
	Source isProcessRequest_Source `protobuf_oneof:"source"`
	// Required. The resource name of the [Processor][google.cloud.documentai.v1beta3.Processor] or
	// [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
	// to use for processing. If a [Processor][google.cloud.documentai.v1beta3.Processor] is specified, the server will use
	// its [default version][google.cloud.documentai.v1beta3.Processor.default_processor_version]. Format:
	// `projects/{project}/locations/{location}/processors/{processor}`, or
	// `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The document payload, the [content] and [mime_type] fields must be set.
	//
	// Deprecated: Do not use.
	Document *Document `protobuf:"bytes,2,opt,name=document,proto3" json:"document,omitempty"`
	// Whether Human Review feature should be skipped for this request. Default to
	// false.
	SkipHumanReview bool `protobuf:"varint,3,opt,name=skip_human_review,json=skipHumanReview,proto3" json:"skip_human_review,omitempty"`
	// Specifies which fields to include in ProcessResponse's document.
	FieldMask *field_mask.FieldMask `protobuf:"bytes,6,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *ProcessRequest) Reset() {
	*x = ProcessRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessRequest) ProtoMessage() {}

func (x *ProcessRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessRequest.ProtoReflect.Descriptor instead.
func (*ProcessRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{0}
}

func (m *ProcessRequest) GetSource() isProcessRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ProcessRequest) GetInlineDocument() *Document {
	if x, ok := x.GetSource().(*ProcessRequest_InlineDocument); ok {
		return x.InlineDocument
	}
	return nil
}

func (x *ProcessRequest) GetRawDocument() *RawDocument {
	if x, ok := x.GetSource().(*ProcessRequest_RawDocument); ok {
		return x.RawDocument
	}
	return nil
}

func (x *ProcessRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Deprecated: Do not use.
func (x *ProcessRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *ProcessRequest) GetSkipHumanReview() bool {
	if x != nil {
		return x.SkipHumanReview
	}
	return false
}

func (x *ProcessRequest) GetFieldMask() *field_mask.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

type isProcessRequest_Source interface {
	isProcessRequest_Source()
}

type ProcessRequest_InlineDocument struct {
	// An inline document proto.
	InlineDocument *Document `protobuf:"bytes,4,opt,name=inline_document,json=inlineDocument,proto3,oneof"`
}

type ProcessRequest_RawDocument struct {
	// A raw document content (bytes).
	RawDocument *RawDocument `protobuf:"bytes,5,opt,name=raw_document,json=rawDocument,proto3,oneof"`
}

func (*ProcessRequest_InlineDocument) isProcessRequest_Source() {}

func (*ProcessRequest_RawDocument) isProcessRequest_Source() {}

// The status of human review on a processed document.
type HumanReviewStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of human review on the processing request.
	State HumanReviewStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.documentai.v1beta3.HumanReviewStatus_State" json:"state,omitempty"`
	// A message providing more details about the human review state.
	StateMessage string `protobuf:"bytes,2,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
	// The name of the operation triggered by the processed document. This field
	// is populated only when the [state] is [HUMAN_REVIEW_IN_PROGRESS]. It has
	// the same response type and metadata as the long running operation returned
	// by [ReviewDocument] method.
	HumanReviewOperation string `protobuf:"bytes,3,opt,name=human_review_operation,json=humanReviewOperation,proto3" json:"human_review_operation,omitempty"`
}

func (x *HumanReviewStatus) Reset() {
	*x = HumanReviewStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanReviewStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanReviewStatus) ProtoMessage() {}

func (x *HumanReviewStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanReviewStatus.ProtoReflect.Descriptor instead.
func (*HumanReviewStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{1}
}

func (x *HumanReviewStatus) GetState() HumanReviewStatus_State {
	if x != nil {
		return x.State
	}
	return HumanReviewStatus_STATE_UNSPECIFIED
}

func (x *HumanReviewStatus) GetStateMessage() string {
	if x != nil {
		return x.StateMessage
	}
	return ""
}

func (x *HumanReviewStatus) GetHumanReviewOperation() string {
	if x != nil {
		return x.HumanReviewOperation
	}
	return ""
}

// Response message for the process document method.
type ProcessResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The document payload, will populate fields based on the processor's
	// behavior.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// The name of the operation triggered by the processed document. If the human
	// review process is not triggered, this field will be empty. It has the same
	// response type and metadata as the long running operation returned by
	// ReviewDocument method.
	//
	// Deprecated: Do not use.
	HumanReviewOperation string `protobuf:"bytes,2,opt,name=human_review_operation,json=humanReviewOperation,proto3" json:"human_review_operation,omitempty"`
	// The status of human review on the processed document.
	HumanReviewStatus *HumanReviewStatus `protobuf:"bytes,3,opt,name=human_review_status,json=humanReviewStatus,proto3" json:"human_review_status,omitempty"`
}

func (x *ProcessResponse) Reset() {
	*x = ProcessResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessResponse) ProtoMessage() {}

func (x *ProcessResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessResponse.ProtoReflect.Descriptor instead.
func (*ProcessResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{2}
}

func (x *ProcessResponse) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

// Deprecated: Do not use.
func (x *ProcessResponse) GetHumanReviewOperation() string {
	if x != nil {
		return x.HumanReviewOperation
	}
	return ""
}

func (x *ProcessResponse) GetHumanReviewStatus() *HumanReviewStatus {
	if x != nil {
		return x.HumanReviewStatus
	}
	return nil
}

// Request message for batch process document method.
type BatchProcessRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of [Processor][google.cloud.documentai.v1beta3.Processor] or
	// [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion].
	// Format: `projects/{project}/locations/{location}/processors/{processor}`,
	// or
	// `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The input config for each single document in the batch process.
	//
	// Deprecated: Do not use.
	InputConfigs []*BatchProcessRequest_BatchInputConfig `protobuf:"bytes,2,rep,name=input_configs,json=inputConfigs,proto3" json:"input_configs,omitempty"`
	// The overall output config for batch process.
	//
	// Deprecated: Do not use.
	OutputConfig *BatchProcessRequest_BatchOutputConfig `protobuf:"bytes,3,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// The input documents for batch process.
	InputDocuments *BatchDocumentsInputConfig `protobuf:"bytes,5,opt,name=input_documents,json=inputDocuments,proto3" json:"input_documents,omitempty"`
	// The overall output config for batch process.
	DocumentOutputConfig *DocumentOutputConfig `protobuf:"bytes,6,opt,name=document_output_config,json=documentOutputConfig,proto3" json:"document_output_config,omitempty"`
	// Whether Human Review feature should be skipped for this request. Default to
	// false.
	SkipHumanReview bool `protobuf:"varint,4,opt,name=skip_human_review,json=skipHumanReview,proto3" json:"skip_human_review,omitempty"`
}

func (x *BatchProcessRequest) Reset() {
	*x = BatchProcessRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchProcessRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchProcessRequest) ProtoMessage() {}

func (x *BatchProcessRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchProcessRequest.ProtoReflect.Descriptor instead.
func (*BatchProcessRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{3}
}

func (x *BatchProcessRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Deprecated: Do not use.
func (x *BatchProcessRequest) GetInputConfigs() []*BatchProcessRequest_BatchInputConfig {
	if x != nil {
		return x.InputConfigs
	}
	return nil
}

// Deprecated: Do not use.
func (x *BatchProcessRequest) GetOutputConfig() *BatchProcessRequest_BatchOutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *BatchProcessRequest) GetInputDocuments() *BatchDocumentsInputConfig {
	if x != nil {
		return x.InputDocuments
	}
	return nil
}

func (x *BatchProcessRequest) GetDocumentOutputConfig() *DocumentOutputConfig {
	if x != nil {
		return x.DocumentOutputConfig
	}
	return nil
}

func (x *BatchProcessRequest) GetSkipHumanReview() bool {
	if x != nil {
		return x.SkipHumanReview
	}
	return false
}

// Response message for batch process document method.
type BatchProcessResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BatchProcessResponse) Reset() {
	*x = BatchProcessResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchProcessResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchProcessResponse) ProtoMessage() {}

func (x *BatchProcessResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchProcessResponse.ProtoReflect.Descriptor instead.
func (*BatchProcessResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{4}
}

// The long running operation metadata for batch process method.
type BatchProcessMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of the current batch processing.
	State BatchProcessMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.documentai.v1beta3.BatchProcessMetadata_State" json:"state,omitempty"`
	// A message providing more details about the current state of processing.
	// For example, the error message if the operation is failed.
	StateMessage string `protobuf:"bytes,2,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
	// The creation time of the operation.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The last update time of the operation.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The list of response details of each document.
	IndividualProcessStatuses []*BatchProcessMetadata_IndividualProcessStatus `protobuf:"bytes,5,rep,name=individual_process_statuses,json=individualProcessStatuses,proto3" json:"individual_process_statuses,omitempty"`
}

func (x *BatchProcessMetadata) Reset() {
	*x = BatchProcessMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchProcessMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchProcessMetadata) ProtoMessage() {}

func (x *BatchProcessMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchProcessMetadata.ProtoReflect.Descriptor instead.
func (*BatchProcessMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{5}
}

func (x *BatchProcessMetadata) GetState() BatchProcessMetadata_State {
	if x != nil {
		return x.State
	}
	return BatchProcessMetadata_STATE_UNSPECIFIED
}

func (x *BatchProcessMetadata) GetStateMessage() string {
	if x != nil {
		return x.StateMessage
	}
	return ""
}

func (x *BatchProcessMetadata) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BatchProcessMetadata) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *BatchProcessMetadata) GetIndividualProcessStatuses() []*BatchProcessMetadata_IndividualProcessStatus {
	if x != nil {
		return x.IndividualProcessStatuses
	}
	return nil
}

// Request message for fetch processor types.
type FetchProcessorTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project of processor type to list.
	// The available processor types may depend on the allow-listing on projects.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *FetchProcessorTypesRequest) Reset() {
	*x = FetchProcessorTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchProcessorTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchProcessorTypesRequest) ProtoMessage() {}

func (x *FetchProcessorTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchProcessorTypesRequest.ProtoReflect.Descriptor instead.
func (*FetchProcessorTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{6}
}

func (x *FetchProcessorTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Response message for fetch processor types.
type FetchProcessorTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of processor types.
	ProcessorTypes []*ProcessorType `protobuf:"bytes,1,rep,name=processor_types,json=processorTypes,proto3" json:"processor_types,omitempty"`
}

func (x *FetchProcessorTypesResponse) Reset() {
	*x = FetchProcessorTypesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchProcessorTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchProcessorTypesResponse) ProtoMessage() {}

func (x *FetchProcessorTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchProcessorTypesResponse.ProtoReflect.Descriptor instead.
func (*FetchProcessorTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{7}
}

func (x *FetchProcessorTypesResponse) GetProcessorTypes() []*ProcessorType {
	if x != nil {
		return x.ProcessorTypes
	}
	return nil
}

// Request message for list processor types.
type ListProcessorTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location of processor type to list.
	// The available processor types may depend on the allow-listing on projects.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of processor types to return.
	// If unspecified, at most 100 processor types will be returned.
	// The maximum value is 500; values above 500 will be coerced to 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Used to retrieve the next page of results, empty if at the end of the list.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListProcessorTypesRequest) Reset() {
	*x = ListProcessorTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProcessorTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProcessorTypesRequest) ProtoMessage() {}

func (x *ListProcessorTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProcessorTypesRequest.ProtoReflect.Descriptor instead.
func (*ListProcessorTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{8}
}

func (x *ListProcessorTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListProcessorTypesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProcessorTypesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for list processor types.
type ListProcessorTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The processor types.
	ProcessorTypes []*ProcessorType `protobuf:"bytes,1,rep,name=processor_types,json=processorTypes,proto3" json:"processor_types,omitempty"`
	// Points to the next page, otherwise empty.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListProcessorTypesResponse) Reset() {
	*x = ListProcessorTypesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProcessorTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProcessorTypesResponse) ProtoMessage() {}

func (x *ListProcessorTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProcessorTypesResponse.ProtoReflect.Descriptor instead.
func (*ListProcessorTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListProcessorTypesResponse) GetProcessorTypes() []*ProcessorType {
	if x != nil {
		return x.ProcessorTypes
	}
	return nil
}

func (x *ListProcessorTypesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for list all processors belongs to a project.
type ListProcessorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent (project and location) which owns this collection of Processors.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of processors to return.
	// If unspecified, at most 50 processors will be returned.
	// The maximum value is 100; values above 100 will be coerced to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// We will return the processors sorted by creation time. The page token
	// will point to the next processor.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListProcessorsRequest) Reset() {
	*x = ListProcessorsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProcessorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProcessorsRequest) ProtoMessage() {}

func (x *ListProcessorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProcessorsRequest.ProtoReflect.Descriptor instead.
func (*ListProcessorsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListProcessorsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListProcessorsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProcessorsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for list processors.
type ListProcessorsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of processors.
	Processors []*Processor `protobuf:"bytes,1,rep,name=processors,proto3" json:"processors,omitempty"`
	// Points to the next processor, otherwise empty.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListProcessorsResponse) Reset() {
	*x = ListProcessorsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProcessorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProcessorsResponse) ProtoMessage() {}

func (x *ListProcessorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProcessorsResponse.ProtoReflect.Descriptor instead.
func (*ListProcessorsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{11}
}

func (x *ListProcessorsResponse) GetProcessors() []*Processor {
	if x != nil {
		return x.Processors
	}
	return nil
}

func (x *ListProcessorsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for get processor.
type GetProcessorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The processor resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetProcessorRequest) Reset() {
	*x = GetProcessorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProcessorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProcessorRequest) ProtoMessage() {}

func (x *GetProcessorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProcessorRequest.ProtoReflect.Descriptor instead.
func (*GetProcessorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{12}
}

func (x *GetProcessorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for get processor version.
type GetProcessorVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The processor resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetProcessorVersionRequest) Reset() {
	*x = GetProcessorVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProcessorVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProcessorVersionRequest) ProtoMessage() {}

func (x *GetProcessorVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProcessorVersionRequest.ProtoReflect.Descriptor instead.
func (*GetProcessorVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{13}
}

func (x *GetProcessorVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for list all processor versions belongs to a processor.
type ListProcessorVersionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent (project, location and processor) to list all versions.
	// Format: `projects/{project}/locations/{location}/processors/{processor}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of processor versions to return.
	// If unspecified, at most 10 processor versions will be returned.
	// The maximum value is 20; values above 20 will be coerced to 20.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// We will return the processor versions sorted by creation time. The page
	// token will point to the next processor version.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListProcessorVersionsRequest) Reset() {
	*x = ListProcessorVersionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProcessorVersionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProcessorVersionsRequest) ProtoMessage() {}

func (x *ListProcessorVersionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProcessorVersionsRequest.ProtoReflect.Descriptor instead.
func (*ListProcessorVersionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{14}
}

func (x *ListProcessorVersionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListProcessorVersionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProcessorVersionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for list processors.
type ListProcessorVersionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of processors.
	ProcessorVersions []*ProcessorVersion `protobuf:"bytes,1,rep,name=processor_versions,json=processorVersions,proto3" json:"processor_versions,omitempty"`
	// Points to the next processor, otherwise empty.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListProcessorVersionsResponse) Reset() {
	*x = ListProcessorVersionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProcessorVersionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProcessorVersionsResponse) ProtoMessage() {}

func (x *ListProcessorVersionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProcessorVersionsResponse.ProtoReflect.Descriptor instead.
func (*ListProcessorVersionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{15}
}

func (x *ListProcessorVersionsResponse) GetProcessorVersions() []*ProcessorVersion {
	if x != nil {
		return x.ProcessorVersions
	}
	return nil
}

func (x *ListProcessorVersionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for the delete processor version method.
type DeleteProcessorVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The processor version resource name to be deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteProcessorVersionRequest) Reset() {
	*x = DeleteProcessorVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteProcessorVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteProcessorVersionRequest) ProtoMessage() {}

func (x *DeleteProcessorVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteProcessorVersionRequest.ProtoReflect.Descriptor instead.
func (*DeleteProcessorVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{16}
}

func (x *DeleteProcessorVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The long running operation metadata for delete processor version method.
type DeleteProcessorVersionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
}

func (x *DeleteProcessorVersionMetadata) Reset() {
	*x = DeleteProcessorVersionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteProcessorVersionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteProcessorVersionMetadata) ProtoMessage() {}

func (x *DeleteProcessorVersionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteProcessorVersionMetadata.ProtoReflect.Descriptor instead.
func (*DeleteProcessorVersionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{17}
}

func (x *DeleteProcessorVersionMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

// Request message for the deploy processor version method.
type DeployProcessorVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The processor version resource name to be deployed.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeployProcessorVersionRequest) Reset() {
	*x = DeployProcessorVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployProcessorVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployProcessorVersionRequest) ProtoMessage() {}

func (x *DeployProcessorVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployProcessorVersionRequest.ProtoReflect.Descriptor instead.
func (*DeployProcessorVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{18}
}

func (x *DeployProcessorVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for the deploy processor version method.
type DeployProcessorVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeployProcessorVersionResponse) Reset() {
	*x = DeployProcessorVersionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployProcessorVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployProcessorVersionResponse) ProtoMessage() {}

func (x *DeployProcessorVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployProcessorVersionResponse.ProtoReflect.Descriptor instead.
func (*DeployProcessorVersionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{19}
}

// The long running operation metadata for deploy processor version method.
type DeployProcessorVersionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
}

func (x *DeployProcessorVersionMetadata) Reset() {
	*x = DeployProcessorVersionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployProcessorVersionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployProcessorVersionMetadata) ProtoMessage() {}

func (x *DeployProcessorVersionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployProcessorVersionMetadata.ProtoReflect.Descriptor instead.
func (*DeployProcessorVersionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{20}
}

func (x *DeployProcessorVersionMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

// Request message for the undeploy processor version method.
type UndeployProcessorVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The processor version resource name to be undeployed.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UndeployProcessorVersionRequest) Reset() {
	*x = UndeployProcessorVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployProcessorVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployProcessorVersionRequest) ProtoMessage() {}

func (x *UndeployProcessorVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployProcessorVersionRequest.ProtoReflect.Descriptor instead.
func (*UndeployProcessorVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{21}
}

func (x *UndeployProcessorVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for the undeploy processor version method.
type UndeployProcessorVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UndeployProcessorVersionResponse) Reset() {
	*x = UndeployProcessorVersionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployProcessorVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployProcessorVersionResponse) ProtoMessage() {}

func (x *UndeployProcessorVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployProcessorVersionResponse.ProtoReflect.Descriptor instead.
func (*UndeployProcessorVersionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{22}
}

// The long running operation metadata for the undeploy processor version
// method.
type UndeployProcessorVersionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
}

func (x *UndeployProcessorVersionMetadata) Reset() {
	*x = UndeployProcessorVersionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployProcessorVersionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployProcessorVersionMetadata) ProtoMessage() {}

func (x *UndeployProcessorVersionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployProcessorVersionMetadata.ProtoReflect.Descriptor instead.
func (*UndeployProcessorVersionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{23}
}

func (x *UndeployProcessorVersionMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

// Request message for create a processor. Notice this request is sent to
// a regionalized backend service, and if the processor type is not available
// on that region, the creation will fail.
type CreateProcessorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent (project and location) under which to create the processor.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The processor to be created, requires [processor_type] and [display_name]
	// to be set. Also, the processor is under CMEK if CMEK fields are set.
	Processor *Processor `protobuf:"bytes,2,opt,name=processor,proto3" json:"processor,omitempty"`
}

func (x *CreateProcessorRequest) Reset() {
	*x = CreateProcessorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateProcessorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateProcessorRequest) ProtoMessage() {}

func (x *CreateProcessorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateProcessorRequest.ProtoReflect.Descriptor instead.
func (*CreateProcessorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{24}
}

func (x *CreateProcessorRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateProcessorRequest) GetProcessor() *Processor {
	if x != nil {
		return x.Processor
	}
	return nil
}

// Request message for the delete processor method.
type DeleteProcessorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The processor resource name to be deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteProcessorRequest) Reset() {
	*x = DeleteProcessorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteProcessorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteProcessorRequest) ProtoMessage() {}

func (x *DeleteProcessorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteProcessorRequest.ProtoReflect.Descriptor instead.
func (*DeleteProcessorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{25}
}

func (x *DeleteProcessorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The long running operation metadata for delete processor method.
type DeleteProcessorMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,5,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
}

func (x *DeleteProcessorMetadata) Reset() {
	*x = DeleteProcessorMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteProcessorMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteProcessorMetadata) ProtoMessage() {}

func (x *DeleteProcessorMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteProcessorMetadata.ProtoReflect.Descriptor instead.
func (*DeleteProcessorMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{26}
}

func (x *DeleteProcessorMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

// Request message for the enable processor method.
type EnableProcessorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The processor resource name to be enabled.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *EnableProcessorRequest) Reset() {
	*x = EnableProcessorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnableProcessorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableProcessorRequest) ProtoMessage() {}

func (x *EnableProcessorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableProcessorRequest.ProtoReflect.Descriptor instead.
func (*EnableProcessorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{27}
}

func (x *EnableProcessorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for the enable processor method.
// Intentionally empty proto for adding fields in future.
type EnableProcessorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *EnableProcessorResponse) Reset() {
	*x = EnableProcessorResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnableProcessorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableProcessorResponse) ProtoMessage() {}

func (x *EnableProcessorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableProcessorResponse.ProtoReflect.Descriptor instead.
func (*EnableProcessorResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{28}
}

// The long running operation metadata for enable processor method.
type EnableProcessorMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,5,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
}

func (x *EnableProcessorMetadata) Reset() {
	*x = EnableProcessorMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnableProcessorMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableProcessorMetadata) ProtoMessage() {}

func (x *EnableProcessorMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableProcessorMetadata.ProtoReflect.Descriptor instead.
func (*EnableProcessorMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{29}
}

func (x *EnableProcessorMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

// Request message for the disable processor method.
type DisableProcessorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The processor resource name to be disabled.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DisableProcessorRequest) Reset() {
	*x = DisableProcessorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisableProcessorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableProcessorRequest) ProtoMessage() {}

func (x *DisableProcessorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableProcessorRequest.ProtoReflect.Descriptor instead.
func (*DisableProcessorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{30}
}

func (x *DisableProcessorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for the disable processor method.
// Intentionally empty proto for adding fields in future.
type DisableProcessorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DisableProcessorResponse) Reset() {
	*x = DisableProcessorResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisableProcessorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableProcessorResponse) ProtoMessage() {}

func (x *DisableProcessorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableProcessorResponse.ProtoReflect.Descriptor instead.
func (*DisableProcessorResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{31}
}

// The long running operation metadata for disable processor method.
type DisableProcessorMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,5,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
}

func (x *DisableProcessorMetadata) Reset() {
	*x = DisableProcessorMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisableProcessorMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableProcessorMetadata) ProtoMessage() {}

func (x *DisableProcessorMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableProcessorMetadata.ProtoReflect.Descriptor instead.
func (*DisableProcessorMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{32}
}

func (x *DisableProcessorMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

// Request message for the set default processor version method.
type SetDefaultProcessorVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the [Processor][google.cloud.documentai.v1beta3.Processor] to change default version.
	Processor string `protobuf:"bytes,1,opt,name=processor,proto3" json:"processor,omitempty"`
	// Required. The resource name of child [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion] to use as default.
	// Format:
	// `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{version}`
	DefaultProcessorVersion string `protobuf:"bytes,2,opt,name=default_processor_version,json=defaultProcessorVersion,proto3" json:"default_processor_version,omitempty"`
}

func (x *SetDefaultProcessorVersionRequest) Reset() {
	*x = SetDefaultProcessorVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetDefaultProcessorVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetDefaultProcessorVersionRequest) ProtoMessage() {}

func (x *SetDefaultProcessorVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetDefaultProcessorVersionRequest.ProtoReflect.Descriptor instead.
func (*SetDefaultProcessorVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{33}
}

func (x *SetDefaultProcessorVersionRequest) GetProcessor() string {
	if x != nil {
		return x.Processor
	}
	return ""
}

func (x *SetDefaultProcessorVersionRequest) GetDefaultProcessorVersion() string {
	if x != nil {
		return x.DefaultProcessorVersion
	}
	return ""
}

// Response message for set default processor version method.
type SetDefaultProcessorVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SetDefaultProcessorVersionResponse) Reset() {
	*x = SetDefaultProcessorVersionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetDefaultProcessorVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetDefaultProcessorVersionResponse) ProtoMessage() {}

func (x *SetDefaultProcessorVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetDefaultProcessorVersionResponse.ProtoReflect.Descriptor instead.
func (*SetDefaultProcessorVersionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{34}
}

// The long running operation metadata for set default processor version
// method.
type SetDefaultProcessorVersionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
}

func (x *SetDefaultProcessorVersionMetadata) Reset() {
	*x = SetDefaultProcessorVersionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetDefaultProcessorVersionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetDefaultProcessorVersionMetadata) ProtoMessage() {}

func (x *SetDefaultProcessorVersionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetDefaultProcessorVersionMetadata.ProtoReflect.Descriptor instead.
func (*SetDefaultProcessorVersionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{35}
}

func (x *SetDefaultProcessorVersionMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

// Request message for review document method.
type ReviewDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The document payload.
	//
	// Types that are assignable to Source:
	//
	//	*ReviewDocumentRequest_InlineDocument
	Source isReviewDocumentRequest_Source `protobuf_oneof:"source"`
	// Required. The resource name of the HumanReviewConfig that the document will be
	// reviewed with.
	HumanReviewConfig string `protobuf:"bytes,1,opt,name=human_review_config,json=humanReviewConfig,proto3" json:"human_review_config,omitempty"`
	// The document that needs human review.
	//
	// Deprecated: Do not use.
	Document *Document `protobuf:"bytes,2,opt,name=document,proto3" json:"document,omitempty"`
	// Whether the validation should be performed on the ad-hoc review request.
	EnableSchemaValidation bool `protobuf:"varint,3,opt,name=enable_schema_validation,json=enableSchemaValidation,proto3" json:"enable_schema_validation,omitempty"`
	// The priority of the human review task.
	Priority ReviewDocumentRequest_Priority `protobuf:"varint,5,opt,name=priority,proto3,enum=google.cloud.documentai.v1beta3.ReviewDocumentRequest_Priority" json:"priority,omitempty"`
	// The document schema of the human review task.
	DocumentSchema *DocumentSchema `protobuf:"bytes,6,opt,name=document_schema,json=documentSchema,proto3" json:"document_schema,omitempty"`
}

func (x *ReviewDocumentRequest) Reset() {
	*x = ReviewDocumentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReviewDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReviewDocumentRequest) ProtoMessage() {}

func (x *ReviewDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReviewDocumentRequest.ProtoReflect.Descriptor instead.
func (*ReviewDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{36}
}

func (m *ReviewDocumentRequest) GetSource() isReviewDocumentRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ReviewDocumentRequest) GetInlineDocument() *Document {
	if x, ok := x.GetSource().(*ReviewDocumentRequest_InlineDocument); ok {
		return x.InlineDocument
	}
	return nil
}

func (x *ReviewDocumentRequest) GetHumanReviewConfig() string {
	if x != nil {
		return x.HumanReviewConfig
	}
	return ""
}

// Deprecated: Do not use.
func (x *ReviewDocumentRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *ReviewDocumentRequest) GetEnableSchemaValidation() bool {
	if x != nil {
		return x.EnableSchemaValidation
	}
	return false
}

func (x *ReviewDocumentRequest) GetPriority() ReviewDocumentRequest_Priority {
	if x != nil {
		return x.Priority
	}
	return ReviewDocumentRequest_DEFAULT
}

func (x *ReviewDocumentRequest) GetDocumentSchema() *DocumentSchema {
	if x != nil {
		return x.DocumentSchema
	}
	return nil
}

type isReviewDocumentRequest_Source interface {
	isReviewDocumentRequest_Source()
}

type ReviewDocumentRequest_InlineDocument struct {
	// An inline document proto.
	InlineDocument *Document `protobuf:"bytes,4,opt,name=inline_document,json=inlineDocument,proto3,oneof"`
}

func (*ReviewDocumentRequest_InlineDocument) isReviewDocumentRequest_Source() {}

// Response message for review document method.
type ReviewDocumentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud Storage uri for the human reviewed document if the review is
	// succeeded.
	GcsDestination string `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3" json:"gcs_destination,omitempty"`
	// The state of the review operation.
	State ReviewDocumentResponse_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.documentai.v1beta3.ReviewDocumentResponse_State" json:"state,omitempty"`
	// The reason why the review is rejected by reviewer.
	RejectionReason string `protobuf:"bytes,3,opt,name=rejection_reason,json=rejectionReason,proto3" json:"rejection_reason,omitempty"`
}

func (x *ReviewDocumentResponse) Reset() {
	*x = ReviewDocumentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReviewDocumentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReviewDocumentResponse) ProtoMessage() {}

func (x *ReviewDocumentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReviewDocumentResponse.ProtoReflect.Descriptor instead.
func (*ReviewDocumentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{37}
}

func (x *ReviewDocumentResponse) GetGcsDestination() string {
	if x != nil {
		return x.GcsDestination
	}
	return ""
}

func (x *ReviewDocumentResponse) GetState() ReviewDocumentResponse_State {
	if x != nil {
		return x.State
	}
	return ReviewDocumentResponse_STATE_UNSPECIFIED
}

func (x *ReviewDocumentResponse) GetRejectionReason() string {
	if x != nil {
		return x.RejectionReason
	}
	return ""
}

// The long running operation metadata for review document method.
type ReviewDocumentOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Used only when Operation.done is false.
	State ReviewDocumentOperationMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.documentai.v1beta3.ReviewDocumentOperationMetadata_State" json:"state,omitempty"`
	// A message providing more details about the current state of processing.
	// For example, the error message if the operation is failed.
	StateMessage string `protobuf:"bytes,2,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
	// The creation time of the operation.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The last update time of the operation.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The basic metadata of the long running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,5,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
	// The Crowd Compute question ID.
	QuestionId string `protobuf:"bytes,6,opt,name=question_id,json=questionId,proto3" json:"question_id,omitempty"`
}

func (x *ReviewDocumentOperationMetadata) Reset() {
	*x = ReviewDocumentOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReviewDocumentOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReviewDocumentOperationMetadata) ProtoMessage() {}

func (x *ReviewDocumentOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReviewDocumentOperationMetadata.ProtoReflect.Descriptor instead.
func (*ReviewDocumentOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{38}
}

func (x *ReviewDocumentOperationMetadata) GetState() ReviewDocumentOperationMetadata_State {
	if x != nil {
		return x.State
	}
	return ReviewDocumentOperationMetadata_STATE_UNSPECIFIED
}

func (x *ReviewDocumentOperationMetadata) GetStateMessage() string {
	if x != nil {
		return x.StateMessage
	}
	return ""
}

func (x *ReviewDocumentOperationMetadata) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ReviewDocumentOperationMetadata) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ReviewDocumentOperationMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

func (x *ReviewDocumentOperationMetadata) GetQuestionId() string {
	if x != nil {
		return x.QuestionId
	}
	return ""
}

// The message for input config in batch process.
//
// Deprecated: Do not use.
type BatchProcessRequest_BatchInputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud Storage location as the source of the document.
	GcsSource string `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3" json:"gcs_source,omitempty"`
	// Mimetype of the input. If the input is a raw document, the supported
	// mimetypes are application/pdf, image/tiff, and image/gif.
	// If the input is a [Document] proto, the type should be application/json.
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
}

func (x *BatchProcessRequest_BatchInputConfig) Reset() {
	*x = BatchProcessRequest_BatchInputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchProcessRequest_BatchInputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchProcessRequest_BatchInputConfig) ProtoMessage() {}

func (x *BatchProcessRequest_BatchInputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchProcessRequest_BatchInputConfig.ProtoReflect.Descriptor instead.
func (*BatchProcessRequest_BatchInputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{3, 0}
}

func (x *BatchProcessRequest_BatchInputConfig) GetGcsSource() string {
	if x != nil {
		return x.GcsSource
	}
	return ""
}

func (x *BatchProcessRequest_BatchInputConfig) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

// The message for output config in batch process.
//
// Deprecated: Do not use.
type BatchProcessRequest_BatchOutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The output Cloud Storage directory to put the processed documents.
	GcsDestination string `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3" json:"gcs_destination,omitempty"`
}

func (x *BatchProcessRequest_BatchOutputConfig) Reset() {
	*x = BatchProcessRequest_BatchOutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchProcessRequest_BatchOutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchProcessRequest_BatchOutputConfig) ProtoMessage() {}

func (x *BatchProcessRequest_BatchOutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchProcessRequest_BatchOutputConfig.ProtoReflect.Descriptor instead.
func (*BatchProcessRequest_BatchOutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{3, 1}
}

func (x *BatchProcessRequest_BatchOutputConfig) GetGcsDestination() string {
	if x != nil {
		return x.GcsDestination
	}
	return ""
}

// The status of a each individual document in the batch process.
type BatchProcessMetadata_IndividualProcessStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source of the document, same as the [input_gcs_source] field in the
	// request when the batch process started. The batch process is started by
	// take snapshot of that document, since a user can move or change that
	// document during the process.
	InputGcsSource string `protobuf:"bytes,1,opt,name=input_gcs_source,json=inputGcsSource,proto3" json:"input_gcs_source,omitempty"`
	// The status processing the document.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	// The output_gcs_destination (in the request as `output_gcs_destination`)
	// of the processed document if it was successful, otherwise empty.
	OutputGcsDestination string `protobuf:"bytes,3,opt,name=output_gcs_destination,json=outputGcsDestination,proto3" json:"output_gcs_destination,omitempty"`
	// The name of the operation triggered by the processed document. If the
	// human review process is not triggered, this field will be empty. It has
	// the same response type and metadata as the long running operation
	// returned by ReviewDocument method.
	//
	// Deprecated: Do not use.
	HumanReviewOperation string `protobuf:"bytes,4,opt,name=human_review_operation,json=humanReviewOperation,proto3" json:"human_review_operation,omitempty"`
	// The status of human review on the processed document.
	HumanReviewStatus *HumanReviewStatus `protobuf:"bytes,5,opt,name=human_review_status,json=humanReviewStatus,proto3" json:"human_review_status,omitempty"`
}

func (x *BatchProcessMetadata_IndividualProcessStatus) Reset() {
	*x = BatchProcessMetadata_IndividualProcessStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchProcessMetadata_IndividualProcessStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchProcessMetadata_IndividualProcessStatus) ProtoMessage() {}

func (x *BatchProcessMetadata_IndividualProcessStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchProcessMetadata_IndividualProcessStatus.ProtoReflect.Descriptor instead.
func (*BatchProcessMetadata_IndividualProcessStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP(), []int{5, 0}
}

func (x *BatchProcessMetadata_IndividualProcessStatus) GetInputGcsSource() string {
	if x != nil {
		return x.InputGcsSource
	}
	return ""
}

func (x *BatchProcessMetadata_IndividualProcessStatus) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *BatchProcessMetadata_IndividualProcessStatus) GetOutputGcsDestination() string {
	if x != nil {
		return x.OutputGcsDestination
	}
	return ""
}

// Deprecated: Do not use.
func (x *BatchProcessMetadata_IndividualProcessStatus) GetHumanReviewOperation() string {
	if x != nil {
		return x.HumanReviewOperation
	}
	return ""
}

func (x *BatchProcessMetadata_IndividualProcessStatus) GetHumanReviewStatus() *HumanReviewStatus {
	if x != nil {
		return x.HumanReviewStatus
	}
	return nil
}

var File_google_cloud_documentai_v1beta3_document_processor_service_proto protoreflect.FileDescriptor

var file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDesc = []byte{
	0x0a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x94, 0x03, 0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0f, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x69, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x51, 0x0a, 0x0c, 0x72,
	0x61, 0x77, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x52, 0x61, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x48,
	0x00, 0x52, 0x0b, 0x72, 0x61, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1d,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x03, 0x0a, 0x01, 0x2a, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x49, 0x0a,
	0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x6b, 0x69, 0x70,
	0x5f, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0f, 0x73, 0x6b, 0x69, 0x70, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42,
	0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x9e, 0x02, 0x0a, 0x11, 0x48, 0x75,
	0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x4e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x23, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5e, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x4b,
	0x49, 0x50, 0x50, 0x45, 0x44, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x56, 0x41, 0x4c, 0x49, 0x44,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x41, 0x53, 0x53, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0f,
	0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x03, 0x12,
	0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x04, 0x22, 0xf6, 0x01, 0x0a, 0x0f, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45,
	0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x38, 0x0a, 0x16, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72,
	0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x14, 0x68, 0x75, 0x6d, 0x61, 0x6e,
	0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x62, 0x0a, 0x13, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x48,
	0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x11, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x22, 0xa9, 0x05, 0x0a, 0x13, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x03, 0x0a, 0x01, 0x2a, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x6e, 0x0a, 0x0d, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0c, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x6f, 0x0a, 0x0d, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0c, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x63, 0x0a, 0x0f, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x0e, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x6b, 0x0a, 0x16, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x14, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2a, 0x0a,
	0x11, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x73, 0x6b, 0x69, 0x70, 0x48, 0x75,
	0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x1a, 0x52, 0x0a, 0x10, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a,
	0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x09,
	0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x3a, 0x02, 0x18, 0x01, 0x1a, 0x40, 0x0a,
	0x11, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x27, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x67, 0x63, 0x73,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x02, 0x18, 0x01, 0x22,
	0x16, 0x0a, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xd2, 0x06, 0x0a, 0x14, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x51, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x8d, 0x01, 0x0a, 0x1b, 0x69, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61,
	0x6c, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x49, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x19, 0x69, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64,
	0x75, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x65, 0x73, 0x1a, 0xc3, 0x02, 0x0a, 0x17, 0x49, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61,
	0x6c, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x28,
	0x0a, 0x10, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x47,
	0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x67,
	0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x47, 0x63, 0x73, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x16, 0x68, 0x75,
	0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x14,
	0x68, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x13, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x11, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x72, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x49, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47,
	0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10,
	0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10,
	0x04, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x05,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x22, 0x65, 0x0a, 0x1a,
	0x46, 0x65, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x29, 0x12, 0x27, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x22, 0x76, 0x0a, 0x1b, 0x46, 0x65, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x57, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0e, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0xa0, 0x01, 0x0a, 0x19,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x29, 0x12, 0x27, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9d,
	0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a,
	0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x98,
	0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25,
	0x12, 0x23, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8c, 0x01, 0x0a, 0x16, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x56, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x64, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa6, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12,
	0x2a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xa9, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x60, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x11, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x67, 0x0a, 0x1d, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x83, 0x01, 0x0a, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x61, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x67, 0x0a, 0x1d, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2c, 0x0a, 0x2a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x20, 0x0a, 0x1e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x83, 0x01, 0x0a, 0x1e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x61, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x69, 0x0a, 0x1f, 0x55,
	0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x22, 0x0a, 0x20, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x85, 0x01, 0x0a, 0x20, 0x55,
	0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x61, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x22, 0xac, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x22, 0x59, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x25, 0x0a, 0x23, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x7c, 0x0a, 0x17,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x61, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x59, 0x0a, 0x16, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x19, 0x0a, 0x17, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x7c, 0x0a, 0x17, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x61, 0x0a, 0x0f, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x5a,
	0x0a, 0x17, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a,
	0x23, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x1a, 0x0a, 0x18, 0x44, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7d, 0x0a, 0x18, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x61, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xde, 0x01, 0x0a, 0x21, 0x53, 0x65, 0x74, 0x44, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x09, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x09, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x6e, 0x0a, 0x19, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2c, 0x0a, 0x2a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x24, 0x0a, 0x22, 0x53, 0x65, 0x74, 0x44, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x87, 0x01, 0x0a,
	0x22, 0x53, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x61, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xbd, 0x04, 0x0a, 0x15, 0x52, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x54, 0x0a, 0x0f, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x63, 0x0a, 0x13, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x52,
	0x65, 0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x49, 0x0a, 0x08, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x38, 0x0a, 0x18, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x5b, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x2e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x72, 0x69, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x58, 0x0a,
	0x0f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x0e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x23, 0x0a, 0x08, 0x50, 0x72, 0x69, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x55, 0x52, 0x47, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x42, 0x08, 0x0a, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xfe, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x27, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x67, 0x63, 0x73, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x29, 0x0a, 0x10, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x6a, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x3b, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45,
	0x4a, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43,
	0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x22, 0x89, 0x04, 0x0a, 0x1f, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5c, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x52, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3b,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x61, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1f, 0x0a, 0x0b, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x65, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e,
	0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43,
	0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45,
	0x44, 0x10, 0x05, 0x32, 0xa4, 0x22, 0x0a, 0x18, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x9b, 0x02, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa4, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x96,
	0x01, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x3a, 0x01,
	0x2a, 0x5a, 0x54, 0x22, 0x4f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xcc,
	0x02, 0x0a, 0x15, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xdd, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa0, 0x01, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x59, 0x22, 0x54,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41,
	0x2c, 0x0a, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xdf, 0x01,
	0x0a, 0x13, 0x46, 0x65, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x4d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x66, 0x65, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0xd7, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xc7, 0x01, 0x0a, 0x0e, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x12, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0xb4, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73,
	0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xdd, 0x01, 0x0a, 0x13, 0x47,
	0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0x56, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x12, 0x47, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xf0, 0x01, 0x0a, 0x15, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x12, 0x47, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x8a, 0x02,
	0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x90, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49,
	0x2a, 0x47, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0xca, 0x41, 0x37, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x1e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x9d, 0x02, 0x0a, 0x16, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa3, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x22, 0x4e, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x3a, 0x01, 0x2a,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x40, 0x0a, 0x1e, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xa7, 0x02, 0x0a, 0x18, 0x55,
	0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa9, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x55, 0x22, 0x50, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x44,
	0x0a, 0x20, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x20, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0xd1, 0x01, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x22, 0x59, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x40, 0x22, 0x33, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x3a, 0x09, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0xda, 0x41, 0x10, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0xe0, 0x01, 0x0a, 0x0f, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x75, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x2a, 0x33, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x30, 0x0a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xe5, 0x01, 0x0a, 0x0f,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x22,
	0x3a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x3a, 0x01, 0x2a, 0xca, 0x41,
	0x32, 0x0a, 0x17, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x17, 0x45, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0xea, 0x01, 0x0a, 0x10, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x7d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x34, 0x0a, 0x18, 0x44, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0xab, 0x02, 0x0a, 0x1a, 0x53, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x53, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xa9, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x58, 0x22, 0x53, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x3a, 0x01, 0x2a, 0xca, 0x41, 0x48, 0x0a, 0x22, 0x53, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x22, 0x53, 0x65, 0x74, 0x44,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xaa,
	0x02, 0x0a, 0x0e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x33, 0x2e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc0, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x68, 0x22, 0x63, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x7b, 0x68, 0x75, 0x6d,
	0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x3a, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x13, 0x68, 0x75, 0x6d, 0x61,
	0x6e, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0xca,
	0x41, 0x39, 0x0a, 0x16, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x4d, 0xca, 0x41, 0x19,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xc9, 0x03, 0x0a, 0x23, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x42, 0x1a, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x69, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x01,
	0x5a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x3b, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0xaa, 0x02, 0x1f, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x41, 0x49, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x33, 0xca, 0x02, 0x1f,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0xea,
	0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0xea, 0x41, 0x7f, 0x0a, 0x2b, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x50, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x7d, 0x2f, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0xea, 0x41, 0x4d, 0x0a, 0x22, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescOnce sync.Once
	file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescData = file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDesc
)

func file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescGZIP() []byte {
	file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescData)
	})
	return file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDescData
}

var file_google_cloud_documentai_v1beta3_document_processor_service_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes = make([]protoimpl.MessageInfo, 42)
var file_google_cloud_documentai_v1beta3_document_processor_service_proto_goTypes = []interface{}{
	(HumanReviewStatus_State)(0),                         // 0: google.cloud.documentai.v1beta3.HumanReviewStatus.State
	(BatchProcessMetadata_State)(0),                      // 1: google.cloud.documentai.v1beta3.BatchProcessMetadata.State
	(ReviewDocumentRequest_Priority)(0),                  // 2: google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority
	(ReviewDocumentResponse_State)(0),                    // 3: google.cloud.documentai.v1beta3.ReviewDocumentResponse.State
	(ReviewDocumentOperationMetadata_State)(0),           // 4: google.cloud.documentai.v1beta3.ReviewDocumentOperationMetadata.State
	(*ProcessRequest)(nil),                               // 5: google.cloud.documentai.v1beta3.ProcessRequest
	(*HumanReviewStatus)(nil),                            // 6: google.cloud.documentai.v1beta3.HumanReviewStatus
	(*ProcessResponse)(nil),                              // 7: google.cloud.documentai.v1beta3.ProcessResponse
	(*BatchProcessRequest)(nil),                          // 8: google.cloud.documentai.v1beta3.BatchProcessRequest
	(*BatchProcessResponse)(nil),                         // 9: google.cloud.documentai.v1beta3.BatchProcessResponse
	(*BatchProcessMetadata)(nil),                         // 10: google.cloud.documentai.v1beta3.BatchProcessMetadata
	(*FetchProcessorTypesRequest)(nil),                   // 11: google.cloud.documentai.v1beta3.FetchProcessorTypesRequest
	(*FetchProcessorTypesResponse)(nil),                  // 12: google.cloud.documentai.v1beta3.FetchProcessorTypesResponse
	(*ListProcessorTypesRequest)(nil),                    // 13: google.cloud.documentai.v1beta3.ListProcessorTypesRequest
	(*ListProcessorTypesResponse)(nil),                   // 14: google.cloud.documentai.v1beta3.ListProcessorTypesResponse
	(*ListProcessorsRequest)(nil),                        // 15: google.cloud.documentai.v1beta3.ListProcessorsRequest
	(*ListProcessorsResponse)(nil),                       // 16: google.cloud.documentai.v1beta3.ListProcessorsResponse
	(*GetProcessorRequest)(nil),                          // 17: google.cloud.documentai.v1beta3.GetProcessorRequest
	(*GetProcessorVersionRequest)(nil),                   // 18: google.cloud.documentai.v1beta3.GetProcessorVersionRequest
	(*ListProcessorVersionsRequest)(nil),                 // 19: google.cloud.documentai.v1beta3.ListProcessorVersionsRequest
	(*ListProcessorVersionsResponse)(nil),                // 20: google.cloud.documentai.v1beta3.ListProcessorVersionsResponse
	(*DeleteProcessorVersionRequest)(nil),                // 21: google.cloud.documentai.v1beta3.DeleteProcessorVersionRequest
	(*DeleteProcessorVersionMetadata)(nil),               // 22: google.cloud.documentai.v1beta3.DeleteProcessorVersionMetadata
	(*DeployProcessorVersionRequest)(nil),                // 23: google.cloud.documentai.v1beta3.DeployProcessorVersionRequest
	(*DeployProcessorVersionResponse)(nil),               // 24: google.cloud.documentai.v1beta3.DeployProcessorVersionResponse
	(*DeployProcessorVersionMetadata)(nil),               // 25: google.cloud.documentai.v1beta3.DeployProcessorVersionMetadata
	(*UndeployProcessorVersionRequest)(nil),              // 26: google.cloud.documentai.v1beta3.UndeployProcessorVersionRequest
	(*UndeployProcessorVersionResponse)(nil),             // 27: google.cloud.documentai.v1beta3.UndeployProcessorVersionResponse
	(*UndeployProcessorVersionMetadata)(nil),             // 28: google.cloud.documentai.v1beta3.UndeployProcessorVersionMetadata
	(*CreateProcessorRequest)(nil),                       // 29: google.cloud.documentai.v1beta3.CreateProcessorRequest
	(*DeleteProcessorRequest)(nil),                       // 30: google.cloud.documentai.v1beta3.DeleteProcessorRequest
	(*DeleteProcessorMetadata)(nil),                      // 31: google.cloud.documentai.v1beta3.DeleteProcessorMetadata
	(*EnableProcessorRequest)(nil),                       // 32: google.cloud.documentai.v1beta3.EnableProcessorRequest
	(*EnableProcessorResponse)(nil),                      // 33: google.cloud.documentai.v1beta3.EnableProcessorResponse
	(*EnableProcessorMetadata)(nil),                      // 34: google.cloud.documentai.v1beta3.EnableProcessorMetadata
	(*DisableProcessorRequest)(nil),                      // 35: google.cloud.documentai.v1beta3.DisableProcessorRequest
	(*DisableProcessorResponse)(nil),                     // 36: google.cloud.documentai.v1beta3.DisableProcessorResponse
	(*DisableProcessorMetadata)(nil),                     // 37: google.cloud.documentai.v1beta3.DisableProcessorMetadata
	(*SetDefaultProcessorVersionRequest)(nil),            // 38: google.cloud.documentai.v1beta3.SetDefaultProcessorVersionRequest
	(*SetDefaultProcessorVersionResponse)(nil),           // 39: google.cloud.documentai.v1beta3.SetDefaultProcessorVersionResponse
	(*SetDefaultProcessorVersionMetadata)(nil),           // 40: google.cloud.documentai.v1beta3.SetDefaultProcessorVersionMetadata
	(*ReviewDocumentRequest)(nil),                        // 41: google.cloud.documentai.v1beta3.ReviewDocumentRequest
	(*ReviewDocumentResponse)(nil),                       // 42: google.cloud.documentai.v1beta3.ReviewDocumentResponse
	(*ReviewDocumentOperationMetadata)(nil),              // 43: google.cloud.documentai.v1beta3.ReviewDocumentOperationMetadata
	(*BatchProcessRequest_BatchInputConfig)(nil),         // 44: google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
	(*BatchProcessRequest_BatchOutputConfig)(nil),        // 45: google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
	(*BatchProcessMetadata_IndividualProcessStatus)(nil), // 46: google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
	(*Document)(nil),                                     // 47: google.cloud.documentai.v1beta3.Document
	(*RawDocument)(nil),                                  // 48: google.cloud.documentai.v1beta3.RawDocument
	(*field_mask.FieldMask)(nil),                         // 49: google.protobuf.FieldMask
	(*BatchDocumentsInputConfig)(nil),                    // 50: google.cloud.documentai.v1beta3.BatchDocumentsInputConfig
	(*DocumentOutputConfig)(nil),                         // 51: google.cloud.documentai.v1beta3.DocumentOutputConfig
	(*timestamp.Timestamp)(nil),                          // 52: google.protobuf.Timestamp
	(*ProcessorType)(nil),                                // 53: google.cloud.documentai.v1beta3.ProcessorType
	(*Processor)(nil),                                    // 54: google.cloud.documentai.v1beta3.Processor
	(*ProcessorVersion)(nil),                             // 55: google.cloud.documentai.v1beta3.ProcessorVersion
	(*CommonOperationMetadata)(nil),                      // 56: google.cloud.documentai.v1beta3.CommonOperationMetadata
	(*DocumentSchema)(nil),                               // 57: google.cloud.documentai.v1beta3.DocumentSchema
	(*status.Status)(nil),                                // 58: google.rpc.Status
	(*longrunning.Operation)(nil),                        // 59: google.longrunning.Operation
}
var file_google_cloud_documentai_v1beta3_document_processor_service_proto_depIdxs = []int32{
	47, // 0: google.cloud.documentai.v1beta3.ProcessRequest.inline_document:type_name -> google.cloud.documentai.v1beta3.Document
	48, // 1: google.cloud.documentai.v1beta3.ProcessRequest.raw_document:type_name -> google.cloud.documentai.v1beta3.RawDocument
	47, // 2: google.cloud.documentai.v1beta3.ProcessRequest.document:type_name -> google.cloud.documentai.v1beta3.Document
	49, // 3: google.cloud.documentai.v1beta3.ProcessRequest.field_mask:type_name -> google.protobuf.FieldMask
	0,  // 4: google.cloud.documentai.v1beta3.HumanReviewStatus.state:type_name -> google.cloud.documentai.v1beta3.HumanReviewStatus.State
	47, // 5: google.cloud.documentai.v1beta3.ProcessResponse.document:type_name -> google.cloud.documentai.v1beta3.Document
	6,  // 6: google.cloud.documentai.v1beta3.ProcessResponse.human_review_status:type_name -> google.cloud.documentai.v1beta3.HumanReviewStatus
	44, // 7: google.cloud.documentai.v1beta3.BatchProcessRequest.input_configs:type_name -> google.cloud.documentai.v1beta3.BatchProcessRequest.BatchInputConfig
	45, // 8: google.cloud.documentai.v1beta3.BatchProcessRequest.output_config:type_name -> google.cloud.documentai.v1beta3.BatchProcessRequest.BatchOutputConfig
	50, // 9: google.cloud.documentai.v1beta3.BatchProcessRequest.input_documents:type_name -> google.cloud.documentai.v1beta3.BatchDocumentsInputConfig
	51, // 10: google.cloud.documentai.v1beta3.BatchProcessRequest.document_output_config:type_name -> google.cloud.documentai.v1beta3.DocumentOutputConfig
	1,  // 11: google.cloud.documentai.v1beta3.BatchProcessMetadata.state:type_name -> google.cloud.documentai.v1beta3.BatchProcessMetadata.State
	52, // 12: google.cloud.documentai.v1beta3.BatchProcessMetadata.create_time:type_name -> google.protobuf.Timestamp
	52, // 13: google.cloud.documentai.v1beta3.BatchProcessMetadata.update_time:type_name -> google.protobuf.Timestamp
	46, // 14: google.cloud.documentai.v1beta3.BatchProcessMetadata.individual_process_statuses:type_name -> google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus
	53, // 15: google.cloud.documentai.v1beta3.FetchProcessorTypesResponse.processor_types:type_name -> google.cloud.documentai.v1beta3.ProcessorType
	53, // 16: google.cloud.documentai.v1beta3.ListProcessorTypesResponse.processor_types:type_name -> google.cloud.documentai.v1beta3.ProcessorType
	54, // 17: google.cloud.documentai.v1beta3.ListProcessorsResponse.processors:type_name -> google.cloud.documentai.v1beta3.Processor
	55, // 18: google.cloud.documentai.v1beta3.ListProcessorVersionsResponse.processor_versions:type_name -> google.cloud.documentai.v1beta3.ProcessorVersion
	56, // 19: google.cloud.documentai.v1beta3.DeleteProcessorVersionMetadata.common_metadata:type_name -> google.cloud.documentai.v1beta3.CommonOperationMetadata
	56, // 20: google.cloud.documentai.v1beta3.DeployProcessorVersionMetadata.common_metadata:type_name -> google.cloud.documentai.v1beta3.CommonOperationMetadata
	56, // 21: google.cloud.documentai.v1beta3.UndeployProcessorVersionMetadata.common_metadata:type_name -> google.cloud.documentai.v1beta3.CommonOperationMetadata
	54, // 22: google.cloud.documentai.v1beta3.CreateProcessorRequest.processor:type_name -> google.cloud.documentai.v1beta3.Processor
	56, // 23: google.cloud.documentai.v1beta3.DeleteProcessorMetadata.common_metadata:type_name -> google.cloud.documentai.v1beta3.CommonOperationMetadata
	56, // 24: google.cloud.documentai.v1beta3.EnableProcessorMetadata.common_metadata:type_name -> google.cloud.documentai.v1beta3.CommonOperationMetadata
	56, // 25: google.cloud.documentai.v1beta3.DisableProcessorMetadata.common_metadata:type_name -> google.cloud.documentai.v1beta3.CommonOperationMetadata
	56, // 26: google.cloud.documentai.v1beta3.SetDefaultProcessorVersionMetadata.common_metadata:type_name -> google.cloud.documentai.v1beta3.CommonOperationMetadata
	47, // 27: google.cloud.documentai.v1beta3.ReviewDocumentRequest.inline_document:type_name -> google.cloud.documentai.v1beta3.Document
	47, // 28: google.cloud.documentai.v1beta3.ReviewDocumentRequest.document:type_name -> google.cloud.documentai.v1beta3.Document
	2,  // 29: google.cloud.documentai.v1beta3.ReviewDocumentRequest.priority:type_name -> google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority
	57, // 30: google.cloud.documentai.v1beta3.ReviewDocumentRequest.document_schema:type_name -> google.cloud.documentai.v1beta3.DocumentSchema
	3,  // 31: google.cloud.documentai.v1beta3.ReviewDocumentResponse.state:type_name -> google.cloud.documentai.v1beta3.ReviewDocumentResponse.State
	4,  // 32: google.cloud.documentai.v1beta3.ReviewDocumentOperationMetadata.state:type_name -> google.cloud.documentai.v1beta3.ReviewDocumentOperationMetadata.State
	52, // 33: google.cloud.documentai.v1beta3.ReviewDocumentOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	52, // 34: google.cloud.documentai.v1beta3.ReviewDocumentOperationMetadata.update_time:type_name -> google.protobuf.Timestamp
	56, // 35: google.cloud.documentai.v1beta3.ReviewDocumentOperationMetadata.common_metadata:type_name -> google.cloud.documentai.v1beta3.CommonOperationMetadata
	58, // 36: google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.status:type_name -> google.rpc.Status
	6,  // 37: google.cloud.documentai.v1beta3.BatchProcessMetadata.IndividualProcessStatus.human_review_status:type_name -> google.cloud.documentai.v1beta3.HumanReviewStatus
	5,  // 38: google.cloud.documentai.v1beta3.DocumentProcessorService.ProcessDocument:input_type -> google.cloud.documentai.v1beta3.ProcessRequest
	8,  // 39: google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments:input_type -> google.cloud.documentai.v1beta3.BatchProcessRequest
	11, // 40: google.cloud.documentai.v1beta3.DocumentProcessorService.FetchProcessorTypes:input_type -> google.cloud.documentai.v1beta3.FetchProcessorTypesRequest
	13, // 41: google.cloud.documentai.v1beta3.DocumentProcessorService.ListProcessorTypes:input_type -> google.cloud.documentai.v1beta3.ListProcessorTypesRequest
	15, // 42: google.cloud.documentai.v1beta3.DocumentProcessorService.ListProcessors:input_type -> google.cloud.documentai.v1beta3.ListProcessorsRequest
	17, // 43: google.cloud.documentai.v1beta3.DocumentProcessorService.GetProcessor:input_type -> google.cloud.documentai.v1beta3.GetProcessorRequest
	18, // 44: google.cloud.documentai.v1beta3.DocumentProcessorService.GetProcessorVersion:input_type -> google.cloud.documentai.v1beta3.GetProcessorVersionRequest
	19, // 45: google.cloud.documentai.v1beta3.DocumentProcessorService.ListProcessorVersions:input_type -> google.cloud.documentai.v1beta3.ListProcessorVersionsRequest
	21, // 46: google.cloud.documentai.v1beta3.DocumentProcessorService.DeleteProcessorVersion:input_type -> google.cloud.documentai.v1beta3.DeleteProcessorVersionRequest
	23, // 47: google.cloud.documentai.v1beta3.DocumentProcessorService.DeployProcessorVersion:input_type -> google.cloud.documentai.v1beta3.DeployProcessorVersionRequest
	26, // 48: google.cloud.documentai.v1beta3.DocumentProcessorService.UndeployProcessorVersion:input_type -> google.cloud.documentai.v1beta3.UndeployProcessorVersionRequest
	29, // 49: google.cloud.documentai.v1beta3.DocumentProcessorService.CreateProcessor:input_type -> google.cloud.documentai.v1beta3.CreateProcessorRequest
	30, // 50: google.cloud.documentai.v1beta3.DocumentProcessorService.DeleteProcessor:input_type -> google.cloud.documentai.v1beta3.DeleteProcessorRequest
	32, // 51: google.cloud.documentai.v1beta3.DocumentProcessorService.EnableProcessor:input_type -> google.cloud.documentai.v1beta3.EnableProcessorRequest
	35, // 52: google.cloud.documentai.v1beta3.DocumentProcessorService.DisableProcessor:input_type -> google.cloud.documentai.v1beta3.DisableProcessorRequest
	38, // 53: google.cloud.documentai.v1beta3.DocumentProcessorService.SetDefaultProcessorVersion:input_type -> google.cloud.documentai.v1beta3.SetDefaultProcessorVersionRequest
	41, // 54: google.cloud.documentai.v1beta3.DocumentProcessorService.ReviewDocument:input_type -> google.cloud.documentai.v1beta3.ReviewDocumentRequest
	7,  // 55: google.cloud.documentai.v1beta3.DocumentProcessorService.ProcessDocument:output_type -> google.cloud.documentai.v1beta3.ProcessResponse
	59, // 56: google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments:output_type -> google.longrunning.Operation
	12, // 57: google.cloud.documentai.v1beta3.DocumentProcessorService.FetchProcessorTypes:output_type -> google.cloud.documentai.v1beta3.FetchProcessorTypesResponse
	14, // 58: google.cloud.documentai.v1beta3.DocumentProcessorService.ListProcessorTypes:output_type -> google.cloud.documentai.v1beta3.ListProcessorTypesResponse
	16, // 59: google.cloud.documentai.v1beta3.DocumentProcessorService.ListProcessors:output_type -> google.cloud.documentai.v1beta3.ListProcessorsResponse
	54, // 60: google.cloud.documentai.v1beta3.DocumentProcessorService.GetProcessor:output_type -> google.cloud.documentai.v1beta3.Processor
	55, // 61: google.cloud.documentai.v1beta3.DocumentProcessorService.GetProcessorVersion:output_type -> google.cloud.documentai.v1beta3.ProcessorVersion
	20, // 62: google.cloud.documentai.v1beta3.DocumentProcessorService.ListProcessorVersions:output_type -> google.cloud.documentai.v1beta3.ListProcessorVersionsResponse
	59, // 63: google.cloud.documentai.v1beta3.DocumentProcessorService.DeleteProcessorVersion:output_type -> google.longrunning.Operation
	59, // 64: google.cloud.documentai.v1beta3.DocumentProcessorService.DeployProcessorVersion:output_type -> google.longrunning.Operation
	59, // 65: google.cloud.documentai.v1beta3.DocumentProcessorService.UndeployProcessorVersion:output_type -> google.longrunning.Operation
	54, // 66: google.cloud.documentai.v1beta3.DocumentProcessorService.CreateProcessor:output_type -> google.cloud.documentai.v1beta3.Processor
	59, // 67: google.cloud.documentai.v1beta3.DocumentProcessorService.DeleteProcessor:output_type -> google.longrunning.Operation
	59, // 68: google.cloud.documentai.v1beta3.DocumentProcessorService.EnableProcessor:output_type -> google.longrunning.Operation
	59, // 69: google.cloud.documentai.v1beta3.DocumentProcessorService.DisableProcessor:output_type -> google.longrunning.Operation
	59, // 70: google.cloud.documentai.v1beta3.DocumentProcessorService.SetDefaultProcessorVersion:output_type -> google.longrunning.Operation
	59, // 71: google.cloud.documentai.v1beta3.DocumentProcessorService.ReviewDocument:output_type -> google.longrunning.Operation
	55, // [55:72] is the sub-list for method output_type
	38, // [38:55] is the sub-list for method input_type
	38, // [38:38] is the sub-list for extension type_name
	38, // [38:38] is the sub-list for extension extendee
	0,  // [0:38] is the sub-list for field type_name
}

func init() { file_google_cloud_documentai_v1beta3_document_processor_service_proto_init() }
func file_google_cloud_documentai_v1beta3_document_processor_service_proto_init() {
	if File_google_cloud_documentai_v1beta3_document_processor_service_proto != nil {
		return
	}
	file_google_cloud_documentai_v1beta3_document_proto_init()
	file_google_cloud_documentai_v1beta3_document_io_proto_init()
	file_google_cloud_documentai_v1beta3_document_schema_proto_init()
	file_google_cloud_documentai_v1beta3_operation_metadata_proto_init()
	file_google_cloud_documentai_v1beta3_processor_proto_init()
	file_google_cloud_documentai_v1beta3_processor_type_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HumanReviewStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchProcessRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchProcessResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchProcessMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchProcessorTypesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchProcessorTypesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProcessorTypesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProcessorTypesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProcessorsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProcessorsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetProcessorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetProcessorVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProcessorVersionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProcessorVersionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteProcessorVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteProcessorVersionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployProcessorVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployProcessorVersionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployProcessorVersionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployProcessorVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployProcessorVersionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployProcessorVersionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateProcessorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteProcessorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteProcessorMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnableProcessorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnableProcessorResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnableProcessorMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisableProcessorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisableProcessorResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisableProcessorMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetDefaultProcessorVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetDefaultProcessorVersionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetDefaultProcessorVersionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReviewDocumentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReviewDocumentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReviewDocumentOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchProcessRequest_BatchInputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchProcessRequest_BatchOutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchProcessMetadata_IndividualProcessStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*ProcessRequest_InlineDocument)(nil),
		(*ProcessRequest_RawDocument)(nil),
	}
	file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes[36].OneofWrappers = []interface{}{
		(*ReviewDocumentRequest_InlineDocument)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   42,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_documentai_v1beta3_document_processor_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_documentai_v1beta3_document_processor_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_documentai_v1beta3_document_processor_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_documentai_v1beta3_document_processor_service_proto_msgTypes,
	}.Build()
	File_google_cloud_documentai_v1beta3_document_processor_service_proto = out.File
	file_google_cloud_documentai_v1beta3_document_processor_service_proto_rawDesc = nil
	file_google_cloud_documentai_v1beta3_document_processor_service_proto_goTypes = nil
	file_google_cloud_documentai_v1beta3_document_processor_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DocumentProcessorServiceClient is the client API for DocumentProcessorService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DocumentProcessorServiceClient interface {
	// Processes a single document.
	ProcessDocument(ctx context.Context, in *ProcessRequest, opts ...grpc.CallOption) (*ProcessResponse, error)
	// LRO endpoint to batch process many documents. The output is written
	// to Cloud Storage as JSON in the [Document] format.
	BatchProcessDocuments(ctx context.Context, in *BatchProcessRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Fetches processor types. Note that we do not use ListProcessorTypes here
	// because it is not paginated.
	FetchProcessorTypes(ctx context.Context, in *FetchProcessorTypesRequest, opts ...grpc.CallOption) (*FetchProcessorTypesResponse, error)
	// Lists the processor types that exist.
	ListProcessorTypes(ctx context.Context, in *ListProcessorTypesRequest, opts ...grpc.CallOption) (*ListProcessorTypesResponse, error)
	// Lists all processors which belong to this project.
	ListProcessors(ctx context.Context, in *ListProcessorsRequest, opts ...grpc.CallOption) (*ListProcessorsResponse, error)
	// Gets a processor detail.
	GetProcessor(ctx context.Context, in *GetProcessorRequest, opts ...grpc.CallOption) (*Processor, error)
	// Gets a processor version detail.
	GetProcessorVersion(ctx context.Context, in *GetProcessorVersionRequest, opts ...grpc.CallOption) (*ProcessorVersion, error)
	// Lists all versions of a processor.
	ListProcessorVersions(ctx context.Context, in *ListProcessorVersionsRequest, opts ...grpc.CallOption) (*ListProcessorVersionsResponse, error)
	// Deletes the processor version, all artifacts under the processor version
	// will be deleted.
	DeleteProcessorVersion(ctx context.Context, in *DeleteProcessorVersionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deploys the processor version.
	DeployProcessorVersion(ctx context.Context, in *DeployProcessorVersionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Undeploys the processor version.
	UndeployProcessorVersion(ctx context.Context, in *UndeployProcessorVersionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a processor from the type processor that the user chose.
	// The processor will be at "ENABLED" state by default after its creation.
	CreateProcessor(ctx context.Context, in *CreateProcessorRequest, opts ...grpc.CallOption) (*Processor, error)
	// Deletes the processor, unloads all deployed model artifacts if it was
	// enabled and then deletes all artifacts associated with this processor.
	DeleteProcessor(ctx context.Context, in *DeleteProcessorRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Enables a processor
	EnableProcessor(ctx context.Context, in *EnableProcessorRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Disables a processor
	DisableProcessor(ctx context.Context, in *DisableProcessorRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Set the default (active) version of a [Processor][google.cloud.documentai.v1beta3.Processor] that will be used in
	// [ProcessDocument][google.cloud.documentai.v1beta3.DocumentProcessorService.ProcessDocument] and
	// [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments].
	SetDefaultProcessorVersion(ctx context.Context, in *SetDefaultProcessorVersionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Send a document for Human Review. The input document should be processed by
	// the specified processor.
	ReviewDocument(ctx context.Context, in *ReviewDocumentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type documentProcessorServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDocumentProcessorServiceClient(cc grpc.ClientConnInterface) DocumentProcessorServiceClient {
	return &documentProcessorServiceClient{cc}
}

func (c *documentProcessorServiceClient) ProcessDocument(ctx context.Context, in *ProcessRequest, opts ...grpc.CallOption) (*ProcessResponse, error) {
	out := new(ProcessResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentProcessorService/ProcessDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) BatchProcessDocuments(ctx context.Context, in *BatchProcessRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentProcessorService/BatchProcessDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) FetchProcessorTypes(ctx context.Context, in *FetchProcessorTypesRequest, opts ...grpc.CallOption) (*FetchProcessorTypesResponse, error) {
	out := new(FetchProcessorTypesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentProcessorService/FetchProcessorTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) ListProcessorTypes(ctx context.Context, in *ListProcessorTypesRequest, opts ...grpc.CallOption) (*ListProcessorTypesResponse, error) {
	out := new(ListProcessorTypesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentProcessorService/ListProcessorTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) ListProcessors(ctx context.Context, in *ListProcessorsRequest, opts ...grpc.CallOption) (*ListProcessorsResponse, error) {
	out := new(ListProcessorsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentProcessorService/ListProcessors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) GetProcessor(ctx context.Context, in *GetProcessorRequest, opts ...grpc.CallOption) (*Processor, error) {
	out := new(Processor)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentProcessorService/GetProcessor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) GetProcessorVersion(ctx context.Context, in *GetProcessorVersionRequest, opts ...grpc.CallOption) (*ProcessorVersion, error) {
	out := new(ProcessorVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentProcessorService/GetProcessorVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) ListProcessorVersions(ctx context.Context, in *ListProcessorVersionsRequest, opts ...grpc.CallOption) (*ListProcessorVersionsResponse, error) {
	out := new(ListProcessorVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentProcessorService/ListProcessorVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) DeleteProcessorVersion(ctx context.Context, in *DeleteProcessorVersionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentProcessorService/DeleteProcessorVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) DeployProcessorVersion(ctx context.Context, in *DeployProcessorVersionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentProcessorService/DeployProcessorVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) UndeployProcessorVersion(ctx context.Context, in *UndeployProcessorVersionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentProcessorService/UndeployProcessorVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) CreateProcessor(ctx context.Context, in *CreateProcessorRequest, opts ...grpc.CallOption) (*Processor, error) {
	out := new(Processor)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentProcessorService/CreateProcessor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) DeleteProcessor(ctx context.Context, in *DeleteProcessorRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentProcessorService/DeleteProcessor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) EnableProcessor(ctx context.Context, in *EnableProcessorRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentProcessorService/EnableProcessor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) DisableProcessor(ctx context.Context, in *DisableProcessorRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentProcessorService/DisableProcessor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) SetDefaultProcessorVersion(ctx context.Context, in *SetDefaultProcessorVersionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentProcessorService/SetDefaultProcessorVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) ReviewDocument(ctx context.Context, in *ReviewDocumentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta3.DocumentProcessorService/ReviewDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DocumentProcessorServiceServer is the server API for DocumentProcessorService service.
type DocumentProcessorServiceServer interface {
	// Processes a single document.
	ProcessDocument(context.Context, *ProcessRequest) (*ProcessResponse, error)
	// LRO endpoint to batch process many documents. The output is written
	// to Cloud Storage as JSON in the [Document] format.
	BatchProcessDocuments(context.Context, *BatchProcessRequest) (*longrunning.Operation, error)
	// Fetches processor types. Note that we do not use ListProcessorTypes here
	// because it is not paginated.
	FetchProcessorTypes(context.Context, *FetchProcessorTypesRequest) (*FetchProcessorTypesResponse, error)
	// Lists the processor types that exist.
	ListProcessorTypes(context.Context, *ListProcessorTypesRequest) (*ListProcessorTypesResponse, error)
	// Lists all processors which belong to this project.
	ListProcessors(context.Context, *ListProcessorsRequest) (*ListProcessorsResponse, error)
	// Gets a processor detail.
	GetProcessor(context.Context, *GetProcessorRequest) (*Processor, error)
	// Gets a processor version detail.
	GetProcessorVersion(context.Context, *GetProcessorVersionRequest) (*ProcessorVersion, error)
	// Lists all versions of a processor.
	ListProcessorVersions(context.Context, *ListProcessorVersionsRequest) (*ListProcessorVersionsResponse, error)
	// Deletes the processor version, all artifacts under the processor version
	// will be deleted.
	DeleteProcessorVersion(context.Context, *DeleteProcessorVersionRequest) (*longrunning.Operation, error)
	// Deploys the processor version.
	DeployProcessorVersion(context.Context, *DeployProcessorVersionRequest) (*longrunning.Operation, error)
	// Undeploys the processor version.
	UndeployProcessorVersion(context.Context, *UndeployProcessorVersionRequest) (*longrunning.Operation, error)
	// Creates a processor from the type processor that the user chose.
	// The processor will be at "ENABLED" state by default after its creation.
	CreateProcessor(context.Context, *CreateProcessorRequest) (*Processor, error)
	// Deletes the processor, unloads all deployed model artifacts if it was
	// enabled and then deletes all artifacts associated with this processor.
	DeleteProcessor(context.Context, *DeleteProcessorRequest) (*longrunning.Operation, error)
	// Enables a processor
	EnableProcessor(context.Context, *EnableProcessorRequest) (*longrunning.Operation, error)
	// Disables a processor
	DisableProcessor(context.Context, *DisableProcessorRequest) (*longrunning.Operation, error)
	// Set the default (active) version of a [Processor][google.cloud.documentai.v1beta3.Processor] that will be used in
	// [ProcessDocument][google.cloud.documentai.v1beta3.DocumentProcessorService.ProcessDocument] and
	// [BatchProcessDocuments][google.cloud.documentai.v1beta3.DocumentProcessorService.BatchProcessDocuments].
	SetDefaultProcessorVersion(context.Context, *SetDefaultProcessorVersionRequest) (*longrunning.Operation, error)
	// Send a document for Human Review. The input document should be processed by
	// the specified processor.
	ReviewDocument(context.Context, *ReviewDocumentRequest) (*longrunning.Operation, error)
}

// UnimplementedDocumentProcessorServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDocumentProcessorServiceServer struct {
}

func (*UnimplementedDocumentProcessorServiceServer) ProcessDocument(context.Context, *ProcessRequest) (*ProcessResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ProcessDocument not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) BatchProcessDocuments(context.Context, *BatchProcessRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchProcessDocuments not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) FetchProcessorTypes(context.Context, *FetchProcessorTypesRequest) (*FetchProcessorTypesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method FetchProcessorTypes not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) ListProcessorTypes(context.Context, *ListProcessorTypesRequest) (*ListProcessorTypesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListProcessorTypes not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) ListProcessors(context.Context, *ListProcessorsRequest) (*ListProcessorsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListProcessors not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) GetProcessor(context.Context, *GetProcessorRequest) (*Processor, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetProcessor not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) GetProcessorVersion(context.Context, *GetProcessorVersionRequest) (*ProcessorVersion, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetProcessorVersion not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) ListProcessorVersions(context.Context, *ListProcessorVersionsRequest) (*ListProcessorVersionsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListProcessorVersions not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) DeleteProcessorVersion(context.Context, *DeleteProcessorVersionRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteProcessorVersion not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) DeployProcessorVersion(context.Context, *DeployProcessorVersionRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeployProcessorVersion not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) UndeployProcessorVersion(context.Context, *UndeployProcessorVersionRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UndeployProcessorVersion not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) CreateProcessor(context.Context, *CreateProcessorRequest) (*Processor, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateProcessor not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) DeleteProcessor(context.Context, *DeleteProcessorRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteProcessor not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) EnableProcessor(context.Context, *EnableProcessorRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method EnableProcessor not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) DisableProcessor(context.Context, *DisableProcessorRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DisableProcessor not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) SetDefaultProcessorVersion(context.Context, *SetDefaultProcessorVersionRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SetDefaultProcessorVersion not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) ReviewDocument(context.Context, *ReviewDocumentRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ReviewDocument not implemented")
}

func RegisterDocumentProcessorServiceServer(s *grpc.Server, srv DocumentProcessorServiceServer) {
	s.RegisterService(&_DocumentProcessorService_serviceDesc, srv)
}

func _DocumentProcessorService_ProcessDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ProcessDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentProcessorService/ProcessDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ProcessDocument(ctx, req.(*ProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_BatchProcessDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).BatchProcessDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentProcessorService/BatchProcessDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).BatchProcessDocuments(ctx, req.(*BatchProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_FetchProcessorTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchProcessorTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).FetchProcessorTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentProcessorService/FetchProcessorTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).FetchProcessorTypes(ctx, req.(*FetchProcessorTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_ListProcessorTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProcessorTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ListProcessorTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentProcessorService/ListProcessorTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ListProcessorTypes(ctx, req.(*ListProcessorTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_ListProcessors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProcessorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ListProcessors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentProcessorService/ListProcessors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ListProcessors(ctx, req.(*ListProcessorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_GetProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).GetProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentProcessorService/GetProcessor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).GetProcessor(ctx, req.(*GetProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_GetProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).GetProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentProcessorService/GetProcessorVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).GetProcessorVersion(ctx, req.(*GetProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_ListProcessorVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProcessorVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ListProcessorVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentProcessorService/ListProcessorVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ListProcessorVersions(ctx, req.(*ListProcessorVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_DeleteProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).DeleteProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentProcessorService/DeleteProcessorVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).DeleteProcessorVersion(ctx, req.(*DeleteProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_DeployProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).DeployProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentProcessorService/DeployProcessorVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).DeployProcessorVersion(ctx, req.(*DeployProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_UndeployProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeployProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).UndeployProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentProcessorService/UndeployProcessorVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).UndeployProcessorVersion(ctx, req.(*UndeployProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_CreateProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).CreateProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentProcessorService/CreateProcessor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).CreateProcessor(ctx, req.(*CreateProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_DeleteProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).DeleteProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentProcessorService/DeleteProcessor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).DeleteProcessor(ctx, req.(*DeleteProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_EnableProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).EnableProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentProcessorService/EnableProcessor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).EnableProcessor(ctx, req.(*EnableProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_DisableProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).DisableProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentProcessorService/DisableProcessor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).DisableProcessor(ctx, req.(*DisableProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_SetDefaultProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetDefaultProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).SetDefaultProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentProcessorService/SetDefaultProcessorVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).SetDefaultProcessorVersion(ctx, req.(*SetDefaultProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_ReviewDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReviewDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ReviewDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta3.DocumentProcessorService/ReviewDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ReviewDocument(ctx, req.(*ReviewDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DocumentProcessorService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.documentai.v1beta3.DocumentProcessorService",
	HandlerType: (*DocumentProcessorServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ProcessDocument",
			Handler:    _DocumentProcessorService_ProcessDocument_Handler,
		},
		{
			MethodName: "BatchProcessDocuments",
			Handler:    _DocumentProcessorService_BatchProcessDocuments_Handler,
		},
		{
			MethodName: "FetchProcessorTypes",
			Handler:    _DocumentProcessorService_FetchProcessorTypes_Handler,
		},
		{
			MethodName: "ListProcessorTypes",
			Handler:    _DocumentProcessorService_ListProcessorTypes_Handler,
		},
		{
			MethodName: "ListProcessors",
			Handler:    _DocumentProcessorService_ListProcessors_Handler,
		},
		{
			MethodName: "GetProcessor",
			Handler:    _DocumentProcessorService_GetProcessor_Handler,
		},
		{
			MethodName: "GetProcessorVersion",
			Handler:    _DocumentProcessorService_GetProcessorVersion_Handler,
		},
		{
			MethodName: "ListProcessorVersions",
			Handler:    _DocumentProcessorService_ListProcessorVersions_Handler,
		},
		{
			MethodName: "DeleteProcessorVersion",
			Handler:    _DocumentProcessorService_DeleteProcessorVersion_Handler,
		},
		{
			MethodName: "DeployProcessorVersion",
			Handler:    _DocumentProcessorService_DeployProcessorVersion_Handler,
		},
		{
			MethodName: "UndeployProcessorVersion",
			Handler:    _DocumentProcessorService_UndeployProcessorVersion_Handler,
		},
		{
			MethodName: "CreateProcessor",
			Handler:    _DocumentProcessorService_CreateProcessor_Handler,
		},
		{
			MethodName: "DeleteProcessor",
			Handler:    _DocumentProcessorService_DeleteProcessor_Handler,
		},
		{
			MethodName: "EnableProcessor",
			Handler:    _DocumentProcessorService_EnableProcessor_Handler,
		},
		{
			MethodName: "DisableProcessor",
			Handler:    _DocumentProcessorService_DisableProcessor_Handler,
		},
		{
			MethodName: "SetDefaultProcessorVersion",
			Handler:    _DocumentProcessorService_SetDefaultProcessorVersion_Handler,
		},
		{
			MethodName: "ReviewDocument",
			Handler:    _DocumentProcessorService_ReviewDocument_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/documentai/v1beta3/document_processor_service.proto",
}
