// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/bigquery/migration/v2alpha/translation_task.proto

package migrationpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The file encoding types.
type TranslationTaskDetails_FileEncoding int32

const (
	// File encoding setting is not specified.
	TranslationTaskDetails_FILE_ENCODING_UNSPECIFIED TranslationTaskDetails_FileEncoding = 0
	// File encoding is UTF_8.
	TranslationTaskDetails_UTF_8 TranslationTaskDetails_FileEncoding = 1
	// File encoding is ISO_8859_1.
	TranslationTaskDetails_ISO_8859_1 TranslationTaskDetails_FileEncoding = 2
	// File encoding is US_ASCII.
	TranslationTaskDetails_US_ASCII TranslationTaskDetails_FileEncoding = 3
	// File encoding is UTF_16.
	TranslationTaskDetails_UTF_16 TranslationTaskDetails_FileEncoding = 4
	// File encoding is UTF_16LE.
	TranslationTaskDetails_UTF_16LE TranslationTaskDetails_FileEncoding = 5
	// File encoding is UTF_16BE.
	TranslationTaskDetails_UTF_16BE TranslationTaskDetails_FileEncoding = 6
)

// Enum value maps for TranslationTaskDetails_FileEncoding.
var (
	TranslationTaskDetails_FileEncoding_name = map[int32]string{
		0: "FILE_ENCODING_UNSPECIFIED",
		1: "UTF_8",
		2: "ISO_8859_1",
		3: "US_ASCII",
		4: "UTF_16",
		5: "UTF_16LE",
		6: "UTF_16BE",
	}
	TranslationTaskDetails_FileEncoding_value = map[string]int32{
		"FILE_ENCODING_UNSPECIFIED": 0,
		"UTF_8":                     1,
		"ISO_8859_1":                2,
		"US_ASCII":                  3,
		"UTF_16":                    4,
		"UTF_16LE":                  5,
		"UTF_16BE":                  6,
	}
)

func (x TranslationTaskDetails_FileEncoding) Enum() *TranslationTaskDetails_FileEncoding {
	p := new(TranslationTaskDetails_FileEncoding)
	*p = x
	return p
}

func (x TranslationTaskDetails_FileEncoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TranslationTaskDetails_FileEncoding) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_enumTypes[0].Descriptor()
}

func (TranslationTaskDetails_FileEncoding) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_enumTypes[0]
}

func (x TranslationTaskDetails_FileEncoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TranslationTaskDetails_FileEncoding.Descriptor instead.
func (TranslationTaskDetails_FileEncoding) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDescGZIP(), []int{1, 0}
}

// The special token data type.
type TranslationTaskDetails_TokenType int32

const (
	// Token type is not specified.
	TranslationTaskDetails_TOKEN_TYPE_UNSPECIFIED TranslationTaskDetails_TokenType = 0
	// Token type as string.
	TranslationTaskDetails_STRING TranslationTaskDetails_TokenType = 1
	// Token type as integer.
	TranslationTaskDetails_INT64 TranslationTaskDetails_TokenType = 2
	// Token type as numeric.
	TranslationTaskDetails_NUMERIC TranslationTaskDetails_TokenType = 3
	// Token type as boolean.
	TranslationTaskDetails_BOOL TranslationTaskDetails_TokenType = 4
	// Token type as float.
	TranslationTaskDetails_FLOAT64 TranslationTaskDetails_TokenType = 5
	// Token type as date.
	TranslationTaskDetails_DATE TranslationTaskDetails_TokenType = 6
	// Token type as timestamp.
	TranslationTaskDetails_TIMESTAMP TranslationTaskDetails_TokenType = 7
)

// Enum value maps for TranslationTaskDetails_TokenType.
var (
	TranslationTaskDetails_TokenType_name = map[int32]string{
		0: "TOKEN_TYPE_UNSPECIFIED",
		1: "STRING",
		2: "INT64",
		3: "NUMERIC",
		4: "BOOL",
		5: "FLOAT64",
		6: "DATE",
		7: "TIMESTAMP",
	}
	TranslationTaskDetails_TokenType_value = map[string]int32{
		"TOKEN_TYPE_UNSPECIFIED": 0,
		"STRING":                 1,
		"INT64":                  2,
		"NUMERIC":                3,
		"BOOL":                   4,
		"FLOAT64":                5,
		"DATE":                   6,
		"TIMESTAMP":              7,
	}
)

func (x TranslationTaskDetails_TokenType) Enum() *TranslationTaskDetails_TokenType {
	p := new(TranslationTaskDetails_TokenType)
	*p = x
	return p
}

func (x TranslationTaskDetails_TokenType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TranslationTaskDetails_TokenType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_enumTypes[1].Descriptor()
}

func (TranslationTaskDetails_TokenType) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_enumTypes[1]
}

func (x TranslationTaskDetails_TokenType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TranslationTaskDetails_TokenType.Descriptor instead.
func (TranslationTaskDetails_TokenType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDescGZIP(), []int{1, 1}
}

// The identifier case type.
type IdentifierSettings_IdentifierCase int32

const (
	// The identifier case is not specified.
	IdentifierSettings_IDENTIFIER_CASE_UNSPECIFIED IdentifierSettings_IdentifierCase = 0
	// Identifiers' cases will be kept as the original cases.
	IdentifierSettings_ORIGINAL IdentifierSettings_IdentifierCase = 1
	// Identifiers will be in upper cases.
	IdentifierSettings_UPPER IdentifierSettings_IdentifierCase = 2
	// Identifiers will be in lower cases.
	IdentifierSettings_LOWER IdentifierSettings_IdentifierCase = 3
)

// Enum value maps for IdentifierSettings_IdentifierCase.
var (
	IdentifierSettings_IdentifierCase_name = map[int32]string{
		0: "IDENTIFIER_CASE_UNSPECIFIED",
		1: "ORIGINAL",
		2: "UPPER",
		3: "LOWER",
	}
	IdentifierSettings_IdentifierCase_value = map[string]int32{
		"IDENTIFIER_CASE_UNSPECIFIED": 0,
		"ORIGINAL":                    1,
		"UPPER":                       2,
		"LOWER":                       3,
	}
)

func (x IdentifierSettings_IdentifierCase) Enum() *IdentifierSettings_IdentifierCase {
	p := new(IdentifierSettings_IdentifierCase)
	*p = x
	return p
}

func (x IdentifierSettings_IdentifierCase) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IdentifierSettings_IdentifierCase) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_enumTypes[2].Descriptor()
}

func (IdentifierSettings_IdentifierCase) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_enumTypes[2]
}

func (x IdentifierSettings_IdentifierCase) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IdentifierSettings_IdentifierCase.Descriptor instead.
func (IdentifierSettings_IdentifierCase) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDescGZIP(), []int{3, 0}
}

// The SQL identifier rewrite mode.
type IdentifierSettings_IdentifierRewriteMode int32

const (
	// SQL Identifier rewrite mode is unspecified.
	IdentifierSettings_IDENTIFIER_REWRITE_MODE_UNSPECIFIED IdentifierSettings_IdentifierRewriteMode = 0
	// SQL identifiers won't be rewrite.
	IdentifierSettings_NONE IdentifierSettings_IdentifierRewriteMode = 1
	// All SQL identifiers will be rewrite.
	IdentifierSettings_REWRITE_ALL IdentifierSettings_IdentifierRewriteMode = 2
)

// Enum value maps for IdentifierSettings_IdentifierRewriteMode.
var (
	IdentifierSettings_IdentifierRewriteMode_name = map[int32]string{
		0: "IDENTIFIER_REWRITE_MODE_UNSPECIFIED",
		1: "NONE",
		2: "REWRITE_ALL",
	}
	IdentifierSettings_IdentifierRewriteMode_value = map[string]int32{
		"IDENTIFIER_REWRITE_MODE_UNSPECIFIED": 0,
		"NONE":                                1,
		"REWRITE_ALL":                         2,
	}
)

func (x IdentifierSettings_IdentifierRewriteMode) Enum() *IdentifierSettings_IdentifierRewriteMode {
	p := new(IdentifierSettings_IdentifierRewriteMode)
	*p = x
	return p
}

func (x IdentifierSettings_IdentifierRewriteMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IdentifierSettings_IdentifierRewriteMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_enumTypes[3].Descriptor()
}

func (IdentifierSettings_IdentifierRewriteMode) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_enumTypes[3]
}

func (x IdentifierSettings_IdentifierRewriteMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IdentifierSettings_IdentifierRewriteMode.Descriptor instead.
func (IdentifierSettings_IdentifierRewriteMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDescGZIP(), []int{3, 1}
}

// Mapping between an input and output file to be translated in a subtask.
type TranslationFileMapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud Storage path for a file to translation in a subtask.
	InputPath string `protobuf:"bytes,1,opt,name=input_path,json=inputPath,proto3" json:"input_path,omitempty"`
	// The Cloud Storage path to write back the corresponding input file to.
	OutputPath string `protobuf:"bytes,2,opt,name=output_path,json=outputPath,proto3" json:"output_path,omitempty"`
}

func (x *TranslationFileMapping) Reset() {
	*x = TranslationFileMapping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TranslationFileMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranslationFileMapping) ProtoMessage() {}

func (x *TranslationFileMapping) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranslationFileMapping.ProtoReflect.Descriptor instead.
func (*TranslationFileMapping) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDescGZIP(), []int{0}
}

func (x *TranslationFileMapping) GetInputPath() string {
	if x != nil {
		return x.InputPath
	}
	return ""
}

func (x *TranslationFileMapping) GetOutputPath() string {
	if x != nil {
		return x.OutputPath
	}
	return ""
}

// The translation task config to capture necessary settings for a translation
// task and subtask.
type TranslationTaskDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The language specific settings for the translation task.
	//
	// Types that are assignable to LanguageOptions:
	//
	//	*TranslationTaskDetails_TeradataOptions
	//	*TranslationTaskDetails_BteqOptions
	LanguageOptions isTranslationTaskDetails_LanguageOptions `protobuf_oneof:"language_options"`
	// The Cloud Storage path for translation input files.
	InputPath string `protobuf:"bytes,1,opt,name=input_path,json=inputPath,proto3" json:"input_path,omitempty"`
	// The Cloud Storage path for translation output files.
	OutputPath string `protobuf:"bytes,2,opt,name=output_path,json=outputPath,proto3" json:"output_path,omitempty"`
	// Cloud Storage files to be processed for translation.
	FilePaths []*TranslationFileMapping `protobuf:"bytes,12,rep,name=file_paths,json=filePaths,proto3" json:"file_paths,omitempty"`
	// The Cloud Storage path to DDL files as table schema to assist semantic
	// translation.
	SchemaPath string `protobuf:"bytes,3,opt,name=schema_path,json=schemaPath,proto3" json:"schema_path,omitempty"`
	// The file encoding type.
	FileEncoding TranslationTaskDetails_FileEncoding `protobuf:"varint,4,opt,name=file_encoding,json=fileEncoding,proto3,enum=google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails_FileEncoding" json:"file_encoding,omitempty"`
	// The settings for SQL identifiers.
	IdentifierSettings *IdentifierSettings `protobuf:"bytes,5,opt,name=identifier_settings,json=identifierSettings,proto3" json:"identifier_settings,omitempty"`
	// The map capturing special tokens to be replaced during translation. The key
	// is special token in string. The value is the token data type. This is used
	// to translate SQL query template which contains special token as place
	// holder. The special token makes a query invalid to parse. This map will be
	// applied to annotate those special token with types to let parser understand
	// how to parse them into proper structure with type information.
	SpecialTokenMap map[string]TranslationTaskDetails_TokenType `protobuf:"bytes,6,rep,name=special_token_map,json=specialTokenMap,proto3" json:"special_token_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails_TokenType"`
	// The filter applied to translation details.
	Filter *Filter `protobuf:"bytes,7,opt,name=filter,proto3" json:"filter,omitempty"`
	// Specifies the exact name of the bigquery table ("dataset.table") to be used
	// for surfacing raw translation errors. If the table does not exist, we will
	// create it. If it already exists and the schema is the same, we will re-use.
	// If the table exists and the schema is different, we will throw an error.
	TranslationExceptionTable string `protobuf:"bytes,13,opt,name=translation_exception_table,json=translationExceptionTable,proto3" json:"translation_exception_table,omitempty"`
}

func (x *TranslationTaskDetails) Reset() {
	*x = TranslationTaskDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TranslationTaskDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranslationTaskDetails) ProtoMessage() {}

func (x *TranslationTaskDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranslationTaskDetails.ProtoReflect.Descriptor instead.
func (*TranslationTaskDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDescGZIP(), []int{1}
}

func (m *TranslationTaskDetails) GetLanguageOptions() isTranslationTaskDetails_LanguageOptions {
	if m != nil {
		return m.LanguageOptions
	}
	return nil
}

func (x *TranslationTaskDetails) GetTeradataOptions() *TeradataOptions {
	if x, ok := x.GetLanguageOptions().(*TranslationTaskDetails_TeradataOptions); ok {
		return x.TeradataOptions
	}
	return nil
}

func (x *TranslationTaskDetails) GetBteqOptions() *BteqOptions {
	if x, ok := x.GetLanguageOptions().(*TranslationTaskDetails_BteqOptions); ok {
		return x.BteqOptions
	}
	return nil
}

func (x *TranslationTaskDetails) GetInputPath() string {
	if x != nil {
		return x.InputPath
	}
	return ""
}

func (x *TranslationTaskDetails) GetOutputPath() string {
	if x != nil {
		return x.OutputPath
	}
	return ""
}

func (x *TranslationTaskDetails) GetFilePaths() []*TranslationFileMapping {
	if x != nil {
		return x.FilePaths
	}
	return nil
}

func (x *TranslationTaskDetails) GetSchemaPath() string {
	if x != nil {
		return x.SchemaPath
	}
	return ""
}

func (x *TranslationTaskDetails) GetFileEncoding() TranslationTaskDetails_FileEncoding {
	if x != nil {
		return x.FileEncoding
	}
	return TranslationTaskDetails_FILE_ENCODING_UNSPECIFIED
}

func (x *TranslationTaskDetails) GetIdentifierSettings() *IdentifierSettings {
	if x != nil {
		return x.IdentifierSettings
	}
	return nil
}

func (x *TranslationTaskDetails) GetSpecialTokenMap() map[string]TranslationTaskDetails_TokenType {
	if x != nil {
		return x.SpecialTokenMap
	}
	return nil
}

func (x *TranslationTaskDetails) GetFilter() *Filter {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *TranslationTaskDetails) GetTranslationExceptionTable() string {
	if x != nil {
		return x.TranslationExceptionTable
	}
	return ""
}

type isTranslationTaskDetails_LanguageOptions interface {
	isTranslationTaskDetails_LanguageOptions()
}

type TranslationTaskDetails_TeradataOptions struct {
	// The Teradata SQL specific settings for the translation task.
	TeradataOptions *TeradataOptions `protobuf:"bytes,10,opt,name=teradata_options,json=teradataOptions,proto3,oneof"`
}

type TranslationTaskDetails_BteqOptions struct {
	// The BTEQ specific settings for the translation task.
	BteqOptions *BteqOptions `protobuf:"bytes,11,opt,name=bteq_options,json=bteqOptions,proto3,oneof"`
}

func (*TranslationTaskDetails_TeradataOptions) isTranslationTaskDetails_LanguageOptions() {}

func (*TranslationTaskDetails_BteqOptions) isTranslationTaskDetails_LanguageOptions() {}

// The filter applied to fields of translation details.
type Filter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of prefixes used to exclude processing for input files.
	InputFileExclusionPrefixes []string `protobuf:"bytes,1,rep,name=input_file_exclusion_prefixes,json=inputFileExclusionPrefixes,proto3" json:"input_file_exclusion_prefixes,omitempty"`
}

func (x *Filter) Reset() {
	*x = Filter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Filter) ProtoMessage() {}

func (x *Filter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Filter.ProtoReflect.Descriptor instead.
func (*Filter) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDescGZIP(), []int{2}
}

func (x *Filter) GetInputFileExclusionPrefixes() []string {
	if x != nil {
		return x.InputFileExclusionPrefixes
	}
	return nil
}

// Settings related to SQL identifiers.
type IdentifierSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The setting to control output queries' identifier case.
	OutputIdentifierCase IdentifierSettings_IdentifierCase `protobuf:"varint,1,opt,name=output_identifier_case,json=outputIdentifierCase,proto3,enum=google.cloud.bigquery.migration.v2alpha.IdentifierSettings_IdentifierCase" json:"output_identifier_case,omitempty"`
	// Specifies the rewrite mode for SQL identifiers.
	IdentifierRewriteMode IdentifierSettings_IdentifierRewriteMode `protobuf:"varint,2,opt,name=identifier_rewrite_mode,json=identifierRewriteMode,proto3,enum=google.cloud.bigquery.migration.v2alpha.IdentifierSettings_IdentifierRewriteMode" json:"identifier_rewrite_mode,omitempty"`
}

func (x *IdentifierSettings) Reset() {
	*x = IdentifierSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IdentifierSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IdentifierSettings) ProtoMessage() {}

func (x *IdentifierSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IdentifierSettings.ProtoReflect.Descriptor instead.
func (*IdentifierSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDescGZIP(), []int{3}
}

func (x *IdentifierSettings) GetOutputIdentifierCase() IdentifierSettings_IdentifierCase {
	if x != nil {
		return x.OutputIdentifierCase
	}
	return IdentifierSettings_IDENTIFIER_CASE_UNSPECIFIED
}

func (x *IdentifierSettings) GetIdentifierRewriteMode() IdentifierSettings_IdentifierRewriteMode {
	if x != nil {
		return x.IdentifierRewriteMode
	}
	return IdentifierSettings_IDENTIFIER_REWRITE_MODE_UNSPECIFIED
}

// Teradata SQL specific translation task related settings.
type TeradataOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *TeradataOptions) Reset() {
	*x = TeradataOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TeradataOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TeradataOptions) ProtoMessage() {}

func (x *TeradataOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TeradataOptions.ProtoReflect.Descriptor instead.
func (*TeradataOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDescGZIP(), []int{4}
}

// BTEQ translation task related settings.
type BteqOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the project and dataset in BigQuery that will be used for
	// external table creation during the translation.
	ProjectDataset *DatasetReference `protobuf:"bytes,1,opt,name=project_dataset,json=projectDataset,proto3" json:"project_dataset,omitempty"`
	// The Cloud Storage location to be used as the default path for files that
	// are not otherwise specified in the file replacement map.
	DefaultPathUri string `protobuf:"bytes,2,opt,name=default_path_uri,json=defaultPathUri,proto3" json:"default_path_uri,omitempty"`
	// Maps the local paths that are used in BTEQ scripts (the keys) to the paths
	// in Cloud Storage that should be used in their stead in the translation (the
	// value).
	FileReplacementMap map[string]string `protobuf:"bytes,3,rep,name=file_replacement_map,json=fileReplacementMap,proto3" json:"file_replacement_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BteqOptions) Reset() {
	*x = BteqOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BteqOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BteqOptions) ProtoMessage() {}

func (x *BteqOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BteqOptions.ProtoReflect.Descriptor instead.
func (*BteqOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDescGZIP(), []int{5}
}

func (x *BteqOptions) GetProjectDataset() *DatasetReference {
	if x != nil {
		return x.ProjectDataset
	}
	return nil
}

func (x *BteqOptions) GetDefaultPathUri() string {
	if x != nil {
		return x.DefaultPathUri
	}
	return ""
}

func (x *BteqOptions) GetFileReplacementMap() map[string]string {
	if x != nil {
		return x.FileReplacementMap
	}
	return nil
}

// Reference to a BigQuery dataset.
type DatasetReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique ID for this dataset, without the project name. The ID
	// must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
	// The maximum length is 1,024 characters.
	DatasetId string `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// The ID of the project containing this dataset.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *DatasetReference) Reset() {
	*x = DatasetReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatasetReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatasetReference) ProtoMessage() {}

func (x *DatasetReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatasetReference.ProtoReflect.Descriptor instead.
func (*DatasetReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDescGZIP(), []int{6}
}

func (x *DatasetReference) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *DatasetReference) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

var File_google_cloud_bigquery_migration_v2alpha_translation_task_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDesc = []byte{
	0x0a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x22, 0x58, 0x0a, 0x16, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x4d, 0x61, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x1f, 0x0a, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x50,
	0x61, 0x74, 0x68, 0x22, 0xa9, 0x0a, 0x0a, 0x16, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x61, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x65,
	0x0a, 0x10, 0x74, 0x65, 0x72, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x54, 0x65, 0x72, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x48, 0x00, 0x52, 0x0f, 0x74, 0x65, 0x72, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x59, 0x0a, 0x0c, 0x62, 0x74, 0x65, 0x71, 0x5f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x74, 0x65, 0x71, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x48, 0x00, 0x52, 0x0b, 0x62, 0x74, 0x65, 0x71, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12,
	0x1f, 0x0a, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x50, 0x61, 0x74, 0x68,
	0x12, 0x5e, 0x0a, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x0c,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x4d, 0x61,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x74, 0x68, 0x73,
	0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x50, 0x61, 0x74,
	0x68, 0x12, 0x71, 0x0a, 0x0d, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61,
	0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x45, 0x6e,
	0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0c, 0x66, 0x69, 0x6c, 0x65, 0x45, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x6c, 0x0a, 0x13, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x12,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x80, 0x01, 0x0a, 0x11, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x54,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e,
	0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x4d, 0x61, 0x70, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x4d, 0x61, 0x70, 0x12, 0x47, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x3e,
	0x0a, 0x1b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x78,
	0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x19, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x1a, 0x8d,
	0x01, 0x0a, 0x14, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x4d,
	0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x5f, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61,
	0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x7e,
	0x0a, 0x0c, 0x46, 0x69, 0x6c, 0x65, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x1d,
	0x0a, 0x19, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a,
	0x05, 0x55, 0x54, 0x46, 0x5f, 0x38, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x53, 0x4f, 0x5f,
	0x38, 0x38, 0x35, 0x39, 0x5f, 0x31, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x53, 0x5f, 0x41,
	0x53, 0x43, 0x49, 0x49, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x54, 0x46, 0x5f, 0x31, 0x36,
	0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x54, 0x46, 0x5f, 0x31, 0x36, 0x4c, 0x45, 0x10, 0x05,
	0x12, 0x0c, 0x0a, 0x08, 0x55, 0x54, 0x46, 0x5f, 0x31, 0x36, 0x42, 0x45, 0x10, 0x06, 0x22, 0x7b,
	0x0a, 0x09, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x54,
	0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4e, 0x54, 0x36, 0x34, 0x10, 0x02, 0x12, 0x0b,
	0x0a, 0x07, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x42,
	0x4f, 0x4f, 0x4c, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x4c, 0x4f, 0x41, 0x54, 0x36, 0x34,
	0x10, 0x05, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x41, 0x54, 0x45, 0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09,
	0x54, 0x49, 0x4d, 0x45, 0x53, 0x54, 0x41, 0x4d, 0x50, 0x10, 0x07, 0x42, 0x12, 0x0a, 0x10, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0x4b, 0x0a, 0x06, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x41, 0x0a, 0x1d, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x1a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x45, 0x78, 0x63, 0x6c, 0x75,
	0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x22, 0xd7, 0x03, 0x0a,
	0x12, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x80, 0x01, 0x0a, 0x16, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x43, 0x61, 0x73, 0x65,
	0x52, 0x14, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x43, 0x61, 0x73, 0x65, 0x12, 0x89, 0x01, 0x0a, 0x17, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x15, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x22, 0x55, 0x0a, 0x0e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x43, 0x61, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x46, 0x49,
	0x45, 0x52, 0x5f, 0x43, 0x41, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x52, 0x49, 0x47, 0x49, 0x4e, 0x41,
	0x4c, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x55, 0x50, 0x50, 0x45, 0x52, 0x10, 0x02, 0x12, 0x09,
	0x0a, 0x05, 0x4c, 0x4f, 0x57, 0x45, 0x52, 0x10, 0x03, 0x22, 0x5b, 0x0a, 0x15, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x27, 0x0a, 0x23, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x46, 0x49, 0x45, 0x52,
	0x5f, 0x52, 0x45, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4e,
	0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x57, 0x52, 0x49, 0x54, 0x45,
	0x5f, 0x41, 0x4c, 0x4c, 0x10, 0x02, 0x22, 0x11, 0x0a, 0x0f, 0x54, 0x65, 0x72, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xe2, 0x02, 0x0a, 0x0b, 0x42, 0x74,
	0x65, 0x71, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x62, 0x0a, 0x0f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0e, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x28, 0x0a,
	0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x50, 0x61, 0x74, 0x68, 0x55, 0x72, 0x69, 0x12, 0x7e, 0x0a, 0x14, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x61, 0x70, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x42, 0x74, 0x65, 0x71, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x46, 0x69, 0x6c, 0x65,
	0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x70, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x12, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x70, 0x1a, 0x45, 0x0a, 0x17, 0x46, 0x69, 0x6c, 0x65, 0x52,
	0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x50,
	0x0a, 0x10, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49,
	0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64,
	0x42, 0xe4, 0x01, 0x0a, 0x2b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x42, 0x14, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x73,
	0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x49, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0x3b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x70, 0x62, 0xaa, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x32, 0x41, 0x6c, 0x70, 0x68, 0x61, 0xca, 0x02, 0x27,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x5c, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5c,
	0x56, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDescData = file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDesc
)

func file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDescData)
	})
	return file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDescData
}

var file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_goTypes = []any{
	(TranslationTaskDetails_FileEncoding)(0),      // 0: google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding
	(TranslationTaskDetails_TokenType)(0),         // 1: google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType
	(IdentifierSettings_IdentifierCase)(0),        // 2: google.cloud.bigquery.migration.v2alpha.IdentifierSettings.IdentifierCase
	(IdentifierSettings_IdentifierRewriteMode)(0), // 3: google.cloud.bigquery.migration.v2alpha.IdentifierSettings.IdentifierRewriteMode
	(*TranslationFileMapping)(nil),                // 4: google.cloud.bigquery.migration.v2alpha.TranslationFileMapping
	(*TranslationTaskDetails)(nil),                // 5: google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
	(*Filter)(nil),                                // 6: google.cloud.bigquery.migration.v2alpha.Filter
	(*IdentifierSettings)(nil),                    // 7: google.cloud.bigquery.migration.v2alpha.IdentifierSettings
	(*TeradataOptions)(nil),                       // 8: google.cloud.bigquery.migration.v2alpha.TeradataOptions
	(*BteqOptions)(nil),                           // 9: google.cloud.bigquery.migration.v2alpha.BteqOptions
	(*DatasetReference)(nil),                      // 10: google.cloud.bigquery.migration.v2alpha.DatasetReference
	nil,                                           // 11: google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.SpecialTokenMapEntry
	nil,                                           // 12: google.cloud.bigquery.migration.v2alpha.BteqOptions.FileReplacementMapEntry
}
var file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_depIdxs = []int32{
	8,  // 0: google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.teradata_options:type_name -> google.cloud.bigquery.migration.v2alpha.TeradataOptions
	9,  // 1: google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.bteq_options:type_name -> google.cloud.bigquery.migration.v2alpha.BteqOptions
	4,  // 2: google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.file_paths:type_name -> google.cloud.bigquery.migration.v2alpha.TranslationFileMapping
	0,  // 3: google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.file_encoding:type_name -> google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.FileEncoding
	7,  // 4: google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.identifier_settings:type_name -> google.cloud.bigquery.migration.v2alpha.IdentifierSettings
	11, // 5: google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.special_token_map:type_name -> google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.SpecialTokenMapEntry
	6,  // 6: google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.filter:type_name -> google.cloud.bigquery.migration.v2alpha.Filter
	2,  // 7: google.cloud.bigquery.migration.v2alpha.IdentifierSettings.output_identifier_case:type_name -> google.cloud.bigquery.migration.v2alpha.IdentifierSettings.IdentifierCase
	3,  // 8: google.cloud.bigquery.migration.v2alpha.IdentifierSettings.identifier_rewrite_mode:type_name -> google.cloud.bigquery.migration.v2alpha.IdentifierSettings.IdentifierRewriteMode
	10, // 9: google.cloud.bigquery.migration.v2alpha.BteqOptions.project_dataset:type_name -> google.cloud.bigquery.migration.v2alpha.DatasetReference
	12, // 10: google.cloud.bigquery.migration.v2alpha.BteqOptions.file_replacement_map:type_name -> google.cloud.bigquery.migration.v2alpha.BteqOptions.FileReplacementMapEntry
	1,  // 11: google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.SpecialTokenMapEntry.value:type_name -> google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails.TokenType
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_init() }
func file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_init() {
	if File_google_cloud_bigquery_migration_v2alpha_translation_task_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*TranslationFileMapping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*TranslationTaskDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*Filter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*IdentifierSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*TeradataOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*BteqOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*DatasetReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes[1].OneofWrappers = []any{
		(*TranslationTaskDetails_TeradataOptions)(nil),
		(*TranslationTaskDetails_BteqOptions)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_depIdxs,
		EnumInfos:         file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_enumTypes,
		MessageInfos:      file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_migration_v2alpha_translation_task_proto = out.File
	file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_rawDesc = nil
	file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_goTypes = nil
	file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_depIdxs = nil
}
