// Copyright 2023-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: buf/registry/module/v1/label_service.proto

package modulev1connect

import (
	v1 "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/module/v1"
	connect "connectrpc.com/connect"
	context "context"
	errors "errors"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// LabelServiceName is the fully-qualified name of the LabelService service.
	LabelServiceName = "buf.registry.module.v1.LabelService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// LabelServiceGetLabelsProcedure is the fully-qualified name of the LabelService's GetLabels RPC.
	LabelServiceGetLabelsProcedure = "/buf.registry.module.v1.LabelService/GetLabels"
	// LabelServiceListLabelsProcedure is the fully-qualified name of the LabelService's ListLabels RPC.
	LabelServiceListLabelsProcedure = "/buf.registry.module.v1.LabelService/ListLabels"
	// LabelServiceListLabelHistoryProcedure is the fully-qualified name of the LabelService's
	// ListLabelHistory RPC.
	LabelServiceListLabelHistoryProcedure = "/buf.registry.module.v1.LabelService/ListLabelHistory"
	// LabelServiceCreateOrUpdateLabelsProcedure is the fully-qualified name of the LabelService's
	// CreateOrUpdateLabels RPC.
	LabelServiceCreateOrUpdateLabelsProcedure = "/buf.registry.module.v1.LabelService/CreateOrUpdateLabels"
	// LabelServiceArchiveLabelsProcedure is the fully-qualified name of the LabelService's
	// ArchiveLabels RPC.
	LabelServiceArchiveLabelsProcedure = "/buf.registry.module.v1.LabelService/ArchiveLabels"
	// LabelServiceUnarchiveLabelsProcedure is the fully-qualified name of the LabelService's
	// UnarchiveLabels RPC.
	LabelServiceUnarchiveLabelsProcedure = "/buf.registry.module.v1.LabelService/UnarchiveLabels"
)

// These variables are the protoreflect.Descriptor objects for the RPCs defined in this package.
var (
	labelServiceServiceDescriptor                    = v1.File_buf_registry_module_v1_label_service_proto.Services().ByName("LabelService")
	labelServiceGetLabelsMethodDescriptor            = labelServiceServiceDescriptor.Methods().ByName("GetLabels")
	labelServiceListLabelsMethodDescriptor           = labelServiceServiceDescriptor.Methods().ByName("ListLabels")
	labelServiceListLabelHistoryMethodDescriptor     = labelServiceServiceDescriptor.Methods().ByName("ListLabelHistory")
	labelServiceCreateOrUpdateLabelsMethodDescriptor = labelServiceServiceDescriptor.Methods().ByName("CreateOrUpdateLabels")
	labelServiceArchiveLabelsMethodDescriptor        = labelServiceServiceDescriptor.Methods().ByName("ArchiveLabels")
	labelServiceUnarchiveLabelsMethodDescriptor      = labelServiceServiceDescriptor.Methods().ByName("UnarchiveLabels")
)

// LabelServiceClient is a client for the buf.registry.module.v1.LabelService service.
type LabelServiceClient interface {
	// Get Labels by id or name.
	GetLabels(context.Context, *connect.Request[v1.GetLabelsRequest]) (*connect.Response[v1.GetLabelsResponse], error)
	// List Labels for a given Module, Commit, or CommitDigest.
	ListLabels(context.Context, *connect.Request[v1.ListLabelsRequest]) (*connect.Response[v1.ListLabelsResponse], error)
	// List the history of a Label.
	ListLabelHistory(context.Context, *connect.Request[v1.ListLabelHistoryRequest]) (*connect.Response[v1.ListLabelHistoryResponse], error)
	// Create or update Labels on a Module.
	//
	// If the Label does not exist, it will be created.
	// If the Label was archived, it will be unarchived.
	// If the Label already existed, the Commit in the request has to be newer than the Commit that
	// the Label is currently pointing to, otherwise an error is returned.
	//
	// This operation is atomic. Either all Labels are created/updated or an error is returned.
	CreateOrUpdateLabels(context.Context, *connect.Request[v1.CreateOrUpdateLabelsRequest]) (*connect.Response[v1.CreateOrUpdateLabelsResponse], error)
	// Archive existing Labels.
	//
	// This operation is atomic. Either all Labels are archived or an error is returned.
	ArchiveLabels(context.Context, *connect.Request[v1.ArchiveLabelsRequest]) (*connect.Response[v1.ArchiveLabelsResponse], error)
	// Unarchive existing Labels.
	//
	// This operation is atomic. Either all Labels are unarchived or an error is returned.
	UnarchiveLabels(context.Context, *connect.Request[v1.UnarchiveLabelsRequest]) (*connect.Response[v1.UnarchiveLabelsResponse], error)
}

// NewLabelServiceClient constructs a client for the buf.registry.module.v1.LabelService service. By
// default, it uses the Connect protocol with the binary Protobuf Codec, asks for gzipped responses,
// and sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply the
// connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewLabelServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) LabelServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	return &labelServiceClient{
		getLabels: connect.NewClient[v1.GetLabelsRequest, v1.GetLabelsResponse](
			httpClient,
			baseURL+LabelServiceGetLabelsProcedure,
			connect.WithSchema(labelServiceGetLabelsMethodDescriptor),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		listLabels: connect.NewClient[v1.ListLabelsRequest, v1.ListLabelsResponse](
			httpClient,
			baseURL+LabelServiceListLabelsProcedure,
			connect.WithSchema(labelServiceListLabelsMethodDescriptor),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		listLabelHistory: connect.NewClient[v1.ListLabelHistoryRequest, v1.ListLabelHistoryResponse](
			httpClient,
			baseURL+LabelServiceListLabelHistoryProcedure,
			connect.WithSchema(labelServiceListLabelHistoryMethodDescriptor),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		createOrUpdateLabels: connect.NewClient[v1.CreateOrUpdateLabelsRequest, v1.CreateOrUpdateLabelsResponse](
			httpClient,
			baseURL+LabelServiceCreateOrUpdateLabelsProcedure,
			connect.WithSchema(labelServiceCreateOrUpdateLabelsMethodDescriptor),
			connect.WithIdempotency(connect.IdempotencyIdempotent),
			connect.WithClientOptions(opts...),
		),
		archiveLabels: connect.NewClient[v1.ArchiveLabelsRequest, v1.ArchiveLabelsResponse](
			httpClient,
			baseURL+LabelServiceArchiveLabelsProcedure,
			connect.WithSchema(labelServiceArchiveLabelsMethodDescriptor),
			connect.WithIdempotency(connect.IdempotencyIdempotent),
			connect.WithClientOptions(opts...),
		),
		unarchiveLabels: connect.NewClient[v1.UnarchiveLabelsRequest, v1.UnarchiveLabelsResponse](
			httpClient,
			baseURL+LabelServiceUnarchiveLabelsProcedure,
			connect.WithSchema(labelServiceUnarchiveLabelsMethodDescriptor),
			connect.WithIdempotency(connect.IdempotencyIdempotent),
			connect.WithClientOptions(opts...),
		),
	}
}

// labelServiceClient implements LabelServiceClient.
type labelServiceClient struct {
	getLabels            *connect.Client[v1.GetLabelsRequest, v1.GetLabelsResponse]
	listLabels           *connect.Client[v1.ListLabelsRequest, v1.ListLabelsResponse]
	listLabelHistory     *connect.Client[v1.ListLabelHistoryRequest, v1.ListLabelHistoryResponse]
	createOrUpdateLabels *connect.Client[v1.CreateOrUpdateLabelsRequest, v1.CreateOrUpdateLabelsResponse]
	archiveLabels        *connect.Client[v1.ArchiveLabelsRequest, v1.ArchiveLabelsResponse]
	unarchiveLabels      *connect.Client[v1.UnarchiveLabelsRequest, v1.UnarchiveLabelsResponse]
}

// GetLabels calls buf.registry.module.v1.LabelService.GetLabels.
func (c *labelServiceClient) GetLabels(ctx context.Context, req *connect.Request[v1.GetLabelsRequest]) (*connect.Response[v1.GetLabelsResponse], error) {
	return c.getLabels.CallUnary(ctx, req)
}

// ListLabels calls buf.registry.module.v1.LabelService.ListLabels.
func (c *labelServiceClient) ListLabels(ctx context.Context, req *connect.Request[v1.ListLabelsRequest]) (*connect.Response[v1.ListLabelsResponse], error) {
	return c.listLabels.CallUnary(ctx, req)
}

// ListLabelHistory calls buf.registry.module.v1.LabelService.ListLabelHistory.
func (c *labelServiceClient) ListLabelHistory(ctx context.Context, req *connect.Request[v1.ListLabelHistoryRequest]) (*connect.Response[v1.ListLabelHistoryResponse], error) {
	return c.listLabelHistory.CallUnary(ctx, req)
}

// CreateOrUpdateLabels calls buf.registry.module.v1.LabelService.CreateOrUpdateLabels.
func (c *labelServiceClient) CreateOrUpdateLabels(ctx context.Context, req *connect.Request[v1.CreateOrUpdateLabelsRequest]) (*connect.Response[v1.CreateOrUpdateLabelsResponse], error) {
	return c.createOrUpdateLabels.CallUnary(ctx, req)
}

// ArchiveLabels calls buf.registry.module.v1.LabelService.ArchiveLabels.
func (c *labelServiceClient) ArchiveLabels(ctx context.Context, req *connect.Request[v1.ArchiveLabelsRequest]) (*connect.Response[v1.ArchiveLabelsResponse], error) {
	return c.archiveLabels.CallUnary(ctx, req)
}

// UnarchiveLabels calls buf.registry.module.v1.LabelService.UnarchiveLabels.
func (c *labelServiceClient) UnarchiveLabels(ctx context.Context, req *connect.Request[v1.UnarchiveLabelsRequest]) (*connect.Response[v1.UnarchiveLabelsResponse], error) {
	return c.unarchiveLabels.CallUnary(ctx, req)
}

// LabelServiceHandler is an implementation of the buf.registry.module.v1.LabelService service.
type LabelServiceHandler interface {
	// Get Labels by id or name.
	GetLabels(context.Context, *connect.Request[v1.GetLabelsRequest]) (*connect.Response[v1.GetLabelsResponse], error)
	// List Labels for a given Module, Commit, or CommitDigest.
	ListLabels(context.Context, *connect.Request[v1.ListLabelsRequest]) (*connect.Response[v1.ListLabelsResponse], error)
	// List the history of a Label.
	ListLabelHistory(context.Context, *connect.Request[v1.ListLabelHistoryRequest]) (*connect.Response[v1.ListLabelHistoryResponse], error)
	// Create or update Labels on a Module.
	//
	// If the Label does not exist, it will be created.
	// If the Label was archived, it will be unarchived.
	// If the Label already existed, the Commit in the request has to be newer than the Commit that
	// the Label is currently pointing to, otherwise an error is returned.
	//
	// This operation is atomic. Either all Labels are created/updated or an error is returned.
	CreateOrUpdateLabels(context.Context, *connect.Request[v1.CreateOrUpdateLabelsRequest]) (*connect.Response[v1.CreateOrUpdateLabelsResponse], error)
	// Archive existing Labels.
	//
	// This operation is atomic. Either all Labels are archived or an error is returned.
	ArchiveLabels(context.Context, *connect.Request[v1.ArchiveLabelsRequest]) (*connect.Response[v1.ArchiveLabelsResponse], error)
	// Unarchive existing Labels.
	//
	// This operation is atomic. Either all Labels are unarchived or an error is returned.
	UnarchiveLabels(context.Context, *connect.Request[v1.UnarchiveLabelsRequest]) (*connect.Response[v1.UnarchiveLabelsResponse], error)
}

// NewLabelServiceHandler builds an HTTP handler from the service implementation. It returns the
// path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewLabelServiceHandler(svc LabelServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	labelServiceGetLabelsHandler := connect.NewUnaryHandler(
		LabelServiceGetLabelsProcedure,
		svc.GetLabels,
		connect.WithSchema(labelServiceGetLabelsMethodDescriptor),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	labelServiceListLabelsHandler := connect.NewUnaryHandler(
		LabelServiceListLabelsProcedure,
		svc.ListLabels,
		connect.WithSchema(labelServiceListLabelsMethodDescriptor),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	labelServiceListLabelHistoryHandler := connect.NewUnaryHandler(
		LabelServiceListLabelHistoryProcedure,
		svc.ListLabelHistory,
		connect.WithSchema(labelServiceListLabelHistoryMethodDescriptor),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	labelServiceCreateOrUpdateLabelsHandler := connect.NewUnaryHandler(
		LabelServiceCreateOrUpdateLabelsProcedure,
		svc.CreateOrUpdateLabels,
		connect.WithSchema(labelServiceCreateOrUpdateLabelsMethodDescriptor),
		connect.WithIdempotency(connect.IdempotencyIdempotent),
		connect.WithHandlerOptions(opts...),
	)
	labelServiceArchiveLabelsHandler := connect.NewUnaryHandler(
		LabelServiceArchiveLabelsProcedure,
		svc.ArchiveLabels,
		connect.WithSchema(labelServiceArchiveLabelsMethodDescriptor),
		connect.WithIdempotency(connect.IdempotencyIdempotent),
		connect.WithHandlerOptions(opts...),
	)
	labelServiceUnarchiveLabelsHandler := connect.NewUnaryHandler(
		LabelServiceUnarchiveLabelsProcedure,
		svc.UnarchiveLabels,
		connect.WithSchema(labelServiceUnarchiveLabelsMethodDescriptor),
		connect.WithIdempotency(connect.IdempotencyIdempotent),
		connect.WithHandlerOptions(opts...),
	)
	return "/buf.registry.module.v1.LabelService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case LabelServiceGetLabelsProcedure:
			labelServiceGetLabelsHandler.ServeHTTP(w, r)
		case LabelServiceListLabelsProcedure:
			labelServiceListLabelsHandler.ServeHTTP(w, r)
		case LabelServiceListLabelHistoryProcedure:
			labelServiceListLabelHistoryHandler.ServeHTTP(w, r)
		case LabelServiceCreateOrUpdateLabelsProcedure:
			labelServiceCreateOrUpdateLabelsHandler.ServeHTTP(w, r)
		case LabelServiceArchiveLabelsProcedure:
			labelServiceArchiveLabelsHandler.ServeHTTP(w, r)
		case LabelServiceUnarchiveLabelsProcedure:
			labelServiceUnarchiveLabelsHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedLabelServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedLabelServiceHandler struct{}

func (UnimplementedLabelServiceHandler) GetLabels(context.Context, *connect.Request[v1.GetLabelsRequest]) (*connect.Response[v1.GetLabelsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.module.v1.LabelService.GetLabels is not implemented"))
}

func (UnimplementedLabelServiceHandler) ListLabels(context.Context, *connect.Request[v1.ListLabelsRequest]) (*connect.Response[v1.ListLabelsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.module.v1.LabelService.ListLabels is not implemented"))
}

func (UnimplementedLabelServiceHandler) ListLabelHistory(context.Context, *connect.Request[v1.ListLabelHistoryRequest]) (*connect.Response[v1.ListLabelHistoryResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.module.v1.LabelService.ListLabelHistory is not implemented"))
}

func (UnimplementedLabelServiceHandler) CreateOrUpdateLabels(context.Context, *connect.Request[v1.CreateOrUpdateLabelsRequest]) (*connect.Response[v1.CreateOrUpdateLabelsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.module.v1.LabelService.CreateOrUpdateLabels is not implemented"))
}

func (UnimplementedLabelServiceHandler) ArchiveLabels(context.Context, *connect.Request[v1.ArchiveLabelsRequest]) (*connect.Response[v1.ArchiveLabelsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.module.v1.LabelService.ArchiveLabels is not implemented"))
}

func (UnimplementedLabelServiceHandler) UnarchiveLabels(context.Context, *connect.Request[v1.UnarchiveLabelsRequest]) (*connect.Response[v1.UnarchiveLabelsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.module.v1.LabelService.UnarchiveLabels is not implemented"))
}
