/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.stardict;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import tokyo.northside.stardict.DictionaryData;
import tokyo.northside.stardict.IndexEntry;
import tokyo.northside.stardict.StarDictDictionary;
import tokyo.northside.stardict.StarDictInfo;

public class StarDictFileDict
extends StarDictDictionary {
    private final RandomAccessFile dataFile;

    StarDictFileDict(StarDictInfo info, File dictFile, DictionaryData<IndexEntry> data, int cacheSize) throws FileNotFoundException {
        super(data, info, 64, cacheSize);
        this.dataFile = new RandomAccessFile(dictFile, "r");
    }

    @Override
    protected String readArticle(long start, int len) {
        String result = null;
        try {
            byte[] data = new byte[len];
            this.dataFile.seek(start);
            int readLen = this.dataFile.read(data);
            result = new String(data, 0, readLen, StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.dataFile.close();
    }
}

