/*
   Copyright (c) 2010, 2025, Oracle and/or its affiliates.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is designed to work with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have either included with
   the program or referenced in the documentation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
*/

package com.mysql.clusterj.core.util;

import java.util.function.Supplier;

public interface Logger {

    void detail(String message);
    void detail(Supplier<String> generator);
    void debug(String message);
    void debug(Supplier<String> generator);
    void trace(String message);
    void trace(Supplier<String> generator);
    void info(String message);
    void info(Supplier<String> generator);
    void warn(String message);
    void error(String message);
    void fatal(String message);
    boolean isDetailEnabled();
    boolean isDebugEnabled();
    boolean isTraceEnabled();
    boolean isInfoEnabled();
}
