/*
 * Copyright (C) 2025 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <WebCore/FrameIdentifier.h>
#include <WebCore/ProcessQualified.h>
#include <wtf/Markable.h>
#include <wtf/ObjectIdentifier.h>

namespace JSC {
class JSObject;
}

namespace WebCore {

class Document;
class Node;

struct JSHandleIdentifierType;
using WebProcessJSHandleIdentifier = ObjectIdentifier<JSHandleIdentifierType>;
using JSHandleIdentifier = ProcessQualified<WebProcessJSHandleIdentifier>;

class WebKitJSHandle : public RefCounted<WebKitJSHandle> {
public:
    static Ref<WebKitJSHandle> create(Document& document, JSC::JSObject* object) { return adoptRef(*new WebKitJSHandle(document, object)); }
    WEBCORE_EXPORT static std::pair<RefPtr<Document>, JSC::JSObject*> objectForIdentifier(JSHandleIdentifier);
    WEBCORE_EXPORT static void jsHandleDestroyed(JSHandleIdentifier);

    JSHandleIdentifier identifier() const { return m_identifier; }
    Markable<FrameIdentifier> windowFrameIdentifier() const { return m_windowFrameIdentifier; }

private:
    WEBCORE_EXPORT WebKitJSHandle(Document&, JSC::JSObject*);

    const JSHandleIdentifier m_identifier;
    const Markable<FrameIdentifier> m_windowFrameIdentifier;
};

} // namespace WebCore
