/*
 * Copyright (c) 2016, 2020 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#pragma once

#include <JavaScriptCore/BuiltinUtils.h>
#include <JavaScriptCore/Identifier.h>
#include <JavaScriptCore/JSFunction.h>
#include <JavaScriptCore/UnlinkedFunctionExecutable.h>

namespace JSC {
class FunctionExecutable;
}

namespace WebCore {

/* TransformStreamInternals */
extern const char* const s_transformStreamInternalsIsTransformStreamCode;
extern const int s_transformStreamInternalsIsTransformStreamCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsIsTransformStreamCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsIsTransformStreamCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsIsTransformStreamCodeImplementationVisibility;
extern const char* const s_transformStreamInternalsIsTransformStreamDefaultControllerCode;
extern const int s_transformStreamInternalsIsTransformStreamDefaultControllerCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsIsTransformStreamDefaultControllerCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsIsTransformStreamDefaultControllerCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsIsTransformStreamDefaultControllerCodeImplementationVisibility;
extern const char* const s_transformStreamInternalsCreateInternalTransformStreamFromTransformerCode;
extern const int s_transformStreamInternalsCreateInternalTransformStreamFromTransformerCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsCreateInternalTransformStreamFromTransformerCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsCreateInternalTransformStreamFromTransformerCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsCreateInternalTransformStreamFromTransformerCodeImplementationVisibility;
extern const char* const s_transformStreamInternalsCreateTransformStreamCode;
extern const int s_transformStreamInternalsCreateTransformStreamCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsCreateTransformStreamCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsCreateTransformStreamCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsCreateTransformStreamCodeImplementationVisibility;
extern const char* const s_transformStreamInternalsInitializeTransformStreamCode;
extern const int s_transformStreamInternalsInitializeTransformStreamCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsInitializeTransformStreamCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsInitializeTransformStreamCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsInitializeTransformStreamCodeImplementationVisibility;
extern const char* const s_transformStreamInternalsTransformStreamErrorCode;
extern const int s_transformStreamInternalsTransformStreamErrorCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsTransformStreamErrorCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsTransformStreamErrorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsTransformStreamErrorCodeImplementationVisibility;
extern const char* const s_transformStreamInternalsTransformStreamErrorWritableAndUnblockWriteCode;
extern const int s_transformStreamInternalsTransformStreamErrorWritableAndUnblockWriteCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsTransformStreamErrorWritableAndUnblockWriteCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsTransformStreamErrorWritableAndUnblockWriteCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsTransformStreamErrorWritableAndUnblockWriteCodeImplementationVisibility;
extern const char* const s_transformStreamInternalsTransformStreamSetBackpressureCode;
extern const int s_transformStreamInternalsTransformStreamSetBackpressureCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsTransformStreamSetBackpressureCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsTransformStreamSetBackpressureCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsTransformStreamSetBackpressureCodeImplementationVisibility;
extern const char* const s_transformStreamInternalsSetUpTransformStreamDefaultControllerCode;
extern const int s_transformStreamInternalsSetUpTransformStreamDefaultControllerCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsSetUpTransformStreamDefaultControllerCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsSetUpTransformStreamDefaultControllerCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsSetUpTransformStreamDefaultControllerCodeImplementationVisibility;
extern const char* const s_transformStreamInternalsSetUpTransformStreamDefaultControllerFromTransformerCode;
extern const int s_transformStreamInternalsSetUpTransformStreamDefaultControllerFromTransformerCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsSetUpTransformStreamDefaultControllerFromTransformerCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsSetUpTransformStreamDefaultControllerFromTransformerCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsSetUpTransformStreamDefaultControllerFromTransformerCodeImplementationVisibility;
extern const char* const s_transformStreamInternalsTransformStreamDefaultControllerClearAlgorithmsCode;
extern const int s_transformStreamInternalsTransformStreamDefaultControllerClearAlgorithmsCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsTransformStreamDefaultControllerClearAlgorithmsCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsTransformStreamDefaultControllerClearAlgorithmsCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsTransformStreamDefaultControllerClearAlgorithmsCodeImplementationVisibility;
extern const char* const s_transformStreamInternalsTransformStreamDefaultControllerEnqueueCode;
extern const int s_transformStreamInternalsTransformStreamDefaultControllerEnqueueCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsTransformStreamDefaultControllerEnqueueCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsTransformStreamDefaultControllerEnqueueCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsTransformStreamDefaultControllerEnqueueCodeImplementationVisibility;
extern const char* const s_transformStreamInternalsTransformStreamDefaultControllerErrorCode;
extern const int s_transformStreamInternalsTransformStreamDefaultControllerErrorCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsTransformStreamDefaultControllerErrorCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsTransformStreamDefaultControllerErrorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsTransformStreamDefaultControllerErrorCodeImplementationVisibility;
extern const char* const s_transformStreamInternalsTransformStreamDefaultControllerPerformTransformCode;
extern const int s_transformStreamInternalsTransformStreamDefaultControllerPerformTransformCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsTransformStreamDefaultControllerPerformTransformCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsTransformStreamDefaultControllerPerformTransformCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsTransformStreamDefaultControllerPerformTransformCodeImplementationVisibility;
extern const char* const s_transformStreamInternalsTransformStreamDefaultControllerTerminateCode;
extern const int s_transformStreamInternalsTransformStreamDefaultControllerTerminateCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsTransformStreamDefaultControllerTerminateCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsTransformStreamDefaultControllerTerminateCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsTransformStreamDefaultControllerTerminateCodeImplementationVisibility;
extern const char* const s_transformStreamInternalsTransformStreamDefaultSinkWriteAlgorithmCode;
extern const int s_transformStreamInternalsTransformStreamDefaultSinkWriteAlgorithmCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsTransformStreamDefaultSinkWriteAlgorithmCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsTransformStreamDefaultSinkWriteAlgorithmCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsTransformStreamDefaultSinkWriteAlgorithmCodeImplementationVisibility;
extern const char* const s_transformStreamInternalsTransformStreamDefaultSinkAbortAlgorithmCode;
extern const int s_transformStreamInternalsTransformStreamDefaultSinkAbortAlgorithmCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsTransformStreamDefaultSinkAbortAlgorithmCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsTransformStreamDefaultSinkAbortAlgorithmCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsTransformStreamDefaultSinkAbortAlgorithmCodeImplementationVisibility;
extern const char* const s_transformStreamInternalsTransformStreamDefaultSinkCloseAlgorithmCode;
extern const int s_transformStreamInternalsTransformStreamDefaultSinkCloseAlgorithmCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsTransformStreamDefaultSinkCloseAlgorithmCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsTransformStreamDefaultSinkCloseAlgorithmCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsTransformStreamDefaultSinkCloseAlgorithmCodeImplementationVisibility;
extern const char* const s_transformStreamInternalsTransformStreamDefaultSourcePullAlgorithmCode;
extern const int s_transformStreamInternalsTransformStreamDefaultSourcePullAlgorithmCodeLength;
extern const JSC::ConstructAbility s_transformStreamInternalsTransformStreamDefaultSourcePullAlgorithmCodeConstructAbility;
extern const JSC::ConstructorKind s_transformStreamInternalsTransformStreamDefaultSourcePullAlgorithmCodeConstructorKind;
extern const JSC::ImplementationVisibility s_transformStreamInternalsTransformStreamDefaultSourcePullAlgorithmCodeImplementationVisibility;

#define WEBCORE_FOREACH_TRANSFORMSTREAMINTERNALS_BUILTIN_DATA(macro) \
    macro(isTransformStream, transformStreamInternalsIsTransformStream, 1) \
    macro(isTransformStreamDefaultController, transformStreamInternalsIsTransformStreamDefaultController, 1) \
    macro(createInternalTransformStreamFromTransformer, transformStreamInternalsCreateInternalTransformStreamFromTransformer, 3) \
    macro(createTransformStream, transformStreamInternalsCreateTransformStream, 7) \
    macro(initializeTransformStream, transformStreamInternalsInitializeTransformStream, 6) \
    macro(transformStreamError, transformStreamInternalsTransformStreamError, 2) \
    macro(transformStreamErrorWritableAndUnblockWrite, transformStreamInternalsTransformStreamErrorWritableAndUnblockWrite, 2) \
    macro(transformStreamSetBackpressure, transformStreamInternalsTransformStreamSetBackpressure, 2) \
    macro(setUpTransformStreamDefaultController, transformStreamInternalsSetUpTransformStreamDefaultController, 4) \
    macro(setUpTransformStreamDefaultControllerFromTransformer, transformStreamInternalsSetUpTransformStreamDefaultControllerFromTransformer, 3) \
    macro(transformStreamDefaultControllerClearAlgorithms, transformStreamInternalsTransformStreamDefaultControllerClearAlgorithms, 1) \
    macro(transformStreamDefaultControllerEnqueue, transformStreamInternalsTransformStreamDefaultControllerEnqueue, 2) \
    macro(transformStreamDefaultControllerError, transformStreamInternalsTransformStreamDefaultControllerError, 2) \
    macro(transformStreamDefaultControllerPerformTransform, transformStreamInternalsTransformStreamDefaultControllerPerformTransform, 2) \
    macro(transformStreamDefaultControllerTerminate, transformStreamInternalsTransformStreamDefaultControllerTerminate, 1) \
    macro(transformStreamDefaultSinkWriteAlgorithm, transformStreamInternalsTransformStreamDefaultSinkWriteAlgorithm, 2) \
    macro(transformStreamDefaultSinkAbortAlgorithm, transformStreamInternalsTransformStreamDefaultSinkAbortAlgorithm, 2) \
    macro(transformStreamDefaultSinkCloseAlgorithm, transformStreamInternalsTransformStreamDefaultSinkCloseAlgorithm, 1) \
    macro(transformStreamDefaultSourcePullAlgorithm, transformStreamInternalsTransformStreamDefaultSourcePullAlgorithm, 1) \

#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_ISTRANSFORMSTREAM 1
#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_ISTRANSFORMSTREAMDEFAULTCONTROLLER 1
#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_CREATEINTERNALTRANSFORMSTREAMFROMTRANSFORMER 1
#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_CREATETRANSFORMSTREAM 1
#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_INITIALIZETRANSFORMSTREAM 1
#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_TRANSFORMSTREAMERROR 1
#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_TRANSFORMSTREAMERRORWRITABLEANDUNBLOCKWRITE 1
#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_TRANSFORMSTREAMSETBACKPRESSURE 1
#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_SETUPTRANSFORMSTREAMDEFAULTCONTROLLER 1
#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_SETUPTRANSFORMSTREAMDEFAULTCONTROLLERFROMTRANSFORMER 1
#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_TRANSFORMSTREAMDEFAULTCONTROLLERCLEARALGORITHMS 1
#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_TRANSFORMSTREAMDEFAULTCONTROLLERENQUEUE 1
#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_TRANSFORMSTREAMDEFAULTCONTROLLERERROR 1
#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_TRANSFORMSTREAMDEFAULTCONTROLLERPERFORMTRANSFORM 1
#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_TRANSFORMSTREAMDEFAULTCONTROLLERTERMINATE 1
#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_TRANSFORMSTREAMDEFAULTSINKWRITEALGORITHM 1
#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_TRANSFORMSTREAMDEFAULTSINKABORTALGORITHM 1
#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_TRANSFORMSTREAMDEFAULTSINKCLOSEALGORITHM 1
#define WEBCORE_BUILTIN_TRANSFORMSTREAMINTERNALS_TRANSFORMSTREAMDEFAULTSOURCEPULLALGORITHM 1

#define WEBCORE_FOREACH_TRANSFORMSTREAMINTERNALS_BUILTIN_CODE(macro) \
    macro(transformStreamInternalsIsTransformStreamCode, isTransformStream, ASCIILiteral(), s_transformStreamInternalsIsTransformStreamCodeLength) \
    macro(transformStreamInternalsIsTransformStreamDefaultControllerCode, isTransformStreamDefaultController, ASCIILiteral(), s_transformStreamInternalsIsTransformStreamDefaultControllerCodeLength) \
    macro(transformStreamInternalsCreateInternalTransformStreamFromTransformerCode, createInternalTransformStreamFromTransformer, ASCIILiteral(), s_transformStreamInternalsCreateInternalTransformStreamFromTransformerCodeLength) \
    macro(transformStreamInternalsCreateTransformStreamCode, createTransformStream, ASCIILiteral(), s_transformStreamInternalsCreateTransformStreamCodeLength) \
    macro(transformStreamInternalsInitializeTransformStreamCode, initializeTransformStream, ASCIILiteral(), s_transformStreamInternalsInitializeTransformStreamCodeLength) \
    macro(transformStreamInternalsTransformStreamErrorCode, transformStreamError, ASCIILiteral(), s_transformStreamInternalsTransformStreamErrorCodeLength) \
    macro(transformStreamInternalsTransformStreamErrorWritableAndUnblockWriteCode, transformStreamErrorWritableAndUnblockWrite, ASCIILiteral(), s_transformStreamInternalsTransformStreamErrorWritableAndUnblockWriteCodeLength) \
    macro(transformStreamInternalsTransformStreamSetBackpressureCode, transformStreamSetBackpressure, ASCIILiteral(), s_transformStreamInternalsTransformStreamSetBackpressureCodeLength) \
    macro(transformStreamInternalsSetUpTransformStreamDefaultControllerCode, setUpTransformStreamDefaultController, ASCIILiteral(), s_transformStreamInternalsSetUpTransformStreamDefaultControllerCodeLength) \
    macro(transformStreamInternalsSetUpTransformStreamDefaultControllerFromTransformerCode, setUpTransformStreamDefaultControllerFromTransformer, ASCIILiteral(), s_transformStreamInternalsSetUpTransformStreamDefaultControllerFromTransformerCodeLength) \
    macro(transformStreamInternalsTransformStreamDefaultControllerClearAlgorithmsCode, transformStreamDefaultControllerClearAlgorithms, ASCIILiteral(), s_transformStreamInternalsTransformStreamDefaultControllerClearAlgorithmsCodeLength) \
    macro(transformStreamInternalsTransformStreamDefaultControllerEnqueueCode, transformStreamDefaultControllerEnqueue, ASCIILiteral(), s_transformStreamInternalsTransformStreamDefaultControllerEnqueueCodeLength) \
    macro(transformStreamInternalsTransformStreamDefaultControllerErrorCode, transformStreamDefaultControllerError, ASCIILiteral(), s_transformStreamInternalsTransformStreamDefaultControllerErrorCodeLength) \
    macro(transformStreamInternalsTransformStreamDefaultControllerPerformTransformCode, transformStreamDefaultControllerPerformTransform, ASCIILiteral(), s_transformStreamInternalsTransformStreamDefaultControllerPerformTransformCodeLength) \
    macro(transformStreamInternalsTransformStreamDefaultControllerTerminateCode, transformStreamDefaultControllerTerminate, ASCIILiteral(), s_transformStreamInternalsTransformStreamDefaultControllerTerminateCodeLength) \
    macro(transformStreamInternalsTransformStreamDefaultSinkWriteAlgorithmCode, transformStreamDefaultSinkWriteAlgorithm, ASCIILiteral(), s_transformStreamInternalsTransformStreamDefaultSinkWriteAlgorithmCodeLength) \
    macro(transformStreamInternalsTransformStreamDefaultSinkAbortAlgorithmCode, transformStreamDefaultSinkAbortAlgorithm, ASCIILiteral(), s_transformStreamInternalsTransformStreamDefaultSinkAbortAlgorithmCodeLength) \
    macro(transformStreamInternalsTransformStreamDefaultSinkCloseAlgorithmCode, transformStreamDefaultSinkCloseAlgorithm, ASCIILiteral(), s_transformStreamInternalsTransformStreamDefaultSinkCloseAlgorithmCodeLength) \
    macro(transformStreamInternalsTransformStreamDefaultSourcePullAlgorithmCode, transformStreamDefaultSourcePullAlgorithm, ASCIILiteral(), s_transformStreamInternalsTransformStreamDefaultSourcePullAlgorithmCodeLength) \

#define WEBCORE_FOREACH_TRANSFORMSTREAMINTERNALS_BUILTIN_FUNCTION_NAME(macro) \
    macro(createInternalTransformStreamFromTransformer) \
    macro(createTransformStream) \
    macro(initializeTransformStream) \
    macro(isTransformStream) \
    macro(isTransformStreamDefaultController) \
    macro(setUpTransformStreamDefaultController) \
    macro(setUpTransformStreamDefaultControllerFromTransformer) \
    macro(transformStreamDefaultControllerClearAlgorithms) \
    macro(transformStreamDefaultControllerEnqueue) \
    macro(transformStreamDefaultControllerError) \
    macro(transformStreamDefaultControllerPerformTransform) \
    macro(transformStreamDefaultControllerTerminate) \
    macro(transformStreamDefaultSinkAbortAlgorithm) \
    macro(transformStreamDefaultSinkCloseAlgorithm) \
    macro(transformStreamDefaultSinkWriteAlgorithm) \
    macro(transformStreamDefaultSourcePullAlgorithm) \
    macro(transformStreamError) \
    macro(transformStreamErrorWritableAndUnblockWrite) \
    macro(transformStreamSetBackpressure) \

#define DECLARE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
    JSC::FunctionExecutable* codeName##Generator(JSC::VM&);

WEBCORE_FOREACH_TRANSFORMSTREAMINTERNALS_BUILTIN_CODE(DECLARE_BUILTIN_GENERATOR)
#undef DECLARE_BUILTIN_GENERATOR

class TransformStreamInternalsBuiltinsWrapper : private JSC::WeakHandleOwner {
public:
    explicit TransformStreamInternalsBuiltinsWrapper(JSC::VM& vm)
        : m_vm(vm)
        WEBCORE_FOREACH_TRANSFORMSTREAMINTERNALS_BUILTIN_FUNCTION_NAME(INITIALIZE_BUILTIN_NAMES)
#define INITIALIZE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) , m_##name##Source(JSC::makeSource(StringImpl::createWithoutCopying(s_##name, length), { }))
        WEBCORE_FOREACH_TRANSFORMSTREAMINTERNALS_BUILTIN_CODE(INITIALIZE_BUILTIN_SOURCE_MEMBERS)
#undef INITIALIZE_BUILTIN_SOURCE_MEMBERS
    {
    }

#define EXPOSE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
    JSC::UnlinkedFunctionExecutable* name##Executable(); \
    const JSC::SourceCode& name##Source() const { return m_##name##Source; }
    WEBCORE_FOREACH_TRANSFORMSTREAMINTERNALS_BUILTIN_CODE(EXPOSE_BUILTIN_EXECUTABLES)
#undef EXPOSE_BUILTIN_EXECUTABLES

    WEBCORE_FOREACH_TRANSFORMSTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_IDENTIFIER_ACCESSOR)

    void exportNames();

private:
    JSC::VM& m_vm;

    WEBCORE_FOREACH_TRANSFORMSTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_NAMES)

#define DECLARE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) \
    JSC::SourceCode m_##name##Source;\
    JSC::Weak<JSC::UnlinkedFunctionExecutable> m_##name##Executable;
    WEBCORE_FOREACH_TRANSFORMSTREAMINTERNALS_BUILTIN_CODE(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS

};

#define DEFINE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
inline JSC::UnlinkedFunctionExecutable* TransformStreamInternalsBuiltinsWrapper::name##Executable() \
{\
    if (!m_##name##Executable) {\
        JSC::Identifier executableName = functionName##PublicName();\
        if (overriddenName)\
            executableName = JSC::Identifier::fromString(m_vm, overriddenName);\
        m_##name##Executable = JSC::Weak<JSC::UnlinkedFunctionExecutable>(JSC::createBuiltinExecutable(m_vm, m_##name##Source, executableName, s_##name##ImplementationVisibility, s_##name##ConstructorKind, s_##name##ConstructAbility), this, &m_##name##Executable);\
    }\
    return m_##name##Executable.get();\
}
WEBCORE_FOREACH_TRANSFORMSTREAMINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_EXECUTABLES)
#undef DEFINE_BUILTIN_EXECUTABLES

inline void TransformStreamInternalsBuiltinsWrapper::exportNames()
{
#define EXPORT_FUNCTION_NAME(name) m_vm.propertyNames->appendExternalName(name##PublicName(), name##PrivateName());
    WEBCORE_FOREACH_TRANSFORMSTREAMINTERNALS_BUILTIN_FUNCTION_NAME(EXPORT_FUNCTION_NAME)
#undef EXPORT_FUNCTION_NAME
}

class TransformStreamInternalsBuiltinFunctions {
public:
    explicit TransformStreamInternalsBuiltinFunctions(JSC::VM& vm) : m_vm(vm) { }

    void init(JSC::JSGlobalObject&);
    template<typename Visitor> void visit(Visitor&);

public:
    JSC::VM& m_vm;

#define DECLARE_BUILTIN_SOURCE_MEMBERS(functionName) \
    JSC::WriteBarrier<JSC::JSFunction> m_##functionName##Function;
    WEBCORE_FOREACH_TRANSFORMSTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS
};

inline void TransformStreamInternalsBuiltinFunctions::init(JSC::JSGlobalObject& globalObject)
{
#define EXPORT_FUNCTION(codeName, functionName, overriddenName, length)\
    m_##functionName##Function.set(m_vm, &globalObject, JSC::JSFunction::create(m_vm, codeName##Generator(m_vm), &globalObject));
    WEBCORE_FOREACH_TRANSFORMSTREAMINTERNALS_BUILTIN_CODE(EXPORT_FUNCTION)
#undef EXPORT_FUNCTION
}

template<typename Visitor>
inline void TransformStreamInternalsBuiltinFunctions::visit(Visitor& visitor)
{
#define VISIT_FUNCTION(name) visitor.append(m_##name##Function);
    WEBCORE_FOREACH_TRANSFORMSTREAMINTERNALS_BUILTIN_FUNCTION_NAME(VISIT_FUNCTION)
#undef VISIT_FUNCTION
}

template void TransformStreamInternalsBuiltinFunctions::visit(JSC::AbstractSlotVisitor&);
template void TransformStreamInternalsBuiltinFunctions::visit(JSC::SlotVisitor&);



} // namespace WebCore
