// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#pragma once

#include <array>
#include <wtf/HashFunctions.h>
#include <wtf/HashTraits.h>

namespace WebCore {

class Settings;

enum CSSPropertyID : uint16_t {
    CSSPropertyInvalid = 0,
    CSSPropertyCustom = 1,
    CSSPropertyColorScheme = 2,
    CSSPropertyWritingMode = 3,
    CSSPropertyWebkitRubyPosition = 4,
    CSSPropertyColor = 5,
    CSSPropertyDirection = 6,
    CSSPropertyDisplay = 7,
    CSSPropertyFontFamily = 8,
    CSSPropertyFontFeatureSettings = 9,
    CSSPropertyFontKerning = 10,
    CSSPropertyFontOpticalSizing = 11,
    CSSPropertyFontPalette = 12,
    CSSPropertyFontSize = 13,
    CSSPropertyFontSizeAdjust = 14,
    CSSPropertyFontStretch = 15,
    CSSPropertyFontStyle = 16,
    CSSPropertyFontSynthesisSmallCaps = 17,
    CSSPropertyFontSynthesisStyle = 18,
    CSSPropertyFontSynthesisWeight = 19,
    CSSPropertyFontVariantAlternates = 20,
    CSSPropertyFontVariantCaps = 21,
    CSSPropertyFontVariantEastAsian = 22,
    CSSPropertyFontVariantLigatures = 23,
    CSSPropertyFontVariantNumeric = 24,
    CSSPropertyFontVariantPosition = 25,
    CSSPropertyFontVariationSettings = 26,
    CSSPropertyFontWeight = 27,
    CSSPropertyTextOrientation = 28,
    CSSPropertyTextRendering = 29,
    CSSPropertyZoom = 30,
    CSSPropertyWebkitFontSmoothing = 31,
    CSSPropertyWebkitLocale = 32,
    CSSPropertyWebkitTextSizeAdjust = 33,
    CSSPropertyWebkitTextZoom = 34,
    CSSPropertyLetterSpacing = 35,
    CSSPropertyAccentColor = 36,
    CSSPropertyAdditiveSymbols = 37,
    CSSPropertyAlignContent = 38,
    CSSPropertyAlignItems = 39,
    CSSPropertyAlignSelf = 40,
    CSSPropertyAlignTracks = 41,
    CSSPropertyAlignmentBaseline = 42,
    CSSPropertyAlt = 43,
    CSSPropertyAnimationComposition = 44,
    CSSPropertyAnimationDelay = 45,
    CSSPropertyAnimationDirection = 46,
    CSSPropertyAnimationDuration = 47,
    CSSPropertyAnimationFillMode = 48,
    CSSPropertyAnimationIterationCount = 49,
    CSSPropertyAnimationName = 50,
    CSSPropertyAnimationPlayState = 51,
    CSSPropertyAnimationTimingFunction = 52,
    CSSPropertyAppearance = 53,
    CSSPropertyAspectRatio = 54,
    CSSPropertyBackfaceVisibility = 55,
    CSSPropertyBackgroundAttachment = 56,
    CSSPropertyBackgroundBlendMode = 57,
    CSSPropertyBackgroundColor = 58,
    CSSPropertyBackgroundImage = 59,
    CSSPropertyBackgroundPositionX = 60,
    CSSPropertyBackgroundPositionY = 61,
    CSSPropertyBackgroundRepeat = 62,
    CSSPropertyBackgroundSize = 63,
    CSSPropertyBasePalette = 64,
    CSSPropertyBaselineShift = 65,
    CSSPropertyBlockStepInsert = 66,
    CSSPropertyBlockStepSize = 67,
    CSSPropertyBorderCollapse = 68,
    CSSPropertyBorderImageOutset = 69,
    CSSPropertyBorderImageRepeat = 70,
    CSSPropertyBorderImageSlice = 71,
    CSSPropertyBorderImageSource = 72,
    CSSPropertyBorderImageWidth = 73,
    CSSPropertyBoxSizing = 74,
    CSSPropertyBreakAfter = 75,
    CSSPropertyBreakBefore = 76,
    CSSPropertyBreakInside = 77,
    CSSPropertyBufferedRendering = 78,
    CSSPropertyCaptionSide = 79,
    CSSPropertyCaretColor = 80,
    CSSPropertyClear = 81,
    CSSPropertyClip = 82,
    CSSPropertyClipPath = 83,
    CSSPropertyClipRule = 84,
    CSSPropertyColorInterpolation = 85,
    CSSPropertyColorInterpolationFilters = 86,
    CSSPropertyColumnCount = 87,
    CSSPropertyColumnFill = 88,
    CSSPropertyColumnGap = 89,
    CSSPropertyColumnRuleColor = 90,
    CSSPropertyColumnRuleStyle = 91,
    CSSPropertyColumnRuleWidth = 92,
    CSSPropertyColumnSpan = 93,
    CSSPropertyColumnWidth = 94,
    CSSPropertyContain = 95,
    CSSPropertyContainerName = 96,
    CSSPropertyContainerType = 97,
    CSSPropertyContent = 98,
    CSSPropertyContentVisibility = 99,
    CSSPropertyCounterIncrement = 100,
    CSSPropertyCounterReset = 101,
    CSSPropertyCursor = 102,
    CSSPropertyCx = 103,
    CSSPropertyCy = 104,
    CSSPropertyDominantBaseline = 105,
    CSSPropertyEmptyCells = 106,
    CSSPropertyFallback = 107,
    CSSPropertyFill = 108,
    CSSPropertyFillOpacity = 109,
    CSSPropertyFillRule = 110,
    CSSPropertyFilter = 111,
    CSSPropertyFlexBasis = 112,
    CSSPropertyFlexDirection = 113,
    CSSPropertyFlexGrow = 114,
    CSSPropertyFlexShrink = 115,
    CSSPropertyFlexWrap = 116,
    CSSPropertyFloat = 117,
    CSSPropertyFloodColor = 118,
    CSSPropertyFloodOpacity = 119,
    CSSPropertyFontDisplay = 120,
    CSSPropertyGlyphOrientationHorizontal = 121,
    CSSPropertyGlyphOrientationVertical = 122,
    CSSPropertyGridAutoColumns = 123,
    CSSPropertyGridAutoFlow = 124,
    CSSPropertyGridAutoRows = 125,
    CSSPropertyGridColumnEnd = 126,
    CSSPropertyGridColumnStart = 127,
    CSSPropertyGridRowEnd = 128,
    CSSPropertyGridRowStart = 129,
    CSSPropertyGridTemplateAreas = 130,
    CSSPropertyGridTemplateColumns = 131,
    CSSPropertyGridTemplateRows = 132,
    CSSPropertyHangingPunctuation = 133,
    CSSPropertyImageOrientation = 134,
    CSSPropertyImageRendering = 135,
    CSSPropertyInherits = 136,
    CSSPropertyInitialValue = 137,
    CSSPropertyInputSecurity = 138,
    CSSPropertyIsolation = 139,
    CSSPropertyJustifyContent = 140,
    CSSPropertyJustifyItems = 141,
    CSSPropertyJustifySelf = 142,
    CSSPropertyJustifyTracks = 143,
    CSSPropertyKerning = 144,
    CSSPropertyLightingColor = 145,
    CSSPropertyLineBreak = 146,
    CSSPropertyLineHeight = 147,
    CSSPropertyListStyleImage = 148,
    CSSPropertyListStylePosition = 149,
    CSSPropertyListStyleType = 150,
    CSSPropertyMarginTrim = 151,
    CSSPropertyMarkerEnd = 152,
    CSSPropertyMarkerMid = 153,
    CSSPropertyMarkerStart = 154,
    CSSPropertyMaskImage = 155,
    CSSPropertyMaskOrigin = 156,
    CSSPropertyMaskRepeat = 157,
    CSSPropertyMaskSize = 158,
    CSSPropertyMaskType = 159,
    CSSPropertyMasonryAutoFlow = 160,
    CSSPropertyMathStyle = 161,
    CSSPropertyMixBlendMode = 162,
    CSSPropertyNegative = 163,
    CSSPropertyObjectFit = 164,
    CSSPropertyObjectPosition = 165,
    CSSPropertyOffsetAnchor = 166,
    CSSPropertyOffsetDistance = 167,
    CSSPropertyOffsetPath = 168,
    CSSPropertyOffsetPosition = 169,
    CSSPropertyOffsetRotate = 170,
    CSSPropertyOpacity = 171,
    CSSPropertyOrder = 172,
    CSSPropertyOrphans = 173,
    CSSPropertyOutlineColor = 174,
    CSSPropertyOutlineOffset = 175,
    CSSPropertyOutlineStyle = 176,
    CSSPropertyOutlineWidth = 177,
    CSSPropertyOverflowAnchor = 178,
    CSSPropertyOverflowWrap = 179,
    CSSPropertyOverflowX = 180,
    CSSPropertyOverflowY = 181,
    CSSPropertyOverrideColors = 182,
    CSSPropertyPad = 183,
    CSSPropertyPage = 184,
    CSSPropertyPaintOrder = 185,
    CSSPropertyPerspective = 186,
    CSSPropertyPerspectiveOriginX = 187,
    CSSPropertyPerspectiveOriginY = 188,
    CSSPropertyPointerEvents = 189,
    CSSPropertyPosition = 190,
    CSSPropertyPrefix = 191,
    CSSPropertyPrintColorAdjust = 192,
    CSSPropertyQuotes = 193,
    CSSPropertyR = 194,
    CSSPropertyRange = 195,
    CSSPropertyResize = 196,
    CSSPropertyRotate = 197,
    CSSPropertyRowGap = 198,
    CSSPropertyRx = 199,
    CSSPropertyRy = 200,
    CSSPropertyScale = 201,
    CSSPropertyScrollBehavior = 202,
    CSSPropertyScrollSnapAlign = 203,
    CSSPropertyScrollSnapStop = 204,
    CSSPropertyScrollSnapType = 205,
    CSSPropertyScrollbarWidth = 206,
    CSSPropertyShapeImageThreshold = 207,
    CSSPropertyShapeMargin = 208,
    CSSPropertyShapeOutside = 209,
    CSSPropertyShapeRendering = 210,
    CSSPropertySize = 211,
    CSSPropertySizeAdjust = 212,
    CSSPropertySpeakAs = 213,
    CSSPropertySrc = 214,
    CSSPropertyStopColor = 215,
    CSSPropertyStopOpacity = 216,
    CSSPropertyStroke = 217,
    CSSPropertyStrokeColor = 218,
    CSSPropertyStrokeDasharray = 219,
    CSSPropertyStrokeDashoffset = 220,
    CSSPropertyStrokeLinecap = 221,
    CSSPropertyStrokeLinejoin = 222,
    CSSPropertyStrokeMiterlimit = 223,
    CSSPropertyStrokeOpacity = 224,
    CSSPropertyStrokeWidth = 225,
    CSSPropertySuffix = 226,
    CSSPropertySymbols = 227,
    CSSPropertySyntax = 228,
    CSSPropertySystem = 229,
    CSSPropertyTabSize = 230,
    CSSPropertyTableLayout = 231,
    CSSPropertyTextAlign = 232,
    CSSPropertyTextAlignLast = 233,
    CSSPropertyTextAnchor = 234,
    CSSPropertyTextAutospace = 235,
    CSSPropertyTextBoxEdge = 236,
    CSSPropertyTextBoxTrim = 237,
    CSSPropertyTextDecorationColor = 238,
    CSSPropertyTextDecorationLine = 239,
    CSSPropertyTextDecorationSkipInk = 240,
    CSSPropertyTextDecorationStyle = 241,
    CSSPropertyTextDecorationThickness = 242,
    CSSPropertyTextEmphasisColor = 243,
    CSSPropertyTextEmphasisPosition = 244,
    CSSPropertyTextEmphasisStyle = 245,
    CSSPropertyTextGroupAlign = 246,
    CSSPropertyTextIndent = 247,
    CSSPropertyTextJustify = 248,
    CSSPropertyTextOverflow = 249,
    CSSPropertyTextShadow = 250,
    CSSPropertyTextSpacingTrim = 251,
    CSSPropertyTextTransform = 252,
    CSSPropertyTextUnderlineOffset = 253,
    CSSPropertyTextUnderlinePosition = 254,
    CSSPropertyTextWrap = 255,
    CSSPropertyTouchAction = 256,
    CSSPropertyTransform = 257,
    CSSPropertyTransformBox = 258,
    CSSPropertyTransformOriginX = 259,
    CSSPropertyTransformOriginY = 260,
    CSSPropertyTransformOriginZ = 261,
    CSSPropertyTransformStyle = 262,
    CSSPropertyTransitionDelay = 263,
    CSSPropertyTransitionDuration = 264,
    CSSPropertyTransitionProperty = 265,
    CSSPropertyTransitionTimingFunction = 266,
    CSSPropertyTranslate = 267,
    CSSPropertyUnicodeBidi = 268,
    CSSPropertyUnicodeRange = 269,
    CSSPropertyVectorEffect = 270,
    CSSPropertyVerticalAlign = 271,
    CSSPropertyVisibility = 272,
    CSSPropertyWhiteSpace = 273,
    CSSPropertyWhiteSpaceCollapse = 274,
    CSSPropertyWidows = 275,
    CSSPropertyWillChange = 276,
    CSSPropertyWordBreak = 277,
    CSSPropertyWordSpacing = 278,
    CSSPropertyX = 279,
    CSSPropertyY = 280,
    CSSPropertyZIndex = 281,
    CSSPropertyAppleColorFilter = 282,
    CSSPropertyApplePayButtonStyle = 283,
    CSSPropertyApplePayButtonType = 284,
    CSSPropertyInternalTextAutosizingStatus = 285,
    CSSPropertyWebkitBackdropFilter = 286,
    CSSPropertyWebkitBorderHorizontalSpacing = 287,
    CSSPropertyWebkitBorderVerticalSpacing = 288,
    CSSPropertyWebkitBoxAlign = 289,
    CSSPropertyWebkitBoxDecorationBreak = 290,
    CSSPropertyWebkitBoxDirection = 291,
    CSSPropertyWebkitBoxFlex = 292,
    CSSPropertyWebkitBoxFlexGroup = 293,
    CSSPropertyWebkitBoxLines = 294,
    CSSPropertyWebkitBoxOrdinalGroup = 295,
    CSSPropertyWebkitBoxOrient = 296,
    CSSPropertyWebkitBoxPack = 297,
    CSSPropertyWebkitBoxReflect = 298,
    CSSPropertyWebkitColumnAxis = 299,
    CSSPropertyWebkitColumnProgression = 300,
    CSSPropertyWebkitCursorVisibility = 301,
    CSSPropertyWebkitFontSizeDelta = 302,
    CSSPropertyWebkitHyphenateCharacter = 303,
    CSSPropertyWebkitHyphenateLimitAfter = 304,
    CSSPropertyWebkitHyphenateLimitBefore = 305,
    CSSPropertyWebkitHyphenateLimitLines = 306,
    CSSPropertyWebkitHyphens = 307,
    CSSPropertyWebkitInitialLetter = 308,
    CSSPropertyWebkitLineAlign = 309,
    CSSPropertyWebkitLineBoxContain = 310,
    CSSPropertyWebkitLineClamp = 311,
    CSSPropertyWebkitLineGrid = 312,
    CSSPropertyWebkitLineSnap = 313,
    CSSPropertyWebkitMarqueeDirection = 314,
    CSSPropertyWebkitMarqueeIncrement = 315,
    CSSPropertyWebkitMarqueeRepetition = 316,
    CSSPropertyWebkitMarqueeSpeed = 317,
    CSSPropertyWebkitMarqueeStyle = 318,
    CSSPropertyWebkitMaskBoxImageOutset = 319,
    CSSPropertyWebkitMaskBoxImageRepeat = 320,
    CSSPropertyWebkitMaskBoxImageSlice = 321,
    CSSPropertyWebkitMaskBoxImageSource = 322,
    CSSPropertyWebkitMaskBoxImageWidth = 323,
    CSSPropertyWebkitMaskPositionX = 324,
    CSSPropertyWebkitMaskPositionY = 325,
    CSSPropertyWebkitNbspMode = 326,
    CSSPropertyWebkitRtlOrdering = 327,
    CSSPropertyWebkitTapHighlightColor = 328,
    CSSPropertyWebkitTextDecorationsInEffect = 329,
    CSSPropertyWebkitTextFillColor = 330,
    CSSPropertyWebkitTextSecurity = 331,
    CSSPropertyWebkitTextStrokeColor = 332,
    CSSPropertyWebkitTextStrokeWidth = 333,
    CSSPropertyWebkitUserDrag = 334,
    CSSPropertyWebkitUserModify = 335,
    CSSPropertyWebkitUserSelect = 336,
    CSSPropertyBackgroundClip = 337,
    CSSPropertyBackgroundOrigin = 338,
    CSSPropertyBlockSize = 339,
    CSSPropertyBorderBlockEndColor = 340,
    CSSPropertyBorderBlockEndStyle = 341,
    CSSPropertyBorderBlockEndWidth = 342,
    CSSPropertyBorderBlockStartColor = 343,
    CSSPropertyBorderBlockStartStyle = 344,
    CSSPropertyBorderBlockStartWidth = 345,
    CSSPropertyBorderBottomColor = 346,
    CSSPropertyBorderBottomLeftRadius = 347,
    CSSPropertyBorderBottomRightRadius = 348,
    CSSPropertyBorderBottomStyle = 349,
    CSSPropertyBorderBottomWidth = 350,
    CSSPropertyBorderEndEndRadius = 351,
    CSSPropertyBorderEndStartRadius = 352,
    CSSPropertyBorderInlineEndColor = 353,
    CSSPropertyBorderInlineEndStyle = 354,
    CSSPropertyBorderInlineEndWidth = 355,
    CSSPropertyBorderInlineStartColor = 356,
    CSSPropertyBorderInlineStartStyle = 357,
    CSSPropertyBorderInlineStartWidth = 358,
    CSSPropertyBorderLeftColor = 359,
    CSSPropertyBorderLeftStyle = 360,
    CSSPropertyBorderLeftWidth = 361,
    CSSPropertyBorderRightColor = 362,
    CSSPropertyBorderRightStyle = 363,
    CSSPropertyBorderRightWidth = 364,
    CSSPropertyBorderStartEndRadius = 365,
    CSSPropertyBorderStartStartRadius = 366,
    CSSPropertyBorderTopColor = 367,
    CSSPropertyBorderTopLeftRadius = 368,
    CSSPropertyBorderTopRightRadius = 369,
    CSSPropertyBorderTopStyle = 370,
    CSSPropertyBorderTopWidth = 371,
    CSSPropertyBottom = 372,
    CSSPropertyBoxShadow = 373,
    CSSPropertyContainIntrinsicBlockSize = 374,
    CSSPropertyContainIntrinsicHeight = 375,
    CSSPropertyContainIntrinsicInlineSize = 376,
    CSSPropertyContainIntrinsicWidth = 377,
    CSSPropertyHeight = 378,
    CSSPropertyInlineSize = 379,
    CSSPropertyInsetBlockEnd = 380,
    CSSPropertyInsetBlockStart = 381,
    CSSPropertyInsetInlineEnd = 382,
    CSSPropertyInsetInlineStart = 383,
    CSSPropertyLeft = 384,
    CSSPropertyMarginBlockEnd = 385,
    CSSPropertyMarginBlockStart = 386,
    CSSPropertyMarginBottom = 387,
    CSSPropertyMarginInlineEnd = 388,
    CSSPropertyMarginInlineStart = 389,
    CSSPropertyMarginLeft = 390,
    CSSPropertyMarginRight = 391,
    CSSPropertyMarginTop = 392,
    CSSPropertyMaskClip = 393,
    CSSPropertyMaskComposite = 394,
    CSSPropertyMaskMode = 395,
    CSSPropertyMaxBlockSize = 396,
    CSSPropertyMaxHeight = 397,
    CSSPropertyMaxInlineSize = 398,
    CSSPropertyMaxWidth = 399,
    CSSPropertyMinBlockSize = 400,
    CSSPropertyMinHeight = 401,
    CSSPropertyMinInlineSize = 402,
    CSSPropertyMinWidth = 403,
    CSSPropertyOverscrollBehaviorBlock = 404,
    CSSPropertyOverscrollBehaviorInline = 405,
    CSSPropertyOverscrollBehaviorX = 406,
    CSSPropertyOverscrollBehaviorY = 407,
    CSSPropertyPaddingBlockEnd = 408,
    CSSPropertyPaddingBlockStart = 409,
    CSSPropertyPaddingBottom = 410,
    CSSPropertyPaddingInlineEnd = 411,
    CSSPropertyPaddingInlineStart = 412,
    CSSPropertyPaddingLeft = 413,
    CSSPropertyPaddingRight = 414,
    CSSPropertyPaddingTop = 415,
    CSSPropertyRight = 416,
    CSSPropertyScrollMarginBlockEnd = 417,
    CSSPropertyScrollMarginBlockStart = 418,
    CSSPropertyScrollMarginBottom = 419,
    CSSPropertyScrollMarginInlineEnd = 420,
    CSSPropertyScrollMarginInlineStart = 421,
    CSSPropertyScrollMarginLeft = 422,
    CSSPropertyScrollMarginRight = 423,
    CSSPropertyScrollMarginTop = 424,
    CSSPropertyScrollPaddingBlockEnd = 425,
    CSSPropertyScrollPaddingBlockStart = 426,
    CSSPropertyScrollPaddingBottom = 427,
    CSSPropertyScrollPaddingInlineEnd = 428,
    CSSPropertyScrollPaddingInlineStart = 429,
    CSSPropertyScrollPaddingLeft = 430,
    CSSPropertyScrollPaddingRight = 431,
    CSSPropertyScrollPaddingTop = 432,
    CSSPropertyTextCombineUpright = 433,
    CSSPropertyTop = 434,
    CSSPropertyWidth = 435,
    CSSPropertyWebkitBackgroundClip = 436,
    CSSPropertyWebkitBackgroundOrigin = 437,
    CSSPropertyWebkitBoxShadow = 438,
    CSSPropertyWebkitMaskClip = 439,
    CSSPropertyWebkitMaskComposite = 440,
    CSSPropertyWebkitMaskSourceType = 441,
    CSSPropertyWebkitTextCombine = 442,
    CSSPropertyAll = 443,
    CSSPropertyAnimation = 444,
    CSSPropertyBackground = 445,
    CSSPropertyBackgroundPosition = 446,
    CSSPropertyBorder = 447,
    CSSPropertyBorderBlock = 448,
    CSSPropertyBorderBlockColor = 449,
    CSSPropertyBorderBlockEnd = 450,
    CSSPropertyBorderBlockStart = 451,
    CSSPropertyBorderBlockStyle = 452,
    CSSPropertyBorderBlockWidth = 453,
    CSSPropertyBorderBottom = 454,
    CSSPropertyBorderColor = 455,
    CSSPropertyBorderImage = 456,
    CSSPropertyBorderInline = 457,
    CSSPropertyBorderInlineColor = 458,
    CSSPropertyBorderInlineEnd = 459,
    CSSPropertyBorderInlineStart = 460,
    CSSPropertyBorderInlineStyle = 461,
    CSSPropertyBorderInlineWidth = 462,
    CSSPropertyBorderLeft = 463,
    CSSPropertyBorderRadius = 464,
    CSSPropertyBorderRight = 465,
    CSSPropertyBorderSpacing = 466,
    CSSPropertyBorderStyle = 467,
    CSSPropertyBorderTop = 468,
    CSSPropertyBorderWidth = 469,
    CSSPropertyColumnRule = 470,
    CSSPropertyColumns = 471,
    CSSPropertyContainIntrinsicSize = 472,
    CSSPropertyContainer = 473,
    CSSPropertyFlex = 474,
    CSSPropertyFlexFlow = 475,
    CSSPropertyFont = 476,
    CSSPropertyFontSynthesis = 477,
    CSSPropertyFontVariant = 478,
    CSSPropertyGap = 479,
    CSSPropertyGrid = 480,
    CSSPropertyGridArea = 481,
    CSSPropertyGridColumn = 482,
    CSSPropertyGridRow = 483,
    CSSPropertyGridTemplate = 484,
    CSSPropertyInset = 485,
    CSSPropertyInsetBlock = 486,
    CSSPropertyInsetInline = 487,
    CSSPropertyListStyle = 488,
    CSSPropertyMargin = 489,
    CSSPropertyMarginBlock = 490,
    CSSPropertyMarginInline = 491,
    CSSPropertyMarker = 492,
    CSSPropertyMask = 493,
    CSSPropertyMaskPosition = 494,
    CSSPropertyOffset = 495,
    CSSPropertyOutline = 496,
    CSSPropertyOverflow = 497,
    CSSPropertyOverscrollBehavior = 498,
    CSSPropertyPadding = 499,
    CSSPropertyPaddingBlock = 500,
    CSSPropertyPaddingInline = 501,
    CSSPropertyPageBreakAfter = 502,
    CSSPropertyPageBreakBefore = 503,
    CSSPropertyPageBreakInside = 504,
    CSSPropertyPerspectiveOrigin = 505,
    CSSPropertyPlaceContent = 506,
    CSSPropertyPlaceItems = 507,
    CSSPropertyPlaceSelf = 508,
    CSSPropertyScrollMargin = 509,
    CSSPropertyScrollMarginBlock = 510,
    CSSPropertyScrollMarginInline = 511,
    CSSPropertyScrollPadding = 512,
    CSSPropertyScrollPaddingBlock = 513,
    CSSPropertyScrollPaddingInline = 514,
    CSSPropertyTextDecoration = 515,
    CSSPropertyTextDecorationSkip = 516,
    CSSPropertyTextEmphasis = 517,
    CSSPropertyTransformOrigin = 518,
    CSSPropertyTransition = 519,
    CSSPropertyWebkitBackgroundSize = 520,
    CSSPropertyWebkitBorderImage = 521,
    CSSPropertyWebkitBorderRadius = 522,
    CSSPropertyWebkitColumnBreakAfter = 523,
    CSSPropertyWebkitColumnBreakBefore = 524,
    CSSPropertyWebkitColumnBreakInside = 525,
    CSSPropertyWebkitMask = 526,
    CSSPropertyWebkitMaskBoxImage = 527,
    CSSPropertyWebkitMaskPosition = 528,
    CSSPropertyWebkitPerspective = 529,
    CSSPropertyWebkitTextDecoration = 530,
    CSSPropertyWebkitTextOrientation = 531,
    CSSPropertyWebkitTextStroke = 532,
};

constexpr uint16_t firstCSSProperty = 2;
constexpr uint16_t numCSSProperties = 531;
constexpr unsigned maxCSSPropertyNameLength = 34;
constexpr auto firstTopPriorityProperty = CSSPropertyID::CSSPropertyColorScheme;
constexpr auto lastTopPriorityProperty = CSSPropertyID::CSSPropertyWebkitRubyPosition;
constexpr auto firstHighPriorityProperty = CSSPropertyID::CSSPropertyColor;
constexpr auto lastHighPriorityProperty = CSSPropertyID::CSSPropertyLetterSpacing;
constexpr auto firstLowPriorityProperty = CSSPropertyID::CSSPropertyAccentColor;
constexpr auto lastLowPriorityProperty = CSSPropertyID::CSSPropertyWebkitUserSelect;
constexpr auto firstDeferredProperty = CSSPropertyID::CSSPropertyBackgroundClip;
constexpr auto lastDeferredProperty = CSSPropertyID::CSSPropertyWebkitTextCombine;
constexpr auto firstShorthandProperty = CSSPropertyID::CSSPropertyAll;
constexpr auto lastShorthandProperty = CSSPropertyID::CSSPropertyWebkitTextStroke;
constexpr uint16_t numCSSPropertyLonghands = firstShorthandProperty - firstCSSProperty;
extern const std::array<CSSPropertyID, 410> computedPropertyIDs;

struct CSSPropertySettings {
    WTF_MAKE_STRUCT_FAST_ALLOCATED;

    bool CSSOMViewSmoothScrollingEnabled { false };
    bool accentColorEnabled { false };
    bool aspectRatioEnabled { false };
    bool colorFilterEnabled { false };
    bool cssContainIntrinsicSizeEnabled { false };
    bool cssContainerQueriesEnabled { false };
    bool cssContainmentEnabled { false };
    bool cssContentVisibilityEnabled { false };
    bool cssCounterStyleAtRulesEnabled { false };
    bool cssCustomPropertiesAndValuesEnabled { false };
    bool cssFontFaceSizeAdjustEnabled { false };
    bool cssIndividualTransformPropertiesEnabled { false };
    bool cssInputSecurityEnabled { false };
    bool cssMarginTrimEnabled { false };
    bool cssMotionPathEnabled { false };
    bool cssRhythmicSizingEnabled { false };
    bool cssScrollAnchoringEnabled { false };
    bool cssScrollbarWidthEnabled { false };
    bool cssTextAlignLastEnabled { false };
    bool cssTextBoxTrimEnabled { false };
    bool cssTextGroupAlignEnabled { false };
    bool cssTextJustifyEnabled { false };
    bool cssTextSpacingEnabled { false };
    bool cssTextWrapEnabled { false };
    bool cssWhiteSpaceCollapseEnabled { false };
    bool masonryEnabled { false };
    bool overscrollBehaviorEnabled { false };
    bool textAutosizingEnabled { false };
    bool webAnimationsCompositeOperationsEnabled { false };

    CSSPropertySettings() = default;
    explicit CSSPropertySettings(const Settings&);
};

bool operator==(const CSSPropertySettings&, const CSSPropertySettings&);
void add(Hasher&, const CSSPropertySettings&);

constexpr bool isLonghand(CSSPropertyID);
bool isInternal(CSSPropertyID);
bool isExposed(CSSPropertyID, const Settings*);
bool isExposed(CSSPropertyID, const Settings&);
bool isExposed(CSSPropertyID, const CSSPropertySettings*);
bool isExposed(CSSPropertyID, const CSSPropertySettings&);

CSSPropertyID findCSSProperty(const char* characters, unsigned length);
ASCIILiteral nameLiteral(CSSPropertyID);
const AtomString& nameString(CSSPropertyID);
String nameForIDL(CSSPropertyID);

CSSPropertyID relatedProperty(CSSPropertyID);

template<CSSPropertyID first, CSSPropertyID last> struct CSSPropertiesRange {
    struct Iterator {
        uint16_t index { static_cast<uint16_t>(first) };
        constexpr CSSPropertyID operator*() const { return static_cast<CSSPropertyID>(index); }
        constexpr Iterator& operator++() { ++index; return *this; }
        constexpr bool operator==(std::nullptr_t) const { return index > static_cast<uint16_t>(last); }
    };
    static constexpr Iterator begin() { return { }; }
    static constexpr std::nullptr_t end() { return nullptr; }
    static constexpr uint16_t size() { return last - first + 1; }
};
using AllCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastShorthandProperty>;
using AllLonghandCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastDeferredProperty>;
constexpr AllCSSPropertiesRange allCSSProperties() { return { }; }
constexpr AllLonghandCSSPropertiesRange allLonghandCSSProperties() { return { }; }

constexpr bool isLonghand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= firstCSSProperty && static_cast<uint16_t>(property) < static_cast<uint16_t>(firstShorthandProperty);
}
constexpr bool isShorthand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstShorthandProperty) && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastShorthandProperty);
}

} // namespace WebCore

namespace WTF {

template<> struct DefaultHash<WebCore::CSSPropertyID> : IntHash<unsigned> { };

template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(std::numeric_limits<uint16_t>::max()); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return static_cast<uint16_t>(value) == std::numeric_limits<uint16_t>::max(); }
};

} // namespace WTF

namespace std {

template<> struct iterator_traits<WebCore::AllCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };
template<> struct iterator_traits<WebCore::AllLonghandCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };

} // namespace std

