// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#pragma once

#include <array>
#include <wtf/HashFunctions.h>
#include <wtf/HashTraits.h>

namespace WebCore {

class Settings;

enum CSSPropertyID : uint16_t {
    CSSPropertyInvalid = 0,
    CSSPropertyCustom = 1,
    CSSPropertyColorScheme = 2,
    CSSPropertyWritingMode = 3,
    CSSPropertyWebkitRubyPosition = 4,
    CSSPropertyColor = 5,
    CSSPropertyDirection = 6,
    CSSPropertyDisplay = 7,
    CSSPropertyFontFamily = 8,
    CSSPropertyFontFeatureSettings = 9,
    CSSPropertyFontKerning = 10,
    CSSPropertyFontOpticalSizing = 11,
    CSSPropertyFontPalette = 12,
    CSSPropertyFontSize = 13,
    CSSPropertyFontSizeAdjust = 14,
    CSSPropertyFontStretch = 15,
    CSSPropertyFontStyle = 16,
    CSSPropertyFontSynthesisSmallCaps = 17,
    CSSPropertyFontSynthesisStyle = 18,
    CSSPropertyFontSynthesisWeight = 19,
    CSSPropertyFontVariantAlternates = 20,
    CSSPropertyFontVariantCaps = 21,
    CSSPropertyFontVariantEastAsian = 22,
    CSSPropertyFontVariantLigatures = 23,
    CSSPropertyFontVariantNumeric = 24,
    CSSPropertyFontVariantPosition = 25,
    CSSPropertyFontVariationSettings = 26,
    CSSPropertyFontWeight = 27,
    CSSPropertyTextOrientation = 28,
    CSSPropertyTextRendering = 29,
    CSSPropertyZoom = 30,
    CSSPropertyWebkitFontSmoothing = 31,
    CSSPropertyWebkitLocale = 32,
    CSSPropertyWebkitTextSizeAdjust = 33,
    CSSPropertyWebkitTextZoom = 34,
    CSSPropertyLetterSpacing = 35,
    CSSPropertyAccentColor = 36,
    CSSPropertyAdditiveSymbols = 37,
    CSSPropertyAlignContent = 38,
    CSSPropertyAlignItems = 39,
    CSSPropertyAlignSelf = 40,
    CSSPropertyAlignTracks = 41,
    CSSPropertyAlignmentBaseline = 42,
    CSSPropertyAlt = 43,
    CSSPropertyAnimationComposition = 44,
    CSSPropertyAnimationDelay = 45,
    CSSPropertyAnimationDirection = 46,
    CSSPropertyAnimationDuration = 47,
    CSSPropertyAnimationFillMode = 48,
    CSSPropertyAnimationIterationCount = 49,
    CSSPropertyAnimationName = 50,
    CSSPropertyAnimationPlayState = 51,
    CSSPropertyAnimationTimingFunction = 52,
    CSSPropertyAppearance = 53,
    CSSPropertyAspectRatio = 54,
    CSSPropertyBackfaceVisibility = 55,
    CSSPropertyBackgroundAttachment = 56,
    CSSPropertyBackgroundBlendMode = 57,
    CSSPropertyBackgroundColor = 58,
    CSSPropertyBackgroundImage = 59,
    CSSPropertyBackgroundPositionX = 60,
    CSSPropertyBackgroundPositionY = 61,
    CSSPropertyBackgroundRepeat = 62,
    CSSPropertyBackgroundSize = 63,
    CSSPropertyBasePalette = 64,
    CSSPropertyBaselineShift = 65,
    CSSPropertyBlockStepInsert = 66,
    CSSPropertyBlockStepSize = 67,
    CSSPropertyBorderCollapse = 68,
    CSSPropertyBorderImageOutset = 69,
    CSSPropertyBorderImageRepeat = 70,
    CSSPropertyBorderImageSlice = 71,
    CSSPropertyBorderImageSource = 72,
    CSSPropertyBorderImageWidth = 73,
    CSSPropertyBoxSizing = 74,
    CSSPropertyBreakAfter = 75,
    CSSPropertyBreakBefore = 76,
    CSSPropertyBreakInside = 77,
    CSSPropertyBufferedRendering = 78,
    CSSPropertyCaptionSide = 79,
    CSSPropertyCaretColor = 80,
    CSSPropertyClear = 81,
    CSSPropertyClip = 82,
    CSSPropertyClipPath = 83,
    CSSPropertyClipRule = 84,
    CSSPropertyColorInterpolation = 85,
    CSSPropertyColorInterpolationFilters = 86,
    CSSPropertyColumnCount = 87,
    CSSPropertyColumnFill = 88,
    CSSPropertyColumnGap = 89,
    CSSPropertyColumnRuleColor = 90,
    CSSPropertyColumnRuleStyle = 91,
    CSSPropertyColumnRuleWidth = 92,
    CSSPropertyColumnSpan = 93,
    CSSPropertyColumnWidth = 94,
    CSSPropertyContain = 95,
    CSSPropertyContainerName = 96,
    CSSPropertyContainerType = 97,
    CSSPropertyContent = 98,
    CSSPropertyContentVisibility = 99,
    CSSPropertyCounterIncrement = 100,
    CSSPropertyCounterReset = 101,
    CSSPropertyCursor = 102,
    CSSPropertyCx = 103,
    CSSPropertyCy = 104,
    CSSPropertyDominantBaseline = 105,
    CSSPropertyEmptyCells = 106,
    CSSPropertyFallback = 107,
    CSSPropertyFill = 108,
    CSSPropertyFillOpacity = 109,
    CSSPropertyFillRule = 110,
    CSSPropertyFilter = 111,
    CSSPropertyFlexBasis = 112,
    CSSPropertyFlexDirection = 113,
    CSSPropertyFlexGrow = 114,
    CSSPropertyFlexShrink = 115,
    CSSPropertyFlexWrap = 116,
    CSSPropertyFloat = 117,
    CSSPropertyFloodColor = 118,
    CSSPropertyFloodOpacity = 119,
    CSSPropertyFontDisplay = 120,
    CSSPropertyGlyphOrientationHorizontal = 121,
    CSSPropertyGlyphOrientationVertical = 122,
    CSSPropertyGridAutoColumns = 123,
    CSSPropertyGridAutoFlow = 124,
    CSSPropertyGridAutoRows = 125,
    CSSPropertyGridColumnEnd = 126,
    CSSPropertyGridColumnStart = 127,
    CSSPropertyGridRowEnd = 128,
    CSSPropertyGridRowStart = 129,
    CSSPropertyGridTemplateAreas = 130,
    CSSPropertyGridTemplateColumns = 131,
    CSSPropertyGridTemplateRows = 132,
    CSSPropertyHangingPunctuation = 133,
    CSSPropertyImageOrientation = 134,
    CSSPropertyImageRendering = 135,
    CSSPropertyInherits = 136,
    CSSPropertyInitialValue = 137,
    CSSPropertyInputSecurity = 138,
    CSSPropertyIsolation = 139,
    CSSPropertyJustifyContent = 140,
    CSSPropertyJustifyItems = 141,
    CSSPropertyJustifySelf = 142,
    CSSPropertyJustifyTracks = 143,
    CSSPropertyKerning = 144,
    CSSPropertyLightingColor = 145,
    CSSPropertyLineBreak = 146,
    CSSPropertyLineHeight = 147,
    CSSPropertyListStyleImage = 148,
    CSSPropertyListStylePosition = 149,
    CSSPropertyListStyleType = 150,
    CSSPropertyMarginTrim = 151,
    CSSPropertyMarkerEnd = 152,
    CSSPropertyMarkerMid = 153,
    CSSPropertyMarkerStart = 154,
    CSSPropertyMaskImage = 155,
    CSSPropertyMaskOrigin = 156,
    CSSPropertyMaskRepeat = 157,
    CSSPropertyMaskSize = 158,
    CSSPropertyMaskType = 159,
    CSSPropertyMasonryAutoFlow = 160,
    CSSPropertyMathStyle = 161,
    CSSPropertyMixBlendMode = 162,
    CSSPropertyNegative = 163,
    CSSPropertyObjectFit = 164,
    CSSPropertyObjectPosition = 165,
    CSSPropertyOffsetAnchor = 166,
    CSSPropertyOffsetDistance = 167,
    CSSPropertyOffsetPath = 168,
    CSSPropertyOffsetPosition = 169,
    CSSPropertyOffsetRotate = 170,
    CSSPropertyOpacity = 171,
    CSSPropertyOrder = 172,
    CSSPropertyOrphans = 173,
    CSSPropertyOutlineColor = 174,
    CSSPropertyOutlineOffset = 175,
    CSSPropertyOutlineStyle = 176,
    CSSPropertyOutlineWidth = 177,
    CSSPropertyOverflowAnchor = 178,
    CSSPropertyOverflowWrap = 179,
    CSSPropertyOverflowX = 180,
    CSSPropertyOverflowY = 181,
    CSSPropertyOverrideColors = 182,
    CSSPropertyPad = 183,
    CSSPropertyPage = 184,
    CSSPropertyPaintOrder = 185,
    CSSPropertyPerspective = 186,
    CSSPropertyPerspectiveOriginX = 187,
    CSSPropertyPerspectiveOriginY = 188,
    CSSPropertyPointerEvents = 189,
    CSSPropertyPosition = 190,
    CSSPropertyPrefix = 191,
    CSSPropertyPrintColorAdjust = 192,
    CSSPropertyQuotes = 193,
    CSSPropertyR = 194,
    CSSPropertyRange = 195,
    CSSPropertyResize = 196,
    CSSPropertyRotate = 197,
    CSSPropertyRowGap = 198,
    CSSPropertyRx = 199,
    CSSPropertyRy = 200,
    CSSPropertyScale = 201,
    CSSPropertyScrollBehavior = 202,
    CSSPropertyScrollSnapAlign = 203,
    CSSPropertyScrollSnapStop = 204,
    CSSPropertyScrollSnapType = 205,
    CSSPropertyShapeImageThreshold = 206,
    CSSPropertyShapeMargin = 207,
    CSSPropertyShapeOutside = 208,
    CSSPropertyShapeRendering = 209,
    CSSPropertySize = 210,
    CSSPropertySizeAdjust = 211,
    CSSPropertySpeakAs = 212,
    CSSPropertySrc = 213,
    CSSPropertyStopColor = 214,
    CSSPropertyStopOpacity = 215,
    CSSPropertyStroke = 216,
    CSSPropertyStrokeColor = 217,
    CSSPropertyStrokeDasharray = 218,
    CSSPropertyStrokeDashoffset = 219,
    CSSPropertyStrokeLinecap = 220,
    CSSPropertyStrokeLinejoin = 221,
    CSSPropertyStrokeMiterlimit = 222,
    CSSPropertyStrokeOpacity = 223,
    CSSPropertyStrokeWidth = 224,
    CSSPropertySuffix = 225,
    CSSPropertySymbols = 226,
    CSSPropertySyntax = 227,
    CSSPropertySystem = 228,
    CSSPropertyTabSize = 229,
    CSSPropertyTableLayout = 230,
    CSSPropertyTextAlign = 231,
    CSSPropertyTextAlignLast = 232,
    CSSPropertyTextAnchor = 233,
    CSSPropertyTextAutospace = 234,
    CSSPropertyTextBoxEdge = 235,
    CSSPropertyTextBoxTrim = 236,
    CSSPropertyTextDecorationColor = 237,
    CSSPropertyTextDecorationLine = 238,
    CSSPropertyTextDecorationSkipInk = 239,
    CSSPropertyTextDecorationStyle = 240,
    CSSPropertyTextDecorationThickness = 241,
    CSSPropertyTextEmphasisColor = 242,
    CSSPropertyTextEmphasisPosition = 243,
    CSSPropertyTextEmphasisStyle = 244,
    CSSPropertyTextGroupAlign = 245,
    CSSPropertyTextIndent = 246,
    CSSPropertyTextJustify = 247,
    CSSPropertyTextOverflow = 248,
    CSSPropertyTextShadow = 249,
    CSSPropertyTextSpacingTrim = 250,
    CSSPropertyTextTransform = 251,
    CSSPropertyTextUnderlineOffset = 252,
    CSSPropertyTextUnderlinePosition = 253,
    CSSPropertyTextWrap = 254,
    CSSPropertyTouchAction = 255,
    CSSPropertyTransform = 256,
    CSSPropertyTransformBox = 257,
    CSSPropertyTransformOriginX = 258,
    CSSPropertyTransformOriginY = 259,
    CSSPropertyTransformOriginZ = 260,
    CSSPropertyTransformStyle = 261,
    CSSPropertyTransitionDelay = 262,
    CSSPropertyTransitionDuration = 263,
    CSSPropertyTransitionProperty = 264,
    CSSPropertyTransitionTimingFunction = 265,
    CSSPropertyTranslate = 266,
    CSSPropertyUnicodeBidi = 267,
    CSSPropertyUnicodeRange = 268,
    CSSPropertyVectorEffect = 269,
    CSSPropertyVerticalAlign = 270,
    CSSPropertyVisibility = 271,
    CSSPropertyWhiteSpace = 272,
    CSSPropertyWidows = 273,
    CSSPropertyWillChange = 274,
    CSSPropertyWordBreak = 275,
    CSSPropertyWordSpacing = 276,
    CSSPropertyX = 277,
    CSSPropertyY = 278,
    CSSPropertyZIndex = 279,
    CSSPropertyAppleColorFilter = 280,
    CSSPropertyApplePayButtonStyle = 281,
    CSSPropertyApplePayButtonType = 282,
    CSSPropertyInternalTextAutosizingStatus = 283,
    CSSPropertyWebkitBackdropFilter = 284,
    CSSPropertyWebkitBorderHorizontalSpacing = 285,
    CSSPropertyWebkitBorderVerticalSpacing = 286,
    CSSPropertyWebkitBoxAlign = 287,
    CSSPropertyWebkitBoxDecorationBreak = 288,
    CSSPropertyWebkitBoxDirection = 289,
    CSSPropertyWebkitBoxFlex = 290,
    CSSPropertyWebkitBoxFlexGroup = 291,
    CSSPropertyWebkitBoxLines = 292,
    CSSPropertyWebkitBoxOrdinalGroup = 293,
    CSSPropertyWebkitBoxOrient = 294,
    CSSPropertyWebkitBoxPack = 295,
    CSSPropertyWebkitBoxReflect = 296,
    CSSPropertyWebkitColumnAxis = 297,
    CSSPropertyWebkitColumnProgression = 298,
    CSSPropertyWebkitCursorVisibility = 299,
    CSSPropertyWebkitFontSizeDelta = 300,
    CSSPropertyWebkitHyphenateCharacter = 301,
    CSSPropertyWebkitHyphenateLimitAfter = 302,
    CSSPropertyWebkitHyphenateLimitBefore = 303,
    CSSPropertyWebkitHyphenateLimitLines = 304,
    CSSPropertyWebkitHyphens = 305,
    CSSPropertyWebkitInitialLetter = 306,
    CSSPropertyWebkitLineAlign = 307,
    CSSPropertyWebkitLineBoxContain = 308,
    CSSPropertyWebkitLineClamp = 309,
    CSSPropertyWebkitLineGrid = 310,
    CSSPropertyWebkitLineSnap = 311,
    CSSPropertyWebkitMarqueeDirection = 312,
    CSSPropertyWebkitMarqueeIncrement = 313,
    CSSPropertyWebkitMarqueeRepetition = 314,
    CSSPropertyWebkitMarqueeSpeed = 315,
    CSSPropertyWebkitMarqueeStyle = 316,
    CSSPropertyWebkitMaskBoxImageOutset = 317,
    CSSPropertyWebkitMaskBoxImageRepeat = 318,
    CSSPropertyWebkitMaskBoxImageSlice = 319,
    CSSPropertyWebkitMaskBoxImageSource = 320,
    CSSPropertyWebkitMaskBoxImageWidth = 321,
    CSSPropertyWebkitMaskPositionX = 322,
    CSSPropertyWebkitMaskPositionY = 323,
    CSSPropertyWebkitNbspMode = 324,
    CSSPropertyWebkitRtlOrdering = 325,
    CSSPropertyWebkitTapHighlightColor = 326,
    CSSPropertyWebkitTextDecorationsInEffect = 327,
    CSSPropertyWebkitTextFillColor = 328,
    CSSPropertyWebkitTextSecurity = 329,
    CSSPropertyWebkitTextStrokeColor = 330,
    CSSPropertyWebkitTextStrokeWidth = 331,
    CSSPropertyWebkitUserDrag = 332,
    CSSPropertyWebkitUserModify = 333,
    CSSPropertyWebkitUserSelect = 334,
    CSSPropertyBackgroundClip = 335,
    CSSPropertyBackgroundOrigin = 336,
    CSSPropertyBlockSize = 337,
    CSSPropertyBorderBlockEndColor = 338,
    CSSPropertyBorderBlockEndStyle = 339,
    CSSPropertyBorderBlockEndWidth = 340,
    CSSPropertyBorderBlockStartColor = 341,
    CSSPropertyBorderBlockStartStyle = 342,
    CSSPropertyBorderBlockStartWidth = 343,
    CSSPropertyBorderBottomColor = 344,
    CSSPropertyBorderBottomLeftRadius = 345,
    CSSPropertyBorderBottomRightRadius = 346,
    CSSPropertyBorderBottomStyle = 347,
    CSSPropertyBorderBottomWidth = 348,
    CSSPropertyBorderEndEndRadius = 349,
    CSSPropertyBorderEndStartRadius = 350,
    CSSPropertyBorderInlineEndColor = 351,
    CSSPropertyBorderInlineEndStyle = 352,
    CSSPropertyBorderInlineEndWidth = 353,
    CSSPropertyBorderInlineStartColor = 354,
    CSSPropertyBorderInlineStartStyle = 355,
    CSSPropertyBorderInlineStartWidth = 356,
    CSSPropertyBorderLeftColor = 357,
    CSSPropertyBorderLeftStyle = 358,
    CSSPropertyBorderLeftWidth = 359,
    CSSPropertyBorderRightColor = 360,
    CSSPropertyBorderRightStyle = 361,
    CSSPropertyBorderRightWidth = 362,
    CSSPropertyBorderStartEndRadius = 363,
    CSSPropertyBorderStartStartRadius = 364,
    CSSPropertyBorderTopColor = 365,
    CSSPropertyBorderTopLeftRadius = 366,
    CSSPropertyBorderTopRightRadius = 367,
    CSSPropertyBorderTopStyle = 368,
    CSSPropertyBorderTopWidth = 369,
    CSSPropertyBottom = 370,
    CSSPropertyBoxShadow = 371,
    CSSPropertyContainIntrinsicBlockSize = 372,
    CSSPropertyContainIntrinsicHeight = 373,
    CSSPropertyContainIntrinsicInlineSize = 374,
    CSSPropertyContainIntrinsicWidth = 375,
    CSSPropertyHeight = 376,
    CSSPropertyInlineSize = 377,
    CSSPropertyInsetBlockEnd = 378,
    CSSPropertyInsetBlockStart = 379,
    CSSPropertyInsetInlineEnd = 380,
    CSSPropertyInsetInlineStart = 381,
    CSSPropertyLeft = 382,
    CSSPropertyMarginBlockEnd = 383,
    CSSPropertyMarginBlockStart = 384,
    CSSPropertyMarginBottom = 385,
    CSSPropertyMarginInlineEnd = 386,
    CSSPropertyMarginInlineStart = 387,
    CSSPropertyMarginLeft = 388,
    CSSPropertyMarginRight = 389,
    CSSPropertyMarginTop = 390,
    CSSPropertyMaskClip = 391,
    CSSPropertyMaskComposite = 392,
    CSSPropertyMaskMode = 393,
    CSSPropertyMaxBlockSize = 394,
    CSSPropertyMaxHeight = 395,
    CSSPropertyMaxInlineSize = 396,
    CSSPropertyMaxWidth = 397,
    CSSPropertyMinBlockSize = 398,
    CSSPropertyMinHeight = 399,
    CSSPropertyMinInlineSize = 400,
    CSSPropertyMinWidth = 401,
    CSSPropertyOverscrollBehaviorBlock = 402,
    CSSPropertyOverscrollBehaviorInline = 403,
    CSSPropertyOverscrollBehaviorX = 404,
    CSSPropertyOverscrollBehaviorY = 405,
    CSSPropertyPaddingBlockEnd = 406,
    CSSPropertyPaddingBlockStart = 407,
    CSSPropertyPaddingBottom = 408,
    CSSPropertyPaddingInlineEnd = 409,
    CSSPropertyPaddingInlineStart = 410,
    CSSPropertyPaddingLeft = 411,
    CSSPropertyPaddingRight = 412,
    CSSPropertyPaddingTop = 413,
    CSSPropertyRight = 414,
    CSSPropertyScrollMarginBlockEnd = 415,
    CSSPropertyScrollMarginBlockStart = 416,
    CSSPropertyScrollMarginBottom = 417,
    CSSPropertyScrollMarginInlineEnd = 418,
    CSSPropertyScrollMarginInlineStart = 419,
    CSSPropertyScrollMarginLeft = 420,
    CSSPropertyScrollMarginRight = 421,
    CSSPropertyScrollMarginTop = 422,
    CSSPropertyScrollPaddingBlockEnd = 423,
    CSSPropertyScrollPaddingBlockStart = 424,
    CSSPropertyScrollPaddingBottom = 425,
    CSSPropertyScrollPaddingInlineEnd = 426,
    CSSPropertyScrollPaddingInlineStart = 427,
    CSSPropertyScrollPaddingLeft = 428,
    CSSPropertyScrollPaddingRight = 429,
    CSSPropertyScrollPaddingTop = 430,
    CSSPropertyTextCombineUpright = 431,
    CSSPropertyTop = 432,
    CSSPropertyWidth = 433,
    CSSPropertyWebkitBackgroundClip = 434,
    CSSPropertyWebkitBackgroundOrigin = 435,
    CSSPropertyWebkitBoxShadow = 436,
    CSSPropertyWebkitMaskClip = 437,
    CSSPropertyWebkitMaskComposite = 438,
    CSSPropertyWebkitMaskSourceType = 439,
    CSSPropertyWebkitTextCombine = 440,
    CSSPropertyAll = 441,
    CSSPropertyAnimation = 442,
    CSSPropertyBackground = 443,
    CSSPropertyBackgroundPosition = 444,
    CSSPropertyBorder = 445,
    CSSPropertyBorderBlock = 446,
    CSSPropertyBorderBlockColor = 447,
    CSSPropertyBorderBlockEnd = 448,
    CSSPropertyBorderBlockStart = 449,
    CSSPropertyBorderBlockStyle = 450,
    CSSPropertyBorderBlockWidth = 451,
    CSSPropertyBorderBottom = 452,
    CSSPropertyBorderColor = 453,
    CSSPropertyBorderImage = 454,
    CSSPropertyBorderInline = 455,
    CSSPropertyBorderInlineColor = 456,
    CSSPropertyBorderInlineEnd = 457,
    CSSPropertyBorderInlineStart = 458,
    CSSPropertyBorderInlineStyle = 459,
    CSSPropertyBorderInlineWidth = 460,
    CSSPropertyBorderLeft = 461,
    CSSPropertyBorderRadius = 462,
    CSSPropertyBorderRight = 463,
    CSSPropertyBorderSpacing = 464,
    CSSPropertyBorderStyle = 465,
    CSSPropertyBorderTop = 466,
    CSSPropertyBorderWidth = 467,
    CSSPropertyColumnRule = 468,
    CSSPropertyColumns = 469,
    CSSPropertyContainIntrinsicSize = 470,
    CSSPropertyContainer = 471,
    CSSPropertyFlex = 472,
    CSSPropertyFlexFlow = 473,
    CSSPropertyFont = 474,
    CSSPropertyFontSynthesis = 475,
    CSSPropertyFontVariant = 476,
    CSSPropertyGap = 477,
    CSSPropertyGrid = 478,
    CSSPropertyGridArea = 479,
    CSSPropertyGridColumn = 480,
    CSSPropertyGridRow = 481,
    CSSPropertyGridTemplate = 482,
    CSSPropertyInset = 483,
    CSSPropertyInsetBlock = 484,
    CSSPropertyInsetInline = 485,
    CSSPropertyListStyle = 486,
    CSSPropertyMargin = 487,
    CSSPropertyMarginBlock = 488,
    CSSPropertyMarginInline = 489,
    CSSPropertyMarker = 490,
    CSSPropertyMask = 491,
    CSSPropertyMaskPosition = 492,
    CSSPropertyOffset = 493,
    CSSPropertyOutline = 494,
    CSSPropertyOverflow = 495,
    CSSPropertyOverscrollBehavior = 496,
    CSSPropertyPadding = 497,
    CSSPropertyPaddingBlock = 498,
    CSSPropertyPaddingInline = 499,
    CSSPropertyPageBreakAfter = 500,
    CSSPropertyPageBreakBefore = 501,
    CSSPropertyPageBreakInside = 502,
    CSSPropertyPerspectiveOrigin = 503,
    CSSPropertyPlaceContent = 504,
    CSSPropertyPlaceItems = 505,
    CSSPropertyPlaceSelf = 506,
    CSSPropertyScrollMargin = 507,
    CSSPropertyScrollMarginBlock = 508,
    CSSPropertyScrollMarginInline = 509,
    CSSPropertyScrollPadding = 510,
    CSSPropertyScrollPaddingBlock = 511,
    CSSPropertyScrollPaddingInline = 512,
    CSSPropertyTextDecoration = 513,
    CSSPropertyTextDecorationSkip = 514,
    CSSPropertyTextEmphasis = 515,
    CSSPropertyTransformOrigin = 516,
    CSSPropertyTransition = 517,
    CSSPropertyWebkitBackgroundSize = 518,
    CSSPropertyWebkitBorderImage = 519,
    CSSPropertyWebkitBorderRadius = 520,
    CSSPropertyWebkitColumnBreakAfter = 521,
    CSSPropertyWebkitColumnBreakBefore = 522,
    CSSPropertyWebkitColumnBreakInside = 523,
    CSSPropertyWebkitMask = 524,
    CSSPropertyWebkitMaskBoxImage = 525,
    CSSPropertyWebkitMaskPosition = 526,
    CSSPropertyWebkitPerspective = 527,
    CSSPropertyWebkitTextDecoration = 528,
    CSSPropertyWebkitTextOrientation = 529,
    CSSPropertyWebkitTextStroke = 530,
};

constexpr uint16_t firstCSSProperty = 2;
constexpr uint16_t numCSSProperties = 529;
constexpr unsigned maxCSSPropertyNameLength = 34;
constexpr auto firstTopPriorityProperty = CSSPropertyID::CSSPropertyColorScheme;
constexpr auto lastTopPriorityProperty = CSSPropertyID::CSSPropertyWebkitRubyPosition;
constexpr auto firstHighPriorityProperty = CSSPropertyID::CSSPropertyColor;
constexpr auto lastHighPriorityProperty = CSSPropertyID::CSSPropertyLetterSpacing;
constexpr auto firstLowPriorityProperty = CSSPropertyID::CSSPropertyAccentColor;
constexpr auto lastLowPriorityProperty = CSSPropertyID::CSSPropertyWebkitUserSelect;
constexpr auto firstDeferredProperty = CSSPropertyID::CSSPropertyBackgroundClip;
constexpr auto lastDeferredProperty = CSSPropertyID::CSSPropertyWebkitTextCombine;
constexpr auto firstShorthandProperty = CSSPropertyID::CSSPropertyAll;
constexpr auto lastShorthandProperty = CSSPropertyID::CSSPropertyWebkitTextStroke;
constexpr uint16_t numCSSPropertyLonghands = firstShorthandProperty - firstCSSProperty;
extern const std::array<CSSPropertyID, 408> computedPropertyIDs;

struct CSSPropertySettings {
    WTF_MAKE_STRUCT_FAST_ALLOCATED;

    bool CSSOMViewSmoothScrollingEnabled { false };
    bool accentColorEnabled { false };
    bool aspectRatioEnabled { false };
    bool colorFilterEnabled { false };
    bool cssContainIntrinsicSizeEnabled { false };
    bool cssContainerQueriesEnabled { false };
    bool cssContainmentEnabled { false };
    bool cssContentVisibilityEnabled { false };
    bool cssCounterStyleAtRulesEnabled { false };
    bool cssCustomPropertiesAndValuesEnabled { false };
    bool cssFontFaceSizeAdjustEnabled { false };
    bool cssIndividualTransformPropertiesEnabled { false };
    bool cssInputSecurityEnabled { false };
    bool cssMarginTrimEnabled { false };
    bool cssMotionPathEnabled { false };
    bool cssRhythmicSizingEnabled { false };
    bool cssScrollAnchoringEnabled { false };
    bool cssTextAlignLastEnabled { false };
    bool cssTextBoxTrimEnabled { false };
    bool cssTextGroupAlignEnabled { false };
    bool cssTextJustifyEnabled { false };
    bool cssTextSpacingEnabled { false };
    bool cssTextWrapEnabled { false };
    bool masonryEnabled { false };
    bool overscrollBehaviorEnabled { false };
    bool textAutosizingEnabled { false };
    bool webAnimationsCompositeOperationsEnabled { false };

    CSSPropertySettings() = default;
    explicit CSSPropertySettings(const Settings&);
};

bool operator==(const CSSPropertySettings&, const CSSPropertySettings&);
inline bool operator!=(const CSSPropertySettings& a, const CSSPropertySettings& b) { return !(a == b); }
void add(Hasher&, const CSSPropertySettings&);

constexpr bool isLonghand(CSSPropertyID);
bool isInternal(CSSPropertyID);
bool isExposed(CSSPropertyID, const Settings*);
bool isExposed(CSSPropertyID, const Settings&);
bool isExposed(CSSPropertyID, const CSSPropertySettings*);
bool isExposed(CSSPropertyID, const CSSPropertySettings&);

CSSPropertyID findCSSProperty(const char* characters, unsigned length);
ASCIILiteral nameLiteral(CSSPropertyID);
const AtomString& nameString(CSSPropertyID);
String nameForIDL(CSSPropertyID);

CSSPropertyID relatedProperty(CSSPropertyID);

template<CSSPropertyID first, CSSPropertyID last> struct CSSPropertiesRange {
    struct Iterator {
        uint16_t index { static_cast<uint16_t>(first) };
        constexpr CSSPropertyID operator*() const { return static_cast<CSSPropertyID>(index); }
        constexpr Iterator& operator++() { ++index; return *this; }
        constexpr bool operator==(std::nullptr_t) const { return index > static_cast<uint16_t>(last); }
        constexpr bool operator!=(std::nullptr_t) const { return index <= static_cast<uint16_t>(last); }
    };
    static constexpr Iterator begin() { return { }; }
    static constexpr std::nullptr_t end() { return nullptr; }
    static constexpr uint16_t size() { return last - first + 1; }
};
using AllCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastShorthandProperty>;
using AllLonghandCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastDeferredProperty>;
constexpr AllCSSPropertiesRange allCSSProperties() { return { }; }
constexpr AllLonghandCSSPropertiesRange allLonghandCSSProperties() { return { }; }

constexpr bool isLonghand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= firstCSSProperty && static_cast<uint16_t>(property) < static_cast<uint16_t>(firstShorthandProperty);
}
constexpr bool isShorthand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstShorthandProperty) && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastShorthandProperty);
}

} // namespace WebCore

namespace WTF {

template<> struct DefaultHash<WebCore::CSSPropertyID> : IntHash<unsigned> { };

template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(std::numeric_limits<uint16_t>::max()); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return static_cast<uint16_t>(value) == std::numeric_limits<uint16_t>::max(); }
};

} // namespace WTF

namespace std {

template<> struct iterator_traits<WebCore::AllCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };
template<> struct iterator_traits<WebCore::AllLonghandCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };

} // namespace std

