// This file is automatically generated from CSSProperties.json by the process-css-properties script. Do not edit it.

#pragma once

#include <array>
#include <wtf/HashFunctions.h>
#include <wtf/HashTraits.h>

namespace WebCore {

class Settings;

enum CSSPropertyID : uint16_t {
    CSSPropertyInvalid = 0,
    CSSPropertyCustom = 1,
    CSSPropertyColorScheme = 2,
    CSSPropertyWritingMode = 3,
    CSSPropertyWebkitRubyPosition = 4,
    CSSPropertyColor = 5,
    CSSPropertyDirection = 6,
    CSSPropertyDisplay = 7,
    CSSPropertyFontFamily = 8,
    CSSPropertyFontFeatureSettings = 9,
    CSSPropertyFontKerning = 10,
    CSSPropertyFontOpticalSizing = 11,
    CSSPropertyFontPalette = 12,
    CSSPropertyFontSize = 13,
    CSSPropertyFontSizeAdjust = 14,
    CSSPropertyFontStretch = 15,
    CSSPropertyFontStyle = 16,
    CSSPropertyFontSynthesisSmallCaps = 17,
    CSSPropertyFontSynthesisStyle = 18,
    CSSPropertyFontSynthesisWeight = 19,
    CSSPropertyFontVariantAlternates = 20,
    CSSPropertyFontVariantCaps = 21,
    CSSPropertyFontVariantEastAsian = 22,
    CSSPropertyFontVariantLigatures = 23,
    CSSPropertyFontVariantNumeric = 24,
    CSSPropertyFontVariantPosition = 25,
    CSSPropertyFontVariationSettings = 26,
    CSSPropertyFontWeight = 27,
    CSSPropertyTextOrientation = 28,
    CSSPropertyTextRendering = 29,
    CSSPropertyZoom = 30,
    CSSPropertyWebkitFontSmoothing = 31,
    CSSPropertyWebkitLocale = 32,
    CSSPropertyWebkitTextSizeAdjust = 33,
    CSSPropertyWebkitTextZoom = 34,
    CSSPropertyLetterSpacing = 35,
    CSSPropertyAccentColor = 36,
    CSSPropertyAdditiveSymbols = 37,
    CSSPropertyAlignContent = 38,
    CSSPropertyAlignItems = 39,
    CSSPropertyAlignSelf = 40,
    CSSPropertyAlignmentBaseline = 41,
    CSSPropertyAlt = 42,
    CSSPropertyAnimationComposition = 43,
    CSSPropertyAnimationDelay = 44,
    CSSPropertyAnimationDirection = 45,
    CSSPropertyAnimationDuration = 46,
    CSSPropertyAnimationFillMode = 47,
    CSSPropertyAnimationIterationCount = 48,
    CSSPropertyAnimationName = 49,
    CSSPropertyAnimationPlayState = 50,
    CSSPropertyAnimationTimingFunction = 51,
    CSSPropertyAppearance = 52,
    CSSPropertyAspectRatio = 53,
    CSSPropertyBackfaceVisibility = 54,
    CSSPropertyBackgroundAttachment = 55,
    CSSPropertyBackgroundBlendMode = 56,
    CSSPropertyBackgroundColor = 57,
    CSSPropertyBackgroundImage = 58,
    CSSPropertyBackgroundPositionX = 59,
    CSSPropertyBackgroundPositionY = 60,
    CSSPropertyBackgroundRepeat = 61,
    CSSPropertyBackgroundSize = 62,
    CSSPropertyBasePalette = 63,
    CSSPropertyBaselineShift = 64,
    CSSPropertyBorderCollapse = 65,
    CSSPropertyBorderImageOutset = 66,
    CSSPropertyBorderImageRepeat = 67,
    CSSPropertyBorderImageSlice = 68,
    CSSPropertyBorderImageSource = 69,
    CSSPropertyBorderImageWidth = 70,
    CSSPropertyBoxSizing = 71,
    CSSPropertyBreakAfter = 72,
    CSSPropertyBreakBefore = 73,
    CSSPropertyBreakInside = 74,
    CSSPropertyBufferedRendering = 75,
    CSSPropertyCaptionSide = 76,
    CSSPropertyCaretColor = 77,
    CSSPropertyClear = 78,
    CSSPropertyClip = 79,
    CSSPropertyClipPath = 80,
    CSSPropertyClipRule = 81,
    CSSPropertyColorInterpolation = 82,
    CSSPropertyColorInterpolationFilters = 83,
    CSSPropertyColumnCount = 84,
    CSSPropertyColumnFill = 85,
    CSSPropertyColumnGap = 86,
    CSSPropertyColumnRuleColor = 87,
    CSSPropertyColumnRuleStyle = 88,
    CSSPropertyColumnRuleWidth = 89,
    CSSPropertyColumnSpan = 90,
    CSSPropertyColumnWidth = 91,
    CSSPropertyContain = 92,
    CSSPropertyContainerName = 93,
    CSSPropertyContainerType = 94,
    CSSPropertyContent = 95,
    CSSPropertyContentVisibility = 96,
    CSSPropertyCounterIncrement = 97,
    CSSPropertyCounterReset = 98,
    CSSPropertyCursor = 99,
    CSSPropertyCx = 100,
    CSSPropertyCy = 101,
    CSSPropertyDominantBaseline = 102,
    CSSPropertyEmptyCells = 103,
    CSSPropertyFallback = 104,
    CSSPropertyFill = 105,
    CSSPropertyFillOpacity = 106,
    CSSPropertyFillRule = 107,
    CSSPropertyFilter = 108,
    CSSPropertyFlexBasis = 109,
    CSSPropertyFlexDirection = 110,
    CSSPropertyFlexGrow = 111,
    CSSPropertyFlexShrink = 112,
    CSSPropertyFlexWrap = 113,
    CSSPropertyFloat = 114,
    CSSPropertyFloodColor = 115,
    CSSPropertyFloodOpacity = 116,
    CSSPropertyFontDisplay = 117,
    CSSPropertyGlyphOrientationHorizontal = 118,
    CSSPropertyGlyphOrientationVertical = 119,
    CSSPropertyGridAutoColumns = 120,
    CSSPropertyGridAutoFlow = 121,
    CSSPropertyGridAutoRows = 122,
    CSSPropertyGridColumnEnd = 123,
    CSSPropertyGridColumnStart = 124,
    CSSPropertyGridRowEnd = 125,
    CSSPropertyGridRowStart = 126,
    CSSPropertyGridTemplateAreas = 127,
    CSSPropertyGridTemplateColumns = 128,
    CSSPropertyGridTemplateRows = 129,
    CSSPropertyHangingPunctuation = 130,
    CSSPropertyImageOrientation = 131,
    CSSPropertyImageRendering = 132,
    CSSPropertyInputSecurity = 133,
    CSSPropertyIsolation = 134,
    CSSPropertyJustifyContent = 135,
    CSSPropertyJustifyItems = 136,
    CSSPropertyJustifySelf = 137,
    CSSPropertyKerning = 138,
    CSSPropertyLeadingTrim = 139,
    CSSPropertyLightingColor = 140,
    CSSPropertyLineBreak = 141,
    CSSPropertyLineHeight = 142,
    CSSPropertyListStyleImage = 143,
    CSSPropertyListStylePosition = 144,
    CSSPropertyListStyleType = 145,
    CSSPropertyMarkerEnd = 146,
    CSSPropertyMarkerMid = 147,
    CSSPropertyMarkerStart = 148,
    CSSPropertyMaskImage = 149,
    CSSPropertyMaskOrigin = 150,
    CSSPropertyMaskRepeat = 151,
    CSSPropertyMaskSize = 152,
    CSSPropertyMaskType = 153,
    CSSPropertyMathStyle = 154,
    CSSPropertyMixBlendMode = 155,
    CSSPropertyNegative = 156,
    CSSPropertyObjectFit = 157,
    CSSPropertyObjectPosition = 158,
    CSSPropertyOffsetAnchor = 159,
    CSSPropertyOffsetDistance = 160,
    CSSPropertyOffsetPath = 161,
    CSSPropertyOffsetPosition = 162,
    CSSPropertyOffsetRotate = 163,
    CSSPropertyOpacity = 164,
    CSSPropertyOrder = 165,
    CSSPropertyOrphans = 166,
    CSSPropertyOutlineColor = 167,
    CSSPropertyOutlineOffset = 168,
    CSSPropertyOutlineStyle = 169,
    CSSPropertyOutlineWidth = 170,
    CSSPropertyOverflowAnchor = 171,
    CSSPropertyOverflowWrap = 172,
    CSSPropertyOverflowX = 173,
    CSSPropertyOverflowY = 174,
    CSSPropertyOverrideColors = 175,
    CSSPropertyPad = 176,
    CSSPropertyPage = 177,
    CSSPropertyPaintOrder = 178,
    CSSPropertyPerspective = 179,
    CSSPropertyPerspectiveOriginX = 180,
    CSSPropertyPerspectiveOriginY = 181,
    CSSPropertyPointerEvents = 182,
    CSSPropertyPosition = 183,
    CSSPropertyPrefix = 184,
    CSSPropertyPrintColorAdjust = 185,
    CSSPropertyQuotes = 186,
    CSSPropertyR = 187,
    CSSPropertyRange = 188,
    CSSPropertyResize = 189,
    CSSPropertyRotate = 190,
    CSSPropertyRowGap = 191,
    CSSPropertyRx = 192,
    CSSPropertyRy = 193,
    CSSPropertyScale = 194,
    CSSPropertyScrollBehavior = 195,
    CSSPropertyScrollSnapAlign = 196,
    CSSPropertyScrollSnapStop = 197,
    CSSPropertyScrollSnapType = 198,
    CSSPropertyShapeImageThreshold = 199,
    CSSPropertyShapeMargin = 200,
    CSSPropertyShapeOutside = 201,
    CSSPropertyShapeRendering = 202,
    CSSPropertySize = 203,
    CSSPropertySpeakAs = 204,
    CSSPropertySrc = 205,
    CSSPropertyStopColor = 206,
    CSSPropertyStopOpacity = 207,
    CSSPropertyStroke = 208,
    CSSPropertyStrokeColor = 209,
    CSSPropertyStrokeDasharray = 210,
    CSSPropertyStrokeDashoffset = 211,
    CSSPropertyStrokeLinecap = 212,
    CSSPropertyStrokeLinejoin = 213,
    CSSPropertyStrokeMiterlimit = 214,
    CSSPropertyStrokeOpacity = 215,
    CSSPropertyStrokeWidth = 216,
    CSSPropertySuffix = 217,
    CSSPropertySymbols = 218,
    CSSPropertySystem = 219,
    CSSPropertyTabSize = 220,
    CSSPropertyTableLayout = 221,
    CSSPropertyTextAlign = 222,
    CSSPropertyTextAlignLast = 223,
    CSSPropertyTextAnchor = 224,
    CSSPropertyTextDecorationColor = 225,
    CSSPropertyTextDecorationLine = 226,
    CSSPropertyTextDecorationSkipInk = 227,
    CSSPropertyTextDecorationStyle = 228,
    CSSPropertyTextDecorationThickness = 229,
    CSSPropertyTextEmphasisColor = 230,
    CSSPropertyTextEmphasisPosition = 231,
    CSSPropertyTextEmphasisStyle = 232,
    CSSPropertyTextIndent = 233,
    CSSPropertyTextJustify = 234,
    CSSPropertyTextOverflow = 235,
    CSSPropertyTextShadow = 236,
    CSSPropertyTextTransform = 237,
    CSSPropertyTextUnderlineOffset = 238,
    CSSPropertyTextUnderlinePosition = 239,
    CSSPropertyTouchAction = 240,
    CSSPropertyTransform = 241,
    CSSPropertyTransformBox = 242,
    CSSPropertyTransformOriginX = 243,
    CSSPropertyTransformOriginY = 244,
    CSSPropertyTransformOriginZ = 245,
    CSSPropertyTransformStyle = 246,
    CSSPropertyTransitionDelay = 247,
    CSSPropertyTransitionDuration = 248,
    CSSPropertyTransitionProperty = 249,
    CSSPropertyTransitionTimingFunction = 250,
    CSSPropertyTranslate = 251,
    CSSPropertyUnicodeBidi = 252,
    CSSPropertyUnicodeRange = 253,
    CSSPropertyVectorEffect = 254,
    CSSPropertyVerticalAlign = 255,
    CSSPropertyVisibility = 256,
    CSSPropertyWhiteSpace = 257,
    CSSPropertyWidows = 258,
    CSSPropertyWillChange = 259,
    CSSPropertyWordBreak = 260,
    CSSPropertyWordSpacing = 261,
    CSSPropertyX = 262,
    CSSPropertyY = 263,
    CSSPropertyZIndex = 264,
    CSSPropertyAppleColorFilter = 265,
    CSSPropertyApplePayButtonStyle = 266,
    CSSPropertyApplePayButtonType = 267,
    CSSPropertyInternalTextAutosizingStatus = 268,
    CSSPropertyWebkitBackdropFilter = 269,
    CSSPropertyWebkitBorderHorizontalSpacing = 270,
    CSSPropertyWebkitBorderVerticalSpacing = 271,
    CSSPropertyWebkitBoxAlign = 272,
    CSSPropertyWebkitBoxDecorationBreak = 273,
    CSSPropertyWebkitBoxDirection = 274,
    CSSPropertyWebkitBoxFlex = 275,
    CSSPropertyWebkitBoxFlexGroup = 276,
    CSSPropertyWebkitBoxLines = 277,
    CSSPropertyWebkitBoxOrdinalGroup = 278,
    CSSPropertyWebkitBoxOrient = 279,
    CSSPropertyWebkitBoxPack = 280,
    CSSPropertyWebkitBoxReflect = 281,
    CSSPropertyWebkitColumnAxis = 282,
    CSSPropertyWebkitColumnProgression = 283,
    CSSPropertyWebkitCursorVisibility = 284,
    CSSPropertyWebkitFontSizeDelta = 285,
    CSSPropertyWebkitHyphenateCharacter = 286,
    CSSPropertyWebkitHyphenateLimitAfter = 287,
    CSSPropertyWebkitHyphenateLimitBefore = 288,
    CSSPropertyWebkitHyphenateLimitLines = 289,
    CSSPropertyWebkitHyphens = 290,
    CSSPropertyWebkitInitialLetter = 291,
    CSSPropertyWebkitLineAlign = 292,
    CSSPropertyWebkitLineBoxContain = 293,
    CSSPropertyWebkitLineClamp = 294,
    CSSPropertyWebkitLineGrid = 295,
    CSSPropertyWebkitLineSnap = 296,
    CSSPropertyWebkitMarqueeDirection = 297,
    CSSPropertyWebkitMarqueeIncrement = 298,
    CSSPropertyWebkitMarqueeRepetition = 299,
    CSSPropertyWebkitMarqueeSpeed = 300,
    CSSPropertyWebkitMarqueeStyle = 301,
    CSSPropertyWebkitMaskBoxImage = 302,
    CSSPropertyWebkitMaskBoxImageOutset = 303,
    CSSPropertyWebkitMaskBoxImageRepeat = 304,
    CSSPropertyWebkitMaskBoxImageSlice = 305,
    CSSPropertyWebkitMaskBoxImageSource = 306,
    CSSPropertyWebkitMaskBoxImageWidth = 307,
    CSSPropertyWebkitMaskPositionX = 308,
    CSSPropertyWebkitMaskPositionY = 309,
    CSSPropertyWebkitNbspMode = 310,
    CSSPropertyWebkitRtlOrdering = 311,
    CSSPropertyWebkitTapHighlightColor = 312,
    CSSPropertyWebkitTextDecorationsInEffect = 313,
    CSSPropertyWebkitTextFillColor = 314,
    CSSPropertyWebkitTextSecurity = 315,
    CSSPropertyWebkitTextStrokeColor = 316,
    CSSPropertyWebkitTextStrokeWidth = 317,
    CSSPropertyWebkitUserDrag = 318,
    CSSPropertyWebkitUserModify = 319,
    CSSPropertyWebkitUserSelect = 320,
    CSSPropertyBackgroundClip = 321,
    CSSPropertyBackgroundOrigin = 322,
    CSSPropertyBlockSize = 323,
    CSSPropertyBorderBlockEndColor = 324,
    CSSPropertyBorderBlockEndStyle = 325,
    CSSPropertyBorderBlockEndWidth = 326,
    CSSPropertyBorderBlockStartColor = 327,
    CSSPropertyBorderBlockStartStyle = 328,
    CSSPropertyBorderBlockStartWidth = 329,
    CSSPropertyBorderBottomColor = 330,
    CSSPropertyBorderBottomLeftRadius = 331,
    CSSPropertyBorderBottomRightRadius = 332,
    CSSPropertyBorderBottomStyle = 333,
    CSSPropertyBorderBottomWidth = 334,
    CSSPropertyBorderEndEndRadius = 335,
    CSSPropertyBorderEndStartRadius = 336,
    CSSPropertyBorderInlineEndColor = 337,
    CSSPropertyBorderInlineEndStyle = 338,
    CSSPropertyBorderInlineEndWidth = 339,
    CSSPropertyBorderInlineStartColor = 340,
    CSSPropertyBorderInlineStartStyle = 341,
    CSSPropertyBorderInlineStartWidth = 342,
    CSSPropertyBorderLeftColor = 343,
    CSSPropertyBorderLeftStyle = 344,
    CSSPropertyBorderLeftWidth = 345,
    CSSPropertyBorderRightColor = 346,
    CSSPropertyBorderRightStyle = 347,
    CSSPropertyBorderRightWidth = 348,
    CSSPropertyBorderStartEndRadius = 349,
    CSSPropertyBorderStartStartRadius = 350,
    CSSPropertyBorderTopColor = 351,
    CSSPropertyBorderTopLeftRadius = 352,
    CSSPropertyBorderTopRightRadius = 353,
    CSSPropertyBorderTopStyle = 354,
    CSSPropertyBorderTopWidth = 355,
    CSSPropertyBottom = 356,
    CSSPropertyBoxShadow = 357,
    CSSPropertyContainIntrinsicBlockSize = 358,
    CSSPropertyContainIntrinsicHeight = 359,
    CSSPropertyContainIntrinsicInlineSize = 360,
    CSSPropertyContainIntrinsicWidth = 361,
    CSSPropertyHeight = 362,
    CSSPropertyInlineSize = 363,
    CSSPropertyInsetBlockEnd = 364,
    CSSPropertyInsetBlockStart = 365,
    CSSPropertyInsetInlineEnd = 366,
    CSSPropertyInsetInlineStart = 367,
    CSSPropertyLeft = 368,
    CSSPropertyMarginBlockEnd = 369,
    CSSPropertyMarginBlockStart = 370,
    CSSPropertyMarginBottom = 371,
    CSSPropertyMarginInlineEnd = 372,
    CSSPropertyMarginInlineStart = 373,
    CSSPropertyMarginLeft = 374,
    CSSPropertyMarginRight = 375,
    CSSPropertyMarginTop = 376,
    CSSPropertyMaskClip = 377,
    CSSPropertyMaskComposite = 378,
    CSSPropertyMaskMode = 379,
    CSSPropertyMaxBlockSize = 380,
    CSSPropertyMaxHeight = 381,
    CSSPropertyMaxInlineSize = 382,
    CSSPropertyMaxWidth = 383,
    CSSPropertyMinBlockSize = 384,
    CSSPropertyMinHeight = 385,
    CSSPropertyMinInlineSize = 386,
    CSSPropertyMinWidth = 387,
    CSSPropertyOverscrollBehaviorBlock = 388,
    CSSPropertyOverscrollBehaviorInline = 389,
    CSSPropertyOverscrollBehaviorX = 390,
    CSSPropertyOverscrollBehaviorY = 391,
    CSSPropertyPaddingBlockEnd = 392,
    CSSPropertyPaddingBlockStart = 393,
    CSSPropertyPaddingBottom = 394,
    CSSPropertyPaddingInlineEnd = 395,
    CSSPropertyPaddingInlineStart = 396,
    CSSPropertyPaddingLeft = 397,
    CSSPropertyPaddingRight = 398,
    CSSPropertyPaddingTop = 399,
    CSSPropertyRight = 400,
    CSSPropertyScrollMarginBlockEnd = 401,
    CSSPropertyScrollMarginBlockStart = 402,
    CSSPropertyScrollMarginBottom = 403,
    CSSPropertyScrollMarginInlineEnd = 404,
    CSSPropertyScrollMarginInlineStart = 405,
    CSSPropertyScrollMarginLeft = 406,
    CSSPropertyScrollMarginRight = 407,
    CSSPropertyScrollMarginTop = 408,
    CSSPropertyScrollPaddingBlockEnd = 409,
    CSSPropertyScrollPaddingBlockStart = 410,
    CSSPropertyScrollPaddingBottom = 411,
    CSSPropertyScrollPaddingInlineEnd = 412,
    CSSPropertyScrollPaddingInlineStart = 413,
    CSSPropertyScrollPaddingLeft = 414,
    CSSPropertyScrollPaddingRight = 415,
    CSSPropertyScrollPaddingTop = 416,
    CSSPropertyTextCombineUpright = 417,
    CSSPropertyTop = 418,
    CSSPropertyWidth = 419,
    CSSPropertyWebkitBackgroundClip = 420,
    CSSPropertyWebkitBackgroundOrigin = 421,
    CSSPropertyWebkitBoxShadow = 422,
    CSSPropertyWebkitMaskClip = 423,
    CSSPropertyWebkitMaskComposite = 424,
    CSSPropertyWebkitMaskSourceType = 425,
    CSSPropertyWebkitTextCombine = 426,
    CSSPropertyAll = 427,
    CSSPropertyAnimation = 428,
    CSSPropertyBackground = 429,
    CSSPropertyBackgroundPosition = 430,
    CSSPropertyBorder = 431,
    CSSPropertyBorderBlock = 432,
    CSSPropertyBorderBlockColor = 433,
    CSSPropertyBorderBlockEnd = 434,
    CSSPropertyBorderBlockStart = 435,
    CSSPropertyBorderBlockStyle = 436,
    CSSPropertyBorderBlockWidth = 437,
    CSSPropertyBorderBottom = 438,
    CSSPropertyBorderColor = 439,
    CSSPropertyBorderImage = 440,
    CSSPropertyBorderInline = 441,
    CSSPropertyBorderInlineColor = 442,
    CSSPropertyBorderInlineEnd = 443,
    CSSPropertyBorderInlineStart = 444,
    CSSPropertyBorderInlineStyle = 445,
    CSSPropertyBorderInlineWidth = 446,
    CSSPropertyBorderLeft = 447,
    CSSPropertyBorderRadius = 448,
    CSSPropertyBorderRight = 449,
    CSSPropertyBorderSpacing = 450,
    CSSPropertyBorderStyle = 451,
    CSSPropertyBorderTop = 452,
    CSSPropertyBorderWidth = 453,
    CSSPropertyColumnRule = 454,
    CSSPropertyColumns = 455,
    CSSPropertyContainIntrinsicSize = 456,
    CSSPropertyContainer = 457,
    CSSPropertyFlex = 458,
    CSSPropertyFlexFlow = 459,
    CSSPropertyFont = 460,
    CSSPropertyFontSynthesis = 461,
    CSSPropertyFontVariant = 462,
    CSSPropertyGap = 463,
    CSSPropertyGrid = 464,
    CSSPropertyGridArea = 465,
    CSSPropertyGridColumn = 466,
    CSSPropertyGridRow = 467,
    CSSPropertyGridTemplate = 468,
    CSSPropertyInset = 469,
    CSSPropertyInsetBlock = 470,
    CSSPropertyInsetInline = 471,
    CSSPropertyListStyle = 472,
    CSSPropertyMargin = 473,
    CSSPropertyMarginBlock = 474,
    CSSPropertyMarginInline = 475,
    CSSPropertyMarker = 476,
    CSSPropertyMask = 477,
    CSSPropertyMaskPosition = 478,
    CSSPropertyOffset = 479,
    CSSPropertyOutline = 480,
    CSSPropertyOverflow = 481,
    CSSPropertyOverscrollBehavior = 482,
    CSSPropertyPadding = 483,
    CSSPropertyPaddingBlock = 484,
    CSSPropertyPaddingInline = 485,
    CSSPropertyPageBreakAfter = 486,
    CSSPropertyPageBreakBefore = 487,
    CSSPropertyPageBreakInside = 488,
    CSSPropertyPerspectiveOrigin = 489,
    CSSPropertyPlaceContent = 490,
    CSSPropertyPlaceItems = 491,
    CSSPropertyPlaceSelf = 492,
    CSSPropertyScrollMargin = 493,
    CSSPropertyScrollMarginBlock = 494,
    CSSPropertyScrollMarginInline = 495,
    CSSPropertyScrollPadding = 496,
    CSSPropertyScrollPaddingBlock = 497,
    CSSPropertyScrollPaddingInline = 498,
    CSSPropertyTextDecoration = 499,
    CSSPropertyTextDecorationSkip = 500,
    CSSPropertyTextEmphasis = 501,
    CSSPropertyTransformOrigin = 502,
    CSSPropertyTransition = 503,
    CSSPropertyWebkitBackgroundSize = 504,
    CSSPropertyWebkitBorderImage = 505,
    CSSPropertyWebkitBorderRadius = 506,
    CSSPropertyWebkitColumnBreakAfter = 507,
    CSSPropertyWebkitColumnBreakBefore = 508,
    CSSPropertyWebkitColumnBreakInside = 509,
    CSSPropertyWebkitMask = 510,
    CSSPropertyWebkitMaskPosition = 511,
    CSSPropertyWebkitPerspective = 512,
    CSSPropertyWebkitTextDecoration = 513,
    CSSPropertyWebkitTextOrientation = 514,
    CSSPropertyWebkitTextStroke = 515,
};

constexpr uint16_t firstCSSProperty = 2;
constexpr uint16_t numCSSProperties = 514;
constexpr unsigned maxCSSPropertyNameLength = 34;
constexpr auto firstTopPriorityProperty = CSSPropertyID::CSSPropertyColorScheme;
constexpr auto lastTopPriorityProperty = CSSPropertyID::CSSPropertyWebkitRubyPosition;
constexpr auto firstHighPriorityProperty = CSSPropertyID::CSSPropertyColor;
constexpr auto lastHighPriorityProperty = CSSPropertyID::CSSPropertyLetterSpacing;
constexpr auto firstLowPriorityProperty = CSSPropertyID::CSSPropertyAccentColor;
constexpr auto lastLowPriorityProperty = CSSPropertyID::CSSPropertyWebkitUserSelect;
constexpr auto firstDeferredProperty = CSSPropertyID::CSSPropertyBackgroundClip;
constexpr auto lastDeferredProperty = CSSPropertyID::CSSPropertyWebkitTextCombine;
constexpr auto firstShorthandProperty = CSSPropertyID::CSSPropertyAll;
constexpr auto lastShorthandProperty = CSSPropertyID::CSSPropertyWebkitTextStroke;
constexpr uint16_t numCSSPropertyLonghands = firstShorthandProperty - firstCSSProperty;
extern const std::array<CSSPropertyID, 399> computedPropertyIDs;

struct CSSPropertySettings {
    WTF_MAKE_STRUCT_FAST_ALLOCATED;

    bool CSSOMViewSmoothScrollingEnabled { false };
    bool accentColorEnabled { false };
    bool aspectRatioEnabled { false };
    bool colorFilterEnabled { false };
    bool cssContainIntrinsicSizeEnabled { false };
    bool cssContainerQueriesEnabled { false };
    bool cssContainmentEnabled { false };
    bool cssContentVisibilityEnabled { false };
    bool cssCounterStyleAtRulesEnabled { false };
    bool cssIndividualTransformPropertiesEnabled { false };
    bool cssInputSecurityEnabled { false };
    bool cssLeadingTrimEnabled { false };
    bool cssMotionPathEnabled { false };
    bool cssScrollAnchoringEnabled { false };
    bool cssTextAlignLastEnabled { false };
    bool cssTextJustifyEnabled { false };
    bool overscrollBehaviorEnabled { false };
    bool textAutosizingEnabled { false };
    bool webAnimationsCompositeOperationsEnabled { false };

    CSSPropertySettings() = default;
    explicit CSSPropertySettings(const Settings&);
};

bool operator==(const CSSPropertySettings&, const CSSPropertySettings&);
inline bool operator!=(const CSSPropertySettings& a, const CSSPropertySettings& b) { return !(a == b); }
void add(Hasher&, const CSSPropertySettings&);

constexpr bool isLonghand(CSSPropertyID);
bool isInternal(CSSPropertyID);
bool isExposed(CSSPropertyID, const Settings*);
bool isExposed(CSSPropertyID, const Settings&);
bool isExposed(CSSPropertyID, const CSSPropertySettings*);
bool isExposed(CSSPropertyID, const CSSPropertySettings&);

CSSPropertyID findCSSProperty(const char* characters, unsigned length);
ASCIILiteral nameLiteral(CSSPropertyID);
const AtomString& nameString(CSSPropertyID);
String nameForIDL(CSSPropertyID);

CSSPropertyID relatedProperty(CSSPropertyID);

template<CSSPropertyID first, CSSPropertyID last> struct CSSPropertiesRange {
    struct Iterator {
        uint16_t index { static_cast<uint16_t>(first) };
        constexpr CSSPropertyID operator*() const { return static_cast<CSSPropertyID>(index); }
        constexpr Iterator& operator++() { ++index; return *this; }
        constexpr bool operator==(std::nullptr_t) const { return index > static_cast<uint16_t>(last); }
        constexpr bool operator!=(std::nullptr_t) const { return index <= static_cast<uint16_t>(last); }
    };
    static constexpr Iterator begin() { return { }; }
    static constexpr std::nullptr_t end() { return nullptr; }
    static constexpr uint16_t size() { return last - first + 1; }
};
using AllCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastShorthandProperty>;
using AllLonghandCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastDeferredProperty>;
constexpr AllCSSPropertiesRange allCSSProperties() { return { }; }
constexpr AllLonghandCSSPropertiesRange allLonghandCSSProperties() { return { }; }

constexpr bool isLonghand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= firstCSSProperty && static_cast<uint16_t>(property) < static_cast<uint16_t>(firstShorthandProperty);
}

} // namespace WebCore

namespace WTF {

template<> struct DefaultHash<WebCore::CSSPropertyID> : IntHash<unsigned> { };

template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(std::numeric_limits<uint16_t>::max()); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return static_cast<uint16_t>(value) == std::numeric_limits<uint16_t>::max(); }
};

} // namespace WTF

namespace std {

template<> struct iterator_traits<WebCore::AllCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };
template<> struct iterator_traits<WebCore::AllLonghandCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };

} // namespace std

