/*
 * Copyright (C) 2017-2021 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#import <Foundation/Foundation.h>
#import <WebKit/WKFoundation.h>

NS_ASSUME_NONNULL_BEGIN

WK_EXTERN API_AVAILABLE(macos(10.13), ios(11.0))
@interface _WKWebsiteDataStoreConfiguration : NSObject

- (instancetype)init; // Creates a persistent configuration.
- (instancetype)initNonPersistentConfiguration API_AVAILABLE(macos(10.15), ios(13.0));

@property (nonatomic, readonly, getter=isPersistent) BOOL persistent API_AVAILABLE(macos(10.15), ios(13.0));

// These properties apply to both persistent and non-persistent data stores.
@property (nonatomic, nullable, copy) NSString *sourceApplicationBundleIdentifier API_AVAILABLE(macos(10.14.4), ios(12.2));
@property (nonatomic, nullable, copy) NSString *sourceApplicationSecondaryIdentifier API_AVAILABLE(macos(10.14.4), ios(12.2));
@property (nonatomic, nullable, copy, setter=setHTTPProxy:) NSURL *httpProxy API_AVAILABLE(macos(10.14.4), ios(12.2));
@property (nonatomic, nullable, copy, setter=setHTTPSProxy:) NSURL *httpsProxy API_AVAILABLE(macos(10.14.4), ios(12.2));
@property (nonatomic) BOOL deviceManagementRestrictionsEnabled API_AVAILABLE(macos(10.15), ios(13.0));
@property (nonatomic) BOOL networkCacheSpeculativeValidationEnabled API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic) BOOL fastServerTrustEvaluationEnabled API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic) NSUInteger perOriginStorageQuota API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic, nullable, copy) NSString *boundInterfaceIdentifier API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic) BOOL allowsCellularAccess API_AVAILABLE(macos(10.15.4), ios(14.0));
@property (nonatomic) BOOL legacyTLSEnabled API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic, nullable, copy) NSDictionary *proxyConfiguration API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic, nullable, copy) NSString *dataConnectionServiceType API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic) BOOL preventsSystemHTTPProxyAuthentication API_AVAILABLE(macos(11.0), ios(14.0));
@property (nonatomic) BOOL requiresSecureHTTPSProxyConnection API_AVAILABLE(macos(11.0), ios(14.0));
@property (nonatomic) BOOL shouldRunServiceWorkersOnMainThreadForTesting API_AVAILABLE(macos(12.1), ios(NA));

// FIXME: rdar://86641948 Remove acceptInsecureCertificatesForWebSockets once HAVE(NSURLSESSION_WEBSOCKET) is supported on all Cocoa platforms.
@property (nonatomic, setter=_setShouldAcceptInsecureCertificatesForWebSockets:) BOOL _shouldAcceptInsecureCertificatesForWebSockets API_AVAILABLE(macos(12.1), ios(NA));

// These properties only make sense for persistent data stores, and will throw
// an exception if set for non-persistent stores.
@property (nonatomic, copy, setter=_setWebStorageDirectory:) NSURL *_webStorageDirectory;
@property (nonatomic, copy, setter=_setIndexedDBDatabaseDirectory:) NSURL *_indexedDBDatabaseDirectory;
@property (nonatomic, copy, setter=_setWebSQLDatabaseDirectory:) NSURL *_webSQLDatabaseDirectory;
@property (nonatomic, copy, setter=_setCookieStorageFile:) NSURL *_cookieStorageFile;
@property (nonatomic, copy, setter=_setResourceLoadStatisticsDirectory:) NSURL *_resourceLoadStatisticsDirectory API_AVAILABLE(macos(10.13.4), ios(11.3));
@property (nonatomic, nullable, copy) NSURL *privateClickMeasurementStorageDirectory API_AVAILABLE(macos(12.1), ios(NA));
@property (nonatomic, copy, setter=_setCacheStorageDirectory:) NSURL *_cacheStorageDirectory API_AVAILABLE(macos(10.13.4), ios(11.3));
@property (nonatomic, copy, setter=_setServiceWorkerRegistrationDirectory:) NSURL *_serviceWorkerRegistrationDirectory API_AVAILABLE(macos(10.13.4), ios(11.3));
@property (nonatomic) BOOL serviceWorkerProcessTerminationDelayEnabled API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic, nullable, copy) NSURL *networkCacheDirectory API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic, nullable, copy) NSURL *deviceIdHashSaltsStorageDirectory API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic, nullable, copy) NSURL *applicationCacheDirectory API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic, nullable, copy) NSString *applicationCacheFlatFileSubdirectoryName API_AVAILABLE(macos(10.4), ios(13.4));
@property (nonatomic, nullable, copy) NSURL *mediaCacheDirectory API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic, nullable, copy) NSURL *mediaKeysStorageDirectory API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic) NSUInteger testSpeedMultiplier API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic) BOOL suppressesConnectionTerminationOnSystemChange API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic) BOOL allowsServerPreconnect API_AVAILABLE(macos(10.15.4), ios(13.4));
@property (nonatomic, nullable, copy, setter=setHSTSStorageDirectory:) NSURL *hstsStorageDirectory API_AVAILABLE(macos(12.0), ios(15.0));
@property (nonatomic) BOOL enableInAppBrowserPrivacyForTesting API_AVAILABLE(macos(12.0), ios(15.0));
@property (nonatomic) BOOL allowsHSTSWithUntrustedRootCertificate API_AVAILABLE(macos(12.0), ios(15.0));
@property (nonatomic, nullable, copy, setter=setPCMMachServiceName:) NSString *pcmMachServiceName API_AVAILABLE(macos(12.1), ios(NA));
@property (nonatomic, nullable, copy, setter=setWebPushMachServiceName:) NSString *webPushMachServiceName API_AVAILABLE(macos(12.1), ios(NA));

@property (nonatomic, nullable, copy) NSURL *alternativeServicesStorageDirectory API_AVAILABLE(macos(11.0), ios(14.0));
@property (nonatomic, nullable, copy) NSURL *standaloneApplicationURL API_AVAILABLE(macos(11.0), ios(14.0));
@property (nonatomic, nullable, copy) NSURL *generalStorageDirectory API_AVAILABLE(macos(12.1), ios(NA));
@property (nonatomic) BOOL shouldUseCustomStoragePaths API_AVAILABLE(macos(12.1), ios(NA));

// Testing only.
@property (nonatomic) BOOL allLoadsBlockedByDeviceManagementRestrictionsForTesting API_AVAILABLE(macos(10.15), ios(13.0));
@property (nonatomic) BOOL webPushDaemonUsesMockBundlesForTesting API_AVAILABLE(macos(12.1), ios(NA));

@end

NS_ASSUME_NONNULL_END
