import{Settings as e,UIString as t,ObjectWrapper as s,Throttler as i}from"../common/common.js";import{NumberUtilities as r,StringUtilities as o}from"../platform/platform.js";import{OverlayModel as n,LayerTreeBase as a}from"../sdk/sdk.js";import{Widget as l,EmptyWidget as h,ARIAUtils as c,TreeOutline as d,ContextMenu as _,UIUtils as u,Toolbar as p,KeyboardShortcut as m,ShortcutsScreen as g,Geometry as y,XLink as f,ThrottledWidget as w}from"../ui/ui.js";import{PieChart as C,OverviewGrid as v}from"../perf_ui/perf_ui.js";class S{constructor(e,t){this._type=e,this._layer=t}static isEqual(e,t){return e&&t?e._isEqual(t):e===t}type(){return this._type}layer(){return this._layer}_isEqual(e){return!1}}const b={Layer:Symbol("Layer"),ScrollRect:Symbol("ScrollRect"),Snapshot:Symbol("Snapshot")};class x extends S{constructor(e){console.assert(e,"LayerSelection with empty layer"),super(b.Layer,e)}_isEqual(e){return e._type===b.Layer&&e.layer().id()===this.layer().id()}}class T extends S{constructor(e,t){super(b.ScrollRect,e),this.scrollRectIndex=t}_isEqual(e){return e._type===b.ScrollRect&&this.layer().id()===e.layer().id()&&this.scrollRectIndex===e.scrollRectIndex}}class L extends S{constructor(e,t){super(b.Snapshot,e),this._snapshot=t}_isEqual(e){return e._type===b.Snapshot&&this.layer().id()===e.layer().id()&&this._snapshot===e._snapshot}snapshot(){return this._snapshot}}var P=Object.freeze({__proto__:null,LayerView:class{hoverObject(e){}selectObject(e){}setLayerTree(e){}},Selection:S,Type:b,LayerSelection:x,ScrollRectSelection:T,SnapshotSelection:L,LayerViewHost:class{constructor(){this._views=[],this._selectedObject=null,this._hoveredObject=null,this._showInternalLayersSetting=e.Settings.instance().createSetting("layersShowInternalLayers",!1)}registerView(e){this._views.push(e)}setLayerSnapshotMap(e){this._snapshotLayers=e}getLayerSnapshotMap(){return this._snapshotLayers}setLayerTree(e){this._target=e.target();const t=this._selectedObject&&this._selectedObject.layer();!t||e&&e.layerById(t.id())||this.selectObject(null);const s=this._hoveredObject&&this._hoveredObject.layer();!s||e&&e.layerById(s.id())||this.hoverObject(null);for(const t of this._views)t.setLayerTree(e)}hoverObject(e){if(S.isEqual(this._hoveredObject,e))return;this._hoveredObject=e;const t=e&&e.layer();this._toggleNodeHighlight(t?t.nodeForSelfOrAncestor():null);for(const t of this._views)t.hoverObject(e)}selectObject(e){if(!S.isEqual(this._selectedObject,e)){this._selectedObject=e;for(const t of this._views)t.selectObject(e)}}selection(){return this._selectedObject}showContextMenu(e,s){e.defaultSection().appendCheckboxItem(t.UIString("Show internal layers"),this._toggleShowInternalLayers.bind(this),this._showInternalLayersSetting.get());const i=s&&s.layer()&&s.layer().nodeForSelfOrAncestor();i&&e.appendApplicableItems(i),e.show()}showInternalLayersSetting(){return this._showInternalLayersSetting}_toggleShowInternalLayers(){this._showInternalLayersSetting.set(!this._showInternalLayersSetting.get())}_toggleNodeHighlight(e){e?e.highlightForTwoSeconds():n.OverlayModel.hideDOMNodeHighlight()}}});class E extends l.Widget{constructor(e){super(!0),this.registerRequiredCSS("layer_viewer/layerDetailsView.css"),this._layerViewHost=e,this._layerViewHost.registerView(this),this._emptyWidget=new h.EmptyWidget(t.UIString("Select a layer to see its details")),this._layerSnapshotMap=this._layerViewHost.getLayerSnapshotMap(),this._buildContent()}hoverObject(e){}selectObject(e){this._selection=e,this.isShowing()&&this.update()}setLayerTree(e){}wasShown(){super.wasShown(),this.update()}_onScrollRectClicked(e,t){1===t.which&&this._layerViewHost.selectObject(new T(this._selection.layer(),e))}_invokeProfilerLink(){const e=this._selection.type()===b.Snapshot?this._selection:this._layerSnapshotMap.get(this._selection.layer());e&&this.dispatchEventToListeners(I.PaintProfilerRequested,e)}_createScrollRectElement(e,s){s&&this._scrollRectsCell.createTextChild(", ");const i=this._scrollRectsCell.createChild("span","scroll-rect");this._selection.scrollRectIndex===s&&i.classList.add("active"),i.textContent=t.UIString("%s %d × %d (at %d, %d)",O.get(e.type),e.rect.width,e.rect.height,e.rect.x,e.rect.y),i.addEventListener("click",this._onScrollRectClicked.bind(this,s),!1)}_formatStickyAncestorLayer(e,s){if(!s)return"";const i=s.nodeForSelfOrAncestor(),r=i?i.simpleSelector():t.UIString("<unnamed>");return t.UIString("%s: %s (%s)",e,r,s.id())}_createStickyAncestorChild(e,t){if(!t)return;this._stickyPositionConstraintCell.createTextChild(", ");this._stickyPositionConstraintCell.createChild("span").textContent=this._formatStickyAncestorLayer(e,t)}_populateStickyPositionConstraintCell(e){if(this._stickyPositionConstraintCell.removeChildren(),!e)return;const s=e.stickyBoxRect();this._stickyPositionConstraintCell.createChild("span").textContent=t.UIString("Sticky Box %d × %d (at %d, %d)",s.width,s.height,s.x,s.y),this._stickyPositionConstraintCell.createTextChild(", ");const i=e.containingBlockRect();this._stickyPositionConstraintCell.createChild("span").textContent=t.UIString("Containing Block %d × %d (at %d, %d)",i.width,i.height,i.x,i.y),this._createStickyAncestorChild(t.UIString("Nearest Layer Shifting Sticky Box"),e.nearestLayerShiftingStickyBox()),this._createStickyAncestorChild(t.UIString("Nearest Layer Shifting Containing Block"),e.nearestLayerShiftingContainingBlock())}update(){const e=this._selection&&this._selection.layer();if(!e)return this._tableElement.remove(),this._paintProfilerLink.remove(),void this._emptyWidget.show(this.contentElement);this._emptyWidget.detach(),this.contentElement.appendChild(this._tableElement),this.contentElement.appendChild(this._paintProfilerLink),this._sizeCell.textContent=t.UIString("%d × %d (at %d,%d)",e.width(),e.height(),e.offsetX(),e.offsetY()),this._paintCountCell.parentElement.classList.toggle("hidden",!e.paintCount()),this._paintCountCell.textContent=e.paintCount(),this._memoryEstimateCell.textContent=r.bytesToString(e.gpuMemoryUsage()),e.requestCompositingReasonIds().then(this._updateCompositingReasons.bind(this)),this._scrollRectsCell.removeChildren(),e.scrollRects().forEach(this._createScrollRectElement.bind(this)),this._populateStickyPositionConstraintCell(e.stickyPositionConstraint());const s=this._selection.type()===b.Snapshot?this._selection.snapshot():null;this._paintProfilerLink.classList.toggle("hidden",!(this._layerSnapshotMap.has(e)||s))}_buildContent(){this._tableElement=this.contentElement.createChild("table"),this._tbodyElement=this._tableElement.createChild("tbody"),this._sizeCell=this._createRow(t.UIString("Size")),this._compositingReasonsCell=this._createRow(t.UIString("Compositing Reasons")),this._memoryEstimateCell=this._createRow(t.UIString("Memory estimate")),this._paintCountCell=this._createRow(t.UIString("Paint count")),this._scrollRectsCell=this._createRow(t.UIString("Slow scroll regions")),this._stickyPositionConstraintCell=this._createRow(t.UIString("Sticky position constraint")),this._paintProfilerLink=this.contentElement.createChild("span","hidden devtools-link link-margin"),c.markAsLink(this._paintProfilerLink),this._paintProfilerLink.textContent=ls`Paint Profiler`,this._paintProfilerLink.tabIndex=0,this._paintProfilerLink.addEventListener("click",e=>{e.consume(!0),this._invokeProfilerLink()}),this._paintProfilerLink.addEventListener("keydown",e=>{isEnterKey(e)&&(e.consume(),this._invokeProfilerLink())})}_createRow(e){const t=this._tbodyElement.createChild("tr");return t.createChild("td").textContent=e,t.createChild("td")}_updateCompositingReasons(e){if(!e||!e.length)return void(this._compositingReasonsCell.textContent="n/a");this._compositingReasonsCell.removeChildren();const t=this._compositingReasonsCell.createChild("ul"),s=E.getCompositingReasons(e);for(const e of s)t.createChild("li").textContent=e}static getCompositingReasons(e){const t=[];for(const s of e){const e=R.get(s);e?t.push(e):console.error(`Compositing reason id '${s}' is not recognized.`)}return t}}const R=new Map([["transform3D",ls`Has a 3d transform.`],["video",ls`Is an accelerated video.`],["canvas",ls`Is an accelerated canvas, or is a display list backed canvas that was promoted to a layer based on a performance heuristic.`],["plugin",ls`Is an accelerated plugin.`],["iFrame",ls`Is an accelerated iFrame.`],["backfaceVisibilityHidden",ls`Has backface-visibility: hidden.`],["activeTransformAnimation",ls`Has an active accelerated transform animation or transition.`],["activeOpacityAnimation",ls`Has an active accelerated opacity animation or transition.`],["activeFilterAnimation",ls`Has an active accelerated filter animation or transition.`],["activeBackdropFilterAnimation",ls`Has an active accelerated backdrop filter animation or transition.`],["immersiveArOverlay",ls`Is DOM overlay for WebXR immersive-ar mode.`],["scrollDependentPosition",ls`Is fixed or sticky position.`],["overflowScrolling",ls`Is a scrollable overflow element.`],["overflowScrollingParent",ls`Scroll parent is not an ancestor.`],["outOfFlowClipping",ls`Has clipping ancestor.`],["videoOverlay",ls`Is overlay controls for video.`],["willChangeTransform",ls`Has a will-change: transform compositing hint.`],["willChangeOpacity",ls`Has a will-change: opacity compositing hint.`],["willChangeOther",ls`Has a will-change compositing hint other than transform and opacity.`],["backdropFilter",ls`Has a backdrop filter.`],["rootScroller",ls`Is the document.rootScroller.`],["assumedOverlap",ls`Might overlap other composited content.`],["overlap",ls`Overlaps other composited content.`],["negativeZIndexChildren",ls`Parent with composited negative z-index content.`],["squashingDisallowed",ls`Layer was separately composited because it could not be squashed.`],["opacityWithCompositedDescendants",ls`Has opacity that needs to be applied by compositor because of composited descendants.`],["maskWithCompositedDescendants",ls`Has a mask that needs to be known by compositor because of composited descendants.`],["reflectionWithCompositedDescendants",ls`Has a reflection that needs to be known by compositor because of composited descendants.`],["filterWithCompositedDescendants",ls`Has a filter effect that needs to be known by compositor because of composited descendants.`],["blendingWithCompositedDescendants",ls`Has a blending effect that needs to be known by compositor because of composited descendants.`],["clipsCompositingDescendants",ls`Has a clip that needs to be known by compositor because of composited descendants.`],["perspectiveWith3DDescendants",ls`Has a perspective transform that needs to be known by compositor because of 3d descendants.`],["preserve3DWith3DDescendants",ls`Has a preserves-3d property that needs to be known by compositor because of 3d descendants.`],["isolateCompositedDescendants",ls`Should isolate descendants to apply a blend effect.`],["positionFixedWithCompositedDescendants",ls`Is a position:fixed element with composited descendants.`],["root",ls`Is the root layer.`],["layerForHorizontalScrollbar",ls`Secondary layer, the horizontal scrollbar layer.`],["layerForVerticalScrollbar",ls`Secondary layer, the vertical scrollbar layer.`],["layerForOverflowControlsHost",ls`Secondary layer, the overflow controls host layer.`],["layerForScrollCorner",ls`Secondary layer, the scroll corner layer.`],["layerForScrollingContents",ls`Secondary layer, to house contents that can be scrolled.`],["layerForScrollingContainer",ls`Secondary layer, used to position the scrolling contents while scrolling.`],["layerForSquashingContents",ls`Secondary layer, home for a group of squashable content.`],["layerForSquashingContainer",ls`Secondary layer, no-op layer to place the squashing layer correctly in the composited layer tree.`],["layerForForeground",ls`Secondary layer, to contain any normal flow and positive z-index contents on top of a negative z-index layer.`],["layerForMask",ls`Secondary layer, to contain the mask contents.`],["layerForDecoration",ls`Layer painted on top of other layers as decoration.`],["layerForOther",ls`Layer for link highlight, frame overlay, etc.`]]),I={PaintProfilerRequested:Symbol("PaintProfilerRequested")},O=new Map([[a.Layer.ScrollRectType.NonFastScrollable,t.UIString("Non fast scrollable")],[a.Layer.ScrollRectType.TouchEventHandler,t.UIString("Touch event handler")],[a.Layer.ScrollRectType.WheelEventHandler,t.UIString("Wheel event handler")],[a.Layer.ScrollRectType.RepaintsOnScroll,t.UIString("Repaints on scroll")],[a.Layer.ScrollRectType.MainThreadScrollingReason,t.UIString("Main thread scrolling reason")]]);var M=Object.freeze({__proto__:null,LayerDetailsView:E,Events:I,slowScrollRectNames:O});const D=Symbol("layer");class A extends s.ObjectWrapper{constructor(e){super(),this._layerViewHost=e,this._layerViewHost.registerView(this),this._treeOutline=new d.TreeOutlineInShadow,this._treeOutline.element.classList.add("layer-tree","overflow-auto"),this._treeOutline.element.addEventListener("mousemove",this._onMouseMove.bind(this),!1),this._treeOutline.element.addEventListener("mouseout",this._onMouseMove.bind(this),!1),this._treeOutline.element.addEventListener("contextmenu",this._onContextMenu.bind(this),!0),c.setAccessibleName(this._treeOutline.contentElement,ls`Layers Tree Pane`),this._lastHoveredNode=null,this.element=this._treeOutline.element,this._layerViewHost.showInternalLayersSetting().addChangeListener(this._update,this)}focus(){this._treeOutline.focus()}selectObject(e){this.hoverObject(null);const t=e&&e.layer(),s=t&&t[D];s?s.revealAndSelect(!0):this._treeOutline.selectedTreeElement&&this._treeOutline.selectedTreeElement.deselect()}hoverObject(e){const t=e&&e.layer(),s=t&&t[D];s!==this._lastHoveredNode&&(this._lastHoveredNode&&this._lastHoveredNode.setHovered(!1),s&&s.setHovered(!0),this._lastHoveredNode=s)}setLayerTree(e){this._layerTree=e,this._update()}_update(){const e=this._layerViewHost.showInternalLayersSetting().get(),t=new Map;let s=null;this._layerTree&&(e||(s=this._layerTree.contentRoot()),s||(s=this._layerTree.root())),s&&this._layerTree.forEachLayer(function(i){if(!i.drawsContent()&&!e)return;t.get(i)&&console.assert(!1,"Duplicate layer: "+i.id()),t.set(i,!0);let r=i[D],o=i.parent();for(;o&&o!==s&&!o.drawsContent()&&!e;)o=o.parent();const n=i===s?this._treeOutline.rootElement():o[D];if(n)if(r){if(r.parent!==n){const e=this._treeOutline.selectedTreeElement;r.parent&&r.parent.removeChild(r),n.appendChild(r),e!==this._treeOutline.selectedTreeElement&&e.select()}r._update()}else r=new F(this,i),n.appendChild(r),i.drawsContent()||r.expand();else console.assert(!1,"Parent is not in the tree")}.bind(this),s);for(let e=this._treeOutline.rootElement().firstChild();e&&!e.root;)if(t.get(e._layer))e=e.traverseNextTreeElement(!1);else{const t=e.nextSibling||e.parent;e.parent.removeChild(e),e===this._lastHoveredNode&&(this._lastHoveredNode=null),e=t}if(!this._treeOutline.selectedTreeElement){const e=this._layerTree.contentRoot()||this._layerTree.root();e&&e[D].revealAndSelect(!0)}}_onMouseMove(e){const t=this._treeOutline.treeElementFromEvent(e);t!==this._lastHoveredNode&&this._layerViewHost.hoverObject(this._selectionForNode(t))}_selectedNodeChanged(e){this._layerViewHost.selectObject(this._selectionForNode(e))}_onContextMenu(e){const t=this._selectionForNode(this._treeOutline.treeElementFromEvent(e)),s=new _.ContextMenu(e),i=t&&t.layer();i&&(this._layerSnapshotMap=this._layerViewHost.getLayerSnapshotMap(),this._layerSnapshotMap.has(i)&&s.defaultSection().appendItem(ls`Show Paint Profiler`,this.dispatchEventToListeners.bind(this,B.PaintProfilerRequested,t),!1)),this._layerViewHost.showContextMenu(s,t)}_selectionForNode(e){return e&&e._layer?new x(e._layer):null}}const B={PaintProfilerRequested:Symbol("PaintProfilerRequested")};class F extends d.TreeElement{constructor(e,t){super(),this._treeOutline=e,this._layer=t,this._layer[D]=this,this._update()}_update(){const e=this._layer.nodeForSelfOrAncestor(),s=createDocumentFragment();s.createTextChild(e?e.simpleSelector():"#"+this._layer.id());s.createChild("span","dimmed").textContent=t.UIString(" (%d × %d)",this._layer.width(),this._layer.height()),this.title=s}onselect(){return this._treeOutline._selectedNodeChanged(this),!1}setHovered(e){this.listItemElement.classList.toggle("hovered",e)}}var k=Object.freeze({__proto__:null,layerSymbol:D,LayerTreeOutline:A,Events:B,LayerTreeElement:F});class W extends s.ObjectWrapper{constructor(e,s){if(super(),this._shortcuts={},this.element=e,this._registerShortcuts(),u.installDragHandle(e,this._onDragStart.bind(this),this._onDrag.bind(this),this._onDragEnd.bind(this),"move",null),e.addEventListener("keydown",this._onKeyDown.bind(this),!1),e.addEventListener("mousewheel",this._onMouseWheel.bind(this),!1),this._minScale=0,this._maxScale=1/0,this._controlPanelToolbar=new p.Toolbar("transform-control-panel"),this._modeButtons={},!s){const e=new p.ToolbarToggle(t.UIString("Pan mode (X)"),"largeicon-pan");e.addEventListener(p.ToolbarButton.Events.Click,this._setMode.bind(this,U.Pan)),this._modeButtons[U.Pan]=e,this._controlPanelToolbar.appendToolbarItem(e);const s=new p.ToolbarToggle(t.UIString("Rotate mode (V)"),"largeicon-rotate");s.addEventListener(p.ToolbarButton.Events.Click,this._setMode.bind(this,U.Rotate)),this._modeButtons[U.Rotate]=s,this._controlPanelToolbar.appendToolbarItem(s)}this._setMode(U.Pan);const i=new p.ToolbarButton(t.UIString("Reset transform (0)"),"largeicon-center");i.addEventListener(p.ToolbarButton.Events.Click,this.resetAndNotify.bind(this,void 0)),this._controlPanelToolbar.appendToolbarItem(i),this._reset()}toolbar(){return this._controlPanelToolbar}_onKeyDown(e){const t=m.KeyboardShortcut.makeKeyFromEventIgnoringModifiers(e),s=this._shortcuts[t];s&&s(e)&&e.consume()}_addShortcuts(e,t){for(let s=0;s<e.length;++s)this._shortcuts[e[s].key]=t}_registerShortcuts(){this._addShortcuts(g.LayersPanelShortcuts.ResetView,this.resetAndNotify.bind(this)),this._addShortcuts(g.LayersPanelShortcuts.PanMode,this._setMode.bind(this,U.Pan)),this._addShortcuts(g.LayersPanelShortcuts.RotateMode,this._setMode.bind(this,U.Rotate));this._addShortcuts(g.LayersPanelShortcuts.ZoomIn,this._onKeyboardZoom.bind(this,1.1)),this._addShortcuts(g.LayersPanelShortcuts.ZoomOut,this._onKeyboardZoom.bind(this,1/1.1)),this._addShortcuts(g.LayersPanelShortcuts.Up,this._onKeyboardPanOrRotate.bind(this,0,-1)),this._addShortcuts(g.LayersPanelShortcuts.Down,this._onKeyboardPanOrRotate.bind(this,0,1)),this._addShortcuts(g.LayersPanelShortcuts.Left,this._onKeyboardPanOrRotate.bind(this,-1,0)),this._addShortcuts(g.LayersPanelShortcuts.Right,this._onKeyboardPanOrRotate.bind(this,1,0))}_postChangeEvent(){this.dispatchEventToListeners(H.TransformChanged)}_reset(){this._scale=1,this._offsetX=0,this._offsetY=0,this._rotateX=0,this._rotateY=0}_setMode(e){this._mode!==e&&(this._mode=e,this._updateModeButtons())}_updateModeButtons(){for(const e in this._modeButtons)this._modeButtons[e].setToggled(e===this._mode)}resetAndNotify(e){this._reset(),this._postChangeEvent(),e&&e.preventDefault(),this.element.focus()}setScaleConstraints(e,t){this._minScale=e,this._maxScale=t,this._scale=r.clamp(this._scale,e,t)}clampOffsets(e,t,s,i){this._offsetX=r.clamp(this._offsetX,e,t),this._offsetY=r.clamp(this._offsetY,s,i)}scale(){return this._scale}offsetX(){return this._offsetX}offsetY(){return this._offsetY}rotateX(){return this._rotateX}rotateY(){return this._rotateY}_onScale(e,t,s){e=r.clamp(this._scale*e,this._minScale,this._maxScale)/this._scale,this._scale*=e,this._offsetX-=(t-this._offsetX)*(e-1),this._offsetY-=(s-this._offsetY)*(e-1),this._postChangeEvent()}_onPan(e,t){this._offsetX+=e,this._offsetY+=t,this._postChangeEvent()}_onRotate(e,t){this._rotateX=e,this._rotateY=t,this._postChangeEvent()}_onKeyboardZoom(e){this._onScale(e,this.element.clientWidth/2,this.element.clientHeight/2)}_onKeyboardPanOrRotate(e,t){this._mode===U.Rotate?this._onRotate(this._rotateX+5*t,this._rotateY+5*e):this._onPan(6*e,6*t)}_onMouseWheel(e){const t=Math.pow(1.1,e.wheelDeltaY*(1/120));this._onScale(t,e.clientX-this.element.totalOffsetLeft(),e.clientY-this.element.totalOffsetTop())}_onDrag(e){this._mode===U.Rotate?this._onRotate(this._oldRotateX+(this._originY-e.clientY)/this.element.clientHeight*180,this._oldRotateY-(this._originX-e.clientX)/this.element.clientWidth*180):(this._onPan(e.clientX-this._originX,e.clientY-this._originY),this._originX=e.clientX,this._originY=e.clientY)}_onDragStart(e){return this.element.focus(),this._originX=e.clientX,this._originY=e.clientY,this._oldRotateX=this._rotateX,this._oldRotateY=this._rotateY,!0}_onDragEnd(){delete this._originX,delete this._originY,delete this._oldRotateX,delete this._oldRotateY}}const H={TransformChanged:Symbol("TransformChanged")},U={Pan:"Pan",Rotate:"Rotate"};var V=Object.freeze({__proto__:null,TransformController:W,Events:H,Modes:U});class N extends l.VBox{constructor(e){super(!0),this.registerRequiredCSS("layer_viewer/layers3DView.css"),this.contentElement.classList.add("layers-3d-view"),this._failBanner=new l.VBox,this._failBanner.element.classList.add("full-widget-dimmed-banner"),this._failBanner.element.createTextChild(t.UIString("Layer information is not yet available.")),this._layerViewHost=e,this._layerViewHost.registerView(this),this._transformController=new W(this.contentElement),this._transformController.addEventListener(H.TransformChanged,this._update,this),this._initToolbar(),this._canvasElement=this.contentElement.createChild("canvas"),this._canvasElement.tabIndex=0,this._canvasElement.addEventListener("dblclick",this._onDoubleClick.bind(this),!1),this._canvasElement.addEventListener("mousedown",this._onMouseDown.bind(this),!1),this._canvasElement.addEventListener("mouseup",this._onMouseUp.bind(this),!1),this._canvasElement.addEventListener("mouseleave",this._onMouseMove.bind(this),!1),this._canvasElement.addEventListener("mousemove",this._onMouseMove.bind(this),!1),this._canvasElement.addEventListener("contextmenu",this._onContextMenu.bind(this),!1),c.setAccessibleName(this._canvasElement,ls`3D Layers View`),this._lastSelection={},this._layerTree=null,this._textureManager=new ne(this._update.bind(this)),this._chromeTextures=[],this._rects=[],this._snapshotLayers=new Map,this._layerViewHost.setLayerSnapshotMap(this._snapshotLayers),this._layerViewHost.showInternalLayersSetting().addChangeListener(this._update,this)}setLayerTree(e){this._layerTree=e,this._layerTexture=null,delete this._oldTextureScale,this._showPaints()&&this._textureManager.setLayerTree(e),this._update()}showImageForLayer(e,t){if(!t)return this._layerTexture=null,void this._update();u.loadImage(t).then(t=>{const s=t&&ne._createTextureForImage(this._gl,t);this._layerTexture=s?{layer:e,texture:s}:null,this._update()})}onResize(){this._resizeCanvas(),this._update()}willHide(){this._textureManager.suspend()}wasShown(){this._textureManager.resume(),this._needsUpdate&&(this._resizeCanvas(),this._update())}updateLayerSnapshot(e){this._textureManager.layerNeedsUpdate(e)}_setOutline(e,t){this._lastSelection[e]=t,this._update()}hoverObject(e){this._setOutline(X.Hovered,e)}selectObject(e){this._setOutline(X.Hovered,null),this._setOutline(X.Selected,e)}snapshotForSelection(e){if(e.type()===b.Snapshot){const t=e.snapshot();return t.snapshot.addReference(),Promise.resolve(t)}if(e.layer()){const t=e.layer().snapshots()[0];if(t)return t}return Promise.resolve(null)}_initGL(e){const t=e.getContext("webgl");return t?(t.blendFunc(t.SRC_ALPHA,t.ONE_MINUS_SRC_ALPHA),t.enable(t.BLEND),t.clearColor(0,0,0,0),t.enable(t.DEPTH_TEST),t):null}_createShader(e,t){const s=this._gl.createShader(e);this._gl.shaderSource(s,t),this._gl.compileShader(s),this._gl.attachShader(this._shaderProgram,s)}_initShaders(){this._shaderProgram=this._gl.createProgram(),this._createShader(this._gl.FRAGMENT_SHADER,z),this._createShader(this._gl.VERTEX_SHADER,G),this._gl.linkProgram(this._shaderProgram),this._gl.useProgram(this._shaderProgram),this._shaderProgram.vertexPositionAttribute=this._gl.getAttribLocation(this._shaderProgram,"aVertexPosition"),this._gl.enableVertexAttribArray(this._shaderProgram.vertexPositionAttribute),this._shaderProgram.vertexColorAttribute=this._gl.getAttribLocation(this._shaderProgram,"aVertexColor"),this._gl.enableVertexAttribArray(this._shaderProgram.vertexColorAttribute),this._shaderProgram.textureCoordAttribute=this._gl.getAttribLocation(this._shaderProgram,"aTextureCoord"),this._gl.enableVertexAttribArray(this._shaderProgram.textureCoordAttribute),this._shaderProgram.pMatrixUniform=this._gl.getUniformLocation(this._shaderProgram,"uPMatrix"),this._shaderProgram.samplerUniform=this._gl.getUniformLocation(this._shaderProgram,"uSampler")}_resizeCanvas(){this._canvasElement.width=this._canvasElement.offsetWidth*window.devicePixelRatio,this._canvasElement.height=this._canvasElement.offsetHeight*window.devicePixelRatio}_updateTransformAndConstraints(){const e=this._layerTree.viewportSize(),t=e?e.width:this._dimensionsForAutoscale.width,s=e?e.height:this._dimensionsForAutoscale.height,i=this._canvasElement.width,o=this._canvasElement.height,n=.1*i,a=.1*o,l=(i-2*n)/t,h=(o-2*a)/s,c=Math.min(l,h),d=Math.min(t/this._dimensionsForAutoscale.width,s/this._dimensionsForAutoscale.width)/2;this._transformController.setScaleConstraints(d,10/c);const _=this._transformController.scale(),u=this._transformController.rotateX(),p=this._transformController.rotateY();this._scale=_*c;const m=r.clamp(this._scale,.1,1);m!==this._oldTextureScale&&(this._oldTextureScale=m,this._textureManager.setScale(m),this.dispatchEventToListeners(j.ScaleChanged,m));const g=(new WebKitCSSMatrix).scale(_,_,_).translate(i/2,o/2,0).rotate(u,p,0).scale(c,c,c).translate(-t/2,-s/2,0);let f;for(let e=0;e<this._rects.length;++e)f=y.boundsForTransformedPoints(g,this._rects[e].vertices,f);this._transformController.clampOffsets((n-f.maxX)/window.devicePixelRatio,(i-n-f.minX)/window.devicePixelRatio,(a-f.maxY)/window.devicePixelRatio,(o-a-f.minY)/window.devicePixelRatio);const w=this._transformController.offsetX()*window.devicePixelRatio,C=this._transformController.offsetY()*window.devicePixelRatio;this._projectionMatrix=(new WebKitCSSMatrix).translate(w,C,0).multiply(g);const v=(new WebKitCSSMatrix).scale(1,-1,-1).translate(-1,-1,0).scale(2/this._canvasElement.width,2/this._canvasElement.height,1e-6).multiply(this._projectionMatrix);this._gl.uniformMatrix4fv(this._shaderProgram.pMatrixUniform,!1,this._arrayFromMatrix(v))}_arrayFromMatrix(e){return new Float32Array([e.m11,e.m12,e.m13,e.m14,e.m21,e.m22,e.m23,e.m24,e.m31,e.m32,e.m33,e.m34,e.m41,e.m42,e.m43,e.m44])}_initWhiteTexture(){this._whiteTexture=this._gl.createTexture(),this._gl.bindTexture(this._gl.TEXTURE_2D,this._whiteTexture);const e=new Uint8Array([255,255,255,255]);this._gl.texImage2D(this._gl.TEXTURE_2D,0,this._gl.RGBA,1,1,0,this._gl.RGBA,this._gl.UNSIGNED_BYTE,e)}_initChromeTextures(){function e(e,t){u.loadImage(t).then(t=>{this._chromeTextures[e]=t&&ne._createTextureForImage(this._gl,t)||void 0})}e.call(this,Y.Left,"Images/chromeLeft.png"),e.call(this,Y.Middle,"Images/chromeMiddle.png"),e.call(this,Y.Right,"Images/chromeRight.png")}_initGLIfNecessary(){return this._gl?this._gl:(this._gl=this._initGL(this._canvasElement),this._gl?(this._initShaders(),this._initWhiteTexture(),this._initChromeTextures(),this._textureManager.setContext(this._gl),this._gl):null)}_calculateDepthsAndVisibility(){this._depthByLayerId={};let e=0;const t=this._layerViewHost.showInternalLayersSetting().get(),s=t?this._layerTree.root():this._layerTree.contentRoot()||this._layerTree.root(),i=[s];for(this._depthByLayerId[s.id()]=0,this._visibleLayers=new Set;i.length>0;){const s=i.shift();(t||s.drawsContent())&&this._visibleLayers.add(s);const r=s.children();for(let t=0;t<r.length;++t)this._depthByLayerId[r[t].id()]=++e,i.push(r[t])}this._maxDepth=e}_depthForLayer(e){return this._depthByLayerId[e.id()]*re}_calculateScrollRectDepth(e,t){return this._depthForLayer(e)+t*oe+1}_updateDimensionsForAutoscale(e){this._dimensionsForAutoscale.width=Math.max(e.width(),this._dimensionsForAutoscale.width),this._dimensionsForAutoscale.height=Math.max(e.height(),this._dimensionsForAutoscale.height)}_calculateLayerRect(e){if(!this._visibleLayers.has(e))return;const t=new x(e),s=new ae(t);s.setVertices(e.quad(),this._depthForLayer(e)),this._appendRect(s),this._updateDimensionsForAutoscale(e)}_appendRect(e){const t=e.relatedObject,s=S.isEqual(this._lastSelection[X.Selected],t),i=S.isEqual(this._lastSelection[X.Hovered],t);if(s)e.borderColor=Z;else if(i){e.borderColor=K;const t=e.fillColor||[255,255,255,1],s=ee;e.fillColor=[t[0]*s[0]/255,t[1]*s[1]/255,t[2]*s[2]/255,t[3]*s[3]]}else e.borderColor=Q;e.lineWidth=s?se:te,this._rects.push(e)}_calculateLayerScrollRects(e){const t=e.scrollRects();for(let s=0;s<t.length;++s){const i=new T(e,s),r=new ae(i);r.calculateVerticesFromRect(e,t[s].rect,this._calculateScrollRectDepth(e,s)),r.fillColor=$,this._appendRect(r)}}_calculateLayerTileRects(e){const t=this._textureManager.tilesForLayer(e);for(let s=0;s<t.length;++s){const i=t[s];if(!i.texture)continue;const r=new L(e,{rect:i.rect,snapshot:i.snapshot}),o=new ae(r);this._snapshotLayers.has(e)||this._snapshotLayers.set(e,r),o.calculateVerticesFromRect(e,i.rect,this._depthForLayer(e)+1),o.texture=i.texture,this._appendRect(o)}}_calculateRects(){if(this._rects=[],this._snapshotLayers.clear(),this._dimensionsForAutoscale={width:0,height:0},this._layerTree.forEachLayer(this._calculateLayerRect.bind(this)),this._showSlowScrollRectsSetting.get()&&this._layerTree.forEachLayer(this._calculateLayerScrollRects.bind(this)),this._layerTexture&&this._visibleLayers.has(this._layerTexture.layer)){const e=this._layerTexture.layer,t=new x(e),s=new ae(t);s.setVertices(e.quad(),this._depthForLayer(e)),s.texture=this._layerTexture.texture,this._appendRect(s)}else this._showPaints()&&this._layerTree.forEachLayer(this._calculateLayerTileRects.bind(this))}_makeColorsArray(e){let t=[];const s=[e[0]/255,e[1]/255,e[2]/255,e[3]];for(let e=0;e<4;e++)t=t.concat(s);return t}_setVertexAttribute(e,t,s){const i=this._gl,r=i.createBuffer();i.bindBuffer(i.ARRAY_BUFFER,r),i.bufferData(i.ARRAY_BUFFER,new Float32Array(t),i.STATIC_DRAW),i.vertexAttribPointer(e,s,i.FLOAT,!1,0,0)}_drawRectangle(e,t,s,i){const r=this._gl;s=s||[255,255,255,1],this._setVertexAttribute(this._shaderProgram.vertexPositionAttribute,e,3),this._setVertexAttribute(this._shaderProgram.textureCoordAttribute,[0,1,1,1,1,0,0,0],2),this._setVertexAttribute(this._shaderProgram.vertexColorAttribute,this._makeColorsArray(s),s.length),i?(r.activeTexture(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,i),r.uniform1i(this._shaderProgram.samplerUniform,0)):r.bindTexture(r.TEXTURE_2D,this._whiteTexture);const o=e.length/3;r.drawArrays(t,0,o)}_drawTexture(e,t,s){this._drawRectangle(e,this._gl.TRIANGLE_FAN,s,t)}_drawViewportAndChrome(){const t=this._layerTree.viewportSize();if(!t)return;const s=!e.Settings.instance().moduleSetting("frameViewerHideChromeWindow").get()&&this._chromeTextures.length>=3&&this._chromeTextures.indexOf(void 0)<0,i=(this._maxDepth+1)*re,r=Math.ceil(ie*this._scale);let o=[t.width,0,i,t.width,t.height,i,0,t.height,i,0,0,i];if(this._gl.lineWidth(r),this._drawRectangle(o,s?this._gl.LINE_STRIP:this._gl.LINE_LOOP,J),!s)return;const n=ie/2,a=this._layerTree.viewportSize().width+2*n,l=this._chromeTextures[0].image.naturalHeight,h=a-this._chromeTextures[0].image.naturalWidth-this._chromeTextures[2].image.naturalWidth;let c=-n;const d=-l;for(let e=0;e<this._chromeTextures.length;++e){const t=e===Y.Middle?h:this._chromeTextures[e].image.naturalWidth;if(t<0||c+t>a)break;o=[c,d,i,c+t,d,i,c+t,d+l,i,c,d+l,i],this._drawTexture(o,this._chromeTextures[e]),c+=t}}_drawViewRect(e){const t=e.vertices;e.texture?this._drawTexture(t,e.texture,e.fillColor||void 0):e.fillColor&&this._drawRectangle(t,this._gl.TRIANGLE_FAN,e.fillColor),this._gl.lineWidth(e.lineWidth),e.borderColor&&this._drawRectangle(t,this._gl.LINE_LOOP,e.borderColor)}_update(){if(!this.isShowing())return void(this._needsUpdate=!0);if(!this._layerTree||!this._layerTree.root())return void this._failBanner.show(this.contentElement);const e=this._initGLIfNecessary();if(!e)return this._failBanner.element.removeChildren(),this._failBanner.element.appendChild(this._webglDisabledBanner()),void this._failBanner.show(this.contentElement);this._failBanner.detach(),this._gl.viewportWidth=this._canvasElement.width,this._gl.viewportHeight=this._canvasElement.height,this._calculateDepthsAndVisibility(),this._calculateRects(),this._updateTransformAndConstraints(),e.viewport(0,0,e.viewportWidth,e.viewportHeight),e.clear(e.COLOR_BUFFER_BIT|e.DEPTH_BUFFER_BIT),this._rects.forEach(this._drawViewRect.bind(this)),this._drawViewportAndChrome()}_webglDisabledBanner(){const e=this.contentElement.ownerDocument.createDocumentFragment();return e.createChild("div").textContent=t.UIString("Can't display layers,"),e.createChild("div").textContent=t.UIString("WebGL support is disabled in your browser."),e.appendChild(u.formatLocalized("Check %s for possible reasons.",[f.XLink.create("about:gpu")])),e}_selectionFromEventPoint(e){if(!this._layerTree)return null;let t=1/0,s=null;const i=(new WebKitCSSMatrix).scale(1,-1,-1).translate(-1,-1,0).multiply(this._projectionMatrix),r=(e.clientX-this._canvasElement.totalOffsetLeft())*window.devicePixelRatio,o=-(e.clientY-this._canvasElement.totalOffsetTop())*window.devicePixelRatio;return this._rects.forEach((function(e){if(!e.relatedObject)return;const n=e.intersectWithLine(i,r,o);n<t&&(t=n,s=e.relatedObject)})),s}_createVisibilitySetting(s,i,r,o){const n=e.Settings.instance().createSetting(i,r);return n.setTitle(t.UIString(s)),n.addChangeListener(this._update,this),o.appendToolbarItem(new p.ToolbarSettingCheckbox(n)),n}_initToolbar(){this._panelToolbar=this._transformController.toolbar(),this.contentElement.appendChild(this._panelToolbar.element),this._showSlowScrollRectsSetting=this._createVisibilitySetting(ls`Slow scroll rects`,"frameViewerShowSlowScrollRects",!0,this._panelToolbar),this._showPaintsSetting=this._createVisibilitySetting(ls`Paints`,"frameViewerShowPaints",!0,this._panelToolbar),this._showPaintsSetting.addChangeListener(this._updatePaints,this),e.Settings.instance().moduleSetting("frameViewerHideChromeWindow").addChangeListener(this._update,this)}_onContextMenu(e){const s=new _.ContextMenu(e);s.defaultSection().appendItem(t.UIString("Reset View"),this._transformController.resetAndNotify.bind(this._transformController),!1);const i=this._selectionFromEventPoint(e);i&&i.type()===b.Snapshot&&s.defaultSection().appendItem(t.UIString("Show Paint Profiler"),this.dispatchEventToListeners.bind(this,j.PaintProfilerRequested,i),!1),this._layerViewHost.showContextMenu(s,i)}_onMouseMove(e){e.which||this._layerViewHost.hoverObject(this._selectionFromEventPoint(e))}_onMouseDown(e){this._mouseDownX=e.clientX,this._mouseDownY=e.clientY}_onMouseUp(e){this._mouseDownX&&Math.abs(e.clientX-this._mouseDownX)<6&&Math.abs(e.clientY-this._mouseDownY)<6&&this._layerViewHost.selectObject(this._selectionFromEventPoint(e)),delete this._mouseDownX,delete this._mouseDownY}_onDoubleClick(e){const t=this._selectionFromEventPoint(e);t&&(t.type()===b.Snapshot||t.layer())&&this.dispatchEventToListeners(j.PaintProfilerRequested,t),e.stopPropagation()}_updatePaints(){this._showPaints()?(this._textureManager.setLayerTree(this._layerTree),this._textureManager.forceUpdate()):this._textureManager.reset(),this._update()}_showPaints(){return this._showPaintsSetting.get()}}const X={Hovered:"hovered",Selected:"selected"},j={PaintProfilerRequested:Symbol("PaintProfilerRequested"),ScaleChanged:Symbol("ScaleChanged")},Y={Left:0,Middle:1,Right:2},q={RepaintsOnScroll:t.UIString("repaints on scroll"),TouchEventHandler:t.UIString("touch event listener"),WheelEventHandler:t.UIString("mousewheel event listener")},z="precision mediump float;\nvarying vec4 vColor;\nvarying vec2 vTextureCoord;\nuniform sampler2D uSampler;\nvoid main(void)\n{\n    gl_FragColor = texture2D(uSampler, vec2(vTextureCoord.s, vTextureCoord.t)) * vColor;\n}",G="attribute vec3 aVertexPosition;\nattribute vec2 aTextureCoord;\nattribute vec4 aVertexColor;\nuniform mat4 uPMatrix;\nvarying vec2 vTextureCoord;\nvarying vec4 vColor;\nvoid main(void)\n{\ngl_Position = uPMatrix * vec4(aVertexPosition, 1.0);\nvColor = aVertexColor;\nvTextureCoord = aTextureCoord;\n}",K=[0,0,255,1],Z=[0,255,0,1],Q=[0,0,0,1],J=[160,160,160,1],$=[178,100,100,.6],ee=[200,200,255,1],te=1,se=2,ie=3,re=20,oe=4;class ne{constructor(e){this._textureUpdatedCallback=e,this._throttler=new i.Throttler(0),this._scale=0,this._active=!1,this.reset()}static _createTextureForImage(e,t){const s=e.createTexture();return s.image=t,e.bindTexture(e.TEXTURE_2D,s),e.pixelStorei(e.UNPACK_FLIP_Y_WEBGL,1),e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,s.image),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE),e.bindTexture(e.TEXTURE_2D,null),s}reset(){this._tilesByLayer&&this.setLayerTree(null),this._tilesByLayer=new Map,this._queue=[]}setContext(e){this._gl=e,this._scale&&this._updateTextures()}suspend(){this._active=!1}resume(){this._active=!0,this._queue.length&&this._update()}setLayerTree(e){const t=new Set,s=Array.from(this._tilesByLayer.keys());e&&e.forEachLayer(e=>{e.drawsContent()&&(t.add(e),this._tilesByLayer.has(e)||(this._tilesByLayer.set(e,[]),this.layerNeedsUpdate(e)))}),s.length||this.forceUpdate();for(const e of s)t.has(e)||(this._tilesByLayer.get(e).forEach(e=>e.dispose()),this._tilesByLayer.delete(e))}_setSnapshotsForLayer(e,t){const s=new Map((this._tilesByLayer.get(e)||[]).map(e=>[e.snapshot,e])),i=[],r=[];for(const e of t){const t=s.get(e);t?(r.push(t),s.delete(t)):i.push(new le(e))}this._tilesByLayer.set(e,r.concat(i));for(const e of s.values())e.dispose();return this._gl&&this._scale?Promise.all(i.map(e=>e.update(this._gl,this._scale))).then(this._textureUpdatedCallback):Promise.resolve()}setScale(e){this._scale&&this._scale>=e||(this._scale=e,this._updateTextures())}tilesForLayer(e){return this._tilesByLayer.get(e)||[]}layerNeedsUpdate(e){this._queue.indexOf(e)<0&&this._queue.push(e),this._active&&this._throttler.schedule(this._update.bind(this))}forceUpdate(){this._queue.forEach(e=>this._updateLayer(e)),this._queue=[],this._update()}_update(){const e=this._queue.shift();return e?(this._queue.length&&this._throttler.schedule(this._update.bind(this)),this._updateLayer(e)):Promise.resolve()}_updateLayer(e){return Promise.all(e.snapshots()).then(t=>this._setSnapshotsForLayer(e,t.filter(e=>!!e)))}_updateTextures(){if(this._gl&&this._scale)for(const e of this._tilesByLayer.values())for(const t of e){const e=t.updateScale(this._gl,this._scale);e&&e.then(this._textureUpdatedCallback)}}}class ae{constructor(e){this.relatedObject=e,this.lineWidth=1,this.borderColor=null,this.fillColor=null,this.texture=null}setVertices(e,t){this.vertices=[e[0],e[1],t,e[2],e[3],t,e[4],e[5],t,e[6],e[7],t]}_calculatePointOnQuad(e,t,s){const i=e[0],r=e[1],o=e[2],n=e[3],a=e[4],l=e[5],h=e[6],c=e[7],d=i+t*(o-i),_=r+t*(n-r);return[d+s*(h+t*(a-h)-d),_+s*(c+t*(l-c)-_)]}calculateVerticesFromRect(e,t,s){const i=e.quad(),r=t.x/e.width(),o=(t.x+t.width)/e.width(),n=t.y/e.height(),a=(t.y+t.height)/e.height(),l=this._calculatePointOnQuad(i,r,n).concat(this._calculatePointOnQuad(i,o,n)).concat(this._calculatePointOnQuad(i,o,a)).concat(this._calculatePointOnQuad(i,r,a));this.setVertices(l,s)}intersectWithLine(e,t,s){let i;const r=[];for(i=0;i<4;++i)r[i]=y.multiplyVectorByMatrixAndNormalize(new y.Vector(this.vertices[3*i],this.vertices[3*i+1],this.vertices[3*i+2]),e);const o=y.crossProduct(y.subtract(r[1],r[0]),y.subtract(r[2],r[1])),n=o.x,a=o.y,l=o.z,h=-(-(n*r[0].x+a*r[0].y+l*r[0].z)+n*t+a*s)/l,c=new y.Vector(t,s,h),d=r.map(y.subtract.bind(null,c));for(i=0;i<d.length;++i){if(y.scalarProduct(o,y.crossProduct(d[i],d[(i+1)%d.length]))<0)return}return h}}class le{constructor(e){this.snapshot=e.snapshot,this.rect=e.rect,this.scale=0,this.texture=null}dispose(){this.snapshot.release(),this.texture&&(this._gl.deleteTexture(this.texture),this.texture=null)}updateScale(e,t){return this.texture&&this.scale>=t?null:this.update(e,t)}async update(e,t){this._gl=e,this.scale=t;const s=await this.snapshot.replay(t),i=s?await u.loadImage(s):null;this.texture=i?ne._createTextureForImage(e,i):null}}var he=Object.freeze({__proto__:null,Layers3DView:N,OutlineType:X,Events:j,ChromeTexture:Y,ScrollRectTitles:q,FragmentShader:z,VertexShader:G,HoveredBorderColor:K,SelectedBorderColor:Z,BorderColor:Q,ViewportBorderColor:J,ScrollRectBackgroundColor:$,HoveredImageMaskColor:ee,BorderWidth:te,SelectedBorderWidth:se,ViewportBorderWidth:ie,LayerSpacing:re,ScrollRectSpacing:oe,LayerTextureManager:ne,Rectangle:ae,Tile:le});class ce extends l.HBox{constructor(e){super(!0),this.registerRequiredCSS("layer_viewer/paintProfiler.css"),this.contentElement.classList.add("paint-profiler-overview"),this._canvasContainer=this.contentElement.createChild("div","paint-profiler-canvas-container"),this._progressBanner=this.contentElement.createChild("div","full-widget-dimmed-banner hidden"),this._progressBanner.textContent=t.UIString("Profiling…"),this._pieChart=C.createPieChart(),this._populatePieChart(0,[]),this._pieChart.classList.add("paint-profiler-pie-chart"),this.contentElement.appendChild(this._pieChart),this._showImageCallback=e,this._canvas=this._canvasContainer.createChild("canvas","fill"),this._context=this._canvas.getContext("2d"),this._selectionWindow=new v.Window(this._canvasContainer),this._selectionWindow.addEventListener(v.Events.WindowChanged,this._onWindowChanged,this),this._innerBarWidth=4*window.devicePixelRatio,this._minBarHeight=window.devicePixelRatio,this._barPaddingWidth=2*window.devicePixelRatio,this._outerBarWidth=this._innerBarWidth+this._barPaddingWidth,this._pendingScale=1,this._scale=this._pendingScale,this._reset()}static categories(){return ce._categories||(ce._categories={shapes:new me("shapes",t.UIString("Shapes"),"rgb(255, 161, 129)"),bitmap:new me("bitmap",t.UIString("Bitmap"),"rgb(136, 196, 255)"),text:new me("text",t.UIString("Text"),"rgb(180, 255, 137)"),misc:new me("misc",t.UIString("Misc"),"rgb(206, 160, 255)")}),ce._categories}static _initLogItemCategories(){if(ce._logItemCategoriesMap)return ce._logItemCategoriesMap;const e=ce.categories(),t={};return t.Clear=e.misc,t.DrawPaint=e.misc,t.DrawData=e.misc,t.SetMatrix=e.misc,t.PushCull=e.misc,t.PopCull=e.misc,t.Translate=e.misc,t.Scale=e.misc,t.Concat=e.misc,t.Restore=e.misc,t.SaveLayer=e.misc,t.Save=e.misc,t.BeginCommentGroup=e.misc,t.AddComment=e.misc,t.EndCommentGroup=e.misc,t.ClipRect=e.misc,t.ClipRRect=e.misc,t.ClipPath=e.misc,t.ClipRegion=e.misc,t.DrawPoints=e.shapes,t.DrawRect=e.shapes,t.DrawOval=e.shapes,t.DrawRRect=e.shapes,t.DrawPath=e.shapes,t.DrawVertices=e.shapes,t.DrawDRRect=e.shapes,t.DrawBitmap=e.bitmap,t.DrawBitmapRectToRect=e.bitmap,t.DrawBitmapMatrix=e.bitmap,t.DrawBitmapNine=e.bitmap,t.DrawSprite=e.bitmap,t.DrawPicture=e.bitmap,t.DrawText=e.text,t.DrawPosText=e.text,t.DrawPosTextH=e.text,t.DrawTextOnPath=e.text,ce._logItemCategoriesMap=t,t}static _categoryForLogItem(e){const t=o.toTitleCase(e.method),s=ce._initLogItemCategories();let i=s[t];return i||(i=ce.categories().misc,s[t]=i),i}onResize(){this._update()}async setSnapshotAndLog(e,t,s){if(this._reset(),this._snapshot=e,this._snapshot&&this._snapshot.addReference(),this._log=t,this._logCategories=this._log.map(ce._categoryForLogItem),!this._snapshot)return this._update(),this._populatePieChart(0,[]),void this._selectionWindow.setEnabled(!1);this._selectionWindow.setEnabled(!0),this._progressBanner.classList.remove("hidden"),this._updateImage();const i=await e.profile(s);this._progressBanner.classList.add("hidden"),this._profiles=i,this._update(),this._updatePieChart()}setScale(e){const t=e>this._scale;this._pendingScale=Math.min(1,2*e),t&&this._snapshot&&this._updateImage()}_update(){if(this._canvas.width=this._canvasContainer.clientWidth*window.devicePixelRatio,this._canvas.height=this._canvasContainer.clientHeight*window.devicePixelRatio,this._samplesPerBar=0,!this._profiles||!this._profiles.length)return;const e=Math.floor((this._canvas.width-2*this._barPaddingWidth)/this._outerBarWidth),t=this._log.length;this._samplesPerBar=Math.ceil(t/e);let s=0;const i=[],r=[];let o={};for(let e=0,n=0,a=0;e<t;){let l=this._logCategories[e]&&this._logCategories[e].name||"misc";const h=this._log[e].commandIndex;for(let e=0;e<this._profiles.length;e++){const t=this._profiles[e][h];a+=t,o[l]=(o[l]||0)+t}if(++e,e-n===this._samplesPerBar||e===t){const t=this._profiles.length*(e-n);for(l in a/=t,o)o[l]/=t;i.push(a),r.push(o),a>s&&(s=a),a=0,o={},n=e}}const n=4*window.devicePixelRatio,a=(this._canvas.height-n-this._minBarHeight)/s;for(let e=0;e<i.length;++e){for(const t in r[e])r[e][t]*=(i[e]*a+this._minBarHeight)/i[e];this._renderBar(e,r[e])}}_renderBar(e,t){const s=ce.categories();let i=0;const r=this._barPaddingWidth+e*this._outerBarWidth;for(const e in s){if(!t[e])continue;i+=t[e];const o=this._canvas.height-i;this._context.fillStyle=s[e].color,this._context.fillRect(r,o,this._innerBarWidth,t[e])}}_onWindowChanged(){this.dispatchEventToListeners(de.WindowChanged),this._updatePieChart(),this._updateImageTimer||(this._updateImageTimer=setTimeout(this._updateImage.bind(this),100))}_updatePieChart(){const{total:e,slices:t}=this._calculatePieChart();this._populatePieChart(e,t)}_calculatePieChart(){const e=this.selectionWindow();if(!this._profiles||!this._profiles.length||!e)return;let t=0;const s={};for(let i=e.left;i<e.right;++i){const e=this._log[i],r=ce._categoryForLogItem(e);s[r.color]=s[r.color]||0;for(let i=0;i<this._profiles.length;++i){const o=this._profiles[i][e.commandIndex];t+=o,s[r.color]+=o}}const i=[];for(const e in s)i.push({value:s[e]/this._profiles.length,color:e,title:""});return{total:t/this._profiles.length,slices:i}}_populatePieChart(e,t){this._pieChart.data={chartName:ls`Profiling results`,size:55,formatter:this._formatPieChartTime.bind(this),showLegend:!1,total:e,slices:t}}_formatPieChartTime(e){return Number.millisToString(1e3*e,!0)}selectionWindow(){if(!this._log)return null;const e=this._selectionWindow.windowLeft*this._canvas.width,t=this._selectionWindow.windowRight*this._canvas.width,s=Math.floor(e/this._outerBarWidth),i=Math.floor((t+this._innerBarWidth-this._barPaddingWidth/2)/this._outerBarWidth);return{left:r.clamp(s*this._samplesPerBar,0,this._log.length-1),right:r.clamp(i*this._samplesPerBar,0,this._log.length)}}_updateImage(){let e,t;delete this._updateImageTimer;const s=this.selectionWindow();this._profiles&&this._profiles.length&&s&&(e=this._log[s.left].commandIndex,t=this._log[s.right-1].commandIndex);const i=this._pendingScale;this._snapshot.replay(i,e,t).then(e=>{e&&(this._scale=i,this._showImageCallback(e))})}_reset(){this._snapshot&&this._snapshot.release(),this._snapshot=null,this._profiles=null,this._selectionWindow.reset(),this._selectionWindow.setEnabled(!1)}}const de={WindowChanged:Symbol("WindowChanged")};class _e extends w.ThrottledWidget{constructor(){super(),this.setMinimumSize(100,25),this.element.classList.add("overflow-auto"),this._treeOutline=new d.TreeOutlineInShadow,c.setAccessibleName(this._treeOutline.contentElement,ls`Command Log`),this.element.appendChild(this._treeOutline.element),this.setDefaultFocusedElement(this._treeOutline.contentElement),this._log=[]}setCommandLog(e){this._log=e,this._treeItemCache=new Map,this.updateWindow({left:0,right:this._log.length})}_appendLogItem(e){let t=this._treeItemCache.get(e);if(t){if(t.parent)return}else t=new ue(this,e),this._treeItemCache.set(e,t);this._treeOutline.appendChild(t)}updateWindow(e){this._selectionWindow=e,this.update()}doUpdate(){if(!this._selectionWindow||!this._log.length)return this._treeOutline.removeChildren(),Promise.resolve();const e=this._treeOutline.rootElement();for(;;){const t=e.firstChild();if(!t||t._logItem.commandIndex>=this._selectionWindow.left)break;e.removeChildAtIndex(0)}for(;;){const t=e.lastChild();if(!t||t._logItem.commandIndex<this._selectionWindow.right)break;e.removeChildAtIndex(e.children().length-1)}for(let e=this._selectionWindow.left,t=this._selectionWindow.right;e<t;++e)this._appendLogItem(this._log[e]);return Promise.resolve()}}class ue extends d.TreeElement{constructor(e,t){super("",!!t.params),this._logItem=t,this._ownerView=e,this._filled=!1}onattach(){this._update()}async onpopulate(){for(const e in this._logItem.params)pe._appendLogPropertyItem(this,e,this._logItem.params[e])}_paramToString(e,t){if("object"!=typeof e)return"string"==typeof e&&e.length>100?t:JSON.stringify(e);let s="",i=0;for(const r in e){if(++i>4||"object"==typeof e[r]||"string"==typeof e[r]&&e[r].length>100)return t;s&&(s+=", "),s+=e[r]}return s}_paramsToString(e){let t="";for(const s in e)t&&(t+=", "),t+=this._paramToString(e[s],s);return t}_update(){const e=createDocumentFragment();e.createTextChild(this._logItem.method+"("+this._paramsToString(this._logItem.params)+")"),this.title=e}}class pe extends d.TreeElement{constructor(e){super(),this._property=e}static _appendLogPropertyItem(e,t,s){const i=new pe({name:t,value:s});if(e.appendChild(i),s&&"object"==typeof s)for(const e in s)pe._appendLogPropertyItem(i,e,s[e])}onattach(){const e=createDocumentFragment();e.createChild("span","name").textContent=this._property.name;if(e.createChild("span","separator").textContent=": ",null===this._property.value||"object"!=typeof this._property.value){const t=e.createChild("span","value");t.textContent=JSON.stringify(this._property.value),t.classList.add("cm-js-"+(null===this._property.value?"null":typeof this._property.value))}this.title=e}}class me{constructor(e,t,s){this.name=e,this.title=t,this.color=s}}var ge=Object.freeze({__proto__:null,PaintProfilerView:ce,Events:de,PaintProfilerCommandLogView:_e,LogTreeElement:ue,LogPropertyTreeElement:pe,PaintProfilerCategory:me});export{M as LayerDetailsView,k as LayerTreeOutline,P as LayerViewHost,he as Layers3DView,ge as PaintProfilerView,V as TransformController};
