/// <reference types="node" />
import { ArtifactVerificationOptions, Bundle, Envelope, TransparencyLogEntry, VerificationMaterial } from '@sigstore/protobuf-specs';
import { x509Certificate } from '../../x509/cert';
import { WithRequired } from '../utility';
import { ValidBundle } from './validate';
import type { Entry } from '../../external/rekor';
import type { SignatureMaterial } from '../signature';
export * from '@sigstore/protobuf-specs';
export * from './serialized';
export * from './validate';
export declare const bundleFromJSON: (obj: any) => ValidBundle;
export type BundleWithVerificationMaterial = WithRequired<Bundle, 'verificationMaterial'>;
export declare function isBundleWithVerificationMaterial(bundle: Bundle): bundle is BundleWithVerificationMaterial;
export type BundleWithCertificateChain = Bundle & {
    verificationMaterial: VerificationMaterial & {
        content: Extract<VerificationMaterial['content'], {
            $case: 'x509CertificateChain';
        }>;
    };
};
export declare function isBundleWithCertificateChain(bundle: Bundle): bundle is BundleWithCertificateChain;
export type RequiredArtifactVerificationOptions = WithRequired<ArtifactVerificationOptions, 'ctlogOptions' | 'tlogOptions'>;
export type CAArtifactVerificationOptions = WithRequired<ArtifactVerificationOptions, 'ctlogOptions'> & {
    signers?: Extract<ArtifactVerificationOptions['signers'], {
        $case: 'certificateIdentities';
    }>;
};
export declare function isCAVerificationOptions(options: ArtifactVerificationOptions): options is CAArtifactVerificationOptions;
export type VerifiableTransparencyLogEntry = WithRequired<TransparencyLogEntry, 'logId' | 'inclusionPromise' | 'kindVersion'>;
export declare function isVerifiableTransparencyLogEntry(entry: TransparencyLogEntry): entry is VerifiableTransparencyLogEntry;
export declare function toDSSEBundle({ envelope, signature, tlogEntry, timestamp, }: {
    envelope: Envelope;
    signature: SignatureMaterial;
    tlogEntry?: Entry;
    timestamp?: Buffer;
}): Bundle;
export declare function toMessageSignatureBundle({ digest, signature, tlogEntry, timestamp, }: {
    digest: Buffer;
    signature: SignatureMaterial;
    tlogEntry?: Entry;
    timestamp?: Buffer;
}): Bundle;
export declare function signingCertificate(bundle: Bundle): x509Certificate | undefined;
