/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.UUID;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Main {
    private static final int MINIMUM_JAVA_VERSION = 11;
    private static final int MAXIMUM_JAVA_VERSION = 17;
    private static final Set<Integer> SUPPORTED_JAVA_VERSIONS = new HashSet<Integer>(Arrays.asList(11, 17));
    private static final int MINIMUM_JAVA_CLASS_VERSION = 55;
    private static final int MAXIMUM_JAVA_CLASS_VERSION = 61;
    private static final Set<Integer> SUPPORTED_JAVA_CLASS_VERSIONS = new HashSet<Integer>(Arrays.asList(55, 61));
    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());
    private static final String JSESSIONID_COOKIE_NAME = System.getProperty("executableWar.jetty.sessionIdCookieName");
    private static final boolean DISABLE_CUSTOM_JSESSIONID_COOKIE_NAME = Boolean.getBoolean("executableWar.jetty.disableCustomSessionIdCookieName");
    private static final String ENABLE_FUTURE_JAVA_CLI_SWITCH = "--enable-future-java";
    private static final String[] HOME_NAMES = new String[]{"JENKINS_HOME", "HUDSON_HOME"};

    public static void main(String[] args) throws IllegalAccessException {
        try {
            String v = System.getProperty("java.class.version");
            if (v != null) {
                String classVersionString = v.split("\\.")[0];
                try {
                    int javaVersion = Integer.parseInt(classVersionString);
                    Main.verifyJavaVersion(javaVersion, Main.isFutureJavaEnabled(args));
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.WARNING, "Failed to parse java.class.version: {0}. Will continue execution", v);
                }
            }
            Main._main(args);
        }
        catch (UnsupportedClassVersionError e) {
            System.err.printf("Jenkins requires Java versions %s but you are running with Java %s from %s%n", SUPPORTED_JAVA_VERSIONS, System.getProperty("java.specification.version"), System.getProperty("java.home"));
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void verifyJavaVersion(int javaClassVersion, boolean enableFutureJava) {
        String displayVersion = String.format("%d.0", javaClassVersion);
        if (SUPPORTED_JAVA_CLASS_VERSIONS.contains(javaClassVersion)) {
            return;
        }
        if (javaClassVersion <= 55) {
            UnsupportedClassVersionError error = new UnsupportedClassVersionError(displayVersion);
            LOGGER.log(Level.SEVERE, String.format("Running with Java class version %s, which is older than the Minimum required version %s. See https://jenkins.io/redirect/java-support/", javaClassVersion, 55), error);
            throw error;
        }
        if (enableFutureJava) {
            LOGGER.log(Level.WARNING, String.format("Running with Java class version %s which is not in the list of supported versions: %s. Argument %s is set, so will continue. See https://jenkins.io/redirect/java-support/", javaClassVersion, SUPPORTED_JAVA_CLASS_VERSIONS, ENABLE_FUTURE_JAVA_CLI_SWITCH));
            return;
        }
        UnsupportedClassVersionError error = new UnsupportedClassVersionError(displayVersion);
        LOGGER.log(Level.SEVERE, String.format("Running with Java class version %s which is not in the list of supported versions: %s. Run with the --enable-future-java flag to enable such behavior. See https://jenkins.io/redirect/java-support/", javaClassVersion, SUPPORTED_JAVA_CLASS_VERSIONS), error);
        throw error;
    }

    private static boolean isFutureJavaEnabled(String[] args) {
        return Main.hasArgument(ENABLE_FUTURE_JAVA_CLI_SWITCH, args) || Boolean.parseBoolean(System.getenv("JENKINS_ENABLE_FUTURE_JAVA"));
    }

    private static boolean hasArgument(@NonNull String argument, @NonNull String[] args) {
        for (String arg : args) {
            if (!argument.equals(arg)) continue;
            return true;
        }
        return false;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "THROWS_METHOD_THROWS_RUNTIMEEXCEPTION"}, justification="User provided values for running the program and intentional propagation of reflection errors")
    private static void _main(String[] args) throws IllegalAccessException {
        Field usage;
        Method mainMethod;
        Class<?> launcher;
        URLClassLoader cl;
        File tempFile;
        ArrayList<String> arguments;
        if (Main.hasArgument("--paramsFromStdIn", args)) {
            System.out.println("--paramsFromStdIn detected. Parameters are going to be read from stdin. Other parameters passed directly will be ignored.");
            String argsInStdIn = Main.readStringNonBlocking(System.in, 131072).trim();
            args = argsInStdIn.split(" +");
        }
        if ((arguments = new ArrayList<String>(Arrays.asList(args))).contains("--version")) {
            System.out.println(Main.getVersion("?"));
            return;
        }
        File extractedFilesFolder = null;
        for (String arg : args) {
            if (!arg.startsWith("--extractedFilesFolder=") || (extractedFilesFolder = new File(arg.substring("--extractedFilesFolder=".length()))).isDirectory()) continue;
            System.err.println("The extractedFilesFolder value is not a directory. Ignoring.");
            extractedFilesFolder = null;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("--logfile=")) continue;
            PrintStream ps = Main.createLogFileStream(new File(args[i].substring("--logfile=".length())));
            System.setOut(ps);
            System.setErr(ps);
            ArrayList<String> _args = new ArrayList<String>(Arrays.asList(args));
            _args.remove(i);
            args = _args.toArray(new String[0]);
            break;
        }
        for (String arg : args) {
            if (!arg.startsWith("--pluginroot=")) continue;
            System.setProperty("hudson.PluginManager.workDir", new File(arg.substring("--pluginroot=".length())).getAbsolutePath());
            break;
        }
        System.setProperty("java.awt.headless", "true");
        File me = Main.whoAmI(extractedFilesFolder);
        System.out.println("Running from: " + me);
        System.setProperty("executable-war", me.getAbsolutePath());
        Main.trimOffOurOptions(arguments);
        arguments.add(0, "--warfile=" + me.getAbsolutePath());
        if (!Main.hasOption(arguments, "--webroot=")) {
            FileAndDescription describedHomeDir = Main.getHomeDir();
            System.out.println("webroot: " + describedHomeDir.description);
            arguments.add("--webroot=" + new File(describedHomeDir.file, "war"));
        }
        if (extractedFilesFolder != null) {
            Main.deleteContentsFromFolder(extractedFilesFolder, "winstone.*\\.jar");
        }
        File tmpJar = Main.extractFromJar("winstone.jar", "winstone", ".jar", extractedFilesFolder);
        tmpJar.deleteOnExit();
        try {
            tempFile = File.createTempFile("dummy", "dummy");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Main.deleteWinstoneTempContents(new File(tempFile.getParent(), "winstone/" + me.getName()));
        if (!tempFile.delete()) {
            LOGGER.log(Level.WARNING, "Failed to delete the temporary file {0}", tempFile);
        }
        try {
            cl = new URLClassLoader(new URL[]{tmpJar.toURI().toURL()});
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
        try {
            launcher = cl.loadClass("winstone.Launcher");
            mainMethod = launcher.getMethod("main", String[].class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        try {
            usage = launcher.getField("USAGE");
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
        usage.set(null, "Jenkins Automation Server Engine " + Main.getVersion("") + "\nUsage: java -jar jenkins.war [--option=value] [--option=value]\n\nOptions:\n   --webroot                = folder where the WAR file is expanded into. Default is ${JENKINS_HOME}/war\n   --pluginroot             = folder where the plugin archives are expanded into. Default is ${JENKINS_HOME}/plugins\n                              (NOTE: this option does not change the directory where the plugin archives are stored)\n   --extractedFilesFolder   = folder where extracted files are to be located. Default is the temp folder\n   --logfile                = redirect log messages to this file\n   " + ENABLE_FUTURE_JAVA_CLI_SWITCH + "     = allows running with new Java versions which are not fully supported (class version " + 55 + " and above)\n{OPTIONS}");
        if (!DISABLE_CUSTOM_JSESSIONID_COOKIE_NAME) {
            try {
                Field f = cl.loadClass("winstone.WinstoneSession").getField("SESSION_COOKIE_NAME");
                f.setAccessible(true);
                if (JSESSIONID_COOKIE_NAME != null) {
                    f.set(null, JSESSIONID_COOKIE_NAME);
                } else {
                    f.set(null, "JSESSIONID." + UUID.randomUUID().toString().replace("-", "").substring(0, 8));
                }
            }
            catch (ClassNotFoundException | NoSuchFieldException e) {
                throw new AssertionError((Object)e);
            }
        }
        Thread.currentThread().setContextClassLoader(cl);
        try {
            mainMethod.invoke(null, new Object[]{arguments.toArray(new String[0])});
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof IOException) {
                throw new UncheckedIOException((IOException)t);
            }
            if (t instanceof Exception) {
                throw new RuntimeException(t);
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(e);
        }
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="--logfile relies on the default encoding, fine")
    private static PrintStream createLogFileStream(File file) {
        LogFileOutputStream los;
        try {
            los = new LogFileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
        return new PrintStream(los);
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING", "RR_NOT_CHECKED"}, justification="Legacy behavior, We expect less input than maxToRead")
    private static String readStringNonBlocking(InputStream in, int maxToRead) {
        byte[] buffer;
        try {
            buffer = new byte[Math.min(in.available(), maxToRead)];
            in.read(buffer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new String(buffer);
    }

    private static void trimOffOurOptions(List<String> arguments) {
        arguments.removeIf(arg -> arg.startsWith("--daemon") || arg.startsWith("--logfile") || arg.startsWith("--extractedFilesFolder") || arg.startsWith("--pluginroot") || arg.startsWith(ENABLE_FUTURE_JAVA_CLI_SWITCH));
    }

    private static String getVersion(String fallback) {
        try {
            Enumeration<URL> manifests = Main.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                URL res = manifests.nextElement();
                Manifest manifest = new Manifest(res.openStream());
                String v = manifest.getMainAttributes().getValue("Jenkins-Version");
                if (v == null) continue;
                return v;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return fallback;
    }

    private static boolean hasOption(List<String> args, String prefix) {
        for (String s : args) {
            if (!s.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "URLCONNECTION_SSRF_FD"}, justification="User provided values for running the program.")
    public static File whoAmI(File directory) {
        try {
            URL classFile = Main.class.getClassLoader().getResource("Main.class");
            JarFile jf = ((JarURLConnection)classFile.openConnection()).getJarFile();
            return new File(jf.getName());
        }
        catch (Exception x) {
            File myself;
            System.err.println("ZipFile.name trick did not work, using fallback: " + x);
            try {
                myself = File.createTempFile("jenkins", ".jar", directory);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            myself.deleteOnExit();
            try (InputStream is = Main.class.getProtectionDomain().getCodeSource().getLocation().openStream();
                 FileOutputStream os = new FileOutputStream(myself);){
                Main.copyStream(is, os);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return myself;
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="User provided values for running the program.")
    private static File extractFromJar(String resource, String fileName, String suffix, File directory) {
        File tmp;
        URL res = Main.class.getResource(resource);
        if (res == null) {
            throw new MissingResourceException("Unable to find the resource: " + resource, Main.class.getName(), resource);
        }
        try {
            tmp = File.createTempFile(fileName, suffix, directory);
        }
        catch (IOException e) {
            String tmpdir = directory == null ? System.getProperty("java.io.tmpdir") : directory.getAbsolutePath();
            throw new UncheckedIOException("Jenkins failed to create a temporary file in " + tmpdir + ": " + e, e);
        }
        try (InputStream is = res.openStream();
             FileOutputStream os = new FileOutputStream(tmp);){
            Main.copyStream(is, os);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        tmp.deleteOnExit();
        return tmp;
    }

    private static void deleteContentsFromFolder(File folder, String ... patterns) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                for (String pattern : patterns) {
                    if (!file.getName().matches(pattern)) continue;
                    LOGGER.log(Level.FINE, "Deleting the temporary file {0}", file);
                    Main.deleteWinstoneTempContents(file);
                }
            }
        }
    }

    private static void deleteWinstoneTempContents(File file) {
        File[] files;
        if (!file.exists()) {
            LOGGER.log(Level.FINEST, "No file found at {0}, nothing to delete.", file);
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File value : files) {
                Main.deleteWinstoneTempContents(value);
            }
        }
        if (!file.delete()) {
            LOGGER.log(Level.WARNING, "Failed to delete the temporary Winstone file {0}", file);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="User provided values for running the program.")
    private static FileAndDescription getHomeDir() {
        File legacyHome;
        for (String name : HOME_NAMES) {
            String sysProp = System.getProperty(name);
            if (sysProp == null) continue;
            return new FileAndDescription(new File(sysProp.trim()), "System.getProperty(\"" + name + "\")");
        }
        try {
            for (String name : HOME_NAMES) {
                String env = System.getenv(name);
                if (env == null) continue;
                return new FileAndDescription(new File(env.trim()).getAbsoluteFile(), "EnvVars.masterEnvVars.get(\"" + name + "\")");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if ((legacyHome = new File(new File(System.getProperty("user.home")), ".hudson")).exists()) {
            return new FileAndDescription(legacyHome, "$user.home/.hudson");
        }
        File newHome = new File(new File(System.getProperty("user.home")), ".jenkins");
        return new FileAndDescription(newHome, "$user.home/.jenkins");
    }

    private static class FileAndDescription {
        final File file;
        final String description;

        FileAndDescription(File file, String description) {
            this.file = file;
            this.description = description;
        }
    }
}

