/*
 * Decompiled with CFR 0.152.
 */
import [Ljava.lang.String;;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;

public class Main {
    public static void main(String[] args) throws Exception {
        File tmpJar;
        System.setProperty("java.awt.headless", "true");
        File me = Main.whoAmI();
        URL jar = Main.class.getResource("winstone.jar");
        try {
            tmpJar = File.createTempFile("winstone", "jar");
        }
        catch (IOException e) {
            String tmpdir = System.getProperty("java.io.tmpdir");
            IOException x = new IOException("Hudson has failed to create a temporary file in " + tmpdir);
            x.initCause(e);
            throw x;
        }
        Main.copyStream(jar.openStream(), new FileOutputStream(tmpJar));
        tmpJar.deleteOnExit();
        File tempFile = File.createTempFile("dummy", "dummy");
        Main.deleteContents(new File(tempFile.getParent(), "winstone/" + me.getName()));
        tempFile.delete();
        URLClassLoader cl = new URLClassLoader(new URL[]{tmpJar.toURL()});
        Class<?> launcher = cl.loadClass("winstone.Launcher");
        Method mainMethod = launcher.getMethod("main", String;.class);
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        arguments.add(0, "--warfile=" + me.getAbsolutePath());
        mainMethod.invoke(null, new Object[]{arguments.toArray(new String[0])});
    }

    public static File whoAmI() throws IOException, URISyntaxException {
        URL classFile = Main.class.getClassLoader().getResource("Main.class");
        return new File(((JarURLConnection)classFile.openConnection()).getJarFile().getName());
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    private static void deleteContents(File file) throws IOException {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                Main.deleteContents(files[i]);
            }
        }
        file.delete();
    }
}

