/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.LibraryRemover;
import com.izforge.izpack.util.NativeLibraryClient;
import com.izforge.izpack.util.TargetFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.StringCharacterIterator;
import java.util.Vector;

public class Librarian
implements CleanupClient {
    private static final String JAR_PROTOCOL = "jar";
    private static final String FILE_PROTOCOL = "file";
    private static final String TEMP_LOCATION_KEY = "java.io.tmpdir";
    private static final String CLIENT_EXTENSION = ".class";
    private static final String NATIVE = "native";
    private static final int BLOCK_SIZE = 4096;
    private static Librarian me = null;
    private Vector<String> trackList = new Vector();
    private Vector<NativeLibraryClient> clients = new Vector();
    private Vector<String> libraryNames = new Vector();
    private Vector<String> temporaryFileNames = new Vector();
    private String extension = "";
    private String nativeDirectory = "native";

    private Librarian() {
        Housekeeper.getInstance().registerForCleanup(this);
        this.extension = '.' + TargetFactory.getInstance().getNativeLibraryExtension();
    }

    public static Librarian getInstance() {
        if (me == null) {
            me = new Librarian();
        }
        return me;
    }

    public synchronized void loadLibrary(String string, NativeLibraryClient nativeLibraryClient) throws Exception {
        try {
            this.loadArchSpecificLibrary(string, nativeLibraryClient);
        }
        catch (Exception exception) {
            this.loadArchSpecificLibrary(string + "_x64", nativeLibraryClient);
        }
    }

    public synchronized void loadArchSpecificLibrary(String string, NativeLibraryClient nativeLibraryClient) throws Exception {
        String string2 = this.strip(string);
        String string3 = "";
        if (this.loaded(string2)) {
            return;
        }
        if (System.getProperty("DLL_PATH") != null) {
            String string4 = System.getProperty("DLL_PATH") + "/" + string + this.extension;
            string4 = string4.replace('/', File.separatorChar);
            Debug.trace("Try to load library " + string4);
            System.load(string4);
            return;
        }
        try {
            System.loadLibrary(string2);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Class<?> clazz = nativeLibraryClient.getClass();
        String string5 = clazz.getName();
        int n = string5.lastIndexOf(46) + 1;
        string5 = string5.substring(n, string5.length()) + CLIENT_EXTENSION;
        URL uRL = clazz.getResource(string5);
        if (uRL == null) {
            throw new Exception("can't identify load protocol for " + string2 + this.extension);
        }
        String string6 = uRL.getProtocol();
        if (string6.equalsIgnoreCase(FILE_PROTOCOL)) {
            try {
                System.load(this.getClientPath(string, uRL));
            }
            catch (Throwable throwable) {
                try {
                    System.load(this.getNativePath(string, nativeLibraryClient));
                }
                catch (Throwable throwable2) {
                    throw new Exception("error loading library");
                }
            }
        } else if (string6.equalsIgnoreCase(JAR_PROTOCOL)) {
            string3 = this.getTempFileName(string2);
            try {
                this.extractFromJar(string2, string3, nativeLibraryClient);
                this.clients.add(nativeLibraryClient);
                this.temporaryFileNames.add(string3);
                this.libraryNames.add(string3.substring(string3.lastIndexOf(File.separatorChar) + 1, string3.length()));
                System.load(string3);
            }
            catch (Throwable throwable) {
                throw new Exception("error loading library\n" + throwable.toString());
            }
        }
    }

    private boolean loaded(String string) {
        if (this.trackList.contains(string)) {
            return true;
        }
        this.trackList.add(string);
        return false;
    }

    private String strip(String string) {
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(47);
        if (n2 < 0) {
            n2 = string.lastIndexOf(92);
        }
        String string2 = n > 0 ? string.substring(n2, n) : string.substring(++n2, string.length());
        return string2;
    }

    private void extractFromJar(String string, String string2, NativeLibraryClient nativeLibraryClient) throws Exception {
        int n = 0;
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = this.openInputStream(string, nativeLibraryClient);
        try {
            fileOutputStream = new FileOutputStream(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            inputStream.close();
            throw new Exception("can't create destination file");
        }
        catch (SecurityException securityException) {
            inputStream.close();
            throw new Exception("creation of destination file denied");
        }
        catch (Throwable throwable) {
            inputStream.close();
            throw new Exception("unknown problem creating destination file\n" + throwable.toString());
        }
        byte[] byArray = new byte[4096];
        try {
            do {
                if ((n = inputStream.read(byArray)) <= 0) continue;
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            } while (n > 0);
        }
        catch (Throwable throwable) {
            throw new Exception("error writing to destination file\n" + throwable.toString());
        }
        finally {
            inputStream.close();
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
    }

    private String getClientPath(String string, URL uRL) {
        String string2 = uRL.getFile();
        int n = string2.lastIndexOf(47) + 1;
        string2 = string2.substring(0, n);
        string2 = string2 + string + this.extension;
        string2 = string2.replace('/', File.separatorChar);
        string2 = this.revisePath(string2);
        return string2;
    }

    private String getNativePath(String string, NativeLibraryClient nativeLibraryClient) {
        ProtectionDomain protectionDomain = nativeLibraryClient.getClass().getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL uRL = codeSource.getLocation();
        String string2 = uRL.getPath();
        string2 = string2 + this.nativeDirectory + '/' + string + this.extension;
        string2 = string2.replace('/', File.separatorChar);
        string2 = this.revisePath(string2);
        return string2;
    }

    private String revisePath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '%') {
                char c2 = stringCharacterIterator.next();
                if (c2 != '\uffff') {
                    int n = Character.digit(c2, 16);
                    char c3 = stringCharacterIterator.next();
                    if (c3 != '\uffff') {
                        int n2 = Character.digit(c3, 16);
                        stringBuffer.append((char)((n << 4) + n2));
                    }
                }
            } else {
                stringBuffer.append(c);
            }
            c = stringCharacterIterator.next();
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    private InputStream openInputStream(String string, NativeLibraryClient nativeLibraryClient) throws Exception {
        Class<?> clazz = nativeLibraryClient.getClass();
        InputStream inputStream = clazz.getResourceAsStream(string + this.extension);
        if (inputStream == null) {
            inputStream = clazz.getResourceAsStream('/' + this.nativeDirectory + '/' + string + this.extension);
        }
        if (inputStream == null) {
            throw new Exception("can't locate library");
        }
        return inputStream;
    }

    private String getTempFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty(TEMP_LOCATION_KEY);
        if (string2.charAt(string2.length() - 1) == File.separatorChar) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        String string3 = "";
        int n = 0;
        File file = null;
        do {
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(string2);
            stringBuffer.append(File.separatorChar);
            stringBuffer.append(string);
            stringBuffer.append(string3);
            stringBuffer.append(this.extension);
            string3 = Integer.toString(n);
            ++n;
        } while ((file = new File(stringBuffer.toString())).exists());
        return stringBuffer.toString();
    }

    public void setNativeDirectory(String string) {
        this.nativeDirectory = string == null ? "" : string;
    }

    public void cleanUp() {
        try {
            LibraryRemover.invoke(this.temporaryFileNames);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

