/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.ECoord;
import java.io.Serializable;

public class EdgeV
implements Serializable {
    private final double multiplier;
    private final int multiplierInt;
    private final ECoord adder;

    public EdgeV(double multiplier, double adder) {
        this.multiplier = multiplier;
        this.multiplierInt = multiplier == 0.0 ? 0 : (multiplier == 0.5 ? 1 : (multiplier == -0.5 ? -1 : Integer.MIN_VALUE));
        this.adder = ECoord.fromLambdaRoundGrid(adder);
    }

    public boolean equals(Object other) {
        if (!(other instanceof EdgeV)) {
            return false;
        }
        EdgeV otherE = (EdgeV)other;
        return this.multiplier == otherE.multiplier && this.adder.equals(otherE.adder);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.multiplier) ^ Double.doubleToLongBits(this.multiplier) >>> 32);
        hash = 17 * hash + (this.adder != null ? this.adder.hashCode() : 0);
        return hash;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public ECoord getAdder() {
        return this.adder;
    }

    public long getFixpValue(EPoint size) {
        long fixpAdder = this.adder.getFixp();
        switch (this.multiplierInt) {
            case -1: {
                return fixpAdder - (size.getFixpY() >> 1);
            }
            case 0: {
                return fixpAdder;
            }
            case 1: {
                return fixpAdder + (size.getFixpY() >> 1);
            }
        }
        return fixpAdder + (long)Math.rint(this.multiplier * (double)size.getFixpY());
    }

    public long getGridValue(EPoint size) {
        long gridAdder = this.adder.getGrid();
        switch (this.multiplierInt) {
            case -1: {
                return gridAdder - (size.getGridY() >> 1);
            }
            case 0: {
                return gridAdder;
            }
            case 1: {
                return gridAdder + (size.getGridY() >> 1);
            }
        }
        return gridAdder + (long)Math.rint(this.multiplier * (double)size.getGridY());
    }

    public EdgeV withGridAdder(long gridAdder) {
        if (this.adder.getFixp() == gridAdder) {
            return this;
        }
        return new EdgeV(this.multiplier, DBMath.gridToLambda(gridAdder));
    }

    public static EdgeV b(double amt) {
        return new EdgeV(-0.5, amt);
    }

    public static EdgeV c(double amt) {
        return new EdgeV(0.0, amt);
    }

    public static EdgeV t(double amt) {
        return new EdgeV(0.5, amt);
    }

    public static EdgeV by(double width, double amt) {
        return new EdgeV(amt / 2.0, amt * width / 2.0);
    }

    public static EdgeV by0(double amt) {
        return EdgeV.by(0.0, amt);
    }

    public static EdgeV by2(double amt) {
        return EdgeV.by(2.0, amt);
    }

    public static EdgeV by3(double amt) {
        return EdgeV.by(3.0, amt);
    }

    public static EdgeV by4(double amt) {
        return EdgeV.by(4.0, amt);
    }

    public static EdgeV by6(double amt) {
        return EdgeV.by(6.0, amt);
    }

    public static EdgeV by10(double amt) {
        return EdgeV.by(10.0, amt);
    }

    public static EdgeV fromTop(double amt) {
        return new EdgeV(0.5, -amt);
    }

    public static EdgeV fromBottom(double amt) {
        return new EdgeV(-0.5, amt);
    }

    public static EdgeV fromCenter(double amt) {
        return new EdgeV(0.0, amt);
    }

    public static EdgeV makeCenter() {
        return EdgeV.fromCenter(0.0);
    }

    public String toString() {
        return "EdgeV(" + this.multiplier + "," + this.adder.getLambda() + ")";
    }
}

