# etcd functional test suite

etcd functional test suite tests the functionality of an etcd cluster with a focus on failure resistance under high pressure. It sets up an etcd cluster and inject failures into the cluster by killing the process or isolate the network of the process. It expects the etcd cluster to recover within a short amount of time after fixing the fault.

etcd functional test suite has two components: etcd-agent and etcd-tester. etcd-agent runs on every test machines and etcd-tester is a single controller of the test. etcd-tester controls all the etcd-agent to start etcd clusters and simulate various failure cases.

## requirements

The environment of the cluster must be stable enough, so etcd test suite can assume that most of the failures are generated by itself.

## etcd agent

etcd agent is a daemon on each machines. It can start, stop, restart, isolate and terminate an etcd process. The agent exposes these functionality via HTTP RPC. 

## etcd tester

etcd functional tester control the progress of the functional tests. It calls the RPC of the etcd agent to simulate various test cases. For example, it can start a three members cluster by sending three start RPC calls to three different etcd agents. It can make one of the member failed by sending stop RPC call to one etcd agent.

## with Docker (optionally)

To run the functional tests using Docker, the provided script can be used to set up an environment using Docker Compose. 

Script (on linux):
```sh
./tools/functional-tester/test
```

Running the script requires:

- Docker 1.9+ (with networking support) - to create isolated network
- docker-compose - to create etcd cluster and tester
- A multi-arch Go toolchain (OSX)

Notes:
- Docker image is based on Alpine Linux OS running in privileged mode to allow iptables manipulation.
- To specify testing parameters (etcd-tester arguments) modify tools/functional-tester/docker/docker-compose.yml or start etcd-tester manually
- (OSX) make sure that etcd binary is built for linux/amd64 (eg. `rm bin/etcd;GOOS=linux GOARCH=amd64 ./tools/functional-tester/test`) otherwise you get `exec format error`


## with Goreman

To run the functional tests on a single machine using Goreman, build with the provided build script and run with the provided Procfile:

```sh
./tools/functional-tester/build
goreman -f tools/functional-tester/Procfile start
```

Notes:
- The etcd-agent will not run with root privileges; iptables manipulation is disabled.
- To specify testing parameters (etcd-tester arguments) modify tools/functional-tester/Procfile or start etcd-tester manually
