/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/storage/v1"
	storagev1 "k8s.io/client-go/applyconfigurations/storage/v1"
	gentype "k8s.io/client-go/gentype"
	typedstoragev1 "k8s.io/client-go/kubernetes/typed/storage/v1"
)

// fakeCSIStorageCapacities implements CSIStorageCapacityInterface
type fakeCSIStorageCapacities struct {
	*gentype.FakeClientWithListAndApply[*v1.CSIStorageCapacity, *v1.CSIStorageCapacityList, *storagev1.CSIStorageCapacityApplyConfiguration]
	Fake *FakeStorageV1
}

func newFakeCSIStorageCapacities(fake *FakeStorageV1, namespace string) typedstoragev1.CSIStorageCapacityInterface {
	return &fakeCSIStorageCapacities{
		gentype.NewFakeClientWithListAndApply[*v1.CSIStorageCapacity, *v1.CSIStorageCapacityList, *storagev1.CSIStorageCapacityApplyConfiguration](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("csistoragecapacities"),
			v1.SchemeGroupVersion.WithKind("CSIStorageCapacity"),
			func() *v1.CSIStorageCapacity { return &v1.CSIStorageCapacity{} },
			func() *v1.CSIStorageCapacityList { return &v1.CSIStorageCapacityList{} },
			func(dst, src *v1.CSIStorageCapacityList) { dst.ListMeta = src.ListMeta },
			func(list *v1.CSIStorageCapacityList) []*v1.CSIStorageCapacity {
				return gentype.ToPointerSlice(list.Items)
			},
			func(list *v1.CSIStorageCapacityList, items []*v1.CSIStorageCapacity) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
